'TY2KE001 30JAN00 - V1.1

' V1.1 03OCT99 "INPUT VIA IN1" line added to scope waveform display
' V1.1 03OCT99 display STEP value alignment corrected on pulse display
' V1.1 30JAN00 controllable output counter added to Display/Set
' V1.1 30JAN00 output to port added to ADC demo - waveform values

SCREEN 9: COLOR 15, 1: DIM binary$(255), rate(25), ratex(10, 1), store(5640)
DIM cap(55), res(217), decival%(12), v%(1000), j%(1000)

GOSUB clearit: selftest = 0: LOCATE 10, 35: PRINT "SETTING UP"

LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15: GOSUB setup
port$(0) = "&H378": port$(1) = "&H278": port$(2) = "&H3BC"
and$(0) = "        *  ": and$(1) = "      *    ": and$(2) = "    *      "
and$(3) = "  *        ": and$(4) = "*         ": ' andbit = 0

a = 1: FOR B = 10 TO 0 STEP -1: rate(B) = a: ratex(B, 0) = a: a = a / 2: NEXT
a = 1: FOR B = 0 TO 10: rate(B + 11) = a: ratex(B, 1) = a: a = a * 2: NEXT

sp$ = "                                                                    "
sp$ = sp$ + "          "
CONST pi = 3.141592653589# / 180

LOCATE 10, 35: PRINT "          "

OPEN "TY2KPATH.TXT" FOR INPUT AS #1: INPUT #1, menu$: INPUT #1, band$
INPUT #1, port$: INPUT #1, portinbit$: CLOSE : menupath = VAL(menu$) + 1
port1 = VAL(port$): portout = VAL(port$(port1)): portin = portout + 1
OUT portout, 0: andbit = VAL(portinbit$)
ON menupath GOTO 100, 200, 300, 400, 500, 600

menu: OPEN "TY2KPATH.TXT" FOR OUTPUT AS #1: PRINT #1, menu$
PRINT #1, band$: PRINT #1, STR$(port1): PRINT #1, STR$(andbit): CLOSE
OUT portout, 0: CHAIN "TY2KMENU"

'..............

100 : COLOR 11: LOCATE 2, 20
PRINT "DISPLAY/SET DATA ON PARALLEL PORT AT "; : COLOR 14: PRINT port$(port1)

COLOR 10: LOCATE 5, 14: PRINT "DIRECT INPUT BYTE"
COLOR 11: LOCATE 7, 12: PRINT "BIT NO  7 6 5 4 3 2 1 0"
COLOR 14: LOCATE 8, 9: PRINT "ORIG BYTE"
COLOR 11: LOCATE 9, 13: PRINT "VALUE"

COLOR 10: LOCATE 5, 49: PRINT "CORRECTED INPUT BYTE"
COLOR 11: LOCATE 7, 48: PRINT "BIT NO  7 6 5 4 3 2 1 0"
COLOR 14: LOCATE 8, 46: PRINT "NEW BYTE"
COLOR 11: LOCATE 9, 49: PRINT "VALUE"

COLOR 10: LOCATE 14, 35: PRINT "OUTPUT BYTE"
COLOR 11: LOCATE 16, 29: PRINT "BIT NO  7 6 5 4 3 2 1 0"
COLOR 14: LOCATE 17, 31: PRINT "BYTE"
COLOR 11: LOCATE 18, 30: PRINT "VALUE"
COLOR 14: LOCATE 20, 24: PRINT "SET OUTPUT BITS WITH NUMERAL KEYS"

COLOR 10: LOCATE 11, 9: PRINT "CORRECTION FORMULA: "; : COLOR 11
PRINT "NEW VALUE = ((ORIG VALUE + 128) \ 8) AND 31"

COLOR 11: LOCATE 23, 3: PRINT "CHANGE PORT ADDRESS "; : COLOR 14
PRINT "<P>   "; : COLOR 11: PRINT "RETURN TO MENU "; : COLOR 14
PRINT "<M>   "; : COLOR 11: PRINT "OUTPUT COUNTER UP/DOWN "; : COLOR 14
PRINT "<+ ->"

LINE (40 + 8, 56 - 14)-(280 + 8, 182 - 14 - 28), 15, B
LINE (40 + 4 + 8, 56 + 4 - 14)-(280 - 4 + 8, 182 - 4 - 14 - 28), 15, B
PAINT (41 + 8, 57 - 14), 7, 15
LINE (336, 56 - 14)-(584, 182 - 14 - 28), 15, B
LINE (336 + 4, 56 + 4 - 14)-(584 - 4, 182 - 4 - 14 - 28), 15, B
PAINT (337, 57 - 14), 7, 15: COLOR 15

LINE (336 - 128 - 16, 56 + 56 + 56)-(584 - 128 - 16, 182 + 56 + 28), 15, B
LINE (336 - 128 + 4 - 16, 56 + 4 + 56 + 56)-(584 - 4 - 128 - 16, 182 - 4 + 56 + 28), 15, B
PAINT (337 - 16, 57 + 56 + 56), 7, 15: COLOR 15: GOTO 140

120 : a = INP(portin): B = ((a + 128) \ 8) AND 31
LOCATE 8, 20: PRINT binary$(a): LOCATE 9, 19: PRINT STR$(a); "  "
LOCATE 8, 56: PRINT binary$(B): LOCATE 9, 55: PRINT STR$(B); "  "
z$ = INKEY$: IF z$ = "" THEN GOTO 120
IF UCASE$(z$) = "M" THEN GOTO menu
IF UCASE$(z$) <> "P" THEN GOTO 130
port1 = port1 + 1: IF port1 > 2 THEN port1 = 0
portout = VAL(port$(port1)): portin = portout + 1: COLOR 14
LOCATE 2, 57: PRINT port$(port1): COLOR 15: GOTO 120

130 : IF z$ = "+" THEN n = (n + 1) AND 255: GOTO 150
IF z$ = "-" THEN n = n - 1: GOTO 150
IF z$ < "0" OR z$ > "9" THEN GOTO 120
z = VAL(z$): bit(z) = (bit(z) + 1) AND 1
140 : LOCATE 17, 36: n = 0: FOR a = 7 TO 0 STEP -1: n = n + (bit(a) * (2 ^ a))
PRINT STR$(bit(a)); : NEXT: PRINT : LOCATE 18, 36: PRINT n; "   "
OUT portout, n: GOTO 120

150 : IF n < 0 THEN n = 255
LOCATE 17, 37: PRINT binary$(n): LOCATE 18, 36: PRINT n; "   "
c = 1: FOR a = 7 TO 0 STEP -1: bit(a) = VAL(MID$(binary$(n), c, 1))
c = c + 2: NEXT: OUT portout, n: GOTO 120

'.............

clearit: LINE (6, 6)-(633, 343), 0, BF: RETURN

bindeci: v = 0: w = LEN(a$) - 1: FOR t = 1 TO w + 1
e = VAL(MID$(a$, t, 1)) * (2 ^ w): v = v + e: w = w - 1: NEXT: RETURN

hexdeci: e$ = "": v = 0: w = LEN(a$) - 1: FOR t = 1 TO w + 1
c$ = MID$(a$, t, 1): IF c$ >= "0" AND c$ <= "9" THEN GOTO hd2
IF c$ >= "A" AND c$ <= "F" THEN GOTO hd2
e$ = "NOT A VALID HEX VALUE": e = 0: v = 0: EXIT FOR
hd2: e = VAL("&h" + c$) * (16 ^ w): v = v + e: w = w - 1: NEXT: RETURN

decibin:
d = z: B$ = "": FOR t = 7 TO 0 STEP -1: c = 2 ^ t: w = d / c
IF w >= 1 THEN d = d - c: x = 1 ELSE x = 0
B$ = B$ + STR$(x): NEXT: B$ = MID$(B$, 2): RETURN

setup:
OPEN "TY2KBIN" FOR INPUT AS #1: FOR z = 0 TO 255: INPUT #1, binary$(z): NEXT
CLOSE : RETURN

'.................

200 : COLOR 11: LOCATE 2, 17
PRINT "MONITOR FREQUENCY INPUT ON PARALLEL PORT AT "; : COLOR 14
PRINT port$(port1): GOSUB 250
LINE (25 * 8, 3 * 14)-(56 * 8 - 2, 8 * 14), 15, B
LINE (25 * 8 + 4, 3 * 14 + 4)-(56 * 8 - 2 - 4, 8 * 14 - 4), 15, B

LINE (25 * 8, 9 * 14)-(56 * 8 - 2, 13 * 14), 15, B
LINE (25 * 8 + 4, 9 * 14 + 4)-(56 * 8 - 2 - 4, 13 * 14 - 4), 15, B

LINE (25 * 8, 14 * 14)-(56 * 8 - 2, 18 * 14), 15, B
LINE (25 * 8 + 4, 14 * 14 + 4)-(56 * 8 - 2 - 4, 18 * 14 - 4), 15, B

COLOR 11: LOCATE 16, 29: PRINT "TIME       FREQUENCY (Hz)"
COLOR 14: LOCATE 17, 29: PRINT TIME$; TAB(40); "0"
COLOR 11: LOCATE 23, 15: PRINT "SET PORT ADDRESS "; : COLOR 14
PRINT "<P>   "; : COLOR 11: PRINT "SET ACTIVE BIT "; : COLOR 14
PRINT "<B>   "; : COLOR 11: PRINT "MENU "; : COLOR 14: PRINT "<M>"

205 : z$ = INKEY$: IF z$ <> "" THEN GOTO 240
n = 0: a = INP(portin) AND andval: t = TIMER + 1
220 : IF TIMER > t THEN GOTO 230
B = INP(portin) AND andval: IF B <> a THEN n = n + 1
a = B: GOTO 220
230 : COLOR 14: LOCATE 17, 29: PRINT TIME$; TAB(39); STR$(n / 2); "      "
GOTO 205

240 : IF UCASE$(z$) = "M" THEN GOTO menu
IF UCASE$(z$) = "B" THEN GOTO 245
IF UCASE$(z$) <> "P" THEN GOTO 205
port1 = port1 + 1: IF port1 > 2 THEN port1 = 0
portout = VAL(port$(port1)): portin = portout + 1: COLOR 14
LOCATE 2, 61: PRINT port$(port1): COLOR 15: GOTO 205
245 andbit = andbit + 1: IF andbit > 4 THEN andbit = 0
GOSUB 250: GOTO 205

250 : COLOR 11: LOCATE 5, 28: PRINT "REG BIT NO  7 6 5 4 3 2 1 0"
andval = 2 ^ (andbit + 3)
LOCATE 6, 28:           PRINT "ACTIVE BIT  "; : COLOR 14: PRINT and$(andbit)
COLOR 14: LOCATE 7, 28: PRINT "AND "; : COLOR 11: PRINT "VALUE  ";
COLOR 14: PRINT andval; " ":
COLOR 11: LOCATE 11, 28: PRINT "INPUT NO    4 3 2 1 0"
LOCATE 12, 28:           PRINT "SELECTED    "; : COLOR 14: PRINT and$(andbit)
RETURN

'............

300 : 'PULSE WAVEFORM DISPLAY
COLOR 11: LOCATE 2, 5: andval = 2 ^ (andbit + 3): rate1 = 5
rate = rate(rate1): PRINT "PULSE WAVEFORM VIA "; : COLOR 14
PRINT port$(port1); : COLOR 11: PRINT "    ACTIVE LINE";
FOR a = 4 TO 0 STEP -1: IF a = (andbit) THEN COLOR 14 ELSE COLOR 11
PRINT STR$(a); : NEXT: COLOR 11: PRINT "      DISPLAY STEP";
COLOR 14: PRINT rate1

COLOR 11: LOCATE 24, 3: PRINT "PORT ADDRESS "; : COLOR 14
PRINT "<P>   "; : COLOR 11: PRINT "ACTIVE LINE "; : COLOR 14
PRINT "<B>   "; : COLOR 11: PRINT "DISPLAY STEP "; : COLOR 14
PRINT "<+->   "; : COLOR 11: PRINT "HOLD "; : COLOR 14
PRINT "<H>   "; : COLOR 11: PRINT "MENU "; : COLOR 14: PRINT "<M>";
LOCATE 1, 1

col = 14: col2 = 2: y = 3 * 14
FOR a = 1 TO 10: LINE (8, y - 11)-(630, y - 11), col2
LINE (8, y + 11)-(630, y + 11), col2: y = y + 28: NEXT
y = 3 * 14: down = 3
a = (INP(portin) + 128) AND andval: s = -8: IF a = 0 THEN s = 8

320 : a = INP(portin) AND andval: s = -8: IF a = 0 THEN s = 8
PSET (8, y + s), col: FOR y1 = 1 TO 10: FOR x = 8 TO 630 STEP rate
z$ = INKEY$: IF z$ = "" THEN GOTO 325
GOSUB 330: IF UCASE$(z$) = "M" THEN EXIT FOR
IF rt = 1 THEN rt = 0: EXIT FOR

325 : B = (INP(portin) + 128) AND andval
IF B <> a THEN s = -s: LINE -(x, y + s), col
a = B: LINE -(x, y + s), col: NEXT: IF UCASE$(z$) = "M" THEN EXIT FOR
y = y + 28: down = down + 2: IF down > 22 THEN down = 3: y = 3 * 14:
LOCATE down, 2: PRINT sp$: LOCATE down + 1, 2: PRINT sp$
LINE (8, y - 11)-(630, y - 11), col2: LINE (8, y + 11)-(630, y + 11), col2
PSET (8, y + s), col: NEXT: IF UCASE$(z$) = "M" THEN GOTO menu
GOTO 320

330 :
IF UCASE$(z$) = "B" THEN GOTO 345
IF UCASE$(z$) <> "P" THEN GOTO 350
port1 = port1 + 1: IF port1 > 2 THEN port1 = 0
portout = VAL(port$(port1)): portin = portout + 1: COLOR 14
LOCATE 2, 24: PRINT port$(port1): COLOR 15: RETURN
345 rt = 1: andbit = andbit + 1: IF andbit > 4 THEN andbit = 0
andval = 2 ^ (andbit + 3): LOCATE 2, 44
FOR a = 4 TO 0 STEP -1: IF a = (andbit) THEN COLOR 14 ELSE COLOR 11
PRINT STR$(a); : NEXT: RETURN

350 : rt = 0: IF z$ = "+" THEN rate1 = rate1 + 1: GOTO 355
IF z$ = "-" THEN rate1 = rate1 - 1: GOTO 355
IF UCASE$(z$) <> "H" THEN RETURN
353 : IF INKEY$ = "" THEN GOTO 353
RETURN

355 : rt = 1: IF rate1 > 14 THEN rate1 = 14
IF rate1 < 0 THEN rate1 = 0
rate = rate(rate1): LOCATE 2, 72: COLOR 14: PRINT rate1: : COLOR 15: RETURN

'...............

400 : 'ANALOGUE TO DIGITAL CONVERSION & DISPLAY - TLC549 SERIAL ADC
COLOR 11: LOCATE 2, 3: PRINT "INPUT VIA "; : COLOR 14: PRINT "IN1"
COLOR 11: LOCATE 2, 19: rate1(0) = 10: rate1(1) = 0
PRINT "ANALOGUE WAVEFORM VIA "; : COLOR 14: PRINT port$(port1);
COLOR 11: COLOR 11: PRINT "   DISPLAY RATE"; : ' COLOR 14: PRINT rate1

COLOR 11: LOCATE 24, 5: PRINT "PORT ADDRESS "; : COLOR 14
PRINT "<P>   "; : COLOR 11: PRINT "DISPLAY RATE "; : COLOR 14
PRINT "<+->   "; : COLOR 11: PRINT "CAPTURE "; : COLOR 14
PRINT "<C>   "; : COLOR 11: PRINT "HOLD "; : COLOR 14: PRINT "<H>   ";
COLOR 11: PRINT "MENU "; : COLOR 14: PRINT "<M>"; : LOCATE 1, 1
col = 14: col2 = 2: y = 3 * 14

adc = 0: OUT portout, 2: 'set CS high, CLK low
FOR a = 0 TO 7: OUT portout, 1: B = (INP(portin) \ 8) AND 1
adc = (adc * 2) OR B: OUT portout, 0: NEXT: prevx = 6:
adc = 256 - adc: prevadc = adc + y

410 : COLOR 14: LOCATE 2, 68: PRINT "DIRECT ": COLOR 15: capture = 0
rate = ratex(rate1(0), 0): LOCATE 2, 61: COLOR 14: s = 10
PRINT rate1(0): COLOR 15
420 : FOR x = 6 TO 632 STEP rate: z$ = INKEY$: IF z$ = "" THEN GOTO 425
GOSUB 430: IF rt = 1 THEN rt = 0: EXIT FOR

425 : adc = 0: OUT portout, 2: FOR a = 0 TO 7: OUT portout, 1
B = INP(portin) AND 16: adc = (adc * 2) OR B: OUT portout, 0: NEXT
adc = 256 - (adc \ 16): LINE (prevx, prevadc)-(INT(x), y + adc), col

prevadc = adc + y: LINE (x + 1, 2 * 14)-(x + 1, 23 * 14), 0: prevx = INT(x)
426 : NEXT: IF UCASE$(z$) = "M" THEN GOTO menu
LINE (6, 2 * 14)-(6, 23 * 14), 0: prevx = 6
IF UCASE$(z$) = "C" THEN GOTO 460 ELSE GOTO 410

430 : IF UCASE$(z$) <> "P" THEN GOTO 450
port1 = port1 + 1: IF port1 > 2 THEN port1 = 0
portout = VAL(port$(port1)): portin = portout + 1: COLOR 14
LOCATE 2, 41: PRINT port$(port1): COLOR 15: RETURN

450 : rt = 0: IF z$ = "+" THEN rate1(capture) = rate1(capture) + 1: GOTO 455
IF z$ = "-" THEN rate1(capture) = rate1(capture) - 1: GOTO 455
IF UCASE$(z$) = "H" THEN GOSUB hold
IF UCASE$(z$) = "C" OR UCASE$(z$) = "M" THEN rt = 1
RETURN

455 : rt = 1: IF rate1(0) > 10 THEN rate1(0) = 10
IF rate1(1) > 4 THEN rate1(1) = 4
IF rate1(capture) < 0 THEN rate1(capture) = 0
rate = ratex(rate1(capture), capture): LOCATE 2, 61: COLOR 14
PRINT rate1(capture): COLOR 15: RETURN

460 : COLOR 10: LOCATE 2, 68: PRINT "CAPTURE": capture = 1
rate = ratex(rate1(1), 1): LOCATE 2, 61: PRINT rate1(1): COLOR 15

470 : FOR x = 0 TO 640: adc = 0: OUT portout, 2: FOR a = 0 TO 7
OUT portout, 1: B = INP(portin) AND 16: adc = (adc * 2) OR B
OUT portout, 0: NEXT: store(x) = adc: NEXT: prevx = 6
LINE (6, 2 * 14)-(8, 23 * 14), 0, BF
x1 = 6: FOR x = 6 TO 632 STEP rate: adc = 256 - (store(x1) \ 16)
LINE (prevx + 1, 2 * 14)-(x + 1, 23 * 14), 0, BF

LINE (prevx, prevadc)-(INT(x), y + adc), 10: prevadc = adc + y
prevx = INT(x): x1 = x1 + 1: z$ = INKEY$: IF z$ = "" THEN GOTO 480
GOSUB 430: IF rt = 1 THEN rt = 0: EXIT FOR
480 : NEXT: LINE (632, 2 * 14)-(633, 23 * 14), 0, BF
LOCATE 2, 61: COLOR 14: PRINT rate1: COLOR 15
IF UCASE$(z$) = "M" THEN GOTO menu
IF UCASE$(z$) = "C" THEN GOTO 410 ELSE GOTO 460

'.................

500 : 'ANALOGUE TO DIGITAL DEMO
COLOR 14: LOCATE 2, 26: PRINT "ANALOGUE-DIGITAL-ANALOGUE DEMO": COLOR 11
volts = 1: volts2 = volts * 70: rate = 2: sample = 1: ss = 0: s2 = 0
LOCATE 4, 8: PRINT "INPUT VOLTAGE"
LOCATE 4, 61: PRINT "OUTPUT VOLTAGE"

LOCATE 4, 35: PRINT "A-D CONVERTER"
LOCATE 14, 37: PRINT "COMPUTER"
LOCATE 21, 35: PRINT "D-A CONVERTER": COLOR 14
LOCATE 18, 34: PRINT binary$(0)
LOCATE 19, 34: PRINT "= 0"
LOCATE 20, 34: PRINT "= 0    V"
LOCATE 23, 3: PRINT "<M> MENU  ";
PRINT "<B> BINARY STEP ON/OFF  ";
PRINT "<+ -> WAVEFORM RATE "; : COLOR 10: PRINT "1  "; : COLOR 14
PRINT "  <* /> SAMPLE "; : COLOR 10: PRINT "1"

y = 175 + 7: yy = y: x1 = 12 + 2: x2 = 390 + 48 + 8: y1 = 141
LINE (x1, y - y1 - 7)-(x1 + 180, y + y1 - 21), 15, B: 'box 1
LINE (x2 - 1, y - y1 - 7)-(x2 + 180, y + y1 - 21), 15, B: 'box 5

a1 = 31 * 8 + 4: a2 = 49 * 8: d1 = 3 * 14 - 7: d2 = 7 * 14 + 7
LINE (a1, d1)-(a2, d2), 15, B: 'box 2
dc = 28.5: PSET (dc * 8 - 1, 4 * 14 + 6), 14: DRAW "f8 g8 u16": 'right arrow
PAINT (dc * 8, 4 * 14 + 8), 14, 14: ya = d1 + 28 + 7
LINE (x1 + 190, ya)-(x1 + 190 + 48, ya), 14: 'horiz 1
dc = 40: PSET (dc * 8 + 1 + 2, 9 * 14 - 1), 14: DRAW "e8 l16 f8": 'down arrow 1
PAINT (dc * 8 + 2 + 2, 9 * 14 - 3), 14, 14
LINE (dc * 8 + 1 + 2, 7 * 14 + 7)-(dc * 8 + 1 + 2, 10 * 14 - 1 - 7), 14
d1 = 7 * 14 + d1: d2 = 7 * 14 + d2
LINE (a1, d1)-(a2, d2), 15, B: 'box 3

PSET (dc * 8 + 1 + 2, 16 * 14 - 1), 14: DRAW "e8 l16 f8": 'down arrow 2
PAINT (dc * 8 + 2 + 2, 16 * 14 - 3), 14, 14
LINE (dc * 8 + 1 + 2, 14 * 14 + 7)-(dc * 8 + 1 + 2, 17 * 14 - 1 - 7), 14
d1 = 7 * 14 + d1: d2 = 7 * 14 + d2
LINE (a1, d1)-(a2, d2), 15, B: 'box 4

yb = 18 * 14 + 6
dc = 51: PSET (dc * 8 - 1, yb), 14: DRAW "f8 g8 u16": 'right arrow 2
PAINT (dc * 8, yb + 2), 14, 14

yb = 19 * 14: LINE (x2 - 18 + 8, yb)-(x2 - 53, yb), 14: 'horiz 2

y = y + 70 - 21 - 50: angle = 0: GOSUB sine: prevsine = sine1 * volts2
angle2 = 0: y2 = sine1 * volts2: lastsine1 = sine1 * volts2
lastsine2 = sine1 * volts2

510 : prevx = x1 + 1: FOR x = 1 TO 179: GOSUB sine: y2 = sine1 * volts2
LINE (x + x1, yy - y1 + 56)-(x + x1, yy + y1 - 28), 0
LINE (prevx, y - prevsine)-(x + x1, y - y2), 10
prevx = x + x1: prevsine = y2: NEXT:

LINE (x1 + 181, y - lastsine1)-(x1 + 190, y - lastsine1), 0
LINE -(x1 + 190, ya), 0
LINE (x1 + 181, y - y2)-(x1 + 190, y - y2), 14
LINE -(x1 + 190, ya), 14: lastsine1 = y2
adc = CINT((sine1 + 1) / 2 * 255): volts = CINT((sine1 + 1) / 2 * 50) / 10

520 : prevx = x2: angle2 = angle: GOSUB sineb
y3 = sine2 * volts2: prevsine2 = y3
LINE (x2 - 2, y - lastsine2)-(x2 - 18 + 8, y - lastsine2), 0
LINE -(x2 - 18 + 8, yb), 0
LINE (x2 - 2, y - y3)-(x2 - 18 + 8, y - y3), 14
LINE -(x2 - 18 + 8, yb), 14:
lastsine2 = y3

angle2 = angle
FOR x = 0 TO 179: tt = tt + 1: GOSUB sineb
IF tt >= sample THEN y3 = sine2 * volts2: tt = 0
LINE (x + x2, yy - y1 + 56)-(x + x2, yy + y1 - 28), 0: ' ***
LINE (prevx, y - prevsine2)-(x + x2, y - prevsine2), 10
LINE -(x + x2, y - y3), 10: prevx = x + x2: prevsine2 = y3: NEXT

v$ = LEFT$(STR$(volts) + "   ", 5)
LOCATE 5, 34: PRINT "V =   "; v$: B$ = binary$(adc)
COLOR 10: LOCATE 7, 34: PRINT B$
adc$ = LEFT$(STR$(adc) + "   ", 5)
OUT portout, adc
COLOR 14: LOCATE 6, 34: PRINT "ADC = "; adc$ + " =": answer = 0

IF bin = 0 THEN GOTO 530

k = 16: FOR j = 7 TO 0 STEP -1: LOCATE 12, 34: COLOR 14
PRINT LEFT$(binary$(answer), k);
COLOR 10: PRINT MID$(binary$(answer), k + 1): c$ = LEFT$(B$, 1)
COLOR 10: LOCATE 7, 34: PRINT c$: COLOR 15: GOSUB movebit
B = adc AND (2 ^ j): IF B > 0 THEN B = 1
answer = answer * 2 OR B: B$ = MID$(B$, 3) + " 0"
LOCATE 7, 34: COLOR 10: k = k - 2: PRINT LEFT$(B$, k);
COLOR 14: PRINT MID$(B$, k + 1)
z$ = INKEY$: IF z$ = "" THEN GOTO 532
IF UCASE$(z$) = "M" THEN GOTO menu
GOSUB demo1: EXIT FOR
532 : NEXT: LOCATE 12, 34: COLOR 10: PRINT binary$(answer): GOSUB movebit2

530 : COLOR 10: LOCATE 12, 34: PRINT binary$(adc)
LOCATE 18, 34: PRINT binary$(adc)
COLOR 14: LOCATE 19, 34: PRINT "= "; adc$
LOCATE 20, 34: PRINT "= "; v$; "V"

535 : z$ = INKEY$: IF z$ = "" THEN GOTO 540
IF UCASE$(z$) = "M" THEN GOTO menu
GOSUB demo1

540 : GOTO 510

sine: sine1 = SIN(angle * pi): angle = angle + rate
IF angle > 360 THEN angle = angle - 360
RETURN

sineb: sine2 = SIN(angle2 * pi): angle2 = angle2 + rate
IF angle2 > 360 THEN angle2 = angle2 - 360
RETURN

'.........

movebit: COLOR 14: ja = 33 * 8: jd = 6 * 14
GET (ja, jd)-(ja + 8, jd + 14), v%

FOR a = 1 TO 7: PUT (ja, jd), v%, XOR: GOSUB shortdelay
PUT (ja, jd), v%, XOR: jd = jd + 4: NEXT
FOR a = 1 TO 28: PUT (ja, jd), v%, XOR: GOSUB shortdelay
PUT (ja, jd), v%, XOR: ja = ja + 4: NEXT
FOR a = 1 TO 10: PUT (ja, jd), v%, XOR: GOSUB shortdelay
PUT (ja, jd), v%, XOR: jd = jd + 4: NEXT: RETURN

movebit2: COLOR 14: ja = 33 * 8: jd = 11 * 14
GET (ja, jd)-(ja + (8 * 15), jd + 14), v%
FOR a = 1 TO 21: PUT (ja, jd), v%, XOR: GOSUB shortdelay
PUT (ja, jd), v%, XOR: jd = jd + 4: NEXT: RETURN

shortdelay: tx = TIMER + .01
delay3a: IF TIMER > tx THEN RETURN ELSE GOTO delay3a

demo1: IF UCASE$(z$) = "B" THEN bin = (bin + 1) AND 1
IF z$ = "+" THEN rate = (rate + 2): IF rate > 256 THEN rate = 256
IF z$ = "-" THEN rate = (rate - 2): IF rate < 2 THEN rate = 2
IF z$ = "*" THEN sample = (sample + 1): IF sample > 256 THEN sample = 256
IF z$ = "/" THEN sample = (sample - 1): IF sample < 1 THEN sample = 1
COLOR 10: LOCATE 23, 56: PRINT STR$(rate \ 2); "  ":
LOCATE 23, 74: PRINT STR$(sample); "  ": RETURN

'.............

hold: IF INKEY$ = "" THEN GOTO hold ELSE RETURN

'.............

600 : ' pulsed sampling demo
COLOR 14: LOCATE 2, 31: PRINT "DIGITAL SAMPLING AND LOGIC DEMO": COLOR 11

y = 3 * 14 - 7: y1 = 18 * 14 + 7: x1 = 14 * 8 + 3: x2 = 79 * 8 - 3
j = y + 1: k = y1 - 1: LINE (x1, y)-(x2, y1), 15, B: 'box
holdit = 0: pulse = 0

LOCATE 5, 6: PRINT "SIGNAL A"
LOCATE 8, 6: PRINT "SIGNAL B"
LOCATE 11, 7: PRINT "A     B"
LOCATE 14, 8: PRINT "A    B"
LOCATE 17, 7: PRINT "A     B"

COLOR 10
LOCATE 22, 3: PRINT "SIGNAL A ="
LOCATE 23, 3: PRINT "SIGNAL B ="

COLOR 14: LOCATE 11, 9: PRINT "AND"
LOCATE 14, 10: PRINT "OR"
LOCATE 17, 9: PRINT "XOR"

COLOR 11
LOCATE 21, 3: PRINT "CYCLE WIDTH:"
LOCATE 21, 20: PRINT "CONTROLS:"
LOCATE 21, 52: PRINT "MENU ="
LOCATE 23, 52: PRINT "PULSE B ON/OFF ="
COLOR 10
LOCATE 22, 20: PRINT "SIGNAL A/B  ="
LOCATE 23, 20: PRINT "CYCLE WIDTH ="
LOCATE 22, 52: PRINT "HOLD ON/OFF = "
LOCATE 24, 20: PRINT "SIGNAL B SHIFT (WHEN HOLDING) =";
COLOR 14
LOCATE 22, 34: PRINT "UP/DOWN ARROWS"
LOCATE 23, 34: PRINT "+ - * /"
LOCATE 22, 66: PRINT "H"
LOCATE 21, 59: PRINT "M"
LOCATE 23, 69: PRINT "P"
LOCATE 24, 52: PRINT "LEFT/RIGHT ARROWS";
rate(0) = 128: rate(1) = 86: ratea = 0: ' rateb = 0

COLOR 14:
LOCATE 22, 13: PRINT STR$(rate(0)); "  ":
LOCATE 23, 13: PRINT STR$(rate(1)); "  ":

sig = 0: ac = 6: dn = sig * 3 + 4: GOSUB highlight

y = 5 * 14 + 5: y1 = 8 * 14 + 5: y2 = 11 * 14 + 5: y3 = 14 * 14 + 5
y4 = 17 * 14 + 4

610 : x1 = 116: prevx = x1: prevx1 = x1: prevx2 = x1: prevx3 = x1
prevx4 = x1

IF holdit = 0 THEN ratea = p2
rateb = s2

p2 = ratea: p = 1: IF ratea > rate(0) THEN p = 0
t = p AND s: t1 = t * 28: s1 = s * 28: p1 = p * 28
t = p OR s: t2 = t * 28: t = p XOR s: t3 = t * 28

prevp1 = p1: prevs1 = s1: prevt1 = t1: prevt2 = t2: prevt3 = t3

FOR x = x1 TO x1 + 512: t = p AND s: t1 = t * 28: s1 = s * 28: p1 = p * 28
t = p OR s: t2 = t * 28: t = p XOR s: t3 = t * 28

LINE (x, j)-(x, k), 0
IF p1 <> prevp1 THEN LINE (prevx, y - prevp1)-(prevx, y - p1), 10: prevx = x
LINE (prevx, y - p1)-(x, y - p1), 10
IF s1 <> prevs1 THEN LINE (prevx1, y1 - prevs1)-(prevx1, y1 - s1), 10: prevx1 = x
LINE (prevx1, y1 - s1)-(x, y1 - s1), 10
IF t1 <> prevt1 THEN LINE (prevx2, y2 - prevt1)-(prevx2, y2 - t1), 10: prevx2 = x
LINE (prevx2, y2 - t1)-(x, y2 - t1), 10
IF t2 <> prevt2 THEN LINE (prevx3, y3 - prevt2)-(prevx3, y3 - t2), 10: prevx3 = x
LINE (prevx3, y3 - t2)-(x, y3 - t2), 10
IF t3 <> prevt3 THEN LINE (prevx4, y4 - prevt3)-(prevx4, y4 - t3), 10: prevx4 = x
LINE (prevx4, y4 - t3)-(x, y4 - t3), 10

p2 = p2 + 1: p = 1: IF p2 > rate(0) THEN p = 0
IF p2 > (rate(0) * 2) THEN p2 = 0

s2 = s2 + 1: s = 1: IF s2 > rate(1) THEN s = 0
IF pulse = 1 AND s2 > 3 THEN s = 0
IF s2 > (rate(1) * 2) THEN s2 = 0

prevp1 = p1: prevs1 = s1: prevt1 = t1: prevt2 = t2: prevt3 = t3
prevx = x: prevx1 = x: prevx2 = x: prevx3 = x: prevx4 = x: NEXT
615 : z$ = INKEY$: IF z$ = "" AND holdit = 1 THEN GOTO 615
IF z$ = "" THEN GOTO 610
IF UCASE$(z$) = "M" THEN GOTO menu
GOSUB demo2: GOTO 610

shortdelay2: tx = TIMER + 1
delay2: IF TIMER > tx THEN RETURN ELSE GOTO delay2

demo2: IF UCASE$(z$) = "B" THEN bin = (bin + 1) AND 1
IF MID$(z$, 2) = "" THEN GOTO demo2a
ac = 6: dn = sig * 3 + 4: GOSUB highlight
IF MID$(z$, 2) = "H" THEN sig = sig - 1: IF sig < 0 THEN sig = 1
IF MID$(z$, 2) = "P" THEN sig = sig + 1: IF sig > 1 THEN sig = 0
IF holdit = 0 THEN GOTO demo22
IF MID$(z$, 2) = "K" THEN s2 = rateb + 1: GOTO demo21: ' s2 = s2 + 1: GOTO demo21
IF MID$(z$, 2) = "M" THEN s2 = rateb - 1: GOTO demo21: ' s2 = s2 - 1: GOTO demo21
GOTO demo22

demo21: s = 1: IF s2 > rate(1) THEN s = 0
IF pulse = 1 AND s2 > 3 THEN s = 0
IF s2 > (rate(1) * 2) THEN s2 = 0

demo22: ac = 6: dn = sig * 3 + 4: GOSUB highlight
RETURN: 'GOSUB showvalues: GOTO getkey

demo2a:
IF z$ = "+" THEN rate(sig) = rate(sig) + 1: GOTO demo2b
IF z$ = "-" THEN rate(sig) = rate(sig) - 1: GOTO demo2b
IF z$ = "*" THEN rate(sig) = rate(sig) + 10: GOTO demo2b
IF z$ = "/" THEN rate(sig) = rate(sig) - 10: GOTO demo2b
IF UCASE$(z$) = "P" THEN pulse = (pulse + 1) AND 1
IF UCASE$(z$) <> "H" THEN RETURN
holdit = (holdit + 1) AND 1
LOCATE 22, 69:
IF holdit = 1 THEN PRINT "HOLDING" ELSE PRINT "       "
RETURN

demo2b:
IF rate(sig) > 512 THEN rate(sig) = 512
IF rate(sig) < 1 THEN rate(sig) = 1
COLOR 14: LOCATE 22, 13: PRINT STR$(rate(0)); "  ":
LOCATE 23, 13: PRINT STR$(rate(1)); "  ": RETURN

highlight:
ax = ac * 8 - 16: dx = dn * 14 + 1: ay = (ac + 8) * 8 - 1: dy = dx + 14 - 2
GET (ax, dx)-(ay, dy), v%: PUT (ax, dx), v%, PRESET: RETURN

