                             ; Listing 6.10

     include "16F887.PLC"    ; Defines PLC instructions

                             ; AUX0 + AUX1 hold 4 digits to be displayed
     puti     0x12, AUX0     ; AUX0 = L.H. 2 digits of display
     puti     0x34, AUX1     ; AUX1 = R.H. 2 digits of display

                             ; AUX2 bits 0+1 waveforms are decoded to produce
                             ; digit scan pulses (see also 'SCANROW' subroutine)
     ld       OSCH, 4        ; Read 8 ms waveform
     out      AUX2, 0        ; Send to bit 0 of register AUX2
     ld       OSCH, 5        ; Read 16 ms waveform
     out      AUX2, 1        ; Send to bit 1 of register AUX2

                             ; Conditional subroutine calls
     ld       PORTA, 0
     ccall    SCANROW        ; Scan rows if bit 0 of Port A = 1

     ld_not   PORTA, 0
     ccall    BLANKED        ; Disable row scan if bit 0 of Port A = 0

     ld       PORTD, 0
     ccall    DIGIT1         ; Display digit 1 if enabled

     ld       PORTD, 1
     ccall    DIGIT2         ; Display digit 2 if enabled

     ld       PORTD, 2
     ccall    DIGIT3         ; Display digit 3 if enabled

     ld       PORTD, 3
     ccall    DIGIT4         ; Display digit 4 if enabled

                             ; Subroutine definitions
     subdef   SCANROW
     decode   AUX2, PORTD    ; Send digit enable pulses to Port D
     return

     subdef   BLANKED        ; Turn off display driver transistors
     puti     0x00, PORTD    ; Blank 7 segment display
     return

     subdef   DIGIT1         ; Display digit 1 subroutine
     swap     AUX0,   AUX3   ; Swap nibbles of AUX0 into AUX3
     bin27seg AUX3,   PORTC  ; Send to 7 segment display
     return                  ; Return from subroutine

     subdef   DIGIT2         ; Display digit 2 subroutine
     bin27seg AUX0,   PORTC  ; Send to 7 segment display
     return                  ; Return from subroutine

     subdef   DIGIT3         ; Display digit 3 subroutine
     swap     AUX1,   AUX3   ; Swap nibbles of AUX1 into AUX3
     bin27seg AUX3,   PORTC  ; Send to 7 segment display
     return                  ; Return from subroutine

     subdef   DIGIT4         ; Display digit 4 subroutine
     bin27seg AUX1,   PORTC  ; Send to 7 segment display
     return                  ; Return from subroutine

     endp                    ; End of PLC program