// Simple Arduino GPS location fix
// Include the necessary libraries
#include <LCD.h>
#include <LiquidCrystal_I2C.h>
#include <SoftwareSerial.h>
#include <TinyGPS.h>

// *** LCD display settings *** 
#define I2C_ADDR 0x27 // <<----- change if necessary
#define BACKLIGHT_PIN 3
#define En_pin 2
#define Rw_pin 1
#define Rs_pin 0
#define D4_pin 4
#define D5_pin 5
#define D6_pin 6
#define D7_pin 7
#define bl 3
#define blpol POSITIVE
LiquidCrystal_I2C lcd(I2C_ADDR,En_pin,Rw_pin,Rs_pin,D4_pin,D5_pin,D6_pin,D7_pin,bl,blpol);

// Define the Arduino pins used for serial GPS interface
#define RXPIN 10
#define TXPIN 11

// Create an instance of the TinyGPS object
TinyGPS gps;
SoftwareSerial ss(RXPIN, TXPIN);

void setup()
{
  ss.begin(9600);         // GPS serial bit rate
  lcd.begin (20,4);       // 20 characters x 4 lines
  lcd.setBacklight(HIGH);
}

void loop()
{
  bool newData = false;
  unsigned long chars;
  unsigned short sentences, failed;

  // Parse GPS data for 2 seconds
  for (unsigned long start = millis(); millis() - start < 2000;)
  {
    while (ss.available())
    {
      char c = ss.read();
      if (gps.encode(c)) // Is the sentence valid?
        newData = true;
    }
  }

  if (newData)
  {
    // Extract the GPS data from the received sentences
    float flat, flon;
    unsigned long age;
    gps.f_get_position(&flat, &flon, &age);
    int year;
    byte month, day, hour, minute, second, hundredths;
    gps.crack_datetime(&year, &month, &day, &hour, &minute, &second,&hundredths);
    float falt = gps.f_altitude();
    // Send the data to the LCD panel
    // The first line will display the time
    lcd.clear();
    lcd.setCursor(0,0);
    lcd.print("Time = ");
    lcd.print(hour, DEC);
    lcd.print(":");
    lcd.print(minute, DEC);
    lcd.print(":");
    lcd.print(second, DEC);
    // The second line will display the latitude
    lcd.setCursor(0,1);
    lcd.print("Lat. = ");
    lcd.print(flat == TinyGPS::GPS_INVALID_F_ANGLE ? 0.0 : flat, 4); 
    lcd.setCursor(0,2);
    // The third line will display the longitude
    lcd.print("Lon. = ");
    lcd.print(flat == TinyGPS::GPS_INVALID_F_ANGLE ? 0.0 : flon, 4); 
    lcd.setCursor(0,3);
    // The fourth line will display the altitude and number of stellites
    lcd.print("Alt. = ");
    lcd.print(falt); 
    lcd.print("   *->");
    lcd.print(gps.satellites() == TinyGPS::GPS_INVALID_SATELLITES ? 0 : gps.satellites());
  }
}
