
#include <stdlib.h>
#include <plib.h>
#include "mstimer.h"

// functions prototypes
void	SpiInitDevice(int chn, int isMaster);
void 	Seps525_Initialise(void);
void 	delay_ms( unsigned int ticks );
void 	Write_Command( unsigned int addr, unsigned int val );
void 	Write_Register( unsigned int addr );
void 	Write_Parameter( unsigned int val );
void 	Seps525_CLS(unsigned char R, unsigned char G, unsigned B);

// configuration settings
#pragma config FNOSC = PRIPLL, POSCMOD = HS, FPLLMUL = MUL_18, FPLLIDIV = DIV_2, FPBDIV = DIV_2, FPLLODIV = DIV_1
#pragma config FWDTEN = OFF

// Bit definitions for LCD display on SPI2 bus
#define nRESETB 		BIT_13
#define RS 				BIT_14  // RS is low for Commands, high for Parameter/Data
#define nCS 			BIT_15
#define LCD_SPI_PORT 	2

#define REDUCE_CURRENT			0x04
#define SCREEN_SAVER_CONTROL	0x3b
#define OSC_CTL					0x02
#define CLOCK_DIV				0x03
#define PRECHARGE_TIME_R	    0x08
#define PRECHARGE_TIME_G	    0x09
#define PRECHARGE_TIME_B	    0x0a
#define PRECHARGE_CURRENT_R		0x0b
#define PRECHARGE_CURRENT_G		0x0c
#define PRECHARGE_CURRENT_B		0x0d
#define DRIVING_CURRENT_R		0x10
#define DRIVING_CURRENT_G		0x11
#define DRIVING_CURRENT_B		0x12
#define DISPLAY_MODE_SET	    0x13
#define RGB_IF					0x14
#define MEMORY_WRITE_MODE		0x16
#define MX1_ADDR				0x17
#define MX2_ADDR				0x18
#define MY1_ADDR				0x19
#define MY2_ADDR				0x1a
#define MEMORY_ACCESS_POINTER_X	0x20
#define MEMORY_ACCESS_POINTER_Y	0x21
#define DDRAM_DATA_ACCESS_PORT	0x22
#define DUTY					0x28
#define DSL						0x29
#define D1_DDRAM_FAC			0x2e
#define D1_DDRAM_FAR			0x2f
#define D2_DDRAM_SAC			0x31
#define D2_DDRAM_SAR			0x32
#define SCR1_FX1				0x33
#define SCR1_FX2				0x34
#define SCR1_FY1				0x35
#define SCR1_FY2				0x36
#define DISP_ON_OFF				0x06

#define BYTES_PER_PIXEL 3
#define SCREEN_WIDTH	160
#define SCREEN_HEIGHT	128
#define IMAGE_SIZE		BYTES_PER_PIXEL*SCREEN_WIDTH*SCREEN_HEIGHT


// Sample image data
static const char mapdata[IMAGE_SIZE] = {252,252,252,
252,252,252,252,252,252,200,200,200,252,252,252,252,252,252,56,56,56,252,252,252,252,252,252,168,168,168,200,200,200,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,40,40,56,252,252,252,252,252,252,236,236,236,252,252,252,252,252,252,200,184,200,104,88,104,136,120,136,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,104,88,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,184,184,184,252,252,252,84,108,108,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,188,24,152,76,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,232,200,200,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,56,56,56,232,200,184,240,196,188,0,0,0,240,196,188,240,196,188,216,216,200,244,240,220,244,240,220,244,240,220,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,136,180,216,
216,232,248,216,232,248,216,232,248,216,232,248,8,152,232,8,152,216,8,152,216,8,152,216,8,152,216,136,180,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,64,72,88,216,232,248,216,232,248,216,232,248,72,72,68,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,88,72,88,40,24,40,200,184,216,200,184,216,40,24,40,0,0,0,196,60,40,200,40,40,200,40,40,200,40,40,232,196,168,136,152,152,0,0,0,104,104,104,0,0,0,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,104,88,104,136,120,136,252,252,252,252,252,252,252,252,252,200,200,200,252,252,252,104,104,104,252,252,252,0,0,0,252,252,252,252,252,252,200,200,200,40,40,40,0,0,0,220,220,220,252,252,252,104,104,104,236,236,236,252,252,252,220,220,220,152,152,152,152,152,152,248,248,248,252,252,252,252,252,252,200,200,216,104,88,104,120,120,120,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,104,88,104,252,252,252,252,252,252,252,252,252,252,252,252,
184,184,184,72,72,68,0,0,0,40,40,40,168,168,168,24,24,24,252,252,252,168,168,152,8,132,192,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,136,216,8,56,76,8,152,216,8,152,216,8,152,216,8,24,8,212,228,204,212,228,204,184,200,184,24,24,24,24,24,24,200,200,184,212,228,204,212,228,204,56,56,56,212,228,204,212,228,204,212,228,204,104,104,104,0,0,0,104,104,104,240,196,188,240,196,188,240,196,188,56,40,36,0,0,0,172,152,148,240,196,188,240,196,188,240,196,188,108,88,84,188,152,132,0,0,0,240,196,188,240,196,188,188,168,152,0,0,0,136,136,136,8,24,8,24,152,76,8,152,216,60,128,176,0,0,0,176,196,208,72,72,68,216,232,248,216,232,248,72,72,68,216,232,248,216,232,248,8,152,216,8,108,164,0,0,0,8,108,164,72,72,68,216,232,248,216,232,248,136,136,136,0,0,0,104,104,104,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,72,72,68,200,200,216,216,232,248,0,0,0,40,40,40,216,232,248,216,232,248,0,0,0,144,148,168,216,232,248,216,232,248,184,168,196,
0,0,0,120,104,120,216,168,168,200,40,40,0,0,0,152,36,24,200,40,40,200,40,40,200,40,40,200,40,40,216,232,248,40,40,40,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,120,120,120,120,120,120,200,184,216,144,148,168,104,88,104,136,120,136,252,252,252,252,252,252,252,252,252,208,212,220,0,0,0,72,72,68,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,208,212,220,252,252,252,40,24,40,252,252,252,252,252,252,0,0,0,252,252,252,24,24,24,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,208,212,220,104,88,104,100,104,120,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,132,136,152,184,184,184,252,252,252,0,0,0,104,104,104,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,220,220,220,8,108,164,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,136,216,0,0,0,8,152,216,8,152,216,8,152,216,0,0,0,212,228,204,212,228,204,0,0,0,200,216,200,200,216,184,0,0,0,212,228,204,212,228,204,0,0,0,212,228,204,212,228,204,132,152,132,40,40,40,212,228,204,88,88,68,140,120,116,240,196,188,24,24,24,188,152,132,
240,196,188,0,0,0,232,200,184,240,196,188,0,0,0,188,152,132,188,152,132,0,0,0,240,196,188,240,196,188,0,0,0,232,232,200,232,232,216,0,0,0,24,152,76,8,152,216,0,0,0,216,232,248,144,168,168,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,0,0,0,192,220,244,136,152,152,0,0,0,216,232,248,164,168,184,24,24,24,216,232,248,100,104,120,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,208,212,232,176,196,208,216,232,248,0,0,0,40,40,40,136,152,152,216,232,248,208,212,232,0,0,0,216,232,248,216,232,248,0,0,0,152,120,72,200,40,40,200,40,40,200,40,40,188,40,24,0,0,0,200,184,216,200,184,200,44,20,20,0,0,0,232,200,200,216,232,248,216,232,248,216,232,248,216,232,232,120,120,120,120,120,120,232,232,232,252,252,252,200,184,216,200,184,216,200,184,216,144,148,168,104,88,104,252,252,252,252,252,252,252,252,252,252,252,252,208,212,220,56,56,56,200,200,200,168,168,168,252,252,252,252,252,252,252,252,252,104,104,104,72,72,68,0,0,0,184,184,184,136,136,136,
252,252,252,0,0,0,232,232,232,252,252,252,248,248,248,0,0,0,252,252,252,252,252,252,252,252,252,220,220,220,104,88,104,100,104,120,200,184,216,200,184,216,200,184,216,184,168,196,120,104,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,72,72,68,252,252,252,252,252,252,12,88,116,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,136,216,0,0,0,8,152,216,8,152,216,8,152,216,0,0,0,168,200,168,200,216,200,0,0,0,212,228,204,212,228,204,0,0,0,212,228,204,212,228,204,0,0,0,212,228,204,212,228,204,184,184,168,184,200,168,212,228,204,120,120,120,108,88,84,240,196,188,0,0,0,240,196,188,240,196,188,188,152,132,216,168,168,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,244,240,220,244,240,220,0,0,0,232,236,220,8,152,216,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,200,200,216,40,40,40,216,232,248,216,232,248,0,0,0,216,232,248,176,196,208,176,196,208,216,232,248,144,148,168,72,72,68,216,232,248,216,232,248,216,232,248,216,232,248,
216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,24,24,24,176,196,208,0,0,0,208,212,232,216,232,248,132,136,152,0,0,0,216,120,72,200,40,40,200,40,40,200,40,40,100,24,16,208,136,104,200,184,216,100,104,120,0,0,0,0,0,0,148,80,48,200,40,40,200,40,40,216,232,248,208,212,232,120,120,120,120,120,120,232,232,232,252,252,252,252,252,252,252,252,252,200,184,216,200,184,216,200,184,216,168,148,184,120,120,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,0,0,0,56,56,56,252,252,252,252,252,252,24,24,24,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,104,104,104,56,56,56,24,24,24,0,0,0,252,252,252,40,40,56,0,0,0,200,200,200,252,252,252,252,252,252,232,232,232,104,104,104,104,104,104,200,184,200,200,184,216,104,88,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,152,152,152,200,200,200,252,252,252,84,108,108,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,136,216,0,0,0,8,152,216,8,152,216,8,152,216,
0,0,0,24,152,76,200,216,184,0,0,0,212,228,204,212,228,204,0,0,0,200,216,184,212,228,204,0,0,0,212,228,204,212,228,204,212,228,204,200,216,200,24,24,24,0,0,0,232,200,200,240,196,188,0,0,0,56,56,56,56,56,56,56,56,56,200,152,152,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,248,216,200,244,240,220,0,0,0,244,240,220,8,152,216,0,0,0,136,152,152,176,196,208,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,176,196,208,72,72,68,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,40,40,40,0,0,0,216,232,232,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,200,200,216,0,0,0,216,232,248,216,232,248,144,148,168,100,104,120,196,216,216,0,0,0,232,216,216,196,60,40,28,8,8,100,24,16,200,40,40,152,36,24,216,168,168,0,0,0,104,88,104,200,184,216,200,184,216,144,148,168,200,184,216,200,184,216,200,40,40,188,40,24,104,104,104,120,120,120,236,236,236,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,120,136,
200,184,216,200,184,216,104,88,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,252,252,252,120,120,120,232,232,232,252,252,252,232,232,232,136,136,136,252,252,252,220,220,220,200,200,200,252,252,252,24,24,24,236,236,236,252,252,252,72,72,68,252,252,252,88,88,88,252,252,252,184,184,184,252,252,252,252,252,252,236,236,236,100,104,120,104,88,104,104,88,104,252,252,252,252,252,252,252,252,252,208,212,220,120,120,120,0,0,0,0,0,0,136,136,136,200,200,200,88,88,88,252,252,252,136,136,136,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,136,216,0,0,0,8,136,216,8,136,216,8,136,216,0,0,0,8,136,56,212,228,204,0,0,0,212,228,204,212,228,204,0,0,0,212,228,204,212,228,204,0,0,0,212,228,204,212,228,204,212,228,204,0,0,0,120,120,104,212,228,204,212,228,204,240,196,188,0,0,0,240,196,188,240,196,188,40,40,24,200,152,152,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,240,196,188,244,240,220,0,0,0,8,136,56,8,136,56,8,152,216,164,168,184,144,148,168,0,0,0,
216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,176,196,208,72,72,68,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,0,0,0,104,104,104,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,0,0,0,0,0,0,72,72,68,216,232,248,216,232,248,100,104,120,68,88,88,216,232,248,216,232,248,0,0,0,212,184,152,100,24,16,44,20,20,200,40,40,200,40,40,0,0,0,152,152,152,216,232,248,200,184,216,0,0,0,120,104,120,200,184,216,200,184,216,200,184,216,200,184,216,184,168,196,88,68,64,100,24,16,196,60,40,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,232,232,232,104,104,104,100,104,120,120,104,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,252,252,252,252,252,252,24,24,24,252,252,252,252,252,252,136,136,136,252,252,252,88,88,88,220,220,220,252,252,252,56,56,56,252,252,252,252,252,252,252,252,252,136,136,136,104,104,104,0,0,0,168,168,168,252,252,252,252,252,252,248,248,248,120,104,120,208,212,220,252,252,252,40,40,56,
168,168,168,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,200,200,200,8,108,164,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,136,216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,136,56,212,228,204,0,0,0,212,228,204,212,228,204,0,0,0,212,228,204,212,228,204,0,0,0,212,228,204,212,228,204,164,184,168,88,88,68,212,228,204,104,104,104,88,88,88,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,232,176,184,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,240,196,188,244,240,220,0,0,0,24,152,76,24,152,76,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,232,0,0,0,216,232,248,216,232,232,0,0,0,216,232,248,200,200,216,40,40,40,216,232,248,136,152,152,72,72,68,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,136,136,136,216,232,248,216,232,248,84,84,104,40,40,40,216,232,248,216,232,248,24,24,24,164,168,184,228,144,100,0,0,0,200,40,40,200,40,40,8,8,8,152,120,72,216,232,248,216,232,248,40,40,40,
0,0,0,0,0,0,136,120,136,200,184,216,200,184,216,200,184,216,184,168,196,104,88,104,104,104,104,200,184,200,200,40,40,200,40,40,248,248,248,252,252,252,252,252,252,252,252,252,208,212,220,120,120,120,136,136,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,136,136,252,252,252,252,252,252,0,0,0,152,152,152,168,168,168,252,252,252,252,252,252,56,56,56,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,136,136,252,252,252,252,252,252,12,88,116,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,136,216,0,0,0,8,152,216,8,152,216,8,152,216,0,0,0,96,164,104,168,200,152,56,56,56,0,0,0,0,0,0,72,72,68,212,228,204,212,228,204,0,0,0,0,0,0,0,0,0,212,228,204,0,0,0,56,56,56,0,0,0,200,216,184,232,216,200,156,136,136,0,0,0,
24,24,24,24,8,24,240,196,188,240,196,188,124,104,104,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,0,0,0,240,196,188,248,216,200,0,0,0,244,240,220,244,240,220,8,56,76,0,0,0,40,40,40,68,88,88,216,232,248,216,232,248,0,0,0,0,0,0,0,0,0,216,232,248,24,24,24,0,0,0,24,24,24,0,0,0,216,232,248,216,232,248,0,0,0,72,72,68,0,0,0,200,200,216,216,232,248,208,212,220,120,120,120,216,232,248,216,232,248,40,40,40,136,152,152,216,232,248,216,232,248,216,232,248,40,40,40,120,120,120,216,232,232,216,104,68,0,0,0,200,40,40,0,0,0,188,40,24,212,184,152,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,200,184,216,136,120,136,184,168,196,104,88,104,100,104,120,200,184,216,200,184,216,200,184,216,204,88,72,200,40,40,216,80,48,252,252,252,208,212,220,120,120,120,136,136,136,88,88,88,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,104,88,104,232,232,232,252,252,252,252,252,252,252,252,252,252,252,252,
0,0,0,104,104,104,252,252,252,252,252,252,72,72,68,252,252,252,252,252,252,252,252,252,152,152,152,208,212,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,84,84,104,8,152,216,8,152,216,8,152,216,8,132,192,8,108,164,8,136,216,0,0,0,196,216,216,120,120,104,244,240,220,0,0,0,216,216,184,24,152,76,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,120,120,104,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,244,240,220,244,240,220,244,240,220,8,152,188,8,152,232,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,196,216,216,
216,232,248,208,212,220,0,0,0,216,232,248,216,232,248,216,232,248,216,200,184,0,0,0,188,40,24,200,40,40,152,36,24,0,0,0,120,120,120,136,136,136,216,232,248,216,232,248,176,196,208,56,56,56,216,232,248,216,232,248,216,232,248,216,232,248,176,196,208,104,88,104,100,104,120,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,40,40,188,40,24,100,104,120,132,136,152,56,56,56,0,0,0,0,0,0,0,0,0,24,24,24,88,88,88,24,24,24,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,120,136,144,148,168,104,88,104,104,88,104,220,220,220,252,252,252,252,252,252,236,236,236,252,252,252,252,252,252,252,252,252,40,40,56,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,136,136,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,12,88,116,84,108,108,104,104,104,136,136,120,200,200,184,232,216,200,0,0,0,244,240,220,244,240,220,244,240,220,
0,0,0,244,240,220,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,200,216,200,104,104,104,104,104,104,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,120,120,104,120,120,104,8,136,56,8,136,56,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,232,0,0,0,216,232,248,216,232,248,216,232,248,176,196,208,0,0,0,216,232,248,216,232,248,104,104,104,40,40,40,228,176,140,200,40,40,200,40,40,188,40,24,0,0,0,216,120,72,216,232,248,104,104,104,40,40,40,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,200,200,216,120,120,120,132,136,152,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,168,148,184,100,24,16,100,24,16,44,20,20,0,0,0,0,0,0,0,0,0,0,0,0,56,56,56,200,200,200,
252,252,252,104,104,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,104,88,104,200,184,216,200,184,216,200,184,200,104,104,104,104,88,104,200,200,216,252,252,252,252,252,252,252,252,252,120,120,120,248,248,248,252,252,252,252,252,252,168,168,168,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,168,200,200,184,244,240,220,244,240,220,244,240,220,244,240,220,232,216,200,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,244,240,220,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,104,104,104,104,104,104,204,184,176,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,72,72,68,156,136,136,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,184,168,168,120,120,104,136,136,120,96,164,104,8,108,164,192,220,244,216,232,248,
216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,8,152,216,8,152,216,8,152,216,216,232,248,72,72,68,72,72,68,216,232,248,216,232,248,216,232,248,104,104,104,40,40,40,216,232,248,216,128,88,0,0,0,100,24,16,200,40,40,200,40,40,224,148,124,104,104,104,24,24,24,216,232,248,216,232,248,0,0,0,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,200,200,216,120,120,120,132,136,152,252,252,252,252,252,252,236,236,236,200,184,216,200,184,216,200,184,216,200,184,216,168,148,184,104,88,104,100,104,120,24,24,24,0,0,0,0,0,0,0,0,0,0,0,0,72,72,68,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,236,236,236,104,104,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,132,136,152,168,148,184,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,100,104,120,104,88,104,200,184,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,104,104,104,252,252,252,252,252,252,252,252,252,
248,248,248,0,0,0,88,88,88,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,96,164,104,152,184,152,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,200,200,184,184,200,184,200,200,184,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,200,152,152,24,8,24,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,216,216,200,216,216,200,244,240,220,8,136,216,88,172,228,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,216,232,248,0,0,0,164,168,184,216,232,248,216,232,248,168,168,168,0,0,0,100,24,16,200,40,40,200,40,40,0,0,0,204,184,176,216,232,248,216,232,248,216,232,248,0,0,0,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,176,196,208,120,120,120,132,136,152,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,200,184,216,200,184,216,144,148,168,104,88,104,104,104,104,24,8,24,0,0,0,0,0,0,0,0,0,0,0,0,60,56,36,252,252,252,252,252,252,232,232,232,24,24,24,252,252,252,248,248,248,104,104,104,252,252,252,252,252,252,40,24,40,252,252,252,252,252,252,200,200,200,220,220,220,252,252,252,252,252,252,252,252,252,200,200,216,104,88,104,136,120,136,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,120,104,120,104,88,104,184,184,184,252,252,252,252,252,252,252,252,252,208,212,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,40,24,40,40,40,56,248,248,248,252,252,252,252,252,252,56,56,56,252,252,252,208,212,220,56,56,56,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,216,216,184,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,120,120,120,200,200,184,212,228,204,212,228,204,120,120,120,200,216,184,240,196,188,
216,168,168,88,68,64,124,104,104,240,196,188,240,196,188,240,196,188,240,196,188,0,0,0,240,196,188,240,196,188,240,196,188,216,168,168,88,68,64,216,168,168,136,136,120,244,240,220,232,232,216,8,56,76,8,152,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,40,168,232,216,232,232,0,0,0,172,144,116,0,0,0,8,8,8,188,40,24,0,0,0,196,84,48,216,232,232,160,184,192,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,176,196,208,120,120,120,136,152,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,164,168,184,104,88,104,104,88,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,72,88,200,40,40,200,40,40,220,220,220,0,0,0,0,0,0,0,0,0,252,252,252,56,56,56,252,252,252,252,252,252,248,248,248,104,104,104,252,252,252,252,252,252,0,0,0,72,72,68,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,208,212,220,104,88,104,120,120,120,200,184,216,200,184,216,200,184,216,
200,184,216,100,104,120,152,136,152,120,120,120,104,88,104,184,184,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,88,88,88,232,232,232,0,0,0,252,252,252,252,252,252,72,72,68,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,120,120,104,152,152,136,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,184,200,168,212,228,204,212,228,204,0,0,0,212,228,204,232,216,200,0,0,0,216,168,168,156,136,136,24,24,24,240,196,188,240,196,188,188,152,132,0,0,0,216,168,168,240,196,188,240,196,188,0,0,0,216,168,168,140,120,116,0,0,0,244,240,220,96,164,104,0,0,0,8,152,188,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,192,220,244,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,228,144,100,152,36,24,0,0,0,188,40,24,200,40,40,
208,136,104,160,184,192,0,0,0,216,232,248,216,232,248,72,72,68,56,56,56,216,232,248,88,88,88,216,232,248,216,232,248,216,232,248,176,196,208,120,120,120,152,152,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,120,120,120,104,104,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,88,104,200,184,216,200,184,216,152,36,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,252,252,56,56,56,252,252,252,252,252,252,40,40,56,252,252,252,252,252,252,184,184,184,168,168,168,252,252,252,248,248,248,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,104,88,104,120,104,120,200,184,216,200,184,216,104,88,104,200,40,40,216,80,48,200,184,200,136,120,136,104,88,104,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,40,40,56,252,252,252,252,252,252,0,0,0,252,252,252,88,88,88,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,216,200,120,120,104,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,
244,240,220,244,240,220,244,240,220,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,184,200,168,212,228,204,212,228,204,0,0,0,212,228,204,164,184,168,56,40,36,240,196,188,240,196,188,0,0,0,240,196,188,240,196,188,56,40,36,188,152,132,72,72,68,240,196,188,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,244,240,220,244,240,220,0,0,0,8,152,216,136,180,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,8,152,216,8,152,216,32,152,216,196,84,48,200,40,40,200,40,40,200,40,40,44,20,20,88,68,64,216,232,248,216,232,248,216,232,248,68,88,88,56,56,56,216,232,248,216,232,248,216,232,248,216,232,248,64,72,88,176,196,208,160,184,192,120,120,120,144,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,120,120,120,88,88,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,56,56,200,184,216,200,184,216,144,148,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,120,120,252,252,252,0,0,0,
252,252,252,252,252,252,252,252,252,104,104,104,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,40,40,56,252,252,252,252,252,252,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,104,88,104,104,88,104,192,120,88,200,40,40,200,40,40,200,40,40,200,40,40,216,168,168,132,136,152,104,88,104,152,152,152,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,168,168,168,184,184,184,104,104,104,252,252,252,56,56,56,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,236,220,120,120,104,136,136,120,232,232,216,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,96,164,104,136,184,136,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,184,200,168,212,228,204,212,228,204,0,0,0,212,228,204,168,168,152,108,88,84,240,196,188,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,188,152,132,240,196,188,0,0,0,244,240,220,244,240,220,0,0,0,8,152,216,8,108,164,
216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,104,160,192,196,60,40,200,40,40,200,40,40,200,40,40,196,60,40,232,216,216,216,232,248,0,0,0,160,184,192,216,232,248,216,232,248,216,232,248,144,168,168,216,232,248,216,232,248,216,232,248,216,232,248,104,104,104,120,120,120,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,164,168,184,120,120,120,88,88,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,120,136,200,184,216,168,148,184,72,72,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,24,16,232,196,168,252,252,252,252,252,252,252,252,252,200,200,200,220,220,220,56,56,56,252,252,252,252,252,252,168,168,168,184,184,184,252,252,252,252,252,252,200,200,200,0,0,0,88,88,88,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,104,88,104,200,40,40,200,40,40,216,104,68,200,40,40,200,40,40,200,40,40,200,40,40,200,152,152,152,136,152,104,88,104,132,136,152,252,252,252,252,252,252,252,252,252,168,168,168,136,136,136,252,252,252,120,120,120,248,248,248,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,120,120,120,120,120,104,232,232,200,244,240,220,244,240,220,244,240,220,216,232,200,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,184,200,168,212,228,204,136,136,120,0,0,0,212,228,204,164,184,168,108,88,84,240,196,188,240,196,188,0,0,0,240,196,188,216,168,168,24,8,24,240,196,188,0,0,0,232,200,184,240,196,188,240,196,188,124,104,104,108,88,84,0,0,0,248,216,200,244,240,220,0,0,0,8,136,56,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,228,176,140,200,40,40,200,40,40,200,40,40,200,40,40,192,104,68,8,152,216,8,152,216,216,232,248,216,232,248,208,212,232,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,164,168,184,120,120,120,164,168,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,120,120,120,72,72,68,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,184,184,184,252,252,252,232,232,248,136,120,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,120,120,200,152,152,200,40,40,200,40,40,252,252,252,252,252,252,252,252,252,252,252,252,72,72,68,0,0,0,220,220,220,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,72,72,68,252,252,252,200,200,200,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,216,120,72,100,24,16,196,60,40,200,184,216,200,184,216,208,136,104,200,40,40,200,40,40,200,40,40,200,40,40,208,136,104,144,148,168,104,88,104,136,120,136,252,252,252,252,252,252,252,252,252,252,252,252,40,40,56,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,136,136,120,120,120,104,232,216,200,244,240,220,244,240,220,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,0,0,0,0,0,0,24,24,24,212,228,204,212,228,204,184,200,184,
40,40,40,240,196,188,240,196,188,0,0,0,240,196,188,108,88,84,156,136,136,240,196,188,124,104,104,124,104,104,240,196,188,0,0,0,240,196,188,240,196,188,0,0,0,240,196,188,244,240,220,0,0,0,8,136,56,24,152,76,192,220,244,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,128,88,200,40,40,200,40,40,200,40,40,200,40,40,172,144,116,8,152,216,8,152,216,8,152,216,8,152,216,136,180,216,216,232,248,216,232,248,208,212,232,216,232,248,216,232,248,216,232,248,216,232,248,164,168,184,120,120,120,184,184,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,120,120,120,72,72,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,200,200,252,252,252,252,252,252,152,152,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,120,136,200,184,216,200,184,216,200,184,216,200,40,40,200,40,40,248,216,184,252,252,252,136,136,136,252,252,252,252,252,252,252,252,252,88,88,88,152,152,152,200,200,200,252,252,252,252,252,252,252,252,252,40,40,40,252,252,252,0,0,0,252,252,252,252,252,252,88,88,88,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
200,40,40,100,24,16,216,168,168,200,184,216,200,184,216,200,184,216,200,184,216,200,152,152,200,40,40,200,40,40,200,40,40,200,40,40,204,88,72,168,148,184,200,184,216,164,168,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,136,136,120,120,104,216,216,200,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,184,200,168,212,228,204,200,216,200,0,0,0,212,228,204,212,228,204,0,0,0,88,68,64,40,40,24,88,68,64,240,196,188,0,0,0,240,196,188,240,196,188,232,176,184,0,0,0,240,196,188,88,68,64,56,40,36,108,88,84,24,8,24,240,196,188,244,240,220,0,0,0,244,240,220,8,108,164,32,132,188,216,232,248,216,232,248,220,220,220,216,80,48,200,40,40,188,40,24,152,36,24,200,40,40,232,200,184,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,232,216,232,248,216,232,248,216,232,248,
216,232,248,216,232,248,164,168,184,120,120,120,184,184,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,152,152,152,120,120,120,56,56,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,200,200,252,252,252,252,252,252,136,136,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,120,136,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,224,148,124,200,40,40,152,36,24,120,120,120,200,200,184,120,120,104,120,120,120,236,236,236,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,200,200,200,24,24,24,248,248,248,252,252,252,184,184,184,200,200,200,252,252,252,200,200,200,24,24,24,152,152,152,252,252,252,224,148,124,188,40,24,152,36,24,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,168,184,196,60,40,152,36,24,200,40,40,200,40,40,152,36,24,200,184,200,184,168,196,164,168,184,200,200,200,252,252,252,252,252,252,252,252,252,152,152,152,120,120,120,236,236,236,252,252,252,252,252,252,252,252,252,200,184,200,200,184,200,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
252,252,252,252,252,252,252,252,252,152,152,136,68,88,64,96,164,104,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,184,200,168,212,228,204,212,228,204,0,0,0,212,228,204,184,200,184,212,228,204,216,200,184,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,176,184,240,196,188,240,196,188,248,216,200,0,0,0,244,240,220,104,160,192,8,108,164,216,200,168,200,40,40,188,40,24,152,36,24,152,36,24,148,80,48,8,108,164,60,128,176,216,232,248,8,152,232,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,216,232,248,216,232,248,216,232,248,144,168,168,120,120,120,184,184,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,152,152,120,120,120,56,56,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,220,220,200,200,200,248,248,248,120,120,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,184,184,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,120,120,120,100,24,16,152,36,24,232,216,200,244,240,220,
244,240,220,216,216,200,120,120,104,120,120,104,220,220,220,252,252,252,252,252,252,252,252,252,120,120,120,56,56,56,248,248,248,252,252,252,248,248,248,88,88,88,252,252,252,40,40,56,200,200,200,40,40,56,252,252,252,252,252,252,252,252,252,200,40,40,100,24,16,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,56,56,56,204,88,72,188,40,24,0,0,0,188,40,24,200,40,40,108,88,84,88,88,88,200,184,200,248,248,248,0,0,0,120,120,120,168,168,168,0,0,0,208,212,220,252,252,252,252,252,252,0,0,0,72,72,68,0,0,0,0,0,0,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,104,124,96,104,104,104,164,184,168,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,184,200,168,212,228,204,200,216,200,0,0,0,212,228,204,132,152,132,104,104,104,132,152,132,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,0,0,0,232,196,168,196,60,40,
200,40,40,152,36,24,152,36,24,152,36,24,108,88,84,8,108,164,8,108,164,8,108,164,104,160,192,216,232,248,216,232,248,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,216,232,248,144,148,168,120,120,120,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,152,152,120,120,120,40,40,40,0,0,0,0,0,0,0,0,0,0,0,0,24,24,24,232,232,232,252,252,252,252,252,252,40,40,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,200,200,252,252,252,252,252,252,232,232,232,200,184,216,200,184,216,200,184,216,200,184,216,120,104,120,104,88,104,200,184,200,208,136,104,200,40,40,196,60,40,244,240,220,244,240,220,244,240,220,244,240,220,232,216,200,120,120,104,120,120,104,216,216,200,252,252,252,200,200,200,236,236,236,252,252,252,252,252,252,0,0,0,184,184,184,56,56,56,252,252,252,56,56,56,252,252,252,252,252,252,252,252,252,252,252,252,216,80,48,152,36,24,192,120,88,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,56,56,56,200,184,216,100,104,120,88,68,64,100,24,16,200,40,40,100,24,16,100,24,16,208,136,104,
168,148,184,0,0,0,248,248,248,252,252,252,200,184,200,24,24,24,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,208,212,220,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,152,104,104,104,164,184,168,212,228,204,212,228,204,212,228,204,0,0,0,0,0,0,0,0,0,0,0,0,120,120,104,212,228,204,200,216,200,104,104,104,104,104,104,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,228,176,140,216,80,48,0,0,0,200,40,40,200,40,40,188,40,24,152,36,24,104,104,104,8,108,164,8,108,164,32,132,188,192,220,244,216,232,248,216,232,248,216,232,248,216,232,248,8,152,232,8,152,216,8,152,216,8,152,216,8,152,216,8,108,164,100,104,120,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,132,136,152,120,120,120,40,24,40,0,0,0,0,0,0,0,0,0,0,0,0,40,24,40,236,236,236,252,252,252,252,252,252,72,72,68,0,0,0,0,0,0,
0,0,0,0,0,0,8,8,8,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,184,216,200,184,216,120,104,120,104,88,104,168,148,184,200,184,216,168,148,184,0,0,0,8,8,8,44,20,20,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,232,232,216,120,120,104,120,120,104,216,200,200,252,252,252,252,252,252,72,72,68,24,24,24,200,200,200,252,252,252,168,168,168,236,236,236,252,252,252,252,252,252,236,236,236,56,56,56,172,152,148,200,40,40,100,24,16,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,56,56,56,200,184,216,0,0,0,200,184,216,0,0,0,200,152,152,100,24,16,100,24,16,200,40,40,152,36,24,44,20,20,200,184,216,136,120,136,220,220,220,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,168,104,104,104,152,168,152,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,
104,104,104,104,104,104,184,184,168,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,200,184,240,196,188,240,196,188,228,176,140,216,80,48,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,112,92,52,244,240,220,8,108,164,8,108,164,136,180,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,8,152,216,12,88,116,12,88,116,160,184,192,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,136,136,120,120,120,24,24,24,0,0,0,0,0,0,0,0,0,0,0,0,56,56,56,248,248,248,252,252,252,252,252,252,56,56,56,0,0,0,0,0,0,0,0,0,0,0,0,24,24,24,216,200,216,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,120,104,88,104,184,168,196,200,184,216,200,184,216,200,184,216,0,0,0,200,184,216,212,104,88,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,232,232,216,136,136,120,120,120,104,200,200,184,236,236,236,252,252,252,252,252,252,236,236,236,168,168,168,252,252,252,220,220,220,24,24,24,136,136,136,
252,252,252,0,0,0,200,40,40,100,24,16,216,168,168,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,56,56,56,200,184,216,0,0,0,200,184,216,0,0,0,200,184,216,100,104,120,88,68,64,200,40,40,152,36,24,44,20,20,200,40,40,216,80,48,200,184,200,0,0,0,236,236,236,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,200,184,104,104,104,152,152,136,212,228,204,212,228,204,212,228,204,212,228,204,200,216,200,152,168,152,104,104,104,104,104,104,120,120,104,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,228,176,140,216,80,48,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,216,128,88,240,196,188,120,120,104,120,120,104,244,240,220,104,160,192,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,84,108,108,12,88,116,176,196,208,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
252,252,252,248,248,248,136,136,136,100,104,120,24,24,24,0,0,0,0,0,0,0,0,0,0,0,0,72,72,68,252,252,252,252,252,252,236,236,236,40,40,56,0,0,0,0,0,0,0,0,0,0,0,0,40,24,40,208,212,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,120,120,120,120,120,120,208,212,232,200,184,216,144,148,168,200,184,216,200,184,216,200,184,216,104,88,104,120,120,120,200,184,216,152,36,24,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,136,136,120,120,120,104,252,252,252,252,252,252,72,72,68,200,200,200,0,0,0,168,168,168,252,252,252,252,252,252,252,252,252,0,0,0,228,176,140,152,36,24,152,36,24,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,56,56,56,168,148,184,88,72,88,200,184,216,104,104,104,144,148,168,100,104,120,88,88,88,200,184,216,136,120,136,44,20,20,200,40,40,200,40,40,200,40,40,0,0,0,216,168,168,200,184,216,0,0,0,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,216,200,104,104,104,136,136,120,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,120,120,104,184,188,132,240,196,188,240,196,188,240,196,188,228,176,140,216,80,48,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,216,128,88,240,196,188,240,196,188,240,196,188,240,196,188,120,120,104,120,120,104,8,136,56,8,136,56,8,108,164,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,132,136,152,120,120,120,208,212,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,120,120,120,104,104,104,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,88,88,88,72,72,68,208,212,220,232,232,232,40,24,40,0,0,0,0,0,0,0,0,0,0,0,0,40,40,40,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,120,120,120,136,136,136,216,232,248,216,232,248,216,232,248,120,120,120,0,0,0,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,204,88,72,0,0,0,
88,88,88,244,240,220,244,240,220,244,240,220,0,0,0,0,0,0,40,40,40,152,152,136,244,240,220,244,240,220,244,240,220,120,120,104,248,248,248,252,252,252,120,120,120,136,136,136,252,252,252,252,252,252,252,252,252,252,252,252,56,56,56,184,184,184,252,252,252,200,40,40,100,24,16,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,56,56,56,72,56,72,164,168,184,200,184,216,184,168,196,40,40,40,100,104,120,88,88,88,200,184,216,136,120,136,56,56,56,200,184,216,216,104,68,200,40,40,0,0,0,200,40,40,200,40,40,0,0,0,200,184,216,184,184,184,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,104,104,104,136,136,120,200,200,152,248,244,140,248,244,140,248,244,140,248,244,140,248,200,168,204,88,72,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,216,120,72,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,184,168,168,120,120,104,
136,136,120,24,152,76,176,196,208,8,108,164,192,220,244,216,232,248,216,232,248,216,232,248,136,136,136,120,120,120,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,120,120,120,104,104,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,104,104,252,252,252,252,252,252,72,72,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,40,40,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,120,120,120,136,152,152,216,232,248,216,232,248,120,120,120,216,232,248,216,232,248,144,148,168,136,120,136,100,104,120,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,244,240,220,56,56,56,152,152,136,244,240,220,244,240,220,0,0,0,232,216,200,200,200,184,24,24,24,88,88,68,244,240,220,244,240,220,200,200,184,152,152,136,252,252,252,252,252,252,0,0,0,252,252,252,220,220,220,56,56,56,88,88,88,252,252,252,252,252,252,252,252,252,216,80,48,100,24,16,212,104,88,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,56,56,56,0,0,0,200,184,216,200,184,216,200,184,216,0,0,0,100,104,120,88,88,88,200,184,216,
136,120,136,56,56,56,200,184,216,200,184,216,200,184,216,0,0,0,200,40,40,200,40,40,0,0,0,200,40,40,148,80,48,200,184,216,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,216,248,248,152,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,232,136,204,132,56,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,212,104,88,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,120,120,104,120,120,104,184,184,168,244,240,220,8,108,164,8,108,164,216,232,248,136,136,136,120,120,120,232,232,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,232,232,12,88,116,68,88,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,120,120,252,252,252,252,252,252,208,212,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,56,56,232,232,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
236,236,236,120,120,120,144,148,168,216,232,248,216,232,248,104,104,104,216,232,232,164,168,184,144,148,168,216,232,248,164,168,184,168,168,168,0,0,0,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,244,240,220,200,200,184,0,0,0,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,120,120,104,252,252,252,252,252,252,208,212,220,72,72,68,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,232,188,40,24,152,36,24,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,56,56,56,0,0,0,200,184,216,200,184,216,200,184,216,24,8,24,104,104,104,88,88,88,200,184,216,164,168,184,0,0,0,200,184,216,200,184,216,120,120,120,24,24,24,200,184,216,200,152,152,0,0,0,200,40,40,200,40,40,152,36,24,0,0,0,200,184,216,152,136,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,200,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,208,204,116,248,244,140,228,168,76,0,0,0,
152,36,24,200,40,40,200,40,40,200,40,40,216,104,68,232,196,168,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,204,184,176,120,120,104,120,120,104,24,152,76,120,168,152,12,88,116,84,108,108,232,232,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,120,120,120,64,72,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,152,152,252,252,252,252,252,252,200,200,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,72,68,236,236,236,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,120,120,120,120,120,120,216,232,248,216,232,248,72,72,68,0,0,0,176,196,208,216,232,248,216,232,248,0,0,0,216,232,248,160,184,192,164,168,184,144,148,168,120,120,120,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,136,136,120,216,216,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,200,40,40,100,24,16,200,152,152,200,184,216,200,184,216,200,184,216,164,168,184,0,0,0,120,104,120,200,184,216,200,184,216,200,184,216,136,120,136,0,0,0,88,88,88,200,184,216,200,184,216,24,8,24,24,8,24,56,56,56,0,0,0,200,184,200,200,184,216,200,184,216,0,0,0,0,0,0,0,0,0,0,0,0,188,40,24,200,40,40,152,36,24,104,88,104,136,120,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,232,248,240,172,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,228,168,76,0,0,0,200,40,40,200,40,40,0,0,0,0,0,0,216,104,68,248,232,136,248,244,140,248,216,184,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,120,120,104,120,120,104,20,44,24,20,44,24,216,232,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,120,120,120,88,88,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,168,168,
252,252,252,252,252,252,200,200,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,88,88,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,120,120,120,160,184,192,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,144,168,168,164,168,184,176,196,208,144,148,168,208,212,232,0,0,0,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,232,232,200,244,240,220,0,0,0,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,232,232,200,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,228,176,140,152,36,24,188,40,24,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,164,168,184,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,196,84,48,152,36,24,100,24,16,100,24,16,100,24,16,88,68,64,120,120,120,252,252,252,
248,248,216,248,248,152,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,236,220,120,204,132,56,28,8,8,200,40,40,200,40,40,200,40,40,200,40,40,0,0,0,200,40,40,216,80,48,0,0,0,208,204,116,112,92,52,248,244,140,248,244,140,248,244,140,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,176,184,124,104,104,120,120,120,236,236,236,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,120,120,120,72,72,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,168,184,252,252,252,252,252,252,184,184,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,88,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,120,120,120,200,200,216,216,232,248,196,216,216,56,56,56,72,72,68,216,232,248,216,232,248,100,104,120,144,148,168,216,232,248,216,232,248,176,196,208,216,232,248,0,0,0,208,212,232,136,136,136,216,232,248,132,136,152,136,120,136,200,184,216,200,184,216,200,184,216,200,184,216,120,104,120,
244,240,220,0,0,0,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,104,104,104,252,252,252,200,40,40,100,24,16,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,184,168,196,132,136,152,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,88,68,64,100,24,16,152,36,24,200,40,40,200,40,40,228,168,76,248,244,140,248,244,140,248,244,140,248,244,140,168,168,88,228,168,76,196,60,40,200,40,40,200,40,40,200,40,40,200,40,40,28,8,8,152,36,24,188,40,24,100,24,16,0,0,0,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,24,24,8,248,244,140,248,244,140,248,244,140,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,176,184,124,104,104,124,104,104,
236,236,236,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,120,120,120,72,72,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,200,200,252,252,252,252,252,252,152,152,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,104,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,208,212,220,120,120,120,196,216,216,216,232,248,216,232,248,0,0,0,56,56,56,216,232,248,196,216,216,0,0,0,216,232,248,216,232,248,0,0,0,40,40,40,0,0,0,196,216,216,216,232,248,136,152,152,160,184,192,136,136,136,216,232,248,208,212,232,104,88,104,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,0,0,0,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,168,168,152,184,184,168,252,252,252,184,184,184,136,136,136,104,104,104,88,88,88,72,72,68,0,0,0,104,104,104,252,252,252,252,252,252,216,104,68,100,24,16,216,104,68,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,
200,184,216,200,184,216,164,168,184,136,120,136,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,152,152,136,200,200,152,248,244,140,248,244,140,248,244,140,228,168,76,200,40,40,200,40,40,188,40,24,200,40,40,100,24,16,0,0,0,0,0,0,28,8,8,0,0,0,152,36,24,200,40,40,200,40,40,200,40,40,216,104,68,228,168,76,0,0,0,88,68,64,192,172,104,208,204,116,56,76,52,248,244,140,248,244,140,0,0,0,248,244,140,248,232,136,24,24,24,248,244,140,248,244,140,248,220,164,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,216,168,168,124,104,104,124,104,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,216,200,84,84,104,56,56,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,200,200,252,252,252,252,252,252,136,136,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,120,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,216,120,120,120,208,212,232,216,232,248,160,184,192,0,0,0,136,152,152,164,168,184,88,88,88,216,232,248,
216,232,248,120,120,120,136,136,136,216,232,248,88,88,88,144,168,168,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,104,104,104,216,232,248,216,232,248,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,184,168,196,0,0,0,200,184,216,216,200,216,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,252,252,252,248,248,248,252,252,252,252,252,252,236,236,236,40,24,40,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,188,40,24,152,36,24,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,164,168,184,136,120,136,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,152,152,136,216,216,152,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,24,24,8,0,0,0,200,40,40,152,36,24,100,24,16,200,40,40,200,40,40,204,132,56,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,168,168,88,112,92,52,248,244,140,192,172,104,128,120,72,248,244,140,248,244,140,0,0,0,
248,244,140,248,244,140,56,76,52,208,204,116,248,244,140,248,244,140,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,176,184,108,88,84,124,104,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,200,184,20,44,24,56,56,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,220,220,252,252,252,252,252,252,120,120,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,120,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,132,136,152,176,196,208,216,232,248,216,232,248,0,0,0,104,104,104,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,136,136,136,216,232,248,164,168,184,216,232,248,216,232,248,216,232,248,208,212,232,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,56,40,56,104,88,104,200,184,216,200,184,216,0,0,0,200,200,200,232,216,200,88,88,68,56,56,56,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,236,236,236,252,252,252,252,252,252,200,200,200,104,104,104,
252,252,252,252,252,252,252,252,252,208,212,220,40,24,40,236,236,236,200,40,40,100,24,16,200,152,152,200,184,216,200,184,216,200,184,216,168,148,184,120,120,120,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,104,104,104,172,152,148,216,216,152,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,0,0,0,248,232,136,236,196,100,0,0,0,248,244,140,248,244,140,248,244,140,128,120,72,148,144,92,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,24,24,8,248,232,136,168,168,88,168,168,88,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,220,164,240,196,188,240,196,188,240,196,188,240,196,188,216,168,168,124,104,104,124,104,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,200,200,124,104,104,40,40,40,0,0,0,0,0,0,0,0,0,0,0,0,24,24,24,232,232,232,252,252,252,252,252,252,104,104,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,136,136,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,120,120,120,216,232,248,216,232,248,144,148,168,216,232,248,216,232,248,144,148,168,104,104,104,216,232,248,216,232,248,216,232,248,144,148,168,120,120,120,216,232,248,216,232,248,100,104,120,160,184,192,216,232,248,72,72,68,68,88,88,0,0,0,164,168,184,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,200,184,216,200,184,216,200,184,216,200,184,216,0,0,0,40,40,40,200,184,216,200,184,216,200,184,216,0,0,0,0,0,0,0,0,0,88,88,68,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,200,200,184,136,136,120,252,252,252,168,168,168,168,168,168,252,252,252,252,252,252,120,120,120,0,0,0,184,184,184,236,236,236,72,72,68,232,196,168,100,24,16,100,24,16,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,100,104,120,168,168,152,216,216,152,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,236,220,120,60,56,36,248,244,140,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,128,120,72,208,204,116,248,244,140,248,244,140,0,0,0,88,68,64,
248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,232,136,24,24,8,128,120,72,192,172,104,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,128,120,72,168,168,88,248,244,140,248,244,140,240,196,188,240,196,188,216,168,168,108,88,84,140,120,116,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,204,184,176,108,88,84,24,24,24,0,0,0,0,0,0,0,0,0,0,0,0,24,24,24,104,160,192,252,252,252,252,252,252,72,72,68,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,152,152,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,120,120,120,136,152,152,216,232,248,144,168,168,24,24,24,164,168,184,0,0,0,208,212,232,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,176,196,208,104,104,104,216,232,248,216,232,248,160,184,192,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,200,200,216,200,184,216,200,184,216,200,184,216,200,184,216,
200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,220,220,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,252,252,252,252,252,252,184,184,184,0,0,0,104,104,104,248,248,248,252,252,252,252,252,252,252,252,252,24,24,24,252,252,252,188,40,24,100,24,16,104,88,104,120,104,120,168,168,152,232,232,152,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,112,92,52,0,0,0,0,0,0,0,0,0,200,184,120,24,24,8,236,220,120,248,244,140,248,244,140,248,232,136,0,0,0,248,244,140,236,220,120,112,92,52,248,244,140,192,172,104,128,120,72,192,172,104,168,168,88,248,244,140,60,56,36,232,232,136,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,128,120,72,24,24,24,236,220,120,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,200,200,152,188,168,152,124,104,104,140,120,116,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,168,168,108,88,84,24,24,24,
0,0,0,0,0,0,0,0,0,0,0,0,24,24,24,8,136,56,8,136,56,232,232,216,8,24,24,0,0,0,0,0,0,0,0,0,0,0,0,24,24,24,152,152,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,196,216,216,24,24,24,216,232,248,136,152,152,136,136,136,216,232,248,216,232,248,216,232,248,132,136,152,136,152,152,216,232,232,24,24,24,196,216,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,104,104,104,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,136,136,120,200,200,200,252,252,252,40,40,40,248,248,248,252,252,252,252,252,252,252,252,252,200,200,200,0,0,0,232,236,220,248,248,200,204,132,56,200,40,40,216,104,68,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,216,216,136,248,244,140,248,244,140,248,244,140,
0,0,0,248,244,140,128,120,72,192,172,104,248,244,140,248,244,140,248,244,140,248,244,140,0,0,0,0,0,0,0,0,0,60,56,36,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,60,56,36,208,204,116,248,244,140,60,56,36,248,244,140,192,172,104,148,144,92,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,232,136,184,188,132,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,216,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,168,168,108,88,84,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,72,56,72,240,196,188,120,120,104,136,136,120,24,24,24,0,0,0,0,0,0,0,0,0,0,0,0,40,24,40,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,164,168,184,120,120,120,216,232,248,176,196,208,0,0,0,0,0,0,196,216,216,216,232,248,56,56,56,176,196,208,216,232,248,216,232,248,0,0,0,208,212,220,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,
0,0,0,24,24,24,208,212,232,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,200,200,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,104,88,104,232,232,216,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,216,216,200,168,168,152,120,120,104,120,120,104,252,252,252,232,232,232,56,56,56,200,200,200,120,120,104,0,0,0,192,172,104,248,244,140,248,244,140,236,196,100,228,168,76,200,40,40,200,40,40,248,244,140,232,232,136,148,144,92,40,40,24,112,92,52,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,208,204,116,112,92,52,248,244,140,248,244,140,248,244,140,248,244,140,112,92,52,168,168,88,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,128,120,72,112,92,52,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,240,172,248,248,232,236,236,236,
120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,168,168,108,88,84,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,88,68,64,240,196,188,240,196,188,200,152,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,24,40,152,152,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,144,168,168,120,120,120,164,168,184,216,232,248,196,216,216,56,56,56,216,232,248,208,212,220,0,0,0,216,232,248,200,200,216,24,24,24,216,232,248,216,232,248,196,216,216,24,24,24,216,232,248,120,120,120,144,148,168,208,212,232,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,120,120,120,216,232,232,216,232,248,216,232,248,216,232,248,216,232,248,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,136,120,136,200,200,168,244,240,220,200,200,184,136,136,136,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,120,248,248,200,248,248,152,208,204,116,
192,172,104,204,132,56,200,40,40,200,40,40,200,40,40,200,40,40,188,40,24,152,36,24,200,40,40,200,40,40,40,40,24,0,0,0,148,144,92,236,220,120,248,244,140,248,244,140,60,56,36,216,216,136,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,216,216,136,88,88,68,248,244,140,248,244,140,56,76,52,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,56,76,52,0,0,0,24,24,8,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,248,152,248,248,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,200,200,184,244,240,220,244,240,220,120,120,104,152,152,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,168,168,108,88,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,88,84,240,196,188,240,196,188,188,152,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,24,8,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,152,12,88,116,8,108,164,216,232,248,
216,232,248,216,232,248,144,168,168,136,152,152,216,232,248,216,232,248,24,24,24,208,212,220,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,176,196,208,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,200,200,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,216,200,184,200,152,136,152,104,88,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,152,152,136,216,200,152,248,244,140,248,244,140,236,196,100,216,80,48,200,40,40,200,40,40,200,40,40,200,40,40,188,40,24,200,40,40,0,0,0,0,0,0,28,8,8,56,40,36,0,0,0,236,220,120,168,168,88,148,144,92,248,244,140,248,244,140,248,244,140,248,244,140,168,168,88,128,120,72,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,200,184,120,112,92,52,192,172,104,128,120,72,248,244,140,248,244,140,192,172,104,112,92,52,112,92,52,248,244,140,248,244,140,
128,120,72,208,204,116,248,244,140,112,92,52,208,204,116,248,244,140,248,244,140,248,244,140,232,232,152,248,248,216,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,208,212,220,208,212,220,252,252,252,136,136,136,232,232,200,244,240,220,120,120,104,216,216,200,252,252,252,252,252,252,232,232,232,104,104,104,0,0,0,240,196,188,56,40,36,0,0,0,0,0,0,0,0,0,0,0,0,124,104,104,108,88,84,232,176,184,156,136,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,56,56,136,136,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,100,124,128,120,120,104,184,184,168,104,160,192,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,136,152,152,0,0,0,136,152,152,216,232,248,176,196,208,72,72,68,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,200,184,216,200,184,216,
184,168,196,136,120,136,104,88,104,104,88,104,104,88,104,104,88,104,104,88,104,120,120,104,168,168,152,232,232,152,248,244,140,236,220,120,228,168,76,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,152,36,24,152,36,24,200,40,40,196,84,48,112,92,52,248,244,140,128,120,72,192,172,104,248,244,140,248,244,140,128,120,72,200,184,120,248,232,136,24,24,8,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,0,0,0,0,0,0,0,0,0,60,56,36,248,244,140,248,244,140,40,40,24,232,232,136,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,24,24,8,148,144,92,192,172,104,248,244,140,248,244,140,248,244,140,0,0,0,200,184,120,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,168,184,152,152,152,136,120,120,104,120,120,104,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,40,24,40,0,0,0,168,168,168,40,40,40,252,252,252,220,220,220,216,216,200,244,240,220,244,240,220,200,200,200,56,56,56,0,0,0,168,168,168,248,248,248,244,240,220,240,196,188,108,88,84,0,0,0,0,0,0,140,120,116,240,196,188,240,196,188,124,104,104,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,72,72,68,140,120,116,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,144,168,168,100,104,120,12,88,116,176,196,208,244,240,220,244,240,220,8,108,164,60,128,176,216,232,248,216,232,248,216,232,248,24,24,24,196,216,216,208,212,232,216,232,248,216,232,248,216,232,248,216,232,248,40,40,40,72,72,68,40,40,40,68,88,88,216,232,248,216,232,248,216,232,248,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,144,168,168,144,148,168,216,232,248,216,232,248,216,232,248,216,232,248,200,200,216,104,88,104,104,88,104,104,88,104,104,88,104,100,104,120,184,184,152,248,244,140,248,244,140,236,196,100,216,104,68,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,100,24,16,152,36,24,228,168,76,60,56,36,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,208,204,116,112,92,52,248,244,140,248,244,140,148,144,92,168,168,88,248,244,140,0,0,0,148,144,92,0,0,0,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,
248,232,136,0,0,0,248,244,140,148,144,92,148,144,92,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,0,0,0,208,204,116,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,136,168,152,12,88,116,12,88,116,12,88,116,12,88,116,84,84,104,120,120,104,136,136,120,168,168,152,168,168,168,252,252,252,168,168,168,0,0,0,56,56,56,104,104,104,208,212,220,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,184,184,168,104,104,104,56,56,56,200,200,184,252,252,252,0,0,0,248,248,232,120,120,104,0,0,0,0,0,0,0,0,0,108,88,84,240,196,188,240,196,188,156,136,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,68,64,140,120,116,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,168,12,88,116,12,88,116,216,232,248,8,108,164,8,108,164,244,240,220,244,240,220,60,128,176,8,108,164,216,232,248,216,232,248,216,232,248,208,212,220,24,24,24,216,232,248,216,232,248,164,168,184,104,104,104,216,232,248,216,232,248,208,212,232,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,120,120,120,216,232,248,216,232,248,
216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,136,136,136,200,200,152,248,244,140,236,220,120,228,168,76,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,100,24,16,0,0,0,0,0,0,0,0,0,236,196,100,248,244,140,208,204,116,112,92,52,248,244,140,0,0,0,192,172,104,168,168,88,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,232,232,136,168,168,88,0,0,0,248,244,140,248,244,140,0,0,0,168,168,88,248,232,136,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,232,232,136,24,24,24,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,240,172,248,248,216,252,252,252,120,120,104,12,88,116,12,88,116,12,88,116,12,88,116,8,108,164,8,132,192,8,108,164,244,240,220,244,240,220,244,240,220,120,120,104,252,252,252,40,40,40,248,248,248,252,252,252,236,236,236,72,72,68,252,252,252,252,252,252,184,184,184,252,252,252,
252,252,252,120,120,120,232,216,200,72,72,68,244,240,220,252,252,252,0,0,0,244,240,220,72,72,68,200,200,168,244,240,220,240,196,188,240,196,188,240,196,188,40,40,24,0,0,0,0,0,0,0,0,0,0,0,0,108,88,84,140,120,116,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,132,152,132,20,44,24,184,184,168,232,232,216,8,108,164,136,180,216,168,204,236,8,108,164,196,216,216,244,240,220,244,240,220,8,108,164,104,160,192,216,232,248,216,232,248,216,232,248,24,24,24,200,200,216,216,232,248,120,120,120,104,104,104,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,200,200,216,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,104,68,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,152,36,24,152,36,24,196,60,40,228,168,76,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,0,0,0,248,244,140,
0,0,0,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,0,0,0,128,120,72,60,56,36,112,92,52,248,244,140,112,92,52,208,204,116,248,244,140,248,244,140,248,244,140,248,244,140,112,92,52,208,204,116,248,244,140,168,168,88,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,240,172,248,248,216,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,84,108,108,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,184,184,168,244,240,220,244,240,220,120,120,104,252,252,252,200,200,200,152,152,152,252,252,252,252,252,252,248,248,248,252,252,252,252,252,252,168,168,168,120,120,120,252,252,252,216,216,200,244,240,220,40,40,40,0,0,0,24,24,24,216,216,200,244,240,220,244,240,220,168,168,152,0,0,0,248,232,216,216,168,168,0,0,0,0,0,0,56,56,56,240,196,188,240,196,188,248,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,232,216,240,196,188,136,184,136,8,136,56,244,240,220,244,240,220,40,168,232,8,152,216,216,232,248,8,152,216,8,152,216,244,240,220,244,240,220,32,132,188,
8,152,216,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,0,0,0,104,104,104,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,200,40,40,200,40,40,100,24,16,152,36,24,216,104,68,236,196,100,248,244,140,60,56,36,248,244,140,192,172,104,112,92,52,248,244,140,248,244,140,248,244,140,24,24,8,248,244,140,248,244,140,0,0,0,248,244,140,0,0,0,248,244,140,208,204,116,148,144,92,128,120,72,192,172,104,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,192,172,104,128,120,72,248,244,140,248,244,140,192,172,104,248,244,140,208,204,116,0,0,0,0,0,0,112,92,52,248,244,140,248,244,140,248,244,140,248,244,140,248,240,172,248,248,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,168,184,184,168,184,184,168,
8,136,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,104,104,104,244,240,220,244,240,220,184,184,168,184,184,184,252,252,252,232,232,232,252,252,252,236,236,236,120,120,120,0,0,0,120,120,120,236,236,236,252,252,252,252,252,252,252,252,252,152,152,136,244,240,220,244,240,220,244,240,220,136,136,120,0,0,0,56,56,56,200,200,184,152,152,136,184,184,168,240,196,188,0,0,0,0,0,0,88,68,64,240,196,188,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,252,252,252,136,136,136,156,136,136,216,168,168,240,196,188,56,56,56,184,184,168,184,184,168,244,240,220,72,72,68,232,216,200,8,152,216,60,128,176,40,56,56,8,56,76,72,72,68,152,152,136,244,240,220,8,152,216,136,180,216,72,72,68,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,72,72,68,208,212,232,200,200,216,72,72,68,216,232,248,216,232,248,216,232,248,132,136,152,72,72,68,216,232,248,216,232,248,120,120,120,120,120,120,216,232,248,216,232,248,216,232,248,72,72,68,160,184,192,216,232,248,72,72,68,216,232,248,216,232,248,136,152,152,72,72,68,216,232,248,216,232,248,136,152,152,104,104,104,216,232,248,216,232,248,72,72,68,228,168,76,
236,220,120,208,204,116,88,68,64,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,232,232,136,40,40,24,248,244,140,248,244,140,248,244,140,148,144,92,168,168,88,248,244,140,0,0,0,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,208,204,116,112,92,52,248,244,140,128,120,72,168,168,88,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,0,0,0,0,0,0,112,92,52,248,244,140,248,244,140,248,244,140,248,244,140,248,240,172,248,248,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,120,120,104,244,240,220,244,240,220,8,108,164,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,12,88,116,244,240,220,244,240,220,244,240,220,120,120,104,252,252,252,88,88,88,24,24,24,168,168,168,236,236,236,208,212,220,200,184,200,168,168,168,136,136,136,252,252,252,252,252,252,88,88,88,244,240,220,0,0,0,120,120,120,232,232,216,244,240,220,244,240,220,232,216,200,244,240,220,24,24,24,248,232,216,0,0,0,108,88,84,140,120,116,252,252,252,0,0,0,200,184,200,200,184,200,
200,184,200,200,184,200,248,232,216,108,88,84,124,104,104,240,196,188,240,196,188,0,0,0,40,40,24,244,240,220,168,200,152,0,0,0,232,216,200,88,172,228,8,108,164,0,0,0,8,108,164,8,108,164,40,40,40,0,0,0,32,152,216,8,152,216,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,160,184,192,0,0,0,216,232,248,176,196,208,0,0,0,216,232,248,216,232,248,216,232,248,0,0,0,0,0,0,216,232,248,216,232,248,104,104,104,104,104,104,216,232,248,216,232,248,24,24,24,56,56,56,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,0,0,0,0,0,0,216,232,248,216,232,248,136,136,136,72,72,68,216,232,248,216,232,248,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,236,220,120,60,56,36,248,244,140,128,120,72,168,168,88,0,0,0,248,244,140,248,244,140,208,204,116,128,120,72,0,0,0,248,244,140,208,204,116,40,40,24,40,40,24,0,0,0,112,92,52,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,216,216,152,152,168,128,120,120,104,252,252,252,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,152,152,136,216,216,200,244,240,220,244,240,220,84,108,108,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,132,192,216,216,200,244,240,220,244,240,220,120,120,104,252,252,252,168,168,168,152,152,152,184,184,184,208,212,220,232,232,232,252,252,252,152,152,152,120,120,120,252,252,252,252,252,252,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,120,0,0,0,244,240,220,244,240,220,244,240,220,124,104,104,184,168,168,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,204,184,176,188,152,132,240,196,188,108,88,84,124,104,104,240,196,188,140,120,116,108,88,84,0,0,0,248,232,216,8,136,56,0,0,0,232,216,200,244,240,220,8,108,164,0,0,0,168,204,236,8,132,192,232,236,220,0,0,0,184,184,184,8,152,216,40,56,56,104,104,104,164,168,184,164,168,184,164,168,184,56,56,56,72,72,68,216,232,248,176,196,208,0,0,0,216,232,248,216,232,248,144,168,168,24,24,24,0,0,0,216,232,248,216,232,248,104,104,104,
104,104,104,216,232,248,136,152,152,0,0,0,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,0,0,0,72,72,68,160,184,192,216,232,248,136,136,136,72,72,68,216,232,248,216,232,248,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,148,144,92,24,24,24,0,0,0,0,0,0,236,220,120,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,216,216,136,60,56,36,0,0,0,248,244,140,248,244,140,248,244,140,0,0,0,0,0,0,248,244,140,248,244,140,128,120,72,216,216,136,248,244,140,248,244,140,216,216,152,152,152,136,120,120,104,120,120,104,120,120,104,120,120,104,152,152,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,252,252,252,252,252,252,252,252,252,216,216,200,244,240,220,244,240,220,216,216,200,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,132,192,136,136,120,244,240,220,244,240,220,168,168,152,216,200,200,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,40,24,40,248,248,248,252,252,252,
248,248,248,252,252,252,0,0,0,72,72,68,232,216,200,244,240,220,244,240,220,0,0,0,0,0,0,0,0,0,104,104,84,88,88,88,120,120,104,236,236,236,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,140,120,116,156,136,136,156,136,136,232,176,184,108,88,84,124,104,104,240,196,188,0,0,0,216,168,168,24,24,24,216,168,168,184,200,168,0,0,0,232,216,200,244,240,220,100,124,128,0,0,0,216,232,248,8,108,164,32,152,216,0,0,0,184,184,168,8,152,216,8,132,192,0,0,0,72,72,68,72,72,68,72,72,68,0,0,0,196,216,216,216,232,248,176,196,208,0,0,0,216,232,248,216,232,248,0,0,0,208,212,220,0,0,0,216,232,248,216,232,248,104,104,104,104,104,104,216,232,248,0,0,0,176,196,208,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,144,168,168,56,56,56,176,196,208,40,40,40,216,232,248,136,136,136,72,72,68,216,232,248,216,232,248,0,0,0,248,244,140,248,244,140,248,244,140,40,40,24,128,120,72,208,204,116,248,244,140,192,172,104,128,120,72,248,244,140,60,56,36,236,220,120,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,244,140,0,0,0,0,0,0,248,244,140,
248,244,140,248,244,140,232,232,136,248,244,140,248,244,140,216,216,152,152,152,136,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,216,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,104,104,104,252,252,252,168,168,168,152,152,152,24,24,24,252,252,252,200,200,200,136,136,136,56,56,56,152,152,136,200,168,184,8,132,192,8,152,216,8,108,164,12,88,116,104,104,104,200,200,168,244,240,220,244,240,220,244,240,220,232,232,216,120,120,120,252,252,252,252,252,252,236,236,236,0,0,0,208,212,220,220,220,220,88,88,88,0,0,0,152,152,152,252,252,252,200,200,200,120,120,104,244,240,220,168,168,152,0,0,0,0,0,0,0,0,0,24,24,24,200,200,184,136,136,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,216,168,168,216,168,168,216,168,168,232,200,184,240,196,188,108,88,84,124,104,104,240,196,188,0,0,0,240,196,188,188,152,132,56,56,56,248,216,200,0,0,0,232,216,200,244,240,220,172,152,148,0,0,0,8,152,232,136,180,216,8,108,164,0,0,0,
244,240,220,208,212,220,8,152,216,0,0,0,216,232,248,216,232,248,176,196,208,0,0,0,216,232,248,176,196,208,176,196,208,0,0,0,216,232,248,160,184,192,0,0,0,216,232,248,0,0,0,216,232,248,216,232,248,104,104,104,104,104,104,0,0,0,88,88,88,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,24,24,24,176,196,208,216,232,248,0,0,0,216,232,248,136,136,136,72,72,68,216,232,248,216,232,248,0,0,0,248,244,140,248,244,140,248,244,140,168,168,88,168,168,88,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,168,168,88,148,144,92,248,244,140,248,244,140,248,244,140,56,76,52,232,232,136,248,244,140,192,172,104,248,244,140,248,244,140,248,244,140,200,200,152,136,136,120,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,136,136,120,184,184,168,232,232,200,244,240,220,216,200,184,120,120,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,104,104,104,248,248,248,40,40,40,252,252,252,220,220,220,232,232,232,168,168,168,252,252,252,232,232,216,140,120,116,
232,152,184,84,84,104,140,120,116,212,148,172,200,152,152,108,88,84,152,152,136,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,252,252,252,120,120,120,56,56,56,40,40,40,24,24,24,184,184,184,252,252,252,252,252,252,252,252,252,220,220,220,252,252,252,184,184,168,24,24,24,0,0,0,0,0,0,0,0,0,136,136,136,244,240,220,244,240,220,236,236,236,252,252,252,252,252,252,252,252,252,252,252,252,240,196,188,0,0,0,0,0,0,0,0,0,0,0,0,188,152,132,240,196,188,108,88,84,124,104,104,156,136,136,56,40,36,240,196,188,240,196,188,0,0,0,240,196,188,0,0,0,8,136,56,216,216,184,172,152,148,0,0,0,0,0,0,0,0,0,12,24,40,88,172,228,244,240,220,244,240,220,8,152,216,8,24,24,160,184,192,216,232,248,68,88,88,56,56,56,216,232,248,176,196,208,176,196,208,0,0,0,216,232,248,0,0,0,176,196,208,216,232,248,0,0,0,216,232,248,216,232,248,104,104,104,0,0,0,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,0,0,0,216,232,248,216,232,248,24,24,24,176,196,208,136,136,136,72,72,68,216,232,248,216,232,248,0,0,0,200,184,120,
248,244,140,248,244,140,232,232,136,60,56,36,248,244,140,248,244,140,248,244,140,0,0,0,248,244,140,248,232,136,24,24,24,248,244,140,248,244,140,248,244,140,248,244,140,248,244,140,248,248,152,248,248,216,232,232,232,0,0,0,244,240,220,168,168,152,120,120,104,120,120,104,168,168,152,232,216,200,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,152,152,136,120,120,120,252,252,252,252,252,252,252,252,252,88,88,88,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,104,104,104,252,252,252,0,0,0,0,0,0,0,0,0,200,184,200,248,248,248,40,40,40,124,104,104,140,120,116,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,156,136,136,124,104,104,184,184,168,244,240,220,244,240,220,244,240,220,152,152,136,220,220,220,220,220,220,208,212,220,252,252,252,252,252,252,252,252,252,152,152,152,0,0,0,40,40,56,40,24,40,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,232,232,216,244,240,220,244,240,220,244,240,220,244,240,220,252,252,252,252,252,252,236,236,236,140,120,116,240,196,188,0,0,0,240,196,188,240,196,188,
240,196,188,240,196,188,240,196,188,108,88,84,124,104,104,24,8,24,200,152,152,240,196,188,240,196,188,0,0,0,216,168,168,0,0,0,8,136,56,200,216,184,172,152,148,0,0,0,8,152,216,8,152,216,104,160,192,0,0,0,244,240,220,244,240,220,208,212,220,8,108,164,40,56,56,216,232,248,0,0,0,176,196,208,132,136,152,176,196,208,176,196,208,0,0,0,208,212,220,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,104,104,104,104,104,104,40,40,40,136,136,136,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,160,184,192,0,0,0,216,232,248,216,232,248,164,168,184,56,56,56,136,136,136,72,72,68,216,232,248,216,232,248,0,0,0,112,92,52,248,244,140,236,220,120,248,244,140,0,0,0,248,244,140,248,244,140,248,244,140,128,120,72,248,244,140,248,244,140,248,244,140,248,244,140,248,240,172,248,248,232,252,252,252,252,252,252,252,252,252,152,152,152,72,72,68,244,240,220,244,240,220,244,240,220,120,120,104,216,216,200,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,152,152,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,24,24,24,220,220,220,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,244,240,220,104,104,104,252,252,252,0,0,0,252,252,252,200,200,200,220,220,220,232,216,216,232,152,184,212,148,172,140,120,116,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,124,104,104,124,104,104,216,216,200,244,240,220,244,240,220,232,232,200,136,136,120,252,252,252,232,232,232,120,120,120,0,0,0,40,40,56,200,200,200,252,252,252,252,252,252,0,0,0,252,252,252,88,88,88,0,0,0,88,88,88,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,184,184,168,120,120,104,136,136,120,240,196,188,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,124,104,104,0,0,0,240,196,188,240,196,188,240,196,188,156,136,136,108,88,84,0,0,0,232,216,200,232,232,216,172,152,148,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,168,204,236,244,240,220,244,240,220,8,152,216,0,0,0,216,232,248,0,0,0,216,232,248,72,72,68,176,196,208,176,196,208,0,0,0,24,24,24,164,168,184,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,104,104,104,
104,104,104,216,232,248,0,0,0,176,196,208,216,232,248,216,232,248,216,232,248,0,0,0,56,56,56,144,168,168,216,232,248,216,232,248,216,232,248,0,0,0,136,136,136,72,72,68,216,232,248,216,232,248,0,0,0,0,0,0,0,0,0,40,40,24,248,244,140,192,172,104,248,244,140,248,244,140,248,244,140,248,244,140,248,248,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,56,56,56,152,152,136,244,240,220,244,240,220,244,240,220,232,216,200,244,240,220,120,120,104,244,240,220,244,240,220,244,240,220,244,240,220,232,232,216,120,120,104,216,216,200,252,252,252,252,252,252,208,212,220,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,168,168,168,0,0,0,252,252,252,200,200,200,152,152,152,56,56,56,248,216,216,212,148,172,88,68,64,108,88,84,212,148,172,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,108,88,84,120,120,104,232,232,216,244,240,220,244,240,220,104,104,84,200,200,200,40,40,40,248,248,248,252,252,252,220,220,220,56,56,56,252,252,252,
248,248,248,0,0,0,252,252,252,120,120,120,136,136,136,216,216,200,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,200,200,184,120,120,104,136,136,120,248,200,200,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,56,40,36,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,0,0,0,0,0,0,216,168,168,232,232,216,172,152,148,0,0,0,244,240,220,8,152,216,12,88,116,0,0,0,8,152,216,244,240,220,244,240,220,196,216,216,0,0,0,100,104,120,56,56,56,216,232,248,72,72,68,176,196,208,176,196,208,0,0,0,0,0,0,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,104,104,104,104,104,104,216,232,248,208,212,232,0,0,0,216,232,248,216,232,248,216,232,248,0,0,0,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,104,104,104,72,72,68,216,232,248,216,232,248,0,0,0,248,244,140,248,244,140,248,244,140,248,244,140,248,248,152,104,104,84,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,0,0,0,232,236,220,0,0,0,244,240,220,244,240,220,
244,240,220,24,24,24,244,240,220,136,136,120,232,232,216,244,240,220,244,240,220,200,200,168,120,120,104,248,248,248,252,252,252,252,252,252,0,0,0,120,120,120,40,24,40,168,168,168,252,252,252,252,252,252,248,248,248,0,0,0,252,252,252,252,252,252,236,236,236,252,252,252,252,252,252,0,0,0,248,248,248,244,240,220,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,176,200,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,108,88,84,120,120,104,244,240,220,104,104,84,0,0,0,56,56,56,200,200,200,104,104,104,252,252,252,120,120,120,208,212,220,0,0,0,40,40,56,248,248,248,252,252,252,252,252,252,248,248,248,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,152,152,136,136,136,120,244,240,220,0,0,0,0,0,0,0,0,0,0,0,0,56,56,56,240,196,188,108,88,84,0,0,0,156,136,136,240,196,188,240,196,188,240,196,188,240,196,188,0,0,0,0,0,0,216,168,168,132,180,120,8,136,56,0,0,0,0,0,0,0,0,0,0,0,0,136,180,216,
8,152,216,104,160,192,244,240,220,244,240,220,8,108,164,0,0,0,176,196,208,216,232,248,72,72,68,176,196,208,176,196,208,0,0,0,136,136,136,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,104,104,104,104,104,104,216,232,248,216,232,248,164,168,184,0,0,0,216,232,248,216,232,248,0,0,0,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,144,148,168,0,0,0,72,72,68,216,232,248,216,232,248,0,0,0,216,216,152,152,152,136,236,236,236,252,252,252,252,252,252,232,232,232,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,24,24,24,248,248,248,244,240,220,72,72,68,232,232,216,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,152,152,136,120,120,120,252,252,252,252,252,252,252,252,252,40,40,56,208,212,220,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,208,212,220,40,40,56,184,184,184,0,0,0,184,184,184,168,168,168,0,0,0,172,152,148,232,232,232,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,124,104,104,200,152,152,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,
232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,108,88,84,0,0,0,0,0,0,0,0,0,0,0,0,252,252,252,120,120,120,72,72,68,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,120,120,104,244,240,220,244,240,220,216,216,200,88,88,68,0,0,0,28,8,8,0,0,0,0,0,0,104,104,84,136,136,120,244,240,220,248,216,200,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,216,168,168,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,24,152,76,244,240,220,244,240,220,244,240,220,8,152,216,8,152,216,8,108,164,8,108,164,244,240,220,244,240,220,168,204,236,8,152,216,216,232,248,216,232,248,72,72,68,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,120,120,104,
216,216,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,236,236,236,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,24,24,24,184,184,168,152,152,136,88,88,68,244,240,220,72,72,68,152,152,136,120,120,104,244,240,220,244,240,220,244,240,220,136,136,120,168,168,152,252,252,252,252,252,252,252,252,252,252,252,252,104,104,104,208,212,220,252,252,252,236,236,236,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,40,40,56,40,40,40,252,252,252,208,212,220,184,184,168,184,184,168,200,184,200,236,236,236,200,184,200,252,252,252,252,252,252,248,248,248,108,88,84,212,148,172,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,212,148,172,88,72,88,0,0,0,40,40,40,120,120,104,252,252,252,220,220,220,232,232,232,200,200,200,0,0,0,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,152,152,136,232,216,200,24,24,8,100,24,16,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,100,24,16,24,24,24,120,120,104,240,196,188,240,196,188,
240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,176,184,108,88,84,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,204,184,176,120,120,104,120,120,104,244,240,220,216,232,216,8,108,164,136,180,216,8,108,164,104,160,192,244,240,220,244,240,220,8,136,216,8,108,164,216,232,248,72,72,68,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,168,168,168,252,252,252,184,184,184,0,0,0,40,40,56,252,252,252,252,252,252,252,252,252,40,40,40,208,212,220,252,252,252,220,220,220,252,252,252,252,252,252,252,252,252,244,240,220,136,136,136,200,200,168,244,240,220,152,152,136,200,200,184,244,240,220,56,56,56,56,56,56,40,40,40,232,232,200,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,252,252,252,0,0,0,208,212,220,252,252,252,152,152,152,252,252,252,24,24,24,
104,104,104,252,252,252,248,248,248,184,184,168,216,216,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,108,88,84,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,172,152,148,88,68,64,152,152,136,120,120,104,72,72,68,0,0,0,0,0,0,0,0,0,136,136,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,0,0,0,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,0,0,0,152,152,136,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,124,104,104,172,152,148,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,96,164,104,136,136,120,136,136,120,244,240,220,8,108,164,8,108,164,8,108,164,8,108,164,244,240,220,244,240,220,104,160,192,8,108,164,216,232,248,72,72,68,176,196,208,216,232,248,216,232,248,216,232,248,160,184,192,164,168,184,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,
216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,252,252,252,252,252,252,0,0,0,252,252,252,248,248,248,24,24,24,252,252,252,252,252,252,252,252,252,88,88,88,152,152,152,0,0,0,252,252,252,252,252,252,120,120,104,232,232,216,244,240,220,244,240,220,216,216,200,136,136,136,216,216,200,24,24,24,120,120,104,244,240,220,244,240,220,0,0,0,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,208,212,220,252,252,252,216,216,200,120,120,104,200,200,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,216,216,108,88,84,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,140,120,116,104,104,104,0,0,0,0,0,0,0,0,0,0,0,0,236,236,236,252,252,252,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,24,24,8,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,200,152,152,216,200,168,8,136,56,120,120,104,244,240,220,216,232,216,8,108,164,136,180,216,8,108,164,104,160,192,244,240,220,244,240,220,8,108,164,60,128,176,40,56,56,12,88,116,8,108,164,168,204,236,216,232,248,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,252,252,252,252,252,252,40,24,40,248,248,248,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,120,120,120,216,216,200,244,240,220,244,240,220,244,240,220,0,0,0,0,0,0,168,168,152,
244,240,220,244,240,220,152,152,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,248,248,248,0,0,0,252,252,252,252,252,252,152,152,152,120,120,104,232,232,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,184,200,108,88,84,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,56,40,56,56,40,56,88,68,64,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,124,104,104,24,24,24,0,0,0,72,72,68,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,188,40,24,200,40,40,200,40,40,200,40,40,200,40,40,248,200,168,252,252,252,252,252,252,232,196,168,200,40,40,200,40,40,200,40,40,200,40,40,152,36,24,104,104,84,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,156,136,136,140,120,116,240,196,188,240,196,188,240,196,188,156,136,136,0,0,0,0,0,0,240,196,188,168,168,152,120,120,104,136,136,120,244,240,220,
8,108,164,8,108,164,8,108,164,8,108,164,244,240,220,244,240,220,104,160,192,32,132,188,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,168,204,236,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,252,252,252,252,252,252,252,252,252,236,236,236,252,252,252,0,0,0,252,252,252,168,168,168,232,232,232,88,88,88,236,236,236,252,252,252,152,152,136,184,184,168,244,240,220,244,240,220,244,240,220,244,240,220,216,216,200,244,240,220,244,240,220,120,120,104,152,152,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,0,0,0,0,0,0,232,232,232,252,252,252,120,120,104,120,120,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,168,168,108,88,84,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,108,88,84,0,0,0,0,0,0,
200,152,152,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,108,88,84,88,88,88,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,200,40,40,200,40,40,200,40,40,216,104,68,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,80,48,200,40,40,200,40,40,200,40,40,0,0,0,216,200,184,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,216,168,168,240,196,188,140,120,116,0,0,0,0,0,0,0,0,0,0,0,0,72,72,68,248,200,200,120,120,104,120,120,104,244,240,220,216,232,216,8,108,164,168,204,236,8,108,164,104,160,192,220,220,220,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,136,180,216,192,220,244,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,136,180,216,216,232,248,216,232,248,136,180,216,136,180,216,136,180,216,136,180,216,168,204,236,216,232,248,136,180,216,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,184,184,168,244,240,220,232,232,216,40,40,40,0,0,0,216,216,200,244,240,220,244,240,220,232,232,216,120,120,104,200,200,200,252,252,252,252,252,252,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,120,120,104,120,120,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,140,120,116,124,104,104,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,212,148,172,0,0,0,0,0,0,88,72,88,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,124,104,104,184,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,40,24,40,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,124,104,104,0,0,0,0,0,0,0,0,0,0,0,0,24,8,24,0,0,0,0,0,0,240,196,188,8,136,56,120,120,104,136,136,120,244,240,220,8,108,164,8,108,164,32,132,188,8,108,164,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,88,172,228,136,180,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,216,232,248,216,232,248,8,152,216,136,180,216,168,204,236,168,204,236,168,204,236,216,232,248,8,152,216,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,208,212,220,40,40,56,152,152,152,40,40,56,252,252,252,232,236,220,244,240,220,168,168,152,24,24,24,244,240,220,244,240,220,0,0,0,244,240,220,216,200,184,120,120,104,236,236,236,252,252,252,252,252,252,252,252,252,0,0,0,40,40,40,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,120,120,104,152,152,136,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,124,104,104,140,120,116,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,88,72,88,0,0,0,0,0,0,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,108,88,84,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,88,68,64,0,0,0,0,0,0,0,0,0,0,0,0,40,40,40,232,176,184,240,196,188,124,104,104,0,0,0,108,88,84,216,200,184,120,120,104,120,120,104,244,240,220,216,232,216,8,108,164,168,204,236,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,216,232,248,216,232,248,
216,232,248,216,232,248,192,220,244,8,152,216,216,232,248,216,232,248,216,232,248,208,212,220,216,232,248,8,152,216,192,220,244,216,232,248,88,172,228,136,180,216,216,232,248,216,232,248,216,232,248,216,232,248,88,172,228,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,208,212,220,252,252,252,252,252,252,244,240,220,88,88,68,120,120,104,244,240,220,244,240,220,184,184,168,104,104,84,244,240,220,244,240,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,104,104,104,184,184,184,104,104,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,120,120,104,184,184,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,108,88,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,40,56,56,40,56,56,40,56,56,40,56,56,40,56,56,40,56,56,40,56,56,40,56,56,40,56,56,40,56,56,40,56,56,40,56,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,156,136,136,108,88,84,252,252,252,252,252,252,252,252,252,252,252,252,
24,24,24,252,252,252,0,0,0,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,0,0,0,240,196,188,240,196,188,88,68,64,0,0,0,0,0,0,0,0,0,0,0,0,24,8,24,0,0,0,124,104,104,240,196,188,240,196,188,240,196,188,0,0,0,0,0,0,240,196,188,136,136,120,120,120,104,136,136,120,244,240,220,8,108,164,32,132,188,64,144,208,64,144,208,64,144,208,64,144,208,232,232,248,252,252,252,252,252,252,252,252,252,252,252,252,168,204,236,64,144,208,64,144,208,64,144,208,64,144,208,192,220,244,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,216,232,248,216,232,248,216,232,248,164,168,184,216,232,248,88,172,228,136,180,216,216,232,248,168,204,236,8,152,232,216,232,248,216,232,248,216,232,248,216,232,248,168,204,236,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,244,240,220,56,56,56,184,184,168,244,240,220,244,240,220,244,240,220,200,200,184,244,240,220,40,40,40,232,232,232,252,252,252,252,252,252,
24,24,24,252,252,252,252,252,252,208,212,220,120,120,120,168,168,168,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,120,120,104,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,108,88,84,212,148,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,124,104,104,124,104,104,252,252,252,252,252,252,252,252,252,248,248,248,252,252,252,252,252,252,0,0,0,0,0,0,8,108,164,8,108,164,8,108,164,8,108,164,8,108,164,8,108,164,8,108,164,8,108,164,8,108,164,8,108,164,8,108,164,8,108,164,8,108,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,232,232,0,0,0,0,0,0,120,120,120,248,248,232,248,248,232,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,108,88,84,0,0,0,140,120,116,240,196,188,120,120,104,
120,120,104,244,240,220,216,232,216,64,144,208,64,144,208,64,144,208,64,144,208,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,208,212,232,64,144,208,64,144,208,64,144,208,104,160,192,164,168,184,120,120,120,120,120,120,216,232,248,8,152,216,8,152,216,8,152,216,136,180,216,216,232,248,216,232,248,192,220,244,8,152,216,216,232,248,216,232,248,8,152,216,88,172,228,88,172,228,88,172,228,216,232,248,216,232,248,56,56,56,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,244,240,220,40,40,40,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,252,252,252,252,252,252,236,236,236,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,88,88,88,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,120,120,104,120,120,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,184,200,108,88,84,232,152,184,232,152,184,212,148,172,212,148,172,212,148,172,212,148,172,212,148,172,212,148,172,212,148,172,212,148,172,140,120,116,0,0,0,0,0,0,200,152,152,200,152,152,200,152,152,200,152,152,
200,152,152,200,152,152,200,152,152,200,152,152,200,152,152,200,152,152,200,152,152,200,152,152,232,152,184,232,152,184,232,152,184,232,152,184,108,88,84,120,120,120,252,252,252,252,252,252,252,252,252,56,56,56,104,104,104,252,252,252,252,252,252,208,212,220,72,72,68,236,236,236,0,0,0,188,40,24,188,40,24,188,40,24,232,216,200,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,232,200,184,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,40,24,40,0,0,0,200,200,200,252,252,252,252,252,252,72,72,68,0,0,0,156,136,136,240,196,188,240,196,188,240,196,188,0,0,0,0,0,0,240,196,188,8,136,56,12,88,116,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,132,136,152,216,232,248,216,232,248,8,152,216,168,204,236,216,232,248,136,180,216,8,152,216,216,232,248,216,232,248,8,152,216,216,232,248,216,232,248,8,152,216,168,204,236,168,204,236,168,204,236,216,232,248,216,232,248,0,0,0,
56,56,56,120,120,120,252,252,252,252,252,252,252,252,252,252,252,252,120,120,120,216,216,200,244,240,220,0,0,0,104,104,84,24,24,24,244,240,220,152,152,136,232,232,232,252,252,252,252,252,252,200,200,200,0,0,0,236,236,236,252,252,252,232,232,232,72,72,68,252,252,252,0,0,0,252,252,252,252,252,252,24,24,24,248,248,248,252,252,252,252,252,252,200,200,184,120,120,104,120,120,104,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,156,136,136,108,88,84,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,212,148,172,0,0,0,0,0,0,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,108,88,84,152,152,152,252,252,252,252,252,252,252,252,252,0,0,0,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,120,120,120,200,200,200,56,56,56,200,40,40,200,40,40,200,40,40,200,40,40,248,216,200,252,252,252,252,252,252,252,252,252,252,252,252,248,200,168,200,40,40,168,168,168,252,252,252,252,252,252,252,252,252,
0,0,0,252,252,252,252,252,252,252,252,252,24,24,24,232,232,232,0,0,0,0,0,0,252,252,252,252,252,252,248,216,216,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,216,168,168,240,196,188,240,196,188,216,200,184,12,88,116,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,132,136,152,216,232,248,216,232,248,136,180,216,88,172,228,216,232,248,216,232,248,40,168,232,168,204,236,216,232,248,8,152,216,216,232,248,216,232,248,8,152,216,192,220,244,216,232,248,216,232,248,216,232,248,216,232,248,252,252,252,252,252,252,120,120,120,200,200,200,252,252,252,252,252,252,152,152,136,184,184,168,244,240,220,244,240,220,244,240,220,232,232,200,244,240,220,168,168,152,252,252,252,252,252,252,252,252,252,120,120,120,24,24,24,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,152,152,152,104,104,104,220,220,220,252,252,252,252,252,252,184,184,184,252,252,252,152,152,136,120,120,104,136,136,136,152,152,152,120,120,120,200,200,200,252,252,252,252,252,252,252,252,252,124,104,104,
140,120,116,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,0,0,0,0,0,0,172,152,148,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,212,148,172,108,88,84,200,200,200,252,252,252,252,252,252,200,200,200,252,252,252,152,152,152,184,184,184,252,252,252,252,252,252,236,236,236,252,252,252,252,252,252,24,24,24,248,248,248,44,20,20,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,168,168,168,252,252,252,252,252,252,248,248,248,0,0,0,252,252,252,252,252,252,252,252,252,120,120,120,236,236,236,0,0,0,0,0,0,232,232,232,252,252,252,184,168,168,56,40,36,72,56,72,240,196,188,240,196,188,240,196,188,240,196,188,200,152,152,0,0,0,240,196,188,12,88,116,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,
100,124,128,120,120,120,164,168,184,192,220,244,8,152,216,216,232,248,216,232,248,88,172,228,88,172,228,216,232,248,8,152,216,168,204,236,216,232,248,136,180,216,136,180,216,216,232,248,216,232,248,216,232,248,216,232,248,24,24,24,252,252,252,56,56,56,220,220,220,252,252,252,184,184,168,152,152,136,244,240,220,244,240,220,244,240,220,244,240,220,168,168,152,136,136,120,252,252,252,252,252,252,252,252,252,252,252,252,104,104,104,136,136,136,252,252,252,252,252,252,200,200,200,236,236,236,252,252,252,104,104,104,168,168,168,120,120,120,252,252,252,252,252,252,252,252,252,120,120,104,120,120,104,184,184,168,252,252,252,252,252,252,136,136,136,184,184,184,252,252,252,252,252,252,108,88,84,156,136,136,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,0,0,0,0,0,0,108,88,84,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,156,136,136,108,88,84,236,236,236,252,252,252,252,252,252,104,104,104,72,72,68,252,252,252,252,252,252,56,56,56,236,236,236,24,24,24,
152,152,152,252,252,252,252,252,252,252,252,252,0,0,0,24,24,24,152,36,24,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,168,168,168,252,252,252,252,252,252,220,220,220,0,0,0,252,252,252,252,252,252,252,252,252,232,232,232,40,40,40,208,212,220,0,0,0,40,24,40,252,252,252,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,156,136,136,0,0,0,0,0,0,0,0,0,216,168,168,232,200,184,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,84,84,104,100,124,128,100,124,128,100,124,128,100,124,128,100,124,128,100,124,128,100,124,128,100,124,128,84,84,104,84,84,104,84,84,104,84,84,104,100,124,128,144,148,168,216,232,248,216,232,248,216,232,248,8,152,216,8,152,216,8,152,216,8,152,216,192,220,244,216,232,248,136,180,216,88,172,228,216,232,248,192,220,244,8,152,216,8,152,216,8,152,216,8,152,216,216,232,248,252,252,252,0,0,0,136,136,136,252,252,252,216,216,200,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,184,184,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,40,40,40,208,212,220,120,120,120,
40,24,40,252,252,252,252,252,252,252,252,252,40,40,40,0,0,0,252,252,252,248,248,248,120,120,104,120,120,104,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,108,88,84,212,148,172,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,104,104,252,252,252,252,252,252,252,252,252,200,200,200,72,72,68,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,236,236,236,252,252,252,252,252,252,252,252,252,24,24,24,168,168,168,252,252,252,56,56,56,100,24,16,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,168,168,168,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,200,200,200,252,252,252,252,252,252,0,0,0,252,252,252,0,0,0,0,0,0,252,252,252,156,136,136,240,196,188,240,196,188,140,120,116,0,0,0,0,0,0,0,0,0,0,0,0,40,40,40,232,176,184,
240,196,188,12,88,116,12,88,116,64,144,208,64,144,208,64,144,208,64,144,208,208,212,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,180,216,64,144,208,64,144,208,64,144,208,104,160,192,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,244,240,220,244,240,220,244,240,220,232,216,200,120,120,104,220,220,220,252,252,252,252,252,252,252,252,252,0,0,0,152,152,152,252,252,252,252,252,252,252,252,252,0,0,0,88,88,88,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,176,196,208,120,120,104,120,120,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,200,200,108,88,84,212,148,172,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,68,88,88,68,88,88,88,68,64,88,72,88,88,72,88,88,72,88,88,72,88,88,72,88,88,72,88,88,72,88,88,72,88,88,72,88,88,72,88,88,72,88,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,120,120,120,200,200,200,252,252,252,152,152,152,248,248,248,236,236,236,40,40,56,252,252,252,232,232,232,40,40,56,236,236,236,248,248,248,120,120,104,200,200,184,232,216,200,0,0,0,100,24,16,188,40,24,200,40,40,200,40,40,188,40,24,100,24,16,24,24,24,168,168,168,252,252,252,200,200,200,0,0,0,0,0,0,0,0,0,252,252,252,152,152,152,220,220,220,0,0,0,72,72,68,236,236,236,252,252,252,252,252,252,248,216,216,124,104,104,0,0,0,0,0,0,0,0,0,0,0,0,72,56,72,240,196,188,240,196,188,240,196,188,240,196,188,216,200,184,12,88,116,132,136,152,64,144,208,64,144,208,64,144,208,64,144,208,136,180,216,252,252,252,252,252,252,252,252,252,252,252,252,104,160,192,64,144,208,64,144,208,64,144,208,64,144,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,136,152,152,120,120,120,120,120,120,200,200,216,120,120,120,
252,252,252,252,252,252,252,252,252,236,236,236,120,120,104,244,240,220,184,184,168,120,120,104,248,248,248,252,252,252,252,252,252,248,248,248,252,252,252,40,40,56,200,200,200,24,24,24,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,40,40,56,104,104,104,252,252,252,136,180,216,8,152,216,88,172,228,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,252,252,252,200,168,184,212,148,172,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,212,148,172,12,88,116,8,152,216,8,152,216,68,88,88,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,212,148,172,0,0,0,0,0,0,124,104,104,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,108,88,84,168,168,152,252,252,252,252,252,252,248,248,248,252,252,252,168,168,168,152,152,152,252,252,252,24,24,24,56,56,56,120,120,120,252,252,252,252,252,252,184,184,184,72,72,68,24,24,24,252,252,252,220,220,220,120,120,104,232,232,200,244,240,220,244,240,220,8,136,56,8,136,56,152,168,152,120,120,104,120,120,120,152,168,152,212,228,204,212,228,204,168,168,168,120,120,120,168,168,168,0,0,0,
0,0,0,168,168,168,0,0,0,236,236,236,88,88,88,88,88,88,0,0,0,252,252,252,252,252,252,88,88,88,0,0,0,0,0,0,0,0,0,0,0,0,124,104,104,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,12,88,116,12,88,116,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,104,160,192,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,208,212,220,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,120,120,104,136,136,120,252,252,252,252,252,252,252,252,252,220,220,220,72,72,68,252,252,252,236,236,236,88,88,88,252,252,252,40,24,40,168,168,168,252,252,252,232,232,232,0,0,0,0,0,0,168,168,168,200,184,200,32,132,188,8,152,216,0,0,0,252,252,252,168,168,168,232,232,232,252,252,252,0,0,0,120,120,120,0,0,0,232,152,184,232,152,184,0,0,0,72,56,72,0,0,0,232,152,184,
212,148,172,12,88,116,8,152,216,8,152,216,8,152,216,8,152,216,84,84,104,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,72,56,72,0,0,0,0,0,0,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,200,152,152,108,88,84,216,216,200,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,40,24,40,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,136,136,136,252,252,252,184,184,168,120,120,104,244,240,220,244,240,220,184,200,168,8,136,56,168,200,152,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,168,168,168,252,252,252,0,0,0,168,168,168,0,0,0,236,236,236,40,24,40,252,252,252,0,0,0,0,0,0,0,0,0,208,212,220,136,136,136,0,0,0,0,0,0,0,0,0,140,120,116,240,196,188,240,196,188,216,168,168,156,136,136,108,88,84,24,24,24,0,0,0,0,0,0,240,196,188,232,200,184,12,88,116,120,120,120,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,104,160,192,216,232,248,216,232,248,
216,232,248,216,232,248,8,152,216,8,152,216,8,152,216,8,152,216,40,168,232,216,232,248,8,152,216,216,232,248,216,232,248,88,172,228,68,168,204,216,232,248,216,232,248,8,152,216,216,232,248,216,232,248,8,152,216,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,168,168,168,40,24,40,252,252,252,184,184,184,220,220,220,252,252,252,8,108,164,8,132,192,104,160,192,104,104,104,252,252,252,168,168,168,232,232,232,208,212,220,168,168,168,232,176,184,124,104,104,212,148,172,200,152,152,156,136,136,232,152,184,108,88,84,232,152,184,12,88,116,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,84,84,104,232,152,184,232,152,184,232,152,184,232,152,184,172,152,148,0,0,0,0,0,0,124,104,104,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,140,120,116,104,88,104,236,236,236,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,72,72,68,252,252,252,120,120,120,220,220,220,252,252,252,236,236,236,72,72,68,248,248,248,0,0,0,208,212,220,
252,252,252,136,136,136,136,136,120,244,240,220,244,240,220,8,136,56,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,168,168,168,252,252,252,104,104,104,24,24,24,0,0,0,40,40,56,232,232,232,252,252,252,56,56,56,0,0,0,0,0,0,0,0,0,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,68,64,240,196,188,12,88,116,12,88,116,120,120,120,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,60,128,176,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,88,172,228,168,204,236,216,232,248,216,232,248,216,232,248,216,232,248,88,172,228,192,220,244,216,232,248,8,152,216,8,152,216,216,232,248,216,232,248,8,152,216,192,220,244,216,232,248,8,152,232,184,184,168,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,168,168,168,252,252,252,200,200,200,152,152,152,252,252,252,252,252,252,248,248,248,24,24,24,
252,252,252,236,236,236,184,184,168,60,128,176,160,184,192,88,88,88,236,236,236,184,184,184,168,168,168,232,232,232,184,184,184,200,152,152,232,152,184,200,152,152,156,136,136,232,152,184,232,152,184,232,152,184,40,24,40,232,176,184,12,88,116,8,108,164,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,104,88,104,232,152,184,232,152,184,108,88,84,88,72,88,88,72,88,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,124,104,104,124,104,104,252,252,252,252,252,252,252,252,252,152,152,152,168,168,168,252,252,252,252,252,252,152,152,152,56,56,56,72,72,68,232,232,232,0,0,0,252,252,252,168,168,168,0,0,0,252,252,252,252,252,252,120,120,104,168,168,152,244,240,220,200,216,168,8,136,56,136,184,136,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,168,168,168,252,252,252,252,252,252,0,0,0,0,0,0,0,0,0,252,252,252,252,252,252,168,168,168,0,0,0,0,0,0,0,0,0,252,252,252,104,104,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,88,84,156,136,136,56,40,36,0,0,0,
0,0,0,240,196,188,240,196,188,232,200,184,12,88,116,120,120,120,216,232,232,168,204,236,64,144,208,64,144,208,64,144,208,64,144,208,64,144,208,104,160,192,220,220,220,244,240,220,232,236,220,8,108,164,136,180,216,216,232,248,216,232,248,216,232,248,168,204,236,8,152,232,216,232,248,216,232,248,216,232,248,216,232,248,168,204,236,88,172,228,216,232,248,8,152,216,216,232,248,40,168,232,216,232,248,88,172,228,136,180,216,216,232,248,168,204,236,120,120,120,184,184,168,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,184,184,184,236,236,236,0,0,0,236,236,236,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,200,200,184,120,120,104,184,184,168,184,184,184,208,212,220,0,0,0,252,252,252,40,40,56,168,168,168,232,216,216,156,136,136,200,152,152,232,152,184,200,152,152,156,136,136,232,152,184,232,152,184,56,40,36,88,72,88,232,152,184,120,104,120,8,136,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,104,88,104,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,
108,88,84,136,136,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,56,56,56,232,232,232,252,252,252,252,252,252,56,56,56,232,232,232,252,252,252,184,184,184,168,168,168,252,252,252,252,252,252,248,248,248,120,120,104,200,200,184,244,240,220,24,152,76,8,136,56,212,228,204,184,200,184,184,200,184,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,168,168,168,252,252,252,252,252,252,252,252,252,152,152,152,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,152,152,152,252,252,252,252,252,252,252,252,252,156,136,136,200,152,152,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,56,40,36,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,12,88,116,68,88,88,120,120,120,216,232,248,72,72,68,176,196,208,216,232,248,136,180,216,8,108,164,104,160,192,244,240,220,244,240,220,244,240,220,8,108,164,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,216,232,248,8,152,216,216,232,248,8,152,232,216,232,248,168,204,236,8,152,216,216,232,248,216,232,248,244,240,220,
216,200,184,120,120,104,252,252,252,252,252,252,252,252,252,236,236,236,56,56,56,252,252,252,120,120,120,0,0,0,248,248,248,252,252,252,72,72,68,236,236,236,252,252,252,152,152,152,184,184,184,252,252,252,252,252,252,136,136,136,120,120,104,120,120,104,252,252,252,200,184,200,208,212,220,120,120,120,252,252,252,0,0,0,156,136,136,212,148,172,156,136,136,200,152,152,232,152,184,200,152,152,156,136,136,232,152,184,0,0,0,200,152,152,232,152,184,232,152,184,232,152,184,104,88,104,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,232,176,200,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,248,248,232,252,252,252,248,248,248,0,0,0,0,0,0,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,24,24,24,220,220,220,252,252,252,220,220,220,120,120,104,232,232,216,200,216,184,8,136,56,136,184,136,212,228,204,0,0,0,0,0,0,0,0,0,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,168,168,168,252,252,252,252,252,252,120,120,120,
0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,120,120,120,0,0,0,252,252,252,252,252,252,252,252,252,156,136,136,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,24,8,24,0,0,0,24,8,24,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,12,88,116,120,120,120,216,232,232,72,72,68,176,196,208,216,232,248,216,232,248,8,108,164,8,108,164,8,108,164,32,132,188,8,108,164,8,108,164,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,8,152,216,8,152,216,8,152,216,216,232,248,216,232,248,8,152,216,216,232,248,8,152,216,216,232,248,216,232,248,8,152,232,216,232,248,8,152,216,216,232,248,216,232,248,216,216,200,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,72,72,68,220,220,220,252,252,252,248,248,248,24,24,24,152,152,152,236,236,236,88,88,88,252,252,252,252,252,252,208,212,220,252,252,252,120,120,104,120,120,104,136,136,120,252,252,252,252,252,252,200,184,200,152,152,152,208,212,220,252,252,252,124,104,104,140,120,116,212,148,172,156,136,136,200,152,152,232,152,184,200,152,152,156,136,136,232,152,184,124,104,104,232,152,184,140,120,116,232,152,184,
232,152,184,232,152,184,104,88,104,8,108,164,8,152,216,8,56,76,8,152,216,8,152,216,8,56,76,88,172,228,156,136,136,232,152,184,232,152,184,40,24,40,72,56,72,232,152,184,232,152,184,24,24,24,156,136,136,136,136,136,252,252,252,252,252,252,0,0,0,248,248,248,252,252,252,0,0,0,252,252,252,252,252,252,248,248,248,24,24,24,252,252,252,252,252,252,248,248,248,0,0,0,232,232,232,252,252,252,168,168,168,120,120,104,244,240,220,24,152,76,8,136,56,212,228,204,212,228,204,168,168,152,0,0,0,0,0,0,0,0,0,0,0,0,120,120,120,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,0,0,0,0,0,0,40,40,24,240,196,188,240,196,188,240,196,188,108,88,84,0,0,0,140,120,116,240,196,188,12,88,116,84,84,104,120,120,120,72,72,68,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,104,160,192,8,108,164,8,108,164,168,204,236,216,232,248,216,232,248,
216,232,248,216,232,248,216,232,248,8,152,216,192,220,244,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,216,232,248,8,152,216,216,232,248,216,232,248,8,152,232,216,232,248,8,152,216,216,232,248,216,232,248,120,120,120,232,236,220,252,252,252,252,252,252,40,40,40,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,184,184,184,0,0,0,0,0,0,252,252,252,252,252,252,248,248,248,120,120,104,120,120,104,152,152,152,252,252,252,252,252,252,252,252,252,200,184,200,0,0,0,252,252,252,156,136,136,212,148,172,40,24,40,212,148,172,156,136,136,200,152,152,200,152,152,200,152,152,156,136,136,232,152,184,40,24,40,232,152,184,0,0,0,232,152,184,232,152,184,232,152,184,232,152,184,84,84,104,8,152,216,0,0,0,8,152,216,8,152,216,0,0,0,232,152,184,140,120,116,232,152,184,124,104,104,232,152,184,140,120,116,212,148,172,156,136,136,200,168,184,184,184,184,136,136,136,252,252,252,252,252,252,40,40,56,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,200,200,200,88,88,88,152,152,152,72,72,68,252,252,252,252,252,252,136,136,120,136,136,120,216,216,184,8,136,56,132,180,120,
212,228,204,212,228,204,212,228,204,132,152,132,0,0,0,0,0,0,0,0,0,0,0,0,88,88,88,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,40,40,56,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,0,0,0,240,196,188,240,196,188,240,196,188,0,0,0,0,0,0,72,72,68,240,196,188,240,196,188,72,56,72,0,0,0,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,12,88,116,120,120,120,56,56,56,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,88,172,228,136,180,216,216,232,248,216,232,248,216,232,248,216,232,248,88,172,228,168,204,236,8,152,216,216,232,248,216,232,248,216,232,248,8,152,216,8,152,216,192,220,244,216,232,248,232,232,232,248,248,248,248,248,248,252,252,252,200,200,200,56,56,56,252,252,252,252,252,252,0,0,0,200,184,200,252,252,252,252,252,252,252,252,252,252,252,252,88,88,88,252,252,252,232,236,220,120,120,104,120,120,104,200,200,184,252,252,252,
252,252,252,252,252,252,252,252,252,208,212,220,136,136,136,232,152,184,200,152,152,232,152,184,108,88,84,188,40,24,188,40,24,188,40,24,200,40,40,188,40,24,188,40,24,196,60,40,140,120,116,0,0,0,140,120,116,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,136,180,216,0,0,0,8,152,216,136,180,216,0,0,0,232,152,184,140,120,116,232,152,184,56,40,56,232,152,184,232,152,184,232,152,184,184,168,168,200,200,200,252,252,252,136,136,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,24,24,24,104,104,104,252,252,252,252,252,252,120,120,104,168,168,152,96,164,104,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,0,0,0,0,0,0,0,0,0,200,200,184,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,184,216,184,8,136,56,244,240,220,244,240,220,244,240,220,232,232,216,120,120,104,120,120,104,240,196,188,240,196,188,232,200,184,0,0,0,0,0,0,108,88,84,232,176,184,40,40,40,0,0,0,0,0,0,
0,0,0,0,0,0,56,56,56,232,200,184,240,196,188,240,196,188,100,124,128,84,108,108,100,104,120,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,192,220,244,8,152,232,216,232,248,216,232,248,216,232,248,216,232,248,192,220,244,88,172,228,8,152,216,216,232,248,216,232,248,216,232,248,40,168,232,40,168,232,88,172,228,216,232,248,252,252,252,168,168,168,0,0,0,40,24,40,252,252,252,120,120,120,136,136,136,24,24,24,104,104,104,200,200,200,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,216,216,200,184,184,168,120,120,104,232,232,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,212,148,172,232,152,184,212,148,172,196,84,48,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,212,104,88,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,0,0,0,160,184,192,232,152,184,0,0,0,232,152,184,140,120,116,232,152,184,56,40,56,156,136,136,156,136,136,168,168,152,252,252,252,152,152,152,72,72,68,136,136,136,
252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,72,72,68,252,252,252,72,72,68,232,232,232,24,24,24,184,184,184,252,252,252,248,248,248,120,120,104,184,200,168,8,136,56,132,180,120,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,184,200,184,0,0,0,0,0,0,164,184,168,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,24,152,76,136,184,136,244,240,220,244,240,220,244,240,220,136,136,120,120,120,104,120,120,120,240,196,188,24,8,24,0,0,0,88,68,64,24,8,24,0,0,0,0,0,0,0,0,0,0,0,0,108,88,84,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,12,88,116,120,120,120,200,200,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,8,152,216,8,152,216,8,152,216,216,232,248,216,232,248,8,152,216,40,168,232,216,232,248,216,232,248,216,232,248,216,232,248,8,152,216,8,152,216,216,232,248,208,212,220,
88,88,88,252,252,252,220,220,220,252,252,252,252,252,252,40,40,56,168,168,168,252,252,252,252,252,252,104,104,104,200,200,200,252,252,252,252,252,252,168,168,168,120,120,104,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,168,168,108,88,84,232,152,184,232,152,184,28,8,8,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,0,0,0,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,0,0,0,232,152,184,232,152,184,0,0,0,232,152,184,108,88,84,232,152,184,108,88,84,232,176,184,184,184,184,220,220,220,220,220,220,184,184,184,236,236,236,152,152,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,40,40,56,252,252,252,220,220,220,120,120,120,252,252,252,252,252,252,216,216,200,120,120,104,96,164,104,8,136,56,200,216,200,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,
212,228,204,212,228,204,212,228,204,212,228,204,8,136,56,244,240,220,244,240,220,244,240,220,232,232,216,120,120,104,120,120,104,232,200,184,216,168,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,120,116,240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,0,0,0,188,152,132,240,196,188,12,88,116,84,108,108,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,152,152,152,208,212,220,252,252,252,236,236,236,232,232,232,252,252,252,252,252,252,0,0,0,248,248,248,236,236,236,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,152,152,152,184,184,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,140,120,116,124,104,104,232,152,184,232,152,184,24,24,24,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,216,104,68,224,148,124,216,104,68,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,40,24,40,
232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,0,0,0,232,152,184,232,152,184,0,0,0,56,40,36,40,24,40,232,152,184,232,176,200,0,0,0,40,40,56,252,252,252,252,252,252,24,24,24,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,0,0,0,0,0,0,252,252,252,252,252,252,168,168,152,120,120,104,244,240,220,244,240,220,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,184,216,184,8,136,56,244,240,220,244,240,220,244,240,220,136,136,120,120,120,104,120,120,104,240,196,188,0,0,0,0,0,0,0,0,0,156,136,136,240,196,188,240,196,188,232,176,184,240,196,188,108,88,84,0,0,0,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,12,88,116,120,120,120,208,212,232,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,
216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,232,232,232,72,72,68,252,252,252,232,232,232,232,232,232,252,252,252,232,232,232,252,252,252,0,0,0,0,0,0,232,232,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,220,220,220,252,252,252,252,252,252,252,252,252,124,104,104,140,120,116,232,152,184,232,152,184,232,152,184,100,24,16,200,40,40,200,40,40,200,40,40,216,128,88,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,104,68,200,40,40,200,40,40,200,40,40,100,24,16,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,0,0,0,232,152,184,232,152,184,0,0,0,232,152,184,232,152,184,156,136,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,168,200,152,24,152,76,212,228,204,212,228,204,212,228,204,212,228,204,
212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,24,152,76,136,184,136,244,240,220,244,240,220,232,232,216,120,120,104,120,120,104,232,200,184,200,152,152,200,152,152,240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,0,0,0,0,0,0,0,0,0,0,0,0,40,40,40,0,0,0,188,152,132,240,196,188,84,108,108,100,104,120,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,196,216,216,216,232,248,216,232,248,252,252,252,40,40,56,220,220,220,252,252,252,232,232,232,252,252,252,0,0,0,252,252,252,220,220,220,252,252,252,232,232,216,184,184,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,108,88,84,
200,152,152,232,152,184,232,152,184,124,104,104,72,56,72,100,24,16,100,24,16,100,24,16,148,80,48,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,100,24,16,100,24,16,100,24,16,100,24,16,88,68,64,124,104,104,232,152,184,124,104,104,0,0,0,0,0,0,0,0,0,156,136,136,0,0,0,232,152,184,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,0,0,0,0,0,0,0,0,0,0,0,0,120,120,120,252,252,252,252,252,252,208,212,220,0,0,0,252,252,252,252,252,252,136,136,120,244,240,220,0,0,0,184,184,168,244,240,220,244,240,220,200,200,184,0,0,0,0,0,0,0,0,0,0,0,0,168,168,152,212,228,204,212,228,204,212,228,204,200,200,184,0,0,0,0,0,0,0,0,0,0,0,0,88,88,68,212,228,204,212,228,204,212,228,204,164,184,168,0,0,0,0,0,0,0,0,0,0,0,0,120,120,120,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,8,136,56,244,240,220,244,240,220,244,240,220,136,136,120,120,120,104,120,120,104,240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,0,0,0,0,0,0,
0,0,0,0,0,0,124,104,104,240,196,188,240,196,188,0,0,0,0,0,0,240,196,188,240,196,188,12,88,116,120,120,120,208,212,232,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,136,152,152,0,0,0,216,232,248,216,232,248,24,24,24,100,104,120,56,56,56,216,232,248,120,120,120,252,252,252,0,0,0,232,232,232,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,168,168,168,136,136,136,120,120,104,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,232,232,108,88,84,212,148,172,232,152,184,232,152,184,140,120,116,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,108,164,212,148,172,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,232,152,184,248,248,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,0,0,0,252,252,252,252,252,252,
136,136,136,0,0,0,232,232,232,252,252,252,208,212,220,0,0,0,252,252,252,120,120,104,216,216,200,216,216,200,0,0,0,244,240,220,200,200,184,244,240,220,0,0,0,120,120,104,8,136,56,212,228,204,120,120,120,0,0,0,212,228,204,212,228,204,212,228,204,0,0,0,24,24,24,212,228,204,212,228,204,164,184,168,0,0,0,132,152,132,212,228,204,212,228,204,0,0,0,56,56,56,212,228,204,212,228,204,132,152,132,0,0,0,184,184,168,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,184,200,184,8,136,56,244,240,220,244,240,220,244,240,220,120,120,104,120,120,104,232,200,184,240,196,188,108,88,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,108,88,84,0,0,0,188,152,132,240,196,188,84,108,108,100,104,120,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,0,0,0,0,0,0,216,232,248,144,148,168,176,196,208,216,232,248,72,72,68,216,232,248,120,120,120,
136,136,136,252,252,252,24,24,24,40,24,40,0,0,0,152,152,152,252,252,252,136,136,120,168,168,152,244,240,220,244,240,220,120,120,104,220,220,220,252,252,252,252,252,252,248,248,248,160,184,192,12,88,116,12,88,116,108,88,84,232,152,184,232,152,184,140,120,116,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,108,164,212,148,172,232,152,184,232,152,184,232,152,184,200,152,152,108,88,84,200,200,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,200,184,200,252,252,252,252,252,252,252,252,252,0,0,0,152,152,152,252,252,252,208,212,220,0,0,0,244,240,220,244,240,220,244,240,220,184,184,168,0,0,0,244,240,220,184,184,168,184,184,168,0,0,0,244,240,220,200,216,168,8,136,56,212,228,204,0,0,0,132,152,132,212,228,204,212,228,204,0,0,0,164,184,168,212,228,204,212,228,204,212,228,204,0,0,0,40,40,40,212,228,204,212,228,204,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,104,104,104,212,228,204,
212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,24,152,76,136,184,136,244,240,220,244,240,220,136,136,120,120,120,104,120,120,104,240,196,188,0,0,0,0,0,0,0,0,0,108,88,84,240,196,188,88,68,64,0,0,0,200,152,152,240,196,188,240,196,188,216,168,168,0,0,0,24,24,24,240,196,188,240,196,188,12,88,116,120,120,120,208,212,232,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,88,88,88,0,0,0,216,232,248,136,136,136,120,120,120,136,136,136,136,136,136,216,232,248,168,168,168,120,120,120,120,120,120,252,252,252,248,248,248,252,252,252,252,252,252,152,152,136,184,184,168,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,236,236,236,252,252,252,60,128,176,12,88,116,8,152,216,8,152,216,12,88,116,124,104,104,232,152,184,140,120,116,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,
8,152,216,8,108,164,212,148,172,232,152,184,232,152,184,140,120,116,104,88,104,232,232,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,236,236,236,252,252,252,252,252,252,252,252,252,200,184,200,208,212,220,252,252,252,216,200,200,0,0,0,244,240,220,244,240,220,244,240,220,172,152,148,0,0,0,244,240,220,216,216,200,120,120,120,0,0,0,244,240,220,244,240,220,24,152,76,136,184,136,0,0,0,88,88,88,212,228,204,212,228,204,168,168,152,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,24,24,24,212,228,204,212,228,204,168,168,152,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,104,104,84,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,8,136,56,244,240,220,244,240,220,244,240,220,120,120,104,120,120,104,232,200,184,200,152,152,0,0,0,108,88,84,240,196,188,240,196,188,240,196,188,0,0,0,0,0,0,240,196,188,240,196,188,108,88,84,0,0,0,0,0,0,240,196,188,240,196,188,100,124,128,100,104,120,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,
216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,104,104,104,208,212,232,0,0,0,216,232,248,136,136,136,208,212,220,216,232,248,0,0,0,216,232,248,240,196,188,184,168,168,120,120,120,120,120,120,136,136,136,232,216,216,136,136,120,168,168,152,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,168,168,152,12,88,116,12,88,116,12,88,116,8,152,216,8,152,216,8,152,216,8,152,216,64,72,88,140,120,116,212,148,172,56,56,56,24,24,24,44,20,20,44,20,20,44,20,20,56,40,36,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,72,72,68,56,40,36,44,20,20,44,20,20,44,20,20,40,24,40,56,56,56,232,152,184,232,152,184,124,104,104,124,104,104,252,252,252,252,252,252,24,24,24,0,0,0,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,216,200,200,200,184,0,0,0,244,240,220,244,240,220,244,240,220,72,72,68,0,0,0,244,240,220,232,232,216,104,104,104,0,0,0,244,240,220,244,240,220,244,240,220,8,136,56,0,0,0,
56,56,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,56,56,56,0,0,0,184,200,168,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,40,40,40,0,0,0,200,216,200,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,184,200,184,8,136,56,244,240,220,244,240,220,136,136,120,120,120,104,120,120,104,240,196,188,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,104,104,240,196,188,240,196,188,240,196,188,12,88,116,120,120,120,208,212,232,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,0,0,0,216,232,248,0,0,0,216,232,248,164,168,184,164,168,184,216,232,248,0,0,0,216,232,248,240,196,188,240,196,188,204,184,176,120,120,120,120,120,120,120,120,104,216,216,200,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,136,136,120,12,88,116,8,108,164,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,
8,152,216,68,88,88,156,136,136,232,152,184,200,152,152,152,36,24,200,40,40,200,40,40,200,40,40,248,216,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,200,168,200,40,40,200,40,40,200,40,40,100,24,16,232,152,184,232,152,184,232,152,184,108,88,84,120,120,120,252,252,252,252,252,252,72,72,68,232,232,232,252,252,252,24,24,24,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,200,200,184,200,200,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,168,152,244,240,220,244,240,220,104,104,104,0,0,0,244,240,220,244,240,220,244,240,220,216,232,200,0,0,0,56,56,56,212,228,204,212,228,204,212,228,204,212,228,204,136,136,120,0,0,0,0,0,0,152,168,152,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,104,104,104,0,0,0,0,0,0,184,200,184,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,24,152,76,136,184,136,244,240,220,244,240,220,120,120,104,120,120,104,232,200,184,200,152,152,0,0,0,56,40,36,240,196,188,
216,168,168,0,0,0,72,56,72,0,0,0,0,0,0,0,0,0,40,40,24,240,196,188,188,152,132,124,104,104,240,196,188,100,124,128,84,108,108,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,176,196,208,136,136,136,216,232,248,0,0,0,216,232,248,216,232,248,24,24,24,0,0,0,164,168,184,216,232,248,240,196,188,240,196,188,240,196,188,248,200,200,244,240,220,200,200,168,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,136,120,136,200,152,152,232,152,184,0,0,0,200,40,40,200,40,40,200,40,40,200,40,40,216,80,48,232,196,168,244,240,220,232,196,168,196,60,40,200,40,40,200,40,40,200,40,40,200,40,40,0,0,0,232,152,184,212,148,172,108,88,84,152,152,152,252,252,252,232,232,232,252,252,252,152,152,152,200,200,200,252,252,252,136,136,136,220,220,220,252,252,252,252,252,252,252,252,252,232,232,232,0,0,0,252,252,252,252,252,252,252,252,252,
236,236,236,120,120,104,216,216,200,244,240,220,200,200,184,0,0,0,136,136,120,136,136,120,120,120,104,0,0,0,184,184,168,244,240,220,244,240,220,104,104,104,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,20,44,24,212,228,204,212,228,204,212,228,204,0,0,0,0,0,0,88,88,68,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,0,0,0,104,104,104,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,8,136,56,244,240,220,244,240,220,136,136,120,120,120,104,120,120,104,240,196,188,24,8,24,0,0,0,0,0,0,0,0,0,0,0,0,140,120,116,240,196,188,232,176,184,232,200,184,240,196,188,216,168,168,0,0,0,0,0,0,240,196,188,240,196,188,12,88,116,100,104,120,196,216,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,40,40,40,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,56,56,56,
188,152,132,240,196,188,56,56,56,172,152,148,244,240,220,120,120,120,0,0,0,0,0,0,0,0,0,244,240,220,244,240,220,120,120,104,0,0,0,0,0,0,232,236,220,0,0,0,8,152,216,8,152,216,8,56,76,0,0,0,0,0,0,0,0,0,8,152,216,104,88,104,212,148,172,200,152,152,100,24,16,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,44,20,20,212,148,172,172,152,148,108,88,84,200,200,200,252,252,252,252,252,252,232,232,232,72,72,68,252,252,252,232,232,232,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,0,0,0,252,252,252,252,252,252,200,200,200,244,240,220,244,240,220,244,240,220,244,240,220,200,200,184,0,0,0,244,240,220,244,240,220,244,240,220,200,200,184,0,0,0,244,240,220,232,232,216,104,104,104,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,8,24,8,200,216,184,212,228,204,72,72,68,0,0,0,200,216,200,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,24,24,24,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,
212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,184,200,184,8,136,56,244,240,220,244,240,220,120,120,104,120,120,104,216,200,184,240,196,188,0,0,0,0,0,0,0,0,0,24,8,24,240,196,188,240,196,188,108,88,84,240,196,188,240,196,188,0,0,0,0,0,0,24,8,24,240,196,188,240,196,188,100,124,128,12,88,116,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,56,56,56,188,152,132,240,196,188,56,56,56,188,152,132,240,196,188,0,0,0,244,240,220,244,240,220,88,88,68,152,152,136,244,240,220,0,0,0,200,200,184,244,240,220,244,240,220,0,0,0,8,152,216,8,152,216,0,0,0,8,152,216,8,152,216,0,0,0,8,108,164,8,108,164,108,88,84,232,152,184,140,120,116,100,24,16,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,44,20,20,156,136,136,140,120,116,
124,104,104,236,236,236,252,252,252,120,120,120,252,252,252,252,252,252,152,152,152,168,168,168,252,252,252,252,252,252,0,0,0,252,252,252,184,184,184,120,120,120,252,252,252,252,252,252,0,0,0,232,232,232,168,168,168,120,120,120,244,240,220,0,0,0,184,184,168,244,240,220,200,200,184,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,216,216,200,252,252,252,136,136,136,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,88,88,88,8,136,56,212,228,204,0,0,0,88,88,68,212,228,204,212,228,204,212,228,204,56,56,56,88,88,88,212,228,204,212,228,204,0,0,0,136,136,120,212,228,204,212,228,204,212,228,204,56,56,56,136,136,120,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,24,152,76,152,184,132,244,240,220,136,136,120,120,120,104,120,120,104,240,196,188,240,196,188,216,168,168,240,196,188,240,196,188,240,196,188,240,196,188,124,104,104,240,196,188,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,12,88,116,68,88,88,196,216,216,216,232,248,216,232,248,216,232,248,216,232,248,
216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,164,168,184,200,200,216,216,232,248,216,232,248,160,184,192,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,56,56,56,188,152,132,240,196,188,56,56,56,188,152,132,240,196,188,240,196,188,244,240,220,216,216,200,0,0,0,184,184,168,244,240,220,0,0,0,200,200,184,244,240,220,244,240,220,0,0,0,196,216,216,8,132,192,0,0,0,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,12,88,116,108,88,84,232,152,184,200,152,152,0,0,0,152,36,24,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,152,36,24,0,0,0,212,148,172,108,88,84,124,104,104,252,252,252,252,252,252,168,168,168,236,236,236,40,40,40,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,0,0,0,152,152,136,244,240,220,244,240,220,232,232,216,0,0,0,200,200,184,244,240,220,200,200,184,0,0,0,244,240,220,244,240,220,244,240,220,168,168,152,0,0,0,252,252,252,252,252,252,208,212,220,0,0,0,236,236,236,244,240,220,244,240,220,232,232,216,0,0,0,
184,184,168,136,184,136,24,152,76,0,0,0,0,0,0,212,228,204,212,228,204,212,228,204,0,0,0,104,104,104,212,228,204,212,228,204,0,0,0,72,72,68,212,228,204,212,228,204,212,228,204,0,0,0,152,168,152,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,8,136,56,244,240,220,244,240,220,120,120,104,120,120,104,216,200,184,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,56,40,36,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,132,180,120,12,88,116,100,104,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,56,56,56,188,152,132,240,196,188,56,56,56,188,152,132,240,196,188,240,196,188,24,24,24,0,0,0,152,152,136,244,240,220,244,240,220,0,0,0,200,200,184,244,240,220,244,240,220,0,0,0,244,240,220,104,160,192,0,0,0,0,0,0,
0,0,0,0,0,0,8,56,76,8,152,216,8,152,216,12,88,116,108,88,84,232,152,184,232,152,184,156,136,136,24,24,24,0,0,0,0,0,0,0,0,0,12,40,48,8,108,164,12,88,116,108,88,84,136,136,120,252,252,252,252,252,252,0,0,0,200,200,200,252,252,252,200,200,200,104,104,104,136,136,136,0,0,0,0,0,0,236,236,236,236,236,236,0,0,0,0,0,0,220,220,220,252,252,252,252,252,252,120,120,120,0,0,0,56,56,56,120,120,104,0,0,0,0,0,0,244,240,220,244,240,220,200,200,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,40,40,252,252,252,252,252,252,252,252,252,40,40,40,0,0,0,104,104,84,104,104,104,0,0,0,24,24,24,244,240,220,244,240,220,8,136,56,152,184,152,0,0,0,24,24,24,88,88,88,0,0,0,0,0,0,212,228,204,212,228,204,212,228,204,152,168,152,0,0,0,40,40,40,88,88,88,0,0,0,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,184,200,184,8,136,56,244,240,220,152,152,136,120,120,104,120,120,104,240,196,188,240,196,188,
240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,0,0,0,0,0,0,108,88,84,0,0,0,108,88,84,240,196,188,240,196,188,240,196,188,240,196,188,12,88,116,12,88,116,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,164,168,184,120,120,120,216,232,232,216,232,248,176,196,208,216,232,248,216,232,248,176,196,208,136,152,152,216,232,248,56,56,56,188,152,132,240,196,188,56,56,56,188,152,132,240,196,188,0,0,0,108,88,84,240,196,188,248,232,216,244,240,220,244,240,220,0,0,0,200,200,184,244,240,220,244,240,220,0,0,0,244,240,220,232,216,200,0,0,0,8,152,216,8,152,216,8,56,76,12,88,116,8,152,216,8,152,216,8,152,216,12,88,116,124,104,104,232,152,184,232,152,184,108,88,84,12,88,116,8,152,216,8,152,216,8,152,216,8,152,216,12,88,116,184,184,184,252,252,252,252,252,252,0,0,0,236,236,236,252,252,252,252,252,252,252,252,252,120,120,120,72,72,68,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,136,136,120,244,240,220,200,200,184,88,88,68,0,0,0,
120,120,104,244,240,220,244,240,220,244,240,220,232,216,200,172,152,148,172,152,148,172,152,148,168,168,168,208,212,220,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,184,184,168,56,56,56,40,40,40,168,168,152,244,240,220,244,240,220,244,240,220,244,240,220,8,136,56,200,216,200,104,104,104,0,0,0,88,88,88,200,216,200,212,228,204,212,228,204,212,228,204,212,228,204,200,216,184,88,88,88,0,0,0,104,104,104,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,24,152,76,152,184,132,244,240,220,120,120,104,120,120,104,216,200,184,240,196,188,240,196,188,240,196,188,240,196,188,156,136,136,0,0,0,0,0,0,200,152,152,240,196,188,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,168,168,152,12,88,116,12,88,116,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,136,152,152,68,88,88,164,168,184,0,0,0,216,232,248,136,136,136,216,232,248,216,232,248,56,56,56,176,196,208,0,0,0,0,0,0,
216,168,168,240,196,188,56,56,56,188,152,132,240,196,188,0,0,0,200,152,152,240,196,188,0,0,0,168,168,152,244,240,220,0,0,0,200,200,184,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,0,0,0,32,152,216,8,152,216,0,0,0,8,132,192,8,152,216,8,152,216,8,152,216,8,152,216,68,88,88,140,120,116,108,88,84,12,88,116,8,152,216,8,152,216,8,152,216,8,132,192,12,88,116,236,236,236,252,252,252,184,184,184,252,252,252,236,236,236,40,40,40,252,252,252,252,252,252,104,104,104,252,252,252,56,56,56,232,232,232,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,216,216,200,244,240,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,120,120,104,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,168,200,152,8,136,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,
212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,8,136,56,244,240,220,152,152,136,120,120,104,120,120,104,240,196,188,240,196,188,240,196,188,216,168,168,0,0,0,0,0,0,156,136,136,240,196,188,216,168,168,156,136,136,0,0,0,40,40,24,216,168,168,124,104,104,108,88,84,240,196,188,8,136,56,12,88,116,100,124,128,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,40,40,40,216,232,248,136,136,136,216,232,248,144,168,168,164,168,184,216,232,248,144,148,168,88,68,64,240,196,188,240,196,188,108,88,84,200,152,152,240,196,188,240,196,188,24,8,24,0,0,0,88,68,64,240,196,188,72,72,68,0,0,0,56,56,56,72,72,68,244,240,220,0,0,0,244,240,220,244,240,220,216,200,184,24,24,24,0,0,0,12,88,116,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,136,216,84,84,104,12,88,116,8,152,216,8,152,216,8,152,216,8,108,164,68,88,88,252,252,252,252,252,252,152,152,152,236,236,236,56,56,56,
252,252,252,200,200,200,104,104,104,0,0,0,220,220,220,252,252,252,252,252,252,0,0,0,0,0,0,208,212,220,252,252,252,252,252,252,232,232,216,244,240,220,56,56,56,0,0,0,0,0,0,24,24,24,244,240,220,244,240,220,244,240,220,184,184,168,0,0,0,244,240,220,184,184,168,120,120,104,252,252,252,0,0,0,136,136,136,252,252,252,0,0,0,72,72,68,248,248,232,136,136,120,244,240,220,244,240,220,244,240,220,200,200,184,0,0,0,232,232,200,244,240,220,0,0,0,232,216,200,244,240,220,8,136,56,152,200,148,0,0,0,56,56,56,212,228,204,212,228,204,0,0,0,200,216,184,212,228,204,212,228,204,0,0,0,132,152,132,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,88,88,68,0,0,0,0,0,0,0,0,0,104,104,104,212,228,204,212,228,204,212,228,204,168,200,168,8,136,56,244,240,220,120,120,104,104,104,84,188,168,152,240,196,188,240,196,188,0,0,0,0,0,0,108,88,84,240,196,188,232,176,184,156,136,136,40,40,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,196,188,216,200,168,24,152,76,12,88,116,196,216,216,216,232,248,
216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,136,136,136,216,232,248,144,148,168,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,0,0,0,200,200,184,244,240,220,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,132,192,8,152,216,8,152,216,8,152,216,12,88,116,132,136,152,252,252,252,252,252,252,24,24,24,168,168,168,252,252,252,200,200,200,136,136,136,252,252,252,136,136,136,168,168,168,252,252,252,252,252,252,232,232,232,252,252,252,248,248,248,252,252,252,252,252,252,152,152,136,244,240,220,0,0,0,0,0,0,200,200,168,200,200,184,0,0,0,0,0,0,244,240,220,244,240,220,184,184,168,0,0,0,244,240,220,136,136,120,252,252,252,252,252,252,0,0,0,136,136,136,252,252,252,152,152,152,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,72,72,68,0,0,0,244,240,220,
244,240,220,0,0,0,232,216,200,244,240,220,244,240,220,8,136,56,0,0,0,152,152,136,212,228,204,212,228,204,0,0,0,200,216,184,212,228,204,212,228,204,0,0,0,132,152,132,212,228,204,212,228,204,212,228,204,136,136,120,0,0,0,0,0,0,212,228,204,212,228,204,212,228,204,0,0,0,0,0,0,164,184,168,184,200,184,136,136,120,0,0,0,56,56,56,212,228,204,212,228,204,212,228,204,24,152,76,152,184,132,120,120,104,20,44,24,104,104,104,240,196,188,124,104,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,40,24,156,136,136,240,196,188,136,136,120,12,88,116,12,88,116,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,136,136,136,216,232,248,144,148,168,160,184,192,216,232,248,0,0,0,240,196,188,240,196,188,240,196,188,56,56,56,156,136,136,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,216,200,184,168,168,152,244,240,220,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,
244,240,220,120,120,120,8,108,164,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,136,216,12,88,116,200,200,216,252,252,252,252,252,252,88,88,88,200,200,200,252,252,252,252,252,252,252,252,252,136,136,136,200,200,200,252,252,252,56,56,56,220,220,220,152,152,152,24,24,24,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,232,0,0,0,216,216,200,244,240,220,244,240,220,216,216,200,0,0,0,232,232,200,244,240,220,184,184,168,0,0,0,248,248,232,252,252,252,252,252,252,252,252,252,0,0,0,136,136,136,252,252,252,244,240,220,0,0,0,216,216,200,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,88,88,88,244,240,220,244,240,220,0,0,0,232,216,200,244,240,220,244,240,220,216,216,184,0,0,0,184,200,168,212,228,204,212,228,204,0,0,0,200,216,184,212,228,204,212,228,204,0,0,0,132,152,132,212,228,204,212,228,204,212,228,204,0,0,0,120,120,120,0,0,0,212,228,204,212,228,204,200,216,184,0,0,0,200,216,184,212,228,204,212,228,204,212,228,204,0,0,0,56,56,56,212,228,204,212,228,204,212,228,204,212,228,204,8,136,56,8,136,56,104,104,104,104,104,104,
204,184,176,240,196,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,68,64,156,136,136,232,176,184,240,196,188,240,196,188,240,196,188,240,196,188,200,152,152,240,196,188,96,164,104,12,88,116,12,88,116,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,136,136,136,216,232,248,196,216,216,120,120,120,216,232,248,0,0,0,240,196,188,240,196,188,240,196,188,124,104,104,200,152,152,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,200,184,244,240,220,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,8,108,164,8,152,216,8,152,216,8,152,216,8,152,216,8,152,216,8,108,164,12,88,116,252,252,252,252,252,252,220,220,220,0,0,0,252,252,252,24,24,24,248,248,248,252,252,252,252,252,252,252,252,252,56,56,56,236,236,236,252,252,252,0,0,0,88,88,88,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,184,184,168,
244,240,220,184,184,168,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,136,136,136,216,216,200,244,240,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,216,200,168,168,152,244,240,220,0,0,0,232,216,200,244,240,220,244,240,220,232,232,216,0,0,0,96,164,104,212,228,204,212,228,204,0,0,0,200,216,184,212,228,204,212,228,204,0,0,0,132,152,132,212,228,204,212,228,204,152,168,152,0,0,0,200,216,184,0,0,0,212,228,204,212,228,204,168,168,152,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,56,56,56,212,228,204,212,228,204,212,228,204,212,228,204,168,200,168,212,228,204,132,152,132,104,104,104,104,104,104,240,196,188,188,152,132,108,88,84,200,152,152,240,196,188,240,196,188,240,196,188,232,176,184,156,136,136,240,196,188,240,196,188,240,196,188,216,168,168,0,0,0,0,0,0,240,196,188,216,200,184,8,136,56,12,88,116,164,168,184,216,232,248,216,232,248,216,232,248,104,160,192,216,232,248,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,216,232,248,216,232,248,136,136,136,216,232,248,216,232,248,136,136,136,0,0,0,200,200,216,240,196,188,
240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,216,216,200,216,216,200,120,120,104,232,232,216,244,240,220,244,240,220,244,240,220,244,240,220,104,104,104,8,132,192,8,152,216,8,152,216,8,152,216,12,88,116,84,108,108,252,252,252,252,252,252,168,168,168,24,24,24,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,0,0,0,248,248,232,152,152,136,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,184,184,184,0,0,0,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,136,136,120,244,240,220,244,240,220,104,104,104,0,0,0,200,200,184,200,200,184,200,200,184,88,88,88,0,0,0,244,240,220,120,120,104,244,240,220,0,0,0,232,216,200,244,240,220,244,240,220,200,200,184,0,0,0,8,136,56,200,216,200,212,228,204,0,0,0,200,216,184,212,228,204,212,228,204,0,0,0,132,152,132,212,228,204,212,228,204,0,0,0,104,104,104,
200,216,184,0,0,0,212,228,204,212,228,204,132,152,132,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,56,56,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,104,104,104,104,104,104,204,184,176,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,108,88,84,232,176,184,240,196,188,124,104,104,0,0,0,0,0,0,0,0,0,156,136,136,240,196,188,172,152,148,12,88,116,12,88,116,216,232,248,216,232,248,192,220,244,8,108,164,8,108,164,216,232,248,216,232,248,0,0,0,216,232,248,216,232,248,0,0,0,216,232,248,136,136,136,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,120,120,104,120,120,104,120,120,104,232,232,200,244,240,220,244,240,220,244,240,220,244,240,220,104,104,104,8,136,216,8,152,216,12,88,116,160,184,192,252,252,252,252,252,252,248,248,248,252,252,252,0,0,0,252,252,252,252,252,252,252,252,252,248,248,248,40,40,40,252,252,252,
252,252,252,252,252,252,252,252,252,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,0,0,0,252,252,252,152,152,136,152,152,136,244,240,220,216,216,200,120,120,104,248,248,248,200,184,200,0,0,0,168,168,168,168,168,168,168,168,168,168,168,152,0,0,0,136,136,120,244,240,220,244,240,220,232,232,200,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,72,72,68,244,240,220,152,152,136,244,240,220,0,0,0,168,168,152,184,184,168,152,152,136,0,0,0,0,0,0,232,232,200,8,136,56,212,228,204,0,0,0,200,216,184,212,228,204,212,228,204,0,0,0,132,152,132,212,228,204,184,200,184,0,0,0,212,228,204,200,216,184,0,0,0,212,228,204,212,228,204,132,152,132,0,0,0,212,228,204,212,228,204,0,0,0,0,0,0,0,0,0,56,56,56,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,132,152,132,104,104,104,104,104,104,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,200,184,0,0,0,0,0,0,0,0,0,0,0,0,232,176,184,240,196,188,240,196,188,240,196,188,120,120,104,
12,88,116,12,88,116,216,232,248,8,108,164,8,108,164,8,108,164,32,132,188,216,232,248,164,168,184,0,0,0,88,88,88,0,0,0,216,232,248,136,136,136,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,72,72,68,240,196,188,240,196,188,240,196,188,188,152,132,216,168,168,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,120,120,104,120,120,104,120,120,104,216,216,200,244,240,220,244,240,220,244,240,220,232,232,216,84,108,108,12,88,116,236,236,236,252,252,252,252,252,252,252,252,252,0,0,0,252,252,252,236,236,236,56,56,56,252,252,252,252,252,252,252,252,252,208,212,220,104,104,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,0,0,0,252,252,252,252,252,252,152,152,136,136,136,120,120,120,104,252,252,252,252,252,252,200,184,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,136,120,244,240,220,244,240,220,244,240,220,0,0,0,184,184,168,244,240,220,244,240,220,0,0,0,216,216,200,244,240,220,244,240,220,
244,240,220,0,0,0,0,0,0,0,0,0,0,0,0,40,40,40,216,216,200,244,240,220,96,164,104,96,164,104,0,0,0,200,216,184,212,228,204,212,228,204,0,0,0,132,152,132,212,228,204,24,24,24,72,72,68,212,228,204,200,216,184,0,0,0,212,228,204,212,228,204,132,152,132,0,0,0,212,228,204,212,228,204,120,120,120,120,120,120,120,120,120,136,136,120,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,104,104,104,104,104,104,172,152,148,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,156,136,136,0,0,0,0,0,0,0,0,0,108,88,84,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,8,136,56,12,88,116,84,108,108,8,108,164,60,128,176,160,184,192,8,108,164,136,180,216,216,232,248,216,232,232,176,196,208,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,108,88,84,240,196,188,240,196,188,0,0,0,140,120,116,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,224,148,124,120,120,120,120,120,104,
120,120,104,56,56,56,0,0,0,0,0,0,0,0,0,88,88,68,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,40,40,40,252,252,252,200,200,200,120,120,120,252,252,252,252,252,252,252,252,252,152,152,152,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,0,0,0,252,252,252,252,252,252,252,252,252,184,184,168,252,252,252,252,252,252,252,252,252,200,184,200,0,0,0,252,252,252,244,240,220,244,240,220,244,240,220,0,0,0,136,136,120,200,200,184,0,0,0,244,240,220,88,88,88,24,24,24,244,240,220,152,152,136,0,0,0,244,240,220,40,40,40,120,120,104,252,252,252,0,0,0,232,216,200,244,240,220,244,240,220,216,200,184,0,0,0,244,240,220,88,88,88,8,136,56,0,0,0,200,216,184,88,88,88,212,228,204,0,0,0,132,152,132,200,216,200,0,0,0,212,228,204,132,152,132,200,216,184,0,0,0,212,228,204,168,168,152,132,152,132,0,0,0,212,228,204,184,200,168,184,200,168,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
72,72,68,104,104,104,104,104,104,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,40,40,24,0,0,0,0,0,0,0,0,0,216,168,168,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,200,200,168,84,84,104,12,88,116,12,40,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,104,120,136,152,152,40,40,40,56,56,56,72,72,68,72,72,68,24,24,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,0,0,0,156,136,136,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,228,176,140,200,40,40,216,104,68,136,136,120,120,120,104,120,120,104,200,200,184,152,152,136,152,152,152,252,252,252,236,236,236,252,252,252,0,0,0,168,168,168,252,252,252,252,252,252,220,220,220,104,104,104,252,252,252,120,120,120,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,0,0,0,252,252,252,252,252,252,252,252,252,248,248,248,200,184,200,252,252,252,
252,252,252,200,184,200,0,0,0,244,240,220,184,184,168,244,240,220,244,240,220,0,0,0,136,136,120,244,240,220,244,240,220,244,240,220,216,216,200,0,0,0,244,240,220,0,0,0,56,56,56,244,240,220,120,120,104,252,252,252,252,252,252,0,0,0,232,216,200,244,240,220,244,240,220,244,240,220,0,0,0,152,152,136,244,240,220,244,240,220,0,0,0,200,216,184,212,228,204,212,228,204,0,0,0,132,152,132,56,56,56,40,40,40,212,228,204,212,228,204,200,216,184,0,0,0,212,228,204,212,228,204,152,152,136,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,200,216,184,200,216,184,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,104,104,104,104,104,104,120,120,104,240,196,188,240,196,188,200,152,152,0,0,0,0,0,0,0,0,0,72,72,68,240,196,188,240,196,188,240,196,188,240,196,188,216,168,168,140,120,116,56,40,36,0,0,0,124,104,104,240,196,188,152,152,136,12,88,116,12,88,116,8,108,164,104,160,192,244,240,220,8,108,164,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,
24,24,24,240,196,188,240,196,188,0,0,0,156,136,136,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,196,168,200,40,40,216,104,68,248,200,184,216,104,68,136,136,120,120,120,104,120,120,104,152,152,136,252,252,252,252,252,252,252,252,252,252,252,252,88,88,88,208,212,220,72,72,68,252,252,252,252,252,252,152,152,152,184,184,184,252,252,252,56,56,56,236,236,236,252,252,252,252,252,252,252,252,252,120,120,104,136,136,136,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,0,0,0,248,248,248,252,252,252,252,252,252,208,212,220,0,0,0,252,252,252,252,252,252,184,200,184,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,216,216,184,0,0,0,216,200,184,200,200,184,252,252,252,252,252,252,252,252,252,0,0,0,232,232,232,244,240,220,244,240,220,244,240,220,0,0,0,168,168,152,244,240,220,244,240,220,0,0,0,8,136,56,212,228,204,212,228,204,0,0,0,132,152,132,0,0,0,200,216,184,212,228,204,212,228,204,
200,216,184,0,0,0,212,228,204,212,228,204,184,200,184,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,0,0,0,72,72,68,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,200,216,200,104,104,104,104,104,104,204,184,176,240,196,188,24,24,24,0,0,0,0,0,0,188,152,132,156,136,136,88,68,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,176,184,240,196,188,8,136,56,8,136,56,12,88,116,184,184,168,136,136,120,244,240,220,8,108,164,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,216,168,168,240,196,188,240,196,188,0,0,0,188,152,132,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,200,40,40,200,40,40,252,252,252,252,252,252,248,216,184,204,88,72,152,152,136,120,120,120,120,120,120,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,88,88,88,248,248,248,0,0,0,248,248,248,252,252,252,72,72,68,236,236,236,252,252,252,220,220,220,252,252,252,232,232,232,
120,120,104,216,216,184,244,240,220,200,200,184,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,24,24,24,220,220,220,220,220,220,40,40,40,0,0,0,252,252,252,252,252,252,184,184,168,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,56,56,56,24,24,24,0,0,0,248,248,232,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,152,152,152,172,152,148,152,152,136,0,0,0,0,0,0,244,240,220,244,240,220,244,240,220,0,0,0,8,136,56,168,200,152,212,228,204,0,0,0,0,0,0,0,0,0,212,228,204,212,228,204,212,228,204,200,216,184,0,0,0,212,228,204,212,228,204,212,228,204,0,0,0,24,24,24,184,200,184,212,228,204,104,104,84,0,0,0,164,184,168,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,136,136,120,104,104,104,104,104,104,240,196,188,240,196,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,104,104,108,88,84,0,0,0,0,0,0,
0,0,0,240,196,188,240,196,188,100,124,128,100,104,120,136,136,136,136,136,136,136,136,120,176,196,208,8,108,164,104,160,192,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,156,136,136,240,196,188,240,196,188,240,196,188,0,0,0,200,152,152,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,200,40,40,200,40,40,196,60,40,252,252,252,252,252,252,216,80,48,200,40,40,216,80,48,152,152,152,120,120,120,120,120,120,168,168,168,252,252,252,252,252,252,248,248,248,88,88,88,252,252,252,252,252,252,40,40,56,200,200,200,252,252,252,24,24,24,252,252,252,252,252,252,184,184,168,120,120,104,244,240,220,244,240,220,244,240,220,244,240,220,200,200,184,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,40,24,40,0,0,0,0,0,0,0,0,0,56,56,56,200,200,200,252,252,252,184,184,168,0,0,0,244,240,220,244,240,220,244,240,220,244,240,220,0,0,0,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,200,200,168,0,0,0,56,56,56,252,252,252,252,252,252,252,252,252,252,252,252,
252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,40,40,40,232,232,200,244,240,220,244,240,220,244,240,220,0,0,0,232,216,200,8,136,56,212,228,204,0,0,0,0,0,0,208,212,220,184,184,168,164,184,168,212,228,204,200,216,184,0,0,0,212,228,204,212,228,204,212,228,204,212,228,204,40,40,40,0,0,0,0,0,0,0,0,0,136,136,120,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,104,104,104,104,104,104,120,120,104,240,196,188,188,152,132,0,0,0,24,24,24,124,104,104,200,152,152,240,196,188,240,196,188,240,196,188,240,196,188,56,40,36,0,0,0,0,0,0,0,0,0,216,168,168,240,196,188,240,196,188,204,184,176,120,120,120,252,252,252,252,252,252,120,120,120,136,136,136,60,128,176,8,108,164,192,220,244,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,240,196,188,240,196,188,240,196,188,240,196,188,0,0,0,200,152,152,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,196,60,40,200,40,40,200,40,40,248,232,216,252,252,252,252,252,252,200,40,40,
200,40,40,200,40,40,216,80,48,168,168,168,120,120,120,120,120,120,152,152,152,252,252,252,252,252,252,248,248,248,72,72,68,252,252,252,252,252,252,136,136,136,120,120,120,252,252,252,252,252,252,136,136,120,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,200,200,184,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,248,248,248,0,0,0,252,252,252,252,252,252,248,248,232,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,200,200,168,244,240,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,248,248,248,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,184,200,168,8,136,56,252,252,252,252,252,252,252,252,252,252,252,252,136,136,120,152,152,136,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,
212,228,204,212,228,204,212,228,204,200,216,200,104,104,104,104,104,104,168,168,152,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,216,168,168,0,0,0,0,0,0,0,0,0,56,56,56,240,196,188,240,196,188,232,200,184,188,152,132,240,196,188,104,124,96,120,120,120,120,120,120,12,88,116,8,108,164,244,240,220,8,108,164,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,140,120,116,240,196,188,240,196,188,0,0,0,216,168,168,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,204,88,72,200,40,40,200,40,40,200,40,40,252,252,252,252,252,252,252,252,252,216,104,68,200,40,40,200,40,40,200,40,40,196,60,40,184,168,168,120,120,120,120,120,120,152,152,152,252,252,252,252,252,252,88,88,88,248,248,248,252,252,252,252,252,252,252,252,252,248,248,248,120,120,104,200,200,168,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,200,200,184,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,0,0,0,
252,252,252,252,252,252,252,252,252,216,200,200,120,120,120,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,152,152,136,120,120,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,168,120,120,104,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,184,200,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,184,184,184,104,104,104,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,168,168,152,104,104,104,104,104,104,232,200,184,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,88,68,64,0,0,0,0,0,0,0,0,0,200,152,152,240,196,188,240,196,188,188,152,132,0,0,0,0,0,0,232,200,184,240,196,188,36,56,40,12,88,116,12,88,116,8,108,164,8,108,164,160,184,192,8,108,164,8,108,164,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,0,0,0,
188,152,132,124,104,104,156,136,136,0,0,0,156,136,136,200,152,152,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,216,128,88,200,40,40,200,40,40,200,40,40,248,200,168,252,252,252,252,252,252,252,252,252,252,252,252,216,128,88,200,40,40,200,40,40,200,40,40,200,40,40,204,184,176,120,120,120,120,120,120,168,168,168,252,252,252,252,252,252,40,40,56,252,252,252,252,252,252,200,200,200,120,120,104,232,232,216,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,200,200,184,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,40,40,40,220,220,220,252,252,252,152,152,152,104,104,104,252,252,252,232,232,232,120,120,104,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,168,168,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,136,120,152,152,136,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,244,240,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
236,236,236,104,104,104,184,200,184,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,120,120,104,104,104,104,104,104,104,240,196,188,240,196,188,240,196,188,232,176,184,0,0,0,0,0,0,0,0,0,40,40,24,240,196,188,216,168,168,240,196,188,88,68,64,0,0,0,0,0,0,0,0,0,188,152,132,240,196,188,240,196,188,104,104,104,12,88,116,84,84,104,60,128,176,8,108,164,8,108,164,168,204,236,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,24,8,24,240,196,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,240,196,188,240,196,188,228,176,140,200,40,40,200,40,40,200,40,40,200,40,40,252,252,252,252,252,252,224,148,124,228,144,100,252,252,252,252,252,252,228,144,100,216,104,68,252,252,252,248,248,248,200,40,40,184,168,168,120,120,120,120,120,120,168,168,168,252,252,252,248,248,248,252,252,252,152,152,136,120,120,120,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,
244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,200,200,184,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,104,104,104,184,184,184,252,252,252,40,40,40,220,220,220,232,232,232,56,56,56,252,252,252,248,248,248,120,120,104,232,232,216,232,232,216,120,120,104,216,216,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,184,184,168,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,120,216,216,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,132,152,132,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,104,104,104,104,104,104,136,136,120,240,196,188,156,136,136,0,0,0,0,0,0,0,0,0,156,136,136,240,196,188,240,196,188,240,196,188,24,8,24,0,0,0,
0,0,0,0,0,0,232,200,184,240,196,188,240,196,188,240,196,188,240,196,188,8,136,56,12,88,116,136,152,152,168,204,236,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,232,196,168,200,40,40,200,40,40,200,40,40,200,40,40,224,148,124,252,252,252,252,252,252,200,40,40,200,40,40,216,128,88,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,40,40,184,168,168,120,120,120,120,120,120,168,168,168,252,252,252,120,120,104,168,168,152,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,232,232,200,120,120,104,232,232,232,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,120,120,120,252,252,252,72,72,68,220,220,220,252,252,252,252,252,252,56,56,56,252,252,252,252,252,252,252,252,252,120,120,104,120,120,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,120,120,104,232,232,200,244,240,220,244,240,220,
244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,152,152,136,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,168,168,168,104,104,104,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,200,200,184,104,104,104,104,104,104,184,168,168,240,196,188,0,0,0,0,0,0,232,200,184,240,196,188,240,196,188,216,168,168,0,0,0,0,0,0,0,0,0,56,56,56,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,184,184,152,12,88,116,12,88,116,196,216,216,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,252,252,252,252,252,252,224,148,124,200,40,40,196,60,40,248,248,232,
252,252,252,252,252,252,252,252,252,252,252,252,216,128,88,200,40,40,200,40,40,200,40,40,168,168,168,120,120,120,120,120,120,120,120,104,184,184,168,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,200,200,184,120,120,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,220,220,220,72,72,68,252,252,252,136,136,136,184,184,184,252,252,252,252,252,252,40,40,40,252,252,252,252,252,252,24,24,24,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,184,120,120,104,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,184,184,168,136,136,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,232,232,232,104,104,104,200,216,184,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,
212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,152,152,136,104,104,104,104,104,104,232,200,184,232,176,184,240,196,188,240,196,188,240,196,188,124,104,104,0,0,0,0,0,0,0,0,0,140,120,116,216,168,168,200,152,152,172,152,148,140,120,116,124,104,104,88,68,64,216,168,168,240,196,188,152,152,136,12,88,116,12,88,116,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,120,120,120,120,120,120,120,120,120,120,120,120,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,140,120,116,200,40,40,200,40,40,200,40,40,200,40,40,216,120,72,252,252,252,252,252,252,200,40,40,248,232,216,252,252,252,252,252,252,252,252,252,252,252,252,216,128,88,200,40,40,196,60,40,200,40,40,200,40,40,200,40,40,200,40,40,168,168,152,120,120,104,120,120,104,184,184,168,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,168,168,152,120,120,104,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,152,152,152,120,120,104,252,252,252,252,252,252,168,168,168,252,252,252,232,232,232,104,104,104,252,252,252,
252,252,252,104,104,104,220,220,220,252,252,252,0,0,0,252,252,252,252,252,252,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,152,152,136,136,136,120,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,168,168,152,136,136,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,104,104,104,152,152,136,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,120,120,104,104,104,104,104,104,104,240,196,188,240,196,188,240,196,188,40,40,40,0,0,0,0,0,0,0,0,0,108,88,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,196,188,240,196,188,8,136,56,12,88,116,84,108,108,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,120,120,120,
120,120,120,136,136,136,120,120,120,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,140,120,116,200,40,40,200,40,40,200,40,40,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,216,128,88,200,40,40,200,40,40,196,60,40,252,252,252,224,148,124,200,40,40,200,40,40,200,40,40,200,40,40,152,152,136,120,120,104,120,120,104,200,200,184,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,136,136,120,152,152,136,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,136,120,168,168,152,184,184,168,120,120,104,252,252,252,252,252,252,252,252,252,88,88,88,252,252,252,252,252,252,168,168,168,168,168,168,252,252,252,40,24,40,248,248,248,252,252,252,232,232,232,56,56,56,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,168,168,152,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,232,232,200,136,136,120,136,136,120,252,252,252,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,152,152,136,120,120,104,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,56,56,56,104,104,104,104,104,104,120,120,104,240,196,188,72,56,72,0,0,0,0,0,0,24,8,24,240,196,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,8,24,240,196,188,240,196,188,8,136,56,12,88,116,120,120,120,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,232,232,232,236,236,236,248,248,248,236,236,236,152,152,136,232,232,216,244,240,220,244,240,220,232,232,200,152,152,136,152,152,136,136,136,120,200,40,40,200,40,40,248,216,200,252,252,252,252,252,252,252,252,252,252,252,252,228,144,100,200,40,40,200,40,40,200,40,40,200,40,40,252,252,252,252,252,252,252,252,252,232,196,168,200,40,40,200,40,40,252,252,252,200,40,40,156,136,136,120,120,104,120,120,104,200,200,184,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,
244,240,220,244,240,220,184,184,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,104,200,200,184,244,240,220,244,240,220,184,184,168,120,120,104,252,252,252,252,252,252,208,212,220,40,24,40,88,88,88,136,136,136,252,252,252,88,88,88,0,0,0,220,220,220,252,252,252,0,0,0,252,252,252,232,232,232,184,184,184,252,252,252,184,184,184,136,136,120,232,232,216,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,168,168,152,120,120,104,120,120,104,120,120,120,120,120,120,120,120,120,120,120,120,152,152,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,208,212,220,104,104,104,200,216,200,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,56,56,56,164,184,168,104,104,104,104,104,104,168,168,152,240,196,188,0,0,0,108,88,84,240,196,188,240,196,188,0,0,0,0,0,0,
240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,240,196,188,140,120,116,240,196,188,232,200,184,12,88,116,12,88,116,132,136,152,216,232,248,216,232,248,216,232,248,216,232,248,216,232,248,236,236,236,252,252,252,232,232,232,252,252,252,152,152,136,244,240,220,232,216,200,244,240,220,244,240,220,232,216,200,244,240,220,216,216,200,232,216,184,188,40,24,200,40,40,248,200,168,220,220,220,208,136,104,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,252,252,252,248,248,232,252,252,252,252,252,252,232,196,168,248,248,248,252,252,252,252,252,252,196,60,40,136,136,120,120,120,104,120,120,104,216,200,184,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,252,252,252,252,252,252,252,252,252,252,252,252,236,236,236,120,120,104,232,232,200,244,240,220,244,240,220,244,240,220,244,240,220,216,200,184,120,120,104,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,136,136,136,168,168,168,252,252,252,24,24,24,0,0,0,252,252,252,252,252,252,88,88,88,252,252,252,252,252,252,252,252,252,236,236,236,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,120,120,104,
120,120,104,120,120,104,120,120,104,200,200,200,120,120,120,232,232,232,252,252,252,252,252,252,236,236,236,120,120,120,120,120,120,120,120,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,104,104,104,168,168,152,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,56,56,56,184,200,168,164,184,168,104,104,104,104,104,104,216,200,184,240,196,188,240,196,188,240,196,188,216,168,168,0,0,0,0,0,0,240,196,188,232,176,184,108,88,84,240,196,188,240,196,188,240,196,188,240,196,188,24,8,24,0,0,0,156,136,136,240,196,188,204,184,176,12,88,116,68,88,88,144,168,168,216,232,248,216,232,248,216,232,248,216,232,248,248,248,248,248,248,248,0,0,0,168,168,168,216,216,200,244,240,220,0,0,0,244,240,220,244,240,220,0,0,0,232,216,200,244,240,220,0,0,0,136,136,120,200,40,40,8,8,8,28,8,8,100,24,16,200,40,40,200,40,40,200,40,40,
200,40,40,200,40,40,200,40,40,252,252,252,228,176,140,200,40,40,252,252,252,252,252,252,252,252,252,252,252,252,232,196,168,200,40,40,200,40,40,140,120,116,120,120,104,120,120,104,216,216,200,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,252,252,252,252,252,252,216,216,200,120,120,104,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,232,232,200,120,120,104,236,236,236,252,252,252,252,252,252,200,200,200,104,104,104,252,252,252,252,252,252,40,40,40,236,236,236,252,252,252,24,24,24,252,252,252,252,252,252,136,136,136,24,24,24,252,252,252,252,252,252,120,120,120,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,120,120,120,200,200,200,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,136,136,120,120,104,120,120,104,220,220,220,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,136,136,120,120,120,104,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,
212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,56,56,56,184,200,168,212,228,204,120,120,120,104,104,104,104,104,104,240,196,188,240,196,188,240,196,188,124,104,104,0,0,0,56,56,56,240,196,188,240,196,188,188,152,132,124,104,104,240,196,188,232,200,184,0,0,0,0,0,0,0,0,0,140,120,116,240,196,188,240,196,188,152,184,132,12,88,116,100,104,120,176,196,208,216,232,248,216,232,248,216,232,248,252,252,252,152,152,152,88,88,88,0,0,0,248,248,232,244,240,220,0,0,0,244,240,220,244,240,220,0,0,0,232,216,200,168,168,152,24,24,24,244,240,220,248,232,200,0,0,0,188,40,24,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,200,40,40,228,144,100,252,252,252,216,120,72,200,40,40,248,216,200,252,252,252,252,252,252,248,248,248,200,40,40,200,40,40,200,40,40,200,40,40,140,120,116,120,120,104,120,120,104,216,216,200,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,232,236,220,168,168,168,120,120,120,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,244,240,220,120,120,104,216,216,200,252,252,252,
252,252,252,252,252,252,252,252,252,88,88,88,208,212,220,252,252,252,24,24,24,252,252,252,208,212,220,0,0,0,152,152,152,200,200,200,252,252,252,252,252,252,236,236,236,120,120,120,248,248,248,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,152,152,152,168,168,168,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,200,120,120,104,120,120,104,168,168,152,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,200,200,184,104,104,104,200,216,200,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,212,228,204,56,56,56,184,200,168,212,228,204,212,228,204,104,104,104,104,104,104,104,104,104,240,196,188,240,196,188,0,0,0,0,0,0,172,152,148,240,196,188,240,196,188,240,196,188,216,168,168,216,168,168,0,0,0,0,0,0,0,0,0,200,152,152,240,196,188,240,196,188,240,196,188,240,196,188,84,108,108,12,88,116,120,120,120,208,212,232,216,232,248,216,232,248};


void RenderBitmapData()
{
	int x;

	// render to full screen window 0-159, 0-127
	Write_Command(MX1_ADDR, 0x00);
	Write_Command(MX2_ADDR, 0x9f);

	Write_Command(MY1_ADDR, 0x00);
	Write_Command(MY2_ADDR, 0x7f);

	Write_Command(MEMORY_ACCESS_POINTER_X, 0x00);
	Write_Command(MEMORY_ACCESS_POINTER_Y, 0x7f);

	Write_Register(DDRAM_DATA_ACCESS_PORT);
	
	PORTSetBits(IOPORT_G, RS );
	while (TxBufFullSPI2());
	for (x = 0; x < IMAGE_SIZE; x++)
	{
		Write_Parameter(mapdata[x]);
	}
}



/*********************************************************************
 * Function:        int main(void)
 *
 * PreCondition:    None
 *
 * Input:			None
 *
 * Output:          None ( returns 1 )
 *
 * Side Effects:    None
 *
 * Overview:		Controls the SEPS525 LCD
 *
 * Note:            None.
 ********************************************************************/
int	main(void)
{
	// Configure the device for maximum performance.
	// This macro sets flash wait states, PBCLK divider and DRM wait states based on the specified
	// clock frequency. It also turns on the cache mode if avaialble.
	// Based on the current frequency, the PBCLK divider will be set at 1:2. This knoweldge
	// is required to correctly set UART baud rate, timer reload value and other time sensitive
	// setting.
	SYSTEMConfigPerformance(72000000L);
	
	// Turn on the interrupts
	INTEnableSystemMultiVectoredInt();
	MSTimerInit(36000000);	
	
	// Configure the control bits 
	mPORTGDirection(~(BIT_13 | BIT_14 | BIT_15));
	mPORTDDirection(BIT_6);
	PORTClearBits(IOPORT_G, BIT_13 | BIT_14 | BIT_15 );
	
	// Enable the SPI bus, channel #2
	SpiInitDevice(2, 1);
	
	// Initial power-up init of LCD
	Seps525_Initialise();
	
	// Seps525_CLS(0,50,0);
	RenderBitmapData();
	
	// Enter an infinite loop; there is nothing else to do
	do {
		
	} while (1);


	return 1;
}



void Seps525_Initialise(void)
{
	// Reset the chip
	PORTSetBits(IOPORT_G, nCS );
	PORTClearBits(IOPORT_G, nRESETB );
	delay_ms(200);
	PORTSetBits(IOPORT_G, nRESETB );
	
	delay_ms(200);	
	
	// the recommended initial code from App Notes
	Write_Command(REDUCE_CURRENT, 0x03);
	delay_ms(2);
	Write_Command(REDUCE_CURRENT, 0x00);
	delay_ms(2);
	
	Write_Command(SCREEN_SAVER_CONTROL, 0x0);

	Write_Command(OSC_CTL, 0x41);
	Write_Command(CLOCK_DIV, 0x30);

	Write_Command(PRECHARGE_TIME_R, 0x01); 
	Write_Command(PRECHARGE_TIME_G, 0x01); 
	Write_Command(PRECHARGE_TIME_B, 0x01); 

	Write_Command(PRECHARGE_CURRENT_R, 0x0a);
	Write_Command(PRECHARGE_CURRENT_G, 0x0a);
	Write_Command(PRECHARGE_CURRENT_B, 0x0a);

	Write_Command(DRIVING_CURRENT_R, 0x46); 
	Write_Command(DRIVING_CURRENT_G, 0x38); 
	Write_Command(DRIVING_CURRENT_B, 0x3a); 
	Write_Command(DISPLAY_MODE_SET, 0x00);
	Write_Command(RGB_IF, 0x31);

	// Triple transfer, 8bit per, TRI=1. inc horiz, dec vert
	Write_Command(MEMORY_WRITE_MODE,0x74);

	Write_Command(MX1_ADDR, 0x00);
	Write_Command(MX2_ADDR, 0x9f);
	Write_Command(MY1_ADDR, 0x00);
	Write_Command(MY2_ADDR, 0x7f);
	Write_Command(MEMORY_ACCESS_POINTER_X, 0x00);
	Write_Command(MEMORY_ACCESS_POINTER_Y, 0x00);
	Write_Command(DUTY, 0x7f);
	Write_Command(DSL, 0x00);
	Write_Command(D1_DDRAM_FAC, 0x00);
	Write_Command(D1_DDRAM_FAR, 0x00);
	Write_Command(D2_DDRAM_SAC, 0x00);
	Write_Command(D2_DDRAM_SAR, 0x00);

	Write_Command(SCR1_FX1, 0x00);
	Write_Command(SCR1_FX2, 0x9f);
	Write_Command(SCR1_FY1, 0x00);
	Write_Command(SCR1_FY2, 0x7f);

	Write_Command(DISP_ON_OFF, 0x01);}


/*********************************************************************
 * Function:        void delay_ms( unsigned int ticks )
 *
 * PreCondition:    None
 *
 * Input:           ticks - number of milliseconds to delay for.
 *
 * Output:          void
 *
 * Side Effects:    None
 *
 * Overview:		delays for the specified millseconds
 *
 ********************************************************************/
void delay_ms( unsigned int ticks )
{
	MSTimerWait( ticks );
}


/*********************************************************************
 * Function:        void Write_Command( unsigned int addr, unsigned int val )
 *
 * PreCondition:    None
 *
 * Input:           addr - command address. val - value to write
 *
 * Output:          void
 *
 * Side Effects:    None
 *
 * Overview:		
 *
 ********************************************************************/
void Write_Command( unsigned int addr, unsigned int val )
{
	PORTClearBits(IOPORT_G, nCS );
	PORTClearBits(IOPORT_G, RS );
	while (TxBufFullSPI2());
	WriteSPI2(addr);
	delay_ms(1);  // small delay to allow command to be accepted
	PORTSetBits(IOPORT_G, nCS );	
	
	PORTSetBits(IOPORT_G, RS );
	PORTClearBits(IOPORT_G, nCS );
	while (TxBufFullSPI2());
	WriteSPI2(val);
	delay_ms(1); // small delay to allow command to be accepted
	PORTSetBits(IOPORT_G, nCS );	
}

/*********************************************************************
 * Function:        void Write_Register( unsigned int addr)
 *
 * PreCondition:    None
 *
 * Input:           addr - register address.
 *
 * Output:          void
 *
 * Side Effects:    None
 *
 * Overview:		
 *
 ********************************************************************/
void Write_Register( unsigned int addr )
{
	PORTClearBits(IOPORT_G, nCS );
	PORTClearBits(IOPORT_G, RS );
	while (TxBufFullSPI2());
	WriteSPI2(addr);
	delay_ms(1);  // small delay to allow command to be accepted
	PORTSetBits(IOPORT_G, nCS );	
}

/*********************************************************************
 * Function:        void Write_Parameter( unsigned int val)
 *
 * PreCondition:    None
 *
 * Input:           val - data byte to write.
 *
 * Output:          void
 *
 * Side Effects:    None
 *
 * Overview:		
 *
 ********************************************************************/
void Write_Parameter( unsigned int val )
{
	PORTClearBits(IOPORT_G, nCS );
	while (TxBufFullSPI2());
	WriteSPI2(val);
	while (!SpiChnTxBuffEmpty(2));
	PORTSetBits(IOPORT_G, nCS );	
}

/*********************************************************************
 * Function:        void	SpiInitDevice(int chn, int isMaster, int frmEn, int frmMaster)
 *
 * PreCondition:    None
 *
 * Input:           chn			- the SPI channel to use, 1 or 2
 * 					isMaster	-	1: the device is to act as a bus master
 * 									0: the device is an SPI slave
 * 					frmEn		-	1: frame mode is enabled
 * 								-	0: frame mode is disabled
 * 					frmMaster	-	0: if frame mode is enabled, the device is a frame slave (FRMSYNC is input)
 * 									1: if frame mode is enabled, the device is a frame master (FRMSYNC is output)
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Inits the SPI channel 1 to use 16 bit words
 * 					Performs the device initialization in both master/slave modes.
 *
 * Note:            None
 ********************************************************************/
void SpiInitDevice(int chn, int isMaster)
{
	OpenSPI2( ENABLE_SDO_PIN | SPI_MODE8_ON |  SPI_CKE_OFF | CLK_POL_ACTIVE_LOW | MASTER_ENABLE_ON | SEC_PRESCAL_1_1 | PRI_PRESCAL_1_1, SPI_ENABLE );
}


/*********************************************************************
 * Function:        void Seps525_CLS(unsigned char R, unsigned char G, unsigned B)
 *
 * PreCondition:    None
 *
 * Input:           RGB - colour to erase the screen to
 *
 * Output:          void
 *
 * Side Effects:    None
 *
 * Overview:		
 *
 ********************************************************************/
void 	Seps525_CLS(unsigned char R, unsigned char G, unsigned B)
{
	
	register unsigned int x, y,z;

	// render to full screen window 0-159, 0-127
	Write_Command(MX1_ADDR, 0x00);
	Write_Command(MX2_ADDR, 0x9f);

	Write_Command(MY1_ADDR, 0x00);
	Write_Command(MY2_ADDR, 0x7f);

	Write_Command(MEMORY_ACCESS_POINTER_X, 0x00);
	Write_Command(MEMORY_ACCESS_POINTER_Y, 0x7f);

	Write_Register(DDRAM_DATA_ACCESS_PORT);
	
	PORTSetBits(IOPORT_G, RS );
	for (z=0; z<100; z++)
	{
		while (TxBufFullSPI2());
	
		for (y = 0; y < SCREEN_HEIGHT; y++)
		{
			for (x = 0; x < SCREEN_WIDTH; x++)
			{
				Write_Parameter(R);
				Write_Parameter(G);
				Write_Parameter(B);
			}
		}
	
		for (y = 0; y < SCREEN_HEIGHT; y++)
		{
			for (x = 0; x < SCREEN_WIDTH; x++)
			{
				Write_Parameter(R+ 100);
				Write_Parameter(G);
				Write_Parameter(B+100);
			}
		}
	}
} 
