; SPEECHPLAY112.ASM 17APR07

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

    include p16f628.inc

    __config  $3F22 ;  20MHz

    List P = PIC16F628, r=dec

    include "equates.inc"

        CBLOCK

STORE
STORE1
CLKCNT
LOOP
PHONEME
WORDLOOP
STORE2
MAXMSB
MAXLSB
MSGLENGTH
FREQVAL
AMPVAL
STORE3
STORE4

	ENDC

PROMVAL .EQU $70    ; in both pages
  
        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto STARTIT

CORRECTIT: movf PHONEME,W
        andlw %00000111
        addwf PCL,F
        return              ; 0 not used
        goto DOWNFREQ       ; 1 (129)  lower freq
        goto UPFREQ         ; 2 (130)  higher freq
        goto NORMALFREQ     ; 3 (131)  back to normal freq
        goto LOWERAMPPATH   ; 4 (132)  lower amplitude
        goto HIGHERAMPPATH  ; 5 (133)  higher amplitude
        goto NORMALAMP      ; 6 (134)  back to normal amplitude
        return              ; 7 not used
        
; PHONEME ADDRESSES

        include "AuthorPhonemeAddresses.inc"
;        include "UserPhonemeAddresses.inc"

DOWNFREQ:   movlw 255       ; 1
            movwf FREQVAL
            return
UPFREQ:     movlw 1         ; 2
            movwf FREQVAL
            return
NORMALFREQ: movlw 64        ; 3
            movwf FREQVAL

LOWERAMPPATH: movlw 1       ; 4
            movwf AMPVAL
            return
HIGHERAMPPATH: movlw 2      ; 5
            movwf AMPVAL
            return
NORMALAMP:  clrf AMPVAL     ; 6
            return

;****************

STARTIT: clrf PORTA
        clrf PORTB
        movlw $07
        movwf CMCON

	BANK1
        clrf TRISB
        movlw %00010000       ; RA4 as input
        movwf TRISA

        movlw B'00000111'     ; set timer ratio 1:256, pull-ups on
        movwf OPTION_REG
        BANK0

        clrf INTCON
        call PAUSIT
        clrf INTCON
        call PAUSIT
        clrf STORE
        clrf STATUS                ; Select bank 0
        clrf INTCON                ; No interrupts
        clrf PCLATH                ; Code is in first bank
        clrf AMPVAL
        movlw 32
        movwf FREQVAL

;*****************************************************************************

START2: clrf LOOP
        movlw 0
        call PRMGET

        movwf MSGLENGTH
        incf LOOP,F
        movlw 1
        movwf WORDLOOP

STARTLOOP:
        movf WORDLOOP,W   ; up to & incl 1st 24 chars at present possible
        call PRMGET
        movwf PHONEME
        
        btfss PHONEME,7    ; is bit 7 high?
        goto SL0C          ; no
        call CORRECTIT     ; yes
        goto ENDWAV2

SL0C:   movf PHONEME,W
        xorlw 1               ; space PA2
        btfss STATUS,Z
        goto SL1
        call PA2
        goto ENDWAV2

SL1:    decf PHONEME,W
        call PHONEMEADDRHI
        movwf eepAddH        ; eeprom start address hi

        decf PHONEME,W
        call PHONEMEADDRLO
        movwf   eepAddL      ; eeprom start address lo

        movf PHONEME,W
        call PHONEMEADDRHI   ; end address hi
        movwf MAXMSB

        movf PHONEME,W
        call PHONEMEADDRLO   ; end address lo
        movwf MAXLSB

        call eepReadFirst    ; set eeprom for continuous read

getnext: call  eepReadNext   ; get data - continuous for loop length
        movf eepdata,W

        bcf STATUS,C    ; no
        rrf eepdata,W   ; divide amplitude by 2 to get normal volume
        movwf STORE4

        movf AMPVAL,W
        btfsc STATUS,Z  ; is AMPVAL=0 (normal amp)
        goto GN2        ; yes

        btfsc AMPVAL,0  ; is AMPVAL=1 (lower amp)
        goto GN3        ; yes

        movf eepdata,W  ; so AMPVAL=2 (higher amp)
        movwf STORE4
        goto GN2

GN3:    bcf STATUS,C    ; AMPVAL=1 (lower amp)
        rrf STORE4,F    ; divide amplitude again

GN2:    movf STORE4,W
        movwf PORTB     ; put val out to DAC
        call Delayx     ; delay, related to FREQVAL

CAPDELAY: btfsc PORTA,4   ; is external timer now low?  pot controlled delay
        goto CAPDELAY
        bsf PORTA,3
CAPDELAY2: btfss PORTA,4  ; wait external timer
        goto CAPDELAY2
        bcf PORTA,3       ; reset external timer

J6:     incfsz eepAddL,F
        goto J7
        incf eepAddH,F

J7:     movf eepADDL,W       ; is address LSB now = MAXLSB?
        xorwf MAXLSB,W
        btfss STATUS,Z
        goto getnext         ; no

        movf eepADDH,W       ; yes, is address MSB now = MAXMSB?
        xorwf MAXMSB,W
        btfss STATUS,Z
        goto getnext         ; no
    
ENDWAV:  call eepReadLast    ; yes, end this loop and get next if any
ENDWAV2: incf WORDLOOP,F

        movf WORDLOOP,W      ; is WORDLOOP now = max number of chars?
        xorwf MSGLENGTH,W
        btfss STATUS,Z
        goto STARTLOOP       ; no

        call PAUSIT          ; yes, so redo it all again from the start
        call PAUSIT          ; pauses
        call PAUSIT
;        goto START2          ; go to start of it all

        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT          ; pauses
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT          ; pauses
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT

        goto  START2         ; go to start of it all

;*****************************************************************************        

;   Function : uiWait10ms for use with MH's Serial read
;              delays for a multiple of 10ms

uiWait10ms
    movwf   delay3
    
d1ms001
    movlw   D'100'
    call    uiWait100us
    decfsz  delay3, F
    goto    d1ms001
    return

;*****************************************************************************        

;   Function : uiWait100us for use with MH's Serial read
;              delays for a multiple of 100us

uiWait100us
    movwf   delay2

d1us002
    movlw   D'165'                    
    movwf   delay1                   
    
d1us001    
    decfsz  delay1, F               
    goto    d1us001                    
    decfsz  delay2, F
    goto    d1us002
    return                         
    
;*****************************************************************************        

PAUSIT: movlw 20        ; 1/5th sec wait set at 20MHz
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:  btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ;according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
	
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL, which is located in both pages at or above $70
SETPRM: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value from PROMVAL and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        BANK0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR1 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR1
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x    retlwvices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read flag
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        BANK0
        return

;********* basic timing for 4MHz, pauses repeated 5 times for 20MHz clock

PA1:	movlw 13	; 10ms pause
        call PAGENERAL
        movlw 13        ; 10ms pause
        call PAGENERAL
        movlw 13        ; 10ms pause
        call PAGENERAL
        movlw 13        ; 10ms pause
        call PAGENERAL
        movlw 13        ; 10ms pause
        goto PAGENERAL
PA2:    movlw 39        ; 30ms pause
        call PAGENERAL
        movlw 39        ; 30ms pause
        call PAGENERAL
        movlw 39        ; 30ms pause
        call PAGENERAL
        movlw 39        ; 30ms pause
        call PAGENERAL
        movlw 39        ; 30ms pause
        goto PAGENERAL
PA3:	movlw 65	; 50ms pause
        call PAGENERAL
        movlw 65        ; 50ms pause
        call PAGENERAL
        movlw 65        ; 50ms pause
        call PAGENERAL
        movlw 65        ; 50ms pause
        call PAGENERAL
        movlw 65        ; 50ms pause
        goto PAGENERAL
PA4:	movlw 130	; 100ms pause
        call PAGENERAL
        movlw 130       ; 100ms pause
        call PAGENERAL
        movlw 130       ; 100ms pause
        call PAGENERAL
        movlw 130       ; 100ms pause
        call PAGENERAL
        movlw 130       ; 100ms pause
        goto PAGENERAL
PA5:	movlw 0		; 200ms pause approx
        call PAGENERAL
        movlw 0         ; 200ms pause approx
        call PAGENERAL
        movlw 0         ; 200ms pause approx
        call PAGENERAL
        movlw 0         ; 200ms pause approx
        call PAGENERAL
        movlw 0         ; 200ms pause approx
        goto PAGENERAL

PAGENERAL: movwf STORE1
	clrf STORE
        movlw 128
        movwf PORTB     ; maintain equilibrium on DAC output

PAGENA: decfsz STORE,F
        goto PAGENA
        decfsz STORE1,F
        goto PAGENA
        retlw 0

DOWNFREQ: movlw 64
        movwf STORE3
DF2:    nop
        decfsz STORE3,F
        goto DF2
        return

DelayX: movf FREQVAL,W
        movwf STORE3
DX2:    nop
        decfsz STORE3,F
        goto DX2
        return


;*************

   include "i2c.inc"

        org H'2100'      ; data eeprom address

        include "TESTMSG10.inc

        END
