
#include <Windows.h>

#define WM_CANCHANGESELECTION	(WM_USER+1)
#define WM_PRECHANGESELECTION	(WM_USER+2)
#define WM_POSTCHANGESELECTION	(WM_USER+3)
#define WM_MAINSCROLL			(WM_USER+4)

extern HWND hLights;


DWORD LoadDwordFromRegistry(const wchar_t* name, DWORD def);
bool SaveDwordToRegistry(const wchar_t* name, DWORD value);
bool LoadStringFromRegistry(const wchar_t* name, wchar_t* to_here, DWORD size);
bool SaveStringToRegistry(const wchar_t* name, const wchar_t* string);
bool SetRegistryDialogDword(const wchar_t* dialog_name, int ID, DWORD val);

void OpenCascadeDialog(HWND hWnd, HINSTANCE hInst, HWND* phDialog);
void DoCascade(HWND hWnd, HINSTANCE hInst);

void OpenCustomRampDialog(HWND hWnd, HINSTANCE hInst, HWND* phDialog);
void DoCustomRamp(HWND hWnd, HINSTANCE hInst);

void OpenSettingsDialog(HWND hWnd, HINSTANCE hInst, HWND* phDialog);
void LoadSettings(HWND hWnd, HINSTANCE hInst);

void OpenPublishWaitDialog(HWND hWnd, HINSTANCE hInst);

void OpenBeatDetectionDialog(HWND hWnd, HINSTANCE hInst, HWND* phDialog);
void DoBeatDetection(HWND hWnd, HINSTANCE hInst);

void OpenSpectrumAnalysisDialog(HWND hWnd, HINSTANCE hInst, HWND* phDialog);
void DoSpectrumAnalysis(HWND hWnd, HINSTANCE hInst);

void OpenAutomaticSequencingDialog(HWND hWnd, HINSTANCE hInst, HWND* phDialog);

bool NewSequenceDialog(HWND hWnd, HINSTANCE hInst, int* pLengthToHere);
bool ChangeLengthDialog(HWND hWnd, HINSTANCE hInst, int* pLengthHere);

inline bool CanChangeSelection(HWND hWnd) {
	int ret = 0;
	SendMessage(hWnd, WM_CANCHANGESELECTION, 0, (LPARAM)&ret);
	return ret != 0;
}
inline bool PreChangeSelection(HWND hWnd) {
	int ret = 0;
	SendMessage(hWnd, WM_PRECHANGESELECTION, 0, (LPARAM)&ret);
	return ret != 0;
}
