/**
  Generated Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using PIC24 / dsPIC33 / PIC32MM MCUs

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  PIC24 / dsPIC33 / PIC32MM MCUs - pic24-dspic-pic32mm : 1.55
        Device            :  PIC24FV16KM202
    The generated drivers are tested against the following:
        Compiler          :  XC16 v1.34
        MPLAB             :  MPLAB X v4.15
*/

/*
    (c) 2016 Microchip Technology Inc. and its subsidiaries. You may use this
    software and any derivatives exclusively with Microchip products.

    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
    WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
    PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION
    WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION.

    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
    BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
    FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
    ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
    THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.

    MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE
    TERMS.
*/

#include "mcc_generated_files/mcc.h"
#include "PIC24F-Graphic-ILI9341.h"
#include "PIC24F-DigitalPot.h"

#define FCY 16000000UL       // instruction cycle Hrtz
#include <libpic30.h>
#include <stdio.h>
#include <stdlib.h>

uint16_t adc_val = 0;
float voltage_val_in = 0;
uint16_t actual_voltage = 0;
unsigned char sbuf[40];
//float some_val = 3.014;
//uint16_t some_val = 0;
float input_voltage = 3.300;
uint16_t bit_resolution = 4095;
uint16_t data = 0;
uint16_t LCD_width = ILI9341_TFTWIDTH;
uint16_t LCD_height = ILI9341_TFTHEIGHT;
uint8_t font_height = 0;
uint8_t test_val = 0;
uint16_t current_res_val = 0;
float vout = 0;
uint32_t meas_vout = 0;
float res1 = 1000000;
uint16_t res2 = 0;
float res_ratio = 0;

/*
                         Main application
 *  WARNING: Make sure this device is powered from 3.3V or damage can be done to display
 */
int main(void)
{
    // initialize the device
    SYSTEM_Initialize();

    DISP_CSN_SetHigh();
    DISP_D_C_SetLow();         // When High, data is selected, when low, command is selected
    DIG_POT_CSN_SetHigh();   
    
    LCDILI9341Init();
    LCD_Clear(BLACK);
       
    POINT_COLOR = RED;
    LCD_DrawRectangle(1,1,239,319);   // Replaces 4 lines below
    
    POINT_COLOR = YELLOW;
    LCD_ShowString(140,50,"Voltage read on input: ",font_height);
//    LCD_ShowString(120,100,"0.000 V ",font_height);
    
    digPotInit();
    
    ADC1_Start();
    adc_val = ADC1_ConversionResultGet();
    ADC1_Stop();
    
    while (1) {
        
        switch(test_val){
            case 0:
                current_res_val = TEN_K;
                test_val++;
                break;
            case 1:
                current_res_val = TWENTY_K;
                test_val++;
                break;
            case 2:
                current_res_val = THIRTY_K;
                test_val++;
                break;
            case 3:
                current_res_val = FORTY_K;
                test_val++;
                break;
            case 4:
                current_res_val = ONE_K;
                test_val = 0;
                break;
        }
        
        writePot_Value(current_res_val);
        res2 = (current_res_val * 390);
        res_ratio = res2 / (res2 + res1);
        __delay_ms(1000);
        
        // Add your application code
        ADC1_Start();

        adc_val = ADC1_ConversionResultGet();
        
        ADC1_Stop();
        
        voltage_val_in = (adc_val * input_voltage);
        voltage_val_in = (voltage_val_in / bit_resolution);
//        
//        actual_voltage = voltage_val_in * 1049;
//        actual_voltage = actual_voltage / 49;
//        some_val = (float)actual_voltage;       // Float takes 1% of the program data! every little counts
        
        // Using sprintf is a problem for our little PIC, while it solves one problem, it causes another!
        // It takes up 50% of our program memory, we can do one of two things, not use it or get a bigger processor with more memory
        
        sprintf(sbuf, "ADC Value: %u", adc_val);
//        sprintf(s_voltage, "V: %d, SV: %f, adc: %d mV", actual_voltage, some_val, adc_val);
//        LCD_ShowString(120,100,"ADC Value: ",font_height);
        LCD_ShowString(120,50,sbuf,font_height);
        
        sprintf(sbuf, "Resistor R2: %u ohms", res2);
        LCD_ShowString(100,50,sbuf,font_height);
        
        sprintf(sbuf, "Resistor R1: 1000,000 (1M)");
        LCD_ShowString(80,50,sbuf,font_height);
        
        vout = (input_voltage * res_ratio);
        sprintf(sbuf, "Expected Value: %f V", vout);
        LCD_ShowString(60,50,sbuf,font_height);
        
//        meas_vout = (voltage_val_in * (res2 + res1));
//        meas_vout = (meas_vout / res2);
        sprintf(sbuf, "Measured Value: %f V", voltage_val_in);
        LCD_ShowString(40,50,sbuf,font_height);
        
        
//        sprintf(s_voltage, "SV: %f", (double)some_val);
//        LCD_ShowString(80,100,s_voltage,font_height);
        
        __delay_ms(1000);
        __delay_ms(1000);
        
        LCD_Clear(BLACK);
        POINT_COLOR = RED;
        LCD_DrawRectangle(1,1,239,319);   // Replaces 4 lines below
        POINT_COLOR = YELLOW;
        LCD_ShowString(140,50,"Voltage read on input: ",font_height);
    }

    return -1;
}
/**
 End of File
*/