/* 
 * File:   PIC24F-DigitalPot.h
 * 
 * Author: Mike O'Keeffe
 *
 * Created on 30 July 2018, 18:58
 */

#ifndef PIC24F_DIGITALPOT_H
#define	PIC24F_DIGITALPOT_H

#ifdef	__cplusplus
extern "C" {
#endif
    
    /*
 * Step Resistance in Digital Potentiometer
 * Rs = Rab/(256) for 8 bit devices
 * Rs = Rab/(127) for 7 bit devices
 * 
 * For the MCP4151-104, Rab = 100,000 ohms
 * Rs = 100,000/256 = 390
 * 
 */
#define ONE_K 0x02              // 390 x 2 = 780 ohms
#define TEN_K 0x19              // 390 x 25 = 9750 ohms
#define TWENTY_K 0x33           // 390 x 51 = 19890 ohms
#define THIRTY_K 0x4D           // 390 x 77 = 30,030 ohms
#define FORTY_K 0x66            // 390 x 102 = 39780 ohms
#define FIFTY_K 0x80            // 390 x 128 = 49,920 ohms

void digPotInit(void);
void writePot_Value(uint8_t data);
void writePot_Data(uint8_t command, uint8_t data);

#ifdef	__cplusplus
}
#endif

#endif	/* PIC24F_DIGITALPOT_H */

