;*****************************************************************************        
;
;   Module:     delays.asm
;               
;   Author:     Mike Hibbett, mike.hibbett@gmail.com
;                                                                  
;   Version:    1.0 10/09/07                                                  
;
;            	Provides a delay routine required by the
;              	1-wire routines. These delays are 
;              	produced on the assumption that the CPU
; 				clock speed is 8MHz
;
;*****************************************************************************


#include P16F917.inc

; The following section (UDATA) is used to define the
; variables to be used by the routines within the file.
; The linker program will allocate the space; you don't
; need to worry about where they are in memory - they will
; be in BANK0 memory.

	UDATA
	

ds5usCount		RES	1	; Times outer 1m delay
	
; The following section (CODE) is used to define the 
; program routines. The linker will decide where in 
; program flash the routines will be placed; you 
; don't need to worry about that detail.

	CODE
	
	
;*****************************************************************************        
;
;   Function :  delay5us
;               This function provides a delay in multiples of
;               5us. It assumes the device is running at 8MHZ
;               
;   Input:      multiple of 5us's to delay in W
;
;   Output:     None
;
;*****************************************************************************        
delay5us
	global delay5us
	
	movwf	ds5usCount		; 1
	
	; 8MHz = 2MHz instruction cycle clock
	; == 500ns per instruction
	; Therefore for each 1us we need 2 cycles
dms000
	nop						; 1
	nop						; 1
	nop						; 1
	nop						; 1
	nop						; 1
	nop						; 1
	nop						; 1
	decfsz	ds5usCount, F	; 1
	goto	dms000			; 2

	return					; 2


	END