;**********************************************************************
;   This file is a basic code template for assembly code generation   *
;   on the PIC16F627. This file contains the basic code               *
;   building blocks to build upon.                                    *  
;                                                                     *
;   If interrupts are not used all code presented between the ORG     *
;   0x004 directive and the label main can be removed. In addition    *
;   the variable assignments for 'w_temp' and 'status_temp' can       *
;   be removed.                                                       *                         
;                                                                     *
;   Refer to the MPASM User's Guide for additional information on     *
;   features of the assembler (Document DS33014).                     *
;                                                                     *
;   Refer to the respective PIC data sheet for additional             *
;   information on the instruction set.                               *
;                                                                     *
;   Template file assembled with MPLAB V4.00.00 and MPASM V2.20.12    *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Filename:	    xxx.asm                                           *
;    Date:                                                            *
;    File Version:                                                    *
;                                                                     *
;    Author:      David Clark                                         *
;    Company:                                                         *
;                                                                      
;	MPLAB Checksum	   0x9816                                                            
;**********************************************************************
;                                                                     *
;    Files required:                                                  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     
;    Notes:  
;                                                         
;   'OK' LED on PORT B bit 5                                                                  
;   'Alarm' LED on PORT B bit 4                                          
;   Buzzer on PORT B bit 3
;	Temperature sensor on PORT A bit 3 - RA3/AN3/CMP1 - requires 100mV/degree C                                            
;   Test button on PORT B bit 0 (INT) - uses internal pull-up resistor
;	Temperature sensor test on PORT B bit 1 - RB1 
;	Op-amp and temperature sensor power control on PORT B bit 2 - RB2                                                                  
;**********************************************************************


	list      p=16f627            ; list directive to define processor
	#include <p16f627.inc>        ; processor specific variable definitions
	
	__CONFIG _CP_OFF & _WDT_ON & _BODEN_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_ON & _LVP_OFF

; '__CONFIG' directive is used to embed configuration data within .asm file.
; The labels following the directive are located in the respective .inc file.
; See respective data sheet for additional information on configuration word.


;******************************************************************

;CONFIGURATION BITS -

;Use CONFIG directive -
;config word is 11 1111 0111 1100
;corresponding to -

;programme code memory protection OFF
;data memory code protection OFF
;High Voltage programming mode
;Brown out detect reset enabled
;RA5 is _MCLR_
;Power-up timer enabled
;Watch Dog Timer Enabled
;internal oscillator with I/O on RA6 and RB7
;
;*****************************************************************************************


;***** VARIABLE DEFINITIONS
w_temp			EQU     0x70        ; variable used for context saving 
status_temp		EQU     0x71        ; variable used for context saving

wd_count		EQU		0x20		; watchdog time-out counter	
settle_count	EQU		0x21		;settling time delay count


;**********************************************************************
		ORG     0x000             	; processor reset vector
		goto    initialise          ; go to beginning of program


		ORG     0x004 
;		goto	intrpt            	; interrupt vector location


;MAIN PROGRAMME
;==========================

		ORG		0x005

initialise

		call	config_intrc
		call	config_io
		call	config_Vref
		call	config_comparators
		call	config_watchdog

		banksel	wd_count
		clrf	wd_count	

		clrwdt
;=====================================================
;test alarm

;turn on LEDs and buzzer
		banksel PORTB
		bsf PORTB,d'3'
		bsf PORTB,d'4'			
		bsf PORTB,d'5'

;turn on power to external components
		bsf PORTB,d'2'

;simulate failure of temperature sensor
		bsf PORTB,d'1'	;	for check 'detector passed' - short sensor o/p to 0V via R
;		bcf PORTB,d'1'	;	for check 'detector failed' - pre-implementation only
;						;	need 'no alarm' state - use 15.7 degC (or less) base reference 

;		delay to allow for stabilisation - 30us minimum

		call settle_dly

		sleep
		sleep
		sleep
		sleep

;----------------------------
;pre-test imlememtation check
;		nop;goto main_loop
;------------------------------

;		test for OK/ALARM and go to appropriate section -
;		OK = test failed - should be an alarm
;		ALARM = detector working - continue to main loop
	
;		switch Vref on
		banksel	VRCON
		bsf	VRCON,d'7'

;		delay to allow for stabilisation - 30us minimum

		call settle_dly

		banksel CMCON
		btfsc	CMCON,d'6'
		goto	detector_failed
		goto	detector_passed

;=============================================
detector_failed
		goto	detector_failed	; halt programme
;=============================================
detector_passed
;		remove simulation of failed temperature sensor
		banksel PORTB
		bcf PORTB,d'1'

;		delay to allow for stabilisation - 30us minimum
		call settle_dly

;end_of_test
;=========================================================

main_loop
		clrwdt

;================================

;		ensure LEDs OFF, buzzer OFF, power to temperature sensor and op-amp ON

		banksel PORTB
		bcf PORTB,d'3'
		bcf PORTB,d'4'			
		bcf PORTB,d'5'
		bsf PORTB,d'2'

;		switch/ensure Vref on
		banksel	VRCON
		bsf	VRCON,d'7'

		call settle_dly

;=========================
;		test for OK/ALARM and go to appropriate section
	
		banksel CMCON
		btfsc	CMCON,d'6'
		goto	pre_call_temp_OK
		goto	pre_call_temp_alarm

;=================================================
pre_call_temp_OK
;		switch off Vref to reduce power
		banksel	VRCON
		bcf	VRCON,d'7'

;		switch off supply to external components to reduce power
		banksel PORTB
		bcf PORTB,d'2'

		call	temp_OK
		goto 	main_loop

;=======================================================
pre_call_temp_alarm
;		switch off Vref to reduce power
		banksel	VRCON
		bcf	VRCON,d'7'

;		switch off supply to external components to reduce power
		banksel PORTB
		bcf PORTB,d'2'

		call	temp_alarm
		goto	main_loop

;=================================

;END OF MAIN PROGRAMME
;===================================================

;INTERRUPT SERVICE ROUTINE
;==================================

;ISR_VECTOR		CODE	0x200	;Interrupt Service Routine

;intrpt
;		movwf   w_temp            ; save off current W register contents
;		movf	STATUS,w          ; move status register into W register
;		movwf	status_temp       ; save off contents of STATUS register
;
; isr code can go here or be located as a call subroutine elsewhere
;
;		movf    status_temp,w     ; retrieve copy of STATUS register
;		movwf	STATUS            ; restore pre-isr STATUS register contents
;		swapf   w_temp,f
;		swapf   w_temp,w          ; restore pre-isr W register contents
;
;		retfie                    ; return from interrupt

;END OF INTERRUPT SERVICE ROUTINE
;==================================

;PROGRAM CALLS SUB-ROUTINES
;==============================

;PROGRAM_CALLS_VECTOR		CODE 0x200	;

;***************************************************
settle_dly
		movlw d'50'		
		banksel	settle_count
		movwf	settle_count

settle_dly_loop
		nop		;1us for 4MHz crystal
		decfsz	settle_count
		goto	settle_dly_loop

		return
;end of settle_dly
;******************************************************

;*******************************************************
temp_OK
;		set 'OK' LED ON
		banksel PORTB
		bsf PORTB,d'5'

		sleep		;for 0.5 seconds approx
;		(nb I/O states remain as set when SLEEP state entered)

;============================
;		set 'OK' LED OFF
		banksel PORTB
		bcf PORTB,d'5'

;============================
;		Set lower temperature hysteresis point
;		High range Vref = [1/4 * Vdd + ((bits 3:0 / 32) * Vdd)]; 1 bit = 1.6 degC

		banksel	VRCON
		bcf VRCON,d'0'	;set Vref to V (= 18.9 degC) for hysteresis; 1.6 degC BELOW 'temp OK'

;		Vref settling time - 10us maximum
		call settle_dly

;=========================
;		1 minute delay
		movlw d'120'		;number of sleep cycles for delay of 1 minute
;		movlw d'10'		;number of sleep cycles for delay of 5 seconds for test purposes
		banksel	wd_count
		movwf	wd_count

;=================================================================
dly_loop_1min

;		(nb I/O states remain as set when SLEEP state entered)
		sleep		;for 0.5 seconds approx
		banksel	wd_count
		decfsz	wd_count
		goto	dly_loop_1min

;==========================================================

		return		;goto main_loop

;end of temp_OK
;*************************************************************

;***************************************************************
temp_alarm
;		set 'ALARM' LED and buzzer ON
		banksel PORTB
		bsf PORTB,d'4'
		bsf PORTB,d'3'	

		sleep		;for 0.5 seconds approx

;==========================
;		set 'ALARM' LED and buzzer OFF
		banksel PORTB
		bcf PORTB,d'4'
		bcf PORTB,d'3'	

		sleep		;for 0.5 seconds approx
;		(nb I/O states remain as set when SLEEP state entered)

;============================
;		Set upper temperature hysteresis point
;		High range Vref = [1/4 * Vdd + ((bits 3:0 / 32) * Vdd)]; 1 bit = 1.6 degC
		
		banksel	VRCON
		bsf VRCON,d'0'	;set Vref to V (= 20.5 degC) for hysteresis; 1.6 degC ABOVE 'temp alarm'

;		Vref settling time - 10us maximum
		call settle_dly

		return		;goto main_loop

;end of temp_alarm
;***********************************************************************

;END OF PROGRAM CALLS SUB-ROUTINES
;=================================

;CONFIGURE SUB-ROUTINES
;======================

;CONFIG_SUBS_VECTOR		CODE 0x300	;Configuration Sub-routines


;CONFIGURE I/O
;=======================================
;
config_io
;
;
;TRISA and TRISB are set to all inputs
;after a reset ie at power up
;
;CONFIGURE PORT A
;
;	comparator module is being used - comparator inputs must be configured as inputs
;
		movlw b'11111111';

		banksel TRISA
		movwf TRISA;
;
;+END OF PORT A CONFIGURATION
;----------------------------
;
;CONFIGURE PORT B

;green 'OK' LED on rb5
;red 'alarm' LED on rb4
;buzzer on rb3
;temperature sensor control on RB1
;power to temperature sensor and op-amp on RB2

		movlw b'00000001'

		banksel TRISB
		movwf TRISB

;		set port b pull-up resistors ON (inputs only)
		
		banksel OPTION_REG
		bcf	OPTION_REG,NOT_RBPU

;+END OF PORT B CONFIGURATION
;----------------------------

 		return

;END OF CONFIGURE I/O
;=======================================

;CONFIGURE INTERRUPTS
;========================================

;config_intrpts

;		banksel	OPTION_REG
;		bcf	OPTION_REG,INTEDG	
;
;		banksel	INTCON
;		bsf	INTCON,GIE
;		bcf	INTCON,INTE
;		bcf	INTCON,INTF
;
;		return

;END OF CONFIGURE INTERRUPTS
;========================================



;CONFIGURE MODULES
;==============================

;===============================
config_comparators

;Trisa set to all inputs on power-up

		banksel PORTA
		clrf PORTA

;Set up comparator module as
;four inputs multiplexed to two
;comparators and using Vref module
;Only using ra3 input C1(-)
;
;invert comparator outputs
;alarm if C1 out (bit 6) = 0; ie for C1 Vin+ > C1 Vin- ;C1 Vin- = RA3 (temp), C1 Vin+ = Vref

		banksel	CMCON	
		movlw b'00111010'
		movwf CMCON

		return

;=======================================
config_Vref

;enable Vref
;disconnect from ra2
;high range
;max value

;	Vref not enabled yet
;	Vref not on RA2
;	High range selected
;	High range Vref = [1/4 * Vdd + ((bits 3:0 / 32) * Vdd)]
		
;		xxxx0010 = 12.5 + 2 * 1.6 = 15.7 deg C

;		movlw b'00000010'	;set to xxxx0010 for test1 (15.7 degC base reference)
;		movlw b'00000110'	;set to xxxx0110 for test2 (22.1 degC base reference)
;		movlw b'00001000'	;set to xxxx1000 for test3 (25.6 degC base reference)
		movlw b'00000100'	;set to xxxx0100 for normal operation (18.9 degC base reference)

		banksel	VRCON
		movwf VRCON

		return

;END OF CONFIGURE MODULES
;=======================================



;CONFIGURE SPECIAL FUNCTIONS
;=======================================

;=============================
config_watchdog

		banksel	OPTION_REG
		bsf		OPTION_REG,PSA

;		prescalar 1:32 (approx 0.5 seconds)
		bsf		OPTION_REG,PS2
		bcf		OPTION_REG,PS1
		bsf		OPTION_REG,PS0

		return

;================================
config_intrc		; internal RC oscillator - choose by configuration directive

;set to 4MHz
		banksel	PCON
		bsf	PCON,OSCF

		return

;END OF CONFIGURE SPECIAL FUNCTIONS
;=======================================
;

		END                       ; directive 'end of program'

