
#include "system.h"
#include "strings.h"
//#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#define _XTAL_FREQ 48000000
#include <xc.h>

#include "app_device_cdc_basic.h"
#include "app_led_usb_status.h"

#include "usb.h"
#include "usb_device.h"
#include "usb_device_cdc.h"

#include "config.h"
#include "flash.h"

/* Commands to implement:

   help
   show [active|saved] config
   show status
   set trigger on (high|low|change)
   set trigger delay (minimum|maximum) (<time>|VR[12] <time> to <time>)
   set on time [minimum|maximum] (<time>|VR[12] <time> to <time>)
   set retrigger delay (<delay>|VR[12] <delay> to <delay>)|off)
   set led timer (<time>|VR[12] <time> to <time>)
   save
   revert
   dump [active|saved] config
   restore <string>

   Other things to do:
   * optimise
 */

config_t active_config, saved_config;
status_t status;
extern unsigned short ms_timer;

static uint8_t readBuffer[CDC_DATA_OUT_EP_SIZE];
static char cmdBuffer[255];
unsigned char cmdBufferPos;

static unsigned short ReadADC(unsigned char channel) {
    ADCON0 = (channel << 2) | 3;
    __delay_us(200);
    ADCON0bits.GO = 1;
    while( ADCON0bits.GO )
        ;
    return (((unsigned short)ADRESH)<<8) | ADRESL;
}

static void copy_config_from_flash() {
    HEFLASH_readBlock(((char*)&active_config), 0, 32);
    HEFLASH_readBlock(((char*)&active_config)+32, 1, 32);
}

static void copy_config_to_flash() {
    HEFLASH_writeBlock(0, ((char*)&active_config), 32);
    HEFLASH_writeBlock(1, ((char*)&active_config)+32, 32);
}
/*
unsigned char config_differs_from_flash(char* buf) {
    HEFLASH_readBlock(buf, 0, 32);
    return memcmp(&active_config, buf, sizeof(active_config));
}
*/
static void show_help(char** ptr) {
#if 0
    strcpy(buf, "help\r\n"
                "show [active|saved] config\r\n"
                "show status\r\n"
                "set trigger on (high|low|change)\r\n"
                "set trigger delay (minimum|maximum) (<time>|VR[12] <time> to <time>)\r\n"
                "set on time [minimum|maximum] (<time>|VR[12] <time> to <time>)\r\n"
                "set retrigger delay (<delay>|VR[12] <delay> to <delay>)|off)\r\n"
                "set leds (off|input state|output state)\r\n"
                "set led max on time (<time>|VR[12] <time> to <time>)\r\n"
                "save\r\n"
                "revert\r\n"
                "dump [active|saved] config\r\n"
                "restore <string>\r\n");
#endif
}

static void default_config(config_t* cfg) {
//  unsigned char i;
  memset(cfg, 0, sizeof(*cfg));
  cfg->input_delay_ms = 50;
  cfg->trimpots[0].controls = controls_on_time;
//  cfg->trimpots[0].law = exponential;
  cfg->trimpots[0].min = 1000;
  cfg->trimpots[0].max = 60000;
  cfg->trimpots[1].controls = controls_retrigger_time;
//  cfg->trimpots[1].law = linear;
//  cfg->trimpots[1].min = 0;
  cfg->trimpots[1].max = 1000;
//  cfg->leds_show = leds_show_output_state;
  cfg->led_on_time_ms = 0xFFFFFFFFUL;
}

#if 1
static void print_num(char** dest, unsigned long val, unsigned char min_div) {
    unsigned long dig_val = min_div;
    while( /*dig_val < 1000000000UL &&*/ dig_val < val ) {
        unsigned long temp = dig_val * 10;
        if( temp > dig_val && temp <= val )
            dig_val = temp;
        else
            break;
    }
    do {
        unsigned char dig = val / dig_val;
        *(*dest)++ = '0' + (char)dig;
//        if( dig_val == 1 )
//            break;
        val -= dig * dig_val;
        dig_val /= 10;
    } while( dig_val );
//    return dest;
}
#if 0
static void paste(char** ptr, const char* str) {
    while( **ptr )
        *(*ptr)++ = *str++;
    *(*ptr) = '\0';
//    strcpy(*ptr, str);
//    *ptr += strlen(str);
}
#endif
#if 0
static void print_s(char** dest, unsigned long s) {
    if( s < 60 ) {
        print_num(dest, s, 1);
//        FLASH_read_string(dest, STR_s);
        *(*dest)++ = 's';
        *(*dest)   = '\0';
//        paste(dest, "s");
    } else {
        unsigned long min = s / 60;
        s -= min * 60;
        if( min < 60 ) {
            print_num(dest, min, 1);
            *(*dest)++ = ':';
//            paste(dest, ":");
            print_num(dest, s, 10);
            *(*dest)   = '\0';
        } else {
            unsigned long hr = min / 60;
            min -= hr * 60;
            print_num(dest, hr, 1);
            *(*dest)++ = ':';
//            paste(dest, ":");
            print_num(dest, min, 10);
            *(*dest)++ = ':';
//            paste(dest, ":");
            print_num(dest, s, 10);
            *(*dest)   = '\0';
        }
    }
}
#endif

static void print_ms(char** dest, unsigned long ms) {
    unsigned long s = ms / 1000;
    unsigned long m = s / 60;
    unsigned long h = m / 60;
    unsigned char min = 1;
    m -= h * 60;
    s -= m * 60;
    ms -= s * 1000;
    if( h ) {
        print_num(dest, h, 1);
        *(*dest)++ = 'h';
        min = 10;
    }
    if( m ) {
        print_num(dest, m, min);
        *(*dest)++ = 'm';
        min = 10;
    }
    if( s ) {
        print_num(dest, s, min);
        *(*dest)++ = 's';
        min = 10;
    }
    if( ms ) {
        print_num(dest, ms, min > 1 ? 1000 : 1);
        *(*dest)++ = 'm';
        *(*dest)++ = 's';
    }
}
#else
static char* print_s(char* dest, unsigned long s) {
    if( s < 60 ) {
        return dest + sprintf(dest, "%uls", s);
    } else {
        unsigned long min = s / 60;
        if( min < 60 ) {
            return dest + sprintf(dest, "%ul:%02ul", min, s - min * 60);
        } else {
            unsigned long hr = min / 60;
            return dest + sprintf(dest, "%ul:%02ul:%02ul", hr, min - hr * 60, s - min * 60);
        }
    }
}
static char* print_ms(char* dest, unsigned long ms) {
    unsigned long s = ms / 1000;
    if( s > 0 && ms  - s * 1000 == 0 ) {
        return print_s(dest, s);
    } else {
        return dest + sprintf(dest, "%ulms", ms);
    }
}
#endif

static void show_trimpot_config(char** ptr, trimpot_config_t* cfg, char which) {//, unsigned char ms) {
//  if( ms )
  print_ms(ptr, cfg->min);
//  else
//    print_s(ptr, cfg->min);
  FLASH_read_string(ptr, STR__to_);
//  paste(ptr, " to ");
//  if( ms )
  print_ms(ptr, cfg->max);
//  else
//    print_s(ptr, cfg->max);
  FLASH_read_string(ptr, STR___VR);
//  paste(ptr, " (VR");
  *(*ptr)++ = which;
//  if( cfg->law == linear ) {
//    paste(ptr, ", linearly)");
//  } else {
//    paste(ptr, ", exponentially)");
//  }
  *(*ptr)++ = ')';
}

static void show_config(char** ptr, config_t* cfg) {
//  paste(ptr, "On when input ");
  FLASH_read_string(ptr, STR_On_when_input_);

  switch(cfg->input_polarity) {
  case trigger_on_high:
//    paste(ptr, "goes high");
    FLASH_read_string(ptr, STR_goes_high);
    break;
  case trigger_on_low:
//    paste(ptr, "goes low");
    FLASH_read_string(ptr, STR_goes_low);
    break;
//  case trigger_on_change:
  default:
    FLASH_read_string(ptr, STR_changes);
//    paste(ptr, "changes");
    break;
  }
  if( cfg->input_delay_ms ) {
    if( cfg->delay_type == delay_is_minimum ) {
      FLASH_read_string(ptr, STR__for_at_least_);
//      paste(ptr, " for at least ");
    } else {
      FLASH_read_string(ptr, STR__for_no_longer_than_);
//      paste(ptr, " for no longer than ");
    }
    if( cfg->trimpots[0].controls == controls_delay_time ) {
      show_trimpot_config(ptr, &cfg->trimpots[0], '1');//, 1);
    } else if( cfg->trimpots[1].controls == controls_delay_time ) {
      show_trimpot_config(ptr, &cfg->trimpots[1], '2');//, 1);
    } else {
      print_ms(ptr, cfg->input_delay_ms);
    }
  } else {
    FLASH_read_string(ptr, STR___immediately);
//    paste(ptr, ", immediately");
  }
  FLASH_read_string(ptr, STR___r_nStays_on_);
//  paste(ptr, ".\r\nStays on ");

  if( cfg->relay_on_time_ms == 0xFFFFFFFF ) {
    if( cfg->on_time_type == on_time_is_maximum ) {
      FLASH_read_string(ptr, STR_until_input_changes__r_n);
//      paste(ptr, "until input changes\r\n");
    } else {
      FLASH_read_string(ptr, STR_until_power_cycles__r_n);
//      paste(ptr, "until power cycle\r\n");
    }
  } else {
    FLASH_read_string(ptr, STR_for_);
//    paste(ptr, "for ");
    if( cfg->on_time_type == on_time_is_minimum ) {
      FLASH_read_string(ptr, STR_at_least_);
//      paste(ptr, "at least ");
    }
    if( cfg->trimpots[0].controls == controls_on_time ) {
      show_trimpot_config(ptr, &cfg->trimpots[0], '1');//, 0);
    } else if( cfg->trimpots[1].controls == controls_on_time ) {
      show_trimpot_config(ptr, &cfg->trimpots[1], '2');//, 0);
    } else {
      print_ms(ptr, cfg->relay_on_time_ms);
    }
    if( cfg->on_time_type == on_time_is_maximum ) {
      FLASH_read_string(ptr, STR__or_until_input_changes);
//      paste(ptr, " or until input changes");
//      *ptr++ = '\r';
//      *ptr++ = '\n';
    }
  }

  FLASH_read_string(ptr, STR___r_nRe_trigger_delay__);
//  paste(ptr, ".\r\nRe-trigger delay: ");
  if( cfg->trimpots[0].controls == controls_retrigger_time ) {
    show_trimpot_config(ptr, &cfg->trimpots[0], '1');//, 1);
  } else if( cfg->trimpots[1].controls == controls_retrigger_time ) {
    show_trimpot_config(ptr, &cfg->trimpots[1], '2');//, 1);
  } else {
    print_ms(ptr, cfg->retrigger_delay_ms);
  }

  FLASH_read_string(ptr, STR___r_nLED_timer_);
//  paste(ptr, ".\r\nLED timer ");
//  if( cfg->leds_show == leds_show_output_state ) {
//    paste(ptr, "output");
//  } else {
//    paste(ptr, "input");
//  }
//  paste(ptr, " state ");
  if( cfg->led_on_time_ms == 0xFFFFFFFFUL ) {
    FLASH_read_string(ptr, STR_infinite);
//    paste(ptr, "infinite");
  } else {
//    paste(ptr, "for ");
    if( cfg->trimpots[0].controls == controls_led_on_time ) {
      show_trimpot_config(ptr, &cfg->trimpots[0], '1');//, 1);
    } else if( cfg->trimpots[1].controls == controls_led_on_time ) {
      show_trimpot_config(ptr, &cfg->trimpots[0], '1');//, 1);
    } else {
      print_ms(ptr, cfg->led_on_time_ms);
    }
  }
  FLASH_read_string(ptr, STR___r_n);
//  paste(ptr, ".\r\n");
}

static void show_status(char** ptr, status_t* stat) {
  unsigned char i;

  FLASH_read_string(ptr, STR_Input__);
//  paste(ptr, "Input: ");
  if( stat->input_state ) {
    FLASH_read_string(ptr, STR_high);
//    paste(ptr, "high");
  } else {
    FLASH_read_string(ptr, STR_low);
//    paste(ptr, "low");
  }

  FLASH_read_string(ptr, STR___r_nRelay__);
//  paste(ptr, ".\r\nRelay: ");
  if( stat->state != triggered && stat->state != triggered_timeout ) {
    FLASH_read_string(ptr, STR_de_);
//    paste(ptr, "de-");
  }
  FLASH_read_string(ptr, STR_energised__r_nState__);
//  paste(ptr, "energised.\r\nState: ");
  if( stat->state == waiting ) {
    FLASH_read_string(ptr, STR_waiting);
//    paste(ptr, "waiting");
  } else if( stat->state == pre_trigger ) {
    FLASH_read_string(ptr, STR_delay_for_);
//    paste(ptr, "delay for ");
    print_ms(ptr, stat->delay_time - stat->timer);
    *(*ptr)++ = '/';
    print_ms(ptr, stat->delay_time);
  } else if( stat->state == post_trigger ) {
    FLASH_read_string(ptr, STR_post_wait_for_);
//    paste(ptr, "post-wait for ");
    print_ms(ptr, stat->retrigger_time - stat->timer);
    *(*ptr)++ = '/';
    print_ms(ptr, stat->timer);
  } else {
//    FLASH_read_string(ptr, STR_triggered__time_elapsed);
//    paste(ptr, "triggered; time elapsed");
//  } else {
    FLASH_read_string(ptr, STR_triggered_for_);
//    paste(ptr, "triggered for ");
    print_ms(ptr, stat->timer);
    *(*ptr)++ = '/';
    print_ms(ptr, stat->on_time);
  }
  FLASH_read_string(ptr, STR___r_n);
//  paste(ptr, ".\r\n");

  for( i = 0; i < 2; ++i ) {
      *(*ptr)++ = 'V';
      *(*ptr)++ = 'R';
      *(*ptr)++ = '1'+i;
      FLASH_read_string(ptr, STR__controls_);
//      paste(ptr, " controls ");
      if( active_config.trimpots[i].controls == controls_nothing ) {
          FLASH_read_string(ptr, STR_nothing);
//          paste(ptr, "nothing");
      } else {
//          unsigned char ms = 1;
//          unsigned short trim;
          unsigned long val;
          switch( active_config.trimpots[i].controls ) {
              case controls_on_time:
                  FLASH_read_string(ptr, STR_relay_on_time);
                  val = status.on_time;
//                  paste(ptr, "relay on-time");
//                  ms = 0;
                  break;
              case controls_delay_time:
                  FLASH_read_string(ptr, STR_switch_on_delay);
                  val = status.delay_time;
//                  paste(ptr, "swtich-on delay");
                  break;
              case controls_retrigger_time:
                  FLASH_read_string(ptr, STR_re_trigger_delay);
                  val = status.retrigger_time;
//                  paste(ptr, "re-trigger delay");
                  break;
              default:
                  FLASH_read_string(ptr, STR_LED_on_time);
                  val = status.led_time;
//                  paste(ptr, "LED on time");
                  break;
          }
          FLASH_read_string(ptr, STR___now_);
//          paste(ptr, " (now ");
          print_num(ptr, (stat->trimpots[0] + stat->trimpots[0] / 512) * 50 / 512, 100);
          FLASH_read_string(ptr, STR_pct_equ_);
//          paste(ptr, "% = ");
//          val = active_config.trimpots[i].min + (active_config.trimpots[i].max - active_config.trimpots[i].min) * trim / 1024;
//          if( ms )
          print_ms(ptr, val);
//          else
//              print_s(ptr, val);
          *(*ptr)++ = ')';
      }
      FLASH_read_string(ptr, STR___r_n);
//      paste(ptr, ".\r\n");
  }
//  ptr += sprintf(ptr, "VR1: %3%% [%04d], VR2: %3%% [%04d].\r\n", stat->trimpots[0] * 100 / 1023, stat->trimpots[0], stat->trimpots[1] * 100 / 1023, stat->trimpots[1]);
}

#if 0
static char get_base64_char(unsigned char val) {
  if( val < 26 )
    return 'A' + val;
  else if( val < 52 )
    return 'a' + (val - 26);
  else if( val < 62 )
    return '0' + (val - 52);
  else if( val == 62 )
    return '+';
  else
    return '/';
}

static char* print_base64(char* dest, unsigned char* src, unsigned char len) {
  while( len >= 3 ) {
      dest[0] = get_base64_char( src[0]>>2 );
      dest[1] = get_base64_char( ((src[0]&3)<<4) | (src[1]>>4) );
      dest[2] = get_base64_char( ((src[1]&15)<<2) | (src[2]>>6) );
      dest[4] = get_base64_char( src[2]&63 );
      dest += 4;
      src += 3;
      len -= 3;
  }
  dest[0] = get_base64_char( src[0]>>2 );
  dest[1] = get_base64_char( ((src[0]&3)<<4) | (src[1]>>4) );
  dest[2] = get_base64_char( ((src[1]&15)<<2) );
  dest += 3;
  return dest;
}

static unsigned char get_base64_val(char c) {
  if( c >= 'A' && c <= 'Z' )
    return c - 'A';
  else if( c >= 'a' && c <= 'z' )
    return c - 'a' + 26;
  else if( c >= '0' && c <= '9' )
    return c - '0' + 52;
  else if( c == '+' )
    return 62;
  else if( c == '/' )
    return 63;
  else
    return 255;
}

static unsigned char decode_base64(const char* from, unsigned char* to) {
  unsigned char dat[4];
  unsigned char ret = 0;
  while( *from ) {
    if( !from[1] || !from[2] || !from[3] )
        break;
    dat[0] = get_base64_val(from[0]);
    dat[1] = get_base64_val(from[1]);
    dat[2] = get_base64_val(from[2]);
    dat[3] = get_base64_val(from[3]);
    if( dat[0] == 255 || dat[1] == 255 || dat[2] == 255 || dat[3] == 255 )
      return 0;
    to[0] = (dat[0]<<2)|(dat[1]>>4);
    to[1] = (dat[1]<<4)|(dat[2]>>2);
    to[2] = (dat[2]<<6)| dat[3];
    to += 3;
    from += 4;
    ret += 3;
  }
  if( !from[0] || !from[1] || !from[2] )
      return 0;
  dat[0] = get_base64_val(from[0]);
  dat[1] = get_base64_val(from[1]);
  dat[2] = get_base64_val(from[2]);
  if( dat[0] == 255 || dat[1] == 255 || dat[2] == 255 )
    return 0;
  to[0] = (dat[0]<<2)|(dat[1]>>4);
  to[1] = (dat[1]<<4)|(dat[2]>>2);
  ret += 2;
  return ret;
}

static char* dump_config(char* buf, config_t* cfg) {
    char* ptr = print_base64(buf, (unsigned char*)cfg, sizeof(*cfg));
    paste(&ptr, "\r\n");
//    *ptr++ = '\r';
//    *ptr++ = '\n';
//    *ptr = '\0';
    return ptr;
}

static char* restore_config(char* buf, config_t* pcfg, const char* string) {
  static const unsigned char clen = sizeof(*pcfg);
  unsigned short len = strlen(string);
  if( len == (clen + 4) * 4 / 3 && decode_base64(string, buf) == clen + 4 ) {
      memcpy(&active_config, buf, sizeof(active_config));
      paste(&buf, "Configuration restored.\r\n");
  } else {
      paste(&buf, "Invalid configuration data.\r\n");
  }
  return buf;
}

static const char* tokens1[] = { "help", "show config", "show status", "save", "revert", "high", "low", "change", "set ", 0 };
typedef enum { token_help, token_show_config, token_show_status, token_save, token_revert, token_high, token_low, token_change, token_set_ } token_t;

signed char find_token(const char** tokens, const char* str) {
    signed char ret = 0, len;
    while( *tokens ) {
        len = strlen(*tokens);
        if( !strncmp(*tokens, str, len) ) {
            if( tokens[0][len-1] == ' ' || !str[len] )
                return ret;
        }
        ++tokens;
        ++ret;
    }
    return -1;
}
#endif

#if 0
static unsigned char get_s(char** ptr, unsigned long* to_here, char space) {
    // valid formats: <x>s, <x>m, <x>h, <mm>:<ss>, <hh>:<mm>:<ss>
    char* endptr = *ptr;
    unsigned long a = strtoul(endptr, &endptr, 10);
    if( endptr != *ptr ) {
        if( endptr[0] == 's' ) {
            *to_here = a;
            *ptr = endptr + 1;
            return 1;
        } else if( endptr[0] == 'm' ) {
            *to_here = a * 60;
            *ptr = endptr + 1;
            return 1;
        } else if( endptr[0] == 'h' ) {
            *to_here = a * 3600;
            *ptr = endptr + 1;
            return 1;
        } else if( endptr[0] == ':' ) {
            unsigned long b;
            ++endptr;
            b = strtoul(endptr, &endptr, 10);
            if( endptr != *ptr ) {
                a = a * 60 + b;
                if( endptr[0] == space ) {
                    *to_here = a;
                    *ptr = endptr;
                    return 1;
                } else if( endptr[0] == ':' ) {
                    b = strtoul(endptr, &endptr, 10);
                    if( endptr != *ptr && endptr[0] == space ) {
                        *to_here = a * 60 + b;
                        *ptr = endptr;
                        return 1;
                    }
                }
            }
        }
    }
    return 0;
}

static unsigned char get_ms(char** ptr, unsigned long* to_here, char space) {
    unsigned long a;
    char* endptr;
    if( get_s(ptr, to_here, space) && *to_here <= 4294967UL  ) {
        *to_here = *to_here * 1000;
        return 1;
    }
    endptr = *ptr;
    a = strtoul(endptr, &endptr, 10);
    if( endptr != *ptr && endptr[0] == 'm' && endptr[1] == 's' && endptr[2] == space ) {
        *to_here = a;
        *ptr = endptr + 2;
        return 1;
    }
    return 0;
}
#endif

static unsigned char get_ms(char** ptr, unsigned long* to_here, char space) {
    unsigned long ret = 0, val;
    unsigned long mult;
    unsigned char found = 0;
    char* endptr = 0;

    while( 1 ) {
        endptr = *ptr;
        val = strtoul(endptr, &endptr, 10);
        if( endptr != *ptr ) {
            switch( *endptr ) {
                case 's':
                    mult = 1000UL;
                    break;
                case 'm':
                    if( endptr[1] == 's' ) {
                        mult = 1UL;
                        ++endptr;
                    } else {
                        mult = 60000UL;
                    }
                    break;
                case 'h':
                    mult = 3600000UL;
                    break;
                default:
                    return 0;
            }
            found = 1;
            ret += val * mult;
            *ptr = endptr+1;
            if( **ptr == space ) {
                *to_here = ret;
                return 1;
            }
        } else {
            break;
        }
    }
    return 0;
}

static unsigned char get_trimpot_config(char** ptr, trimpot_controls_t controls) {
    unsigned char vrnum = (*ptr)[2] - '1';
    unsigned long min, max;
    *ptr += 4;
    if( get_ms(ptr, &min, ' ') && (*ptr)[0] == ' ' && (*ptr)[1] == 't' && (*ptr)[2] == 'o' && (*ptr)[3] == ' ' ) {
        ptr += 4;
        if( get_ms(ptr, &max, '\0') ) {
            active_config.trimpots[vrnum].min = min;
            active_config.trimpots[vrnum].max = max;
            active_config.trimpots[vrnum].controls = controls;
            return 1;
        }
    }
    return 0;
}

static unsigned char get_time_or_trimpot(char** ptr, unsigned long* ms_to_here, trimpot_controls_t controls) {
    if( (*ptr)[0] == 'V' && (*ptr)[1] == 'R' && ((*ptr)[2] == '1' || (*ptr)[2] == '2') && (*ptr)[3] == ' ' ) {
        return get_trimpot_config(ptr, controls);
    } else {
        return get_ms(ptr, ms_to_here, '\0');
    }
}

static void ParseCommand() {
    char* ptr = cmdBuffer;
    unsigned char i;

//    token_t tok = (token_t)find_token(tokens1, cmdBuffer);

    if( !FLASH_cmp_string(&ptr, STR_show_config) ) {
        show_config(&ptr, &active_config);
        if( memcmp(&active_config, &saved_config, sizeof(active_config)) ) {
            FLASH_read_string(&ptr, STR_You_have_unsaved_changes__r_n);
//            paste(&ptr, "You have unsaved changes.\r\n");
        }
    } else if( !FLASH_cmp_string(&ptr, STR_show_status) ) {
        show_status(&ptr, &status);
//    } else if( !strcmp(cmdBuffer, "dump config") || !strcmp(cmdBuffer, "dump active config") ) {
//        ptr = dump_config(cmdBuffer, &active_config);
//    } else if( !strcmp(cmdBuffer, "dump saved config") ) {
//        ptr = dump_config(cmdBuffer, &saved_config);
    } else if( !FLASH_cmp_string(&ptr, STR_save) ) {
        memcpy(&saved_config, &active_config, sizeof(saved_config));
        copy_config_to_flash();
        FLASH_read_string(&ptr, STR_Saved__r_n);
//        paste(&ptr, "Saved.\r\n");
    } else if( !FLASH_cmp_string(&ptr, STR_revert) ) {
        copy_config_from_flash();
        memcpy(&active_config, &saved_config, sizeof(active_config));
        FLASH_read_string(&ptr, STR_Reverted__r_n);
//        paste(&ptr, "Reverted.\r\n");
    } else if( !FLASH_cmp_string(&ptr, STR_set_) ) {
//   set on time [minimum|maximum] (<time>|VR[12] <time> to <time>)
        if( !FLASH_cmp_string(&ptr, STR_trigger_) ) {
            if( !FLASH_cmp_string(&ptr, STR_on_) ) {
                if( !FLASH_cmp_string(&ptr, STR_high) )
                    active_config.input_polarity = trigger_on_high;
                else if( !FLASH_cmp_string(&ptr, STR_low) )
                    active_config.input_polarity = trigger_on_low;
                else if( !FLASH_cmp_string(&ptr, STR_change) )
                    active_config.input_polarity = trigger_on_change;
                else
                    goto UnknownCommand;
            } else if( !FLASH_cmp_string(&ptr, STR_delay_) ) {
                delay_type_t delay_type;
                ptr += 6;
                if( !FLASH_cmp_string(&ptr, STR_minimum_) ) {
                    delay_type = delay_is_minimum;
                    ptr += 8;
                } else if( !FLASH_cmp_string(&ptr, STR_maximum_) ) {
                    delay_type = delay_is_maximum;
                    ptr += 8;
                } else {
                    goto UnknownCommand;
                }
                if( get_time_or_trimpot(&ptr, &active_config.input_delay_ms, controls_delay_time) )
                    active_config.delay_type = delay_type;
                else
                    goto UnknownCommand;
            } else {
                goto UnknownCommand;
            }
        } else if( !FLASH_cmp_string(&ptr, STR_on_time_) ) {
            on_time_type_t on_time_type = on_time_is_exact;
            ptr += 8;
            if( !FLASH_cmp_string(&ptr, STR_minimum_) ) {
                on_time_type = on_time_is_minimum;
                ptr += 8;
            } else if( !FLASH_cmp_string(&ptr, STR_maximum_) ) {
                on_time_type = on_time_is_maximum;
                ptr += 8;
            }
            if( get_time_or_trimpot(&ptr, &active_config.relay_on_time_ms, controls_on_time) )
                active_config.on_time_type = on_time_type;
            else
                goto UnknownCommand;
        } else if( !FLASH_cmp_string(&ptr, STR_retrigger_delay_) ) {
            if( ptr[0] == 'V' && ptr[1] == 'R' && (ptr[2] == '1' || ptr[2] == '2') && ptr[3] == ' ' ) {
                if( !get_trimpot_config(&ptr, controls_retrigger_time) )
                    goto UnknownCommand;
            } else {
                if( !get_ms(&ptr, &active_config.retrigger_delay_ms, '\0') )
                    goto UnknownCommand;
            }
//            if( !get_time_or_trimpot(&ptr, &active_config.retrigger_delay_ms, controls_retrigger_time) )
//                goto UnknownCommand;
        } else if( !FLASH_cmp_string(&ptr, STR_led_timer_) ) {
#if 0
            if( ptr[0] == 'V' && ptr[1] == 'R' && (ptr[2] == '1' || ptr[2] == '2') && ptr[3] == ' ' ) {
                if( !get_trimpot_config(&ptr, controls_led_on_time) )
                    goto UnknownCommand;
            } else {
                if( !get_ms(&ptr, &active_config.led_on_time_ms, '\0') )
                    goto UnknownCommand;
            }
#endif
//            if( !get_time_or_trimpot(&ptr, &active_config.led_on_time_ms, controls_led_on_time) )
//                goto UnknownCommand;
//            if( !strcmp(ptr, "off" ) )
//                active_config.leds_show = leds_off;
//            else if( !strcmp(ptr, "input state" ) )
//                active_config.leds_show = leds_show_input_state;
//            else if( !strcmp(ptr, "output state" ) )
//                active_config.leds_show = leds_show_output_state;
//            else
//                goto UnknownCommand;
        } else {
            goto UnknownCommand;
        }
    } else {
    UnknownCommand:
        FLASH_read_string(&ptr, STR__r_nUnknown_command__r_n);
//        paste(&ptr, "\r\nUnknown command.\r\n");
    }
    putUSBUSART(cmdBuffer, ptr-cmdBuffer);
}

static void on_led_on() {
    LATBbits.LATB4 = 1;
    LATBbits.LATB5 = 0;
}

static void off_led_on() {
    LATBbits.LATB4 = 0;
    LATBbits.LATB5 = 1;
}

static void both_leds_off() {
    LATBbits.LATB4 = 0;
    LATBbits.LATB5 = 0;
}

static void relay_on() {
    LATAbits.LATA4 = 1; // fix this
    if( active_config.on_time_type == on_time_is_exact )
        status.state = triggered_timeout;
    else
        status.state = triggered;
    status.timer = 0;
    if( status.led_time ) {
        status.led_timer = status.led_time;
        on_led_on();
    }
}

static void relay_off() {
    LATAbits.LATA4 = 0; // fix this
    if( status.retrigger_time ) {
        status.state = post_trigger;
        status.timer = 0;
    } else {
        status.state = waiting;
    }
    if( status.led_time ) {
        status.led_timer = status.led_time;
        off_led_on();
    }
}

static void update_trimpot_vals() {
    unsigned char i;
    unsigned long diff;

    for( i = 0; i < 2; ++i ) {
        if( active_config.trimpots[i].controls != controls_nothing ) {
            diff = active_config.trimpots[i].max - active_config.trimpots[i].min;
            diff = (unsigned long long)diff * status.trimpots[i] / 1023;
            diff += active_config.trimpots[i].min;
            switch( active_config.trimpots[i].controls ) {
                case controls_on_time:
                    status.on_time = diff;
                    break;
                case controls_delay_time:
                    status.delay_time = diff;
                    break;
                case controls_retrigger_time:
                    status.retrigger_time = diff;
                    break;
                default:
                    status.led_time = diff;
                    break;
            }
        }
    }
}

MAIN_RETURN main(void) {
    unsigned char i;
#if defined(USE_INTERNAL_OSC)
    //Make sure to turn on active clock tuning for USB full speed
    //operation from the INTOSC
    OSCCON = 0xFC;  //HFINTOSC @ 16MHz, 3X PLL, PLL enabled
    ACTCON = 0x90;  //Active clock tuning enabled for USB
#endif
    // RB6 = USB supply detection

    copy_config_from_flash();
    if( ((unsigned char*)&saved_config)[0] == 0xFF )
        default_config(&saved_config);
    memcpy(&active_config, &saved_config, sizeof(active_config));

    ADCON1 = 2|32|64|128;
    USBDeviceInit();
    USBDeviceAttach();

    while(1) {
        unsigned short local_ms_timer;

        INTCONbits.GIE = 0;
        local_ms_timer = ms_timer;
        ms_timer = 0;
        INTCONbits.GIE = 1;
        if( local_ms_timer > 0 ) {
            unsigned char last_input_state = status.input_state;

            status.input_state = PORTAbits.RA0; // fix this

            status.on_time = active_config.relay_on_time_ms;
            status.delay_time = active_config.input_delay_ms;
            status.retrigger_time = active_config.retrigger_delay_ms;
            status.led_time = active_config.led_on_time_ms;
            update_trimpot_vals();

            if( status.led_timer ) {
                if( status.led_timer <= local_ms_timer ) {
                    both_leds_off();
                    status.led_timer = 0;
                } else {
                    status.led_timer -= local_ms_timer;
                }
            }
            switch( status.state ) {
                case waiting:
                    if( (active_config.input_polarity == trigger_on_high   && status.input_state == 0) ||
                        (active_config.input_polarity == trigger_on_low    && status.input_state != 0) ||
                        (active_config.input_polarity == trigger_on_change && status.input_state != last_input_state) ) {
                        if( status.input_state == 0 ) {
                            if( status.delay_time ) {
                                status.state = pre_trigger;
                                status.timer = 0;
                            } else {
                                relay_on();
                            }
                        }
                        break;
                    }
                    break;
                case pre_trigger:
                    if( (active_config.input_polarity == trigger_on_high   && status.input_state != 0) ||
                        (active_config.input_polarity == trigger_on_low    && status.input_state == 0) ) {
                        if( active_config.delay_type == delay_is_maximum && status.timer <= status.delay_time ) {
                            relay_on();
                        } else {
                            status.state = waiting;
                        }
                    } else {
                        status.timer += local_ms_timer;
                        if( active_config.delay_type == delay_is_minimum && status.timer >= status.delay_time ) {
                            relay_on();
                        }
                    }
                    break;
                case triggered:
                    status.timer += local_ms_timer;
                    if( (active_config.input_polarity == trigger_on_high   && status.input_state != 0) ||
                        (active_config.input_polarity == trigger_on_low    && status.input_state == 0) ||
                        (active_config.input_polarity == trigger_on_change && status.input_state != last_input_state) ) {
                        if( active_config.on_time_type == on_time_is_maximum ) {
                            relay_off();
                        } else {
                            status.state = triggered_timeout;
                        }
                    }
                    break;
                case triggered_timeout:
                    status.timer += local_ms_timer;
                    if( status.timer >= status.on_time )
                        relay_off();
                    break;
                case post_trigger:
                    status.timer += local_ms_timer;
                    if( status.timer >= status.retrigger_time )
                        status.state = waiting;
                    break;
            }

            status.trimpots[0] = ReadADC(0); // fix this
            status.trimpots[1] = ReadADC(1); // fix this
        }

        if( USBGetDeviceState() >= CONFIGURED_STATE && !USBIsDeviceSuspended() ) {
            if( USBUSARTIsTxTrfReady() == true ) {
                uint8_t i, parsed;
                uint8_t numBytesRead;

                numBytesRead = getsUSBUSART(readBuffer, sizeof(readBuffer));
                parsed = 0;
                for( i = 0; i < numBytesRead; ++i ) {
                    if( cmdBufferPos == sizeof(cmdBuffer) ) {
                        memmove(cmdBuffer, cmdBuffer+1, sizeof(cmdBuffer)-1);
                        --cmdBufferPos;
                    }
                    if( readBuffer[i] == '\b' ) {
                        if( cmdBufferPos )
                            --cmdBufferPos;
                    } else if( readBuffer[i] != '\n' ) {
                        cmdBuffer[cmdBufferPos] = (char)readBuffer[i];//tolower((char)readBuffer[i]);
                        if( cmdBuffer[cmdBufferPos] == '\r' ) {
                            cmdBuffer[cmdBufferPos] = '\0';
//                                putUSBUSART(cmdBuffer,cmdBufferPos);
                            ParseCommand();
                            ++parsed;
                            cmdBufferPos = 0;
                        } else {
                            ++cmdBufferPos;
                        }
                    }
                }
                if( !parsed ) {
                    putUSBUSART(readBuffer, numBytesRead);
                }
            }
            CDCTxService();
        }
    }
}
