' *****************************************************
' **  Name:      HEATSINK.BAS     Version:  0.4      **
' **  Function:  Practical Electronics Teach-In 2019 **
' **  Language:  QB64                                **
' **  Compiler:  https://www.portal.qb64.org         **
' **  OS:        Windows 64-bit (all versions        **
' **  Important: Please see readme.txt               ** 
' *****************************************************
'
'00: Black            08: Dark Grey
'01: Dark Blue        09: Light Blue
'02: Dark Green       10: Light Green
'03: Dark Cyan        11: Light Cyan
'04: Dark Red         12: Light Red
'05: Dark Purple      13: Magenta
'06: Orange Brown     14: Yellow
'07: Grey             15: White
'
' Initialise
'
_TITLE "Heatsink"
'
ON ERROR GOTO warning

' Initialise video mode: 640 x 350 graphics
SCREEN _NEWIMAGE(640, 350, 256)

' Set window background colour
COLOR , 250: CLS

ul$ = STRING$(80, CHR$(205))
'
' Set initial default ratings
'
' The values shown below are for common TO220 style devices
' and thermally conductive insulating washers. If required
' these values can be changed from the main menu.
'
thjcdef = 3.25 'Thermal resistance junction-case
thchdef = 1.25 'Thermal resistance case-heatsink (washer)
tjmax = 150 'Maximum junction temperature
'
' Display main menu
'
DO
    main:
    CLS
    PRINT ul$
    TITLE$ = " PRACTICAL ELECTRONICS HEATSINK CALCULATOR " + "                         " + DATE$
	COLOR 15
    PRINT TITLE$
    PRINT ul$
    PRINT " "
    COLOR 11
    PRINT " Please select an option..."
    COLOR 15
    PRINT ""
	COLOR 14
    PRINT " [1] ";
	COLOR 15
	PRINT "to calculate junction temperature given heatsink parameters"
    PRINT ""
	COLOR 14
    PRINT " [2] ";
	COLOR 15
	PRINT "to calculate heatsink requirements given operating conditions"
    PRINT ""
	COLOR 14
	PRINT " [3] ";
	COLOR 15
	PRINT "to set maximum junction temperature and other parameters"
    PRINT ""
	COLOR 14
    PRINT " [4] ";
	COLOR 15
	PRINT "to quit"
	PRINT ""
	PRINT ""
	COLOR 10
	PRINT " WARNING: This is Beta software currently under development"
	PRINT " and therefore all results should be treated with caution!"
	COLOR 15
    DO
        r$ = UCASE$(INKEY$)
    LOOP UNTIL r$ <> "" AND INSTR("1234", r$)
    IF r$ = "4" THEN CLS: SCREEN 0: END
    '
    PRINT ul$
    IF r$ = "1" THEN GOSUB temp
    IF r$ = "2" THEN GOSUB heatsink
    IF r$ = "3" THEN GOSUB maxtemp
LOOP
'
temp:
CLS
PRINT ul$
PRINT " JUNCTION TEMPERATURE CALCULATION"
PRINT ul$
PRINT
COLOR 11
PRINT " Please supply parameters for the device/heatsink or press [ENTER]"
PRINT " to use the default values when * appears. The default values"
PRINT " are typical for a TO0220 device and its associated mounting kit"
PRINT " but they can be changed using option [3] from the main menu."
COLOR 15
PRINT
INPUT " Input ambient temperature             (deg.C): "; tamb
PRINT
INPUT " Input device total dissipation            (W): "; ptot
PRINT
INPUT " Thermal resistance junction-case *  (deg.C/W): "; thjc
PRINT
INPUT " Thermal resistance case-heatsink *  (deg.C/W): "; thch
PRINT
INPUT " Thermal resistance heatsink-ambient (deg.C/W): "; thha
PRINT
'
IF thjc = 0 THEN thjc = thjcdef
IF thch = 0 THEN thch = thchdef
'
thtot = thjc + thch + thha
tjunc = tamb + (thtot * ptot)
'
CLS
PRINT ul$
PRINT " RESULTS"
PRINT ul$
PRINT
PRINT " Ambient temperature       : "; tamb; "deg.C"
PRINT
PRINT " Total power dissipation   : "; ptot; "W"
PRINT
PRINT " Total thermal resistance  : "; thtot; "deg.C/W"
PRINT
PRINT " Junction temperature      : "; tjunc; "deg.C"
PRINT
IF tjunc >= tjmax THEN
    COLOR 12
    PRINT " WARNING - EXCEEDS MAXIMUM JUNCTION RATING FOR THIS DEVICE!"
    COLOR 15
END IF
PRINT
COLOR 11
PRINT " Press ";
COLOR 14
PRINT "[A]";
COLOR 11
PRINT " to run again"
PRINT " Press ";
COLOR 14
PRINT "[P]";
COLOR 11
PRINT " to send this data to a connected printer and return to the main menu"
PRINT " Press any other key to return to the main menu without printing."
COLOR 15
GOSUB keywait
IF r$ = "p" OR r$ = "P" THEN GOSUB printout_heatsink
IF r$ = "a" OR r$ = "A" THEN GOTO heatsink
PRINT
COLOR 15
RETURN
'
heatsink:
CLS
PRINT ul$
PRINT " HEATSINK REQUIREMENTS"
PRINT ul$
PRINT
COLOR 11
PRINT " Please supply parameters for the devic/heatsink or press [ENTER]"
PRINT " to use the default values when * appears. The default values"
PRINT " are typical for a TO0220 device and its associated mounting kit"
PRINT " but they can be changed using the [M] option from the main menu."
COLOR 15
PRINT
input " Input ambient temperature             (deg.C): "; tamb
PRINT
INPUT " Input junction temperature            (deg.C): "; tjunc
PRINT
INPUT " Input device total dissipation            (W): "; ptot
PRINT
INPUT " Thermal resistance junction-case *  (deg.C/W): "; thjc
PRINT
INPUT " Thermal resistance case-heatsink *  (deg.C/W): "; thch
PRINT
'
IF thjc = 0 THEN thjc = thjcdef
IF thch = 0 THEN thch = thchdef
'
thtot = (tjunc - tamb) / ptot
thha = thtot - (thjc + thch)
CLS
PRINT ul$
PRINT " RESULTS"
PRINT ul$
PRINT
PRINT " Ambient temperature       : "; tamb; "deg.C"
PRINT
PRINT " Total power dissipation   : "; ptot; "W"
PRINT
PRINT " Junction temperature      : "; tjunc; "deg.C"
PRINT
PRINT " Required heatsink thermal resistance (deg.C/W): "; thha
PRINT
'
PRINT
COLOR 11
PRINT " Press ";
COLOR 14
PRINT "[A]";
COLOR 11
PRINT " to run again"
PRINT " Press ";
COLOR 14
PRINT "[P]";
COLOR 11
PRINT " to send this data to a connected printer and return to the main menu"
PRINT " Press any other key to return to the main menu without printing."
COLOR 11
GOSUB keywait
IF r$ = "p" OR r$ = "P" THEN GOSUB printout_heatsink
IF r$ = "a" OR r$ = "A" THEN GOTO heatsink
PRINT
COLOR 15
RETURN
'
maxtemp:
CLS
PRINT ul$
PRINT " SET MAXIMUM JUNCTION TEMPERATURE AND OTHER PARAMETERS"
PRINT ul$
PRINT
COLOR 11
PRINT " Please specify maximum junction temperature, etc...."
COLOR 13
PRINT
PRINT " Note: These values will become the default values for"
PRINT " this session and you will not need to enter them again."
COLOR 15
PRINT
INPUT " Input maximum junction temperature             (deg.C): "; tjmax
PRINT
INPUT " Input thermal resistance from junction-case  (deg.C/W): "; thjcdef
PRINT
INPUT " Input thermal resistance from case-heatsink  (deg.C/W): "; thchdef
PRINT
'
'
'
keywait:
DO
    r$ = INKEY$
LOOP UNTIL r$ <> ""
RETURN
'
'
printout_temp:
CLS
IF thha = 0 THEN
    COLOR 13
	PRINT 
    PRINT " WARNING - No data yet! Please run with option [2] first!"
	COLOR 15
	GOSUB keywait
ELSE
	LPRINT ul$
	LPRINT " JUMCTION TEMPERATURE SUMMARY"
	LPRINT ul$
	LPRINT " " + DATE$ + " at " + TIME$
	LPRINT
    LPRINT " Ambient temperature             : "; tamb; "deg.C"
    LPRINT
    LPRINT " Total power dissipation         : "; ptot; "W"
    LPRINT
    LPRINT " Thermal resistance junction-case: "; thjc; "deg.C/W"
    LPRINT
    LPRINT " Thermal resistance case-heatsink: "; thch; "deg.C/W"
    LPRINT
    LPRINT " Junction temperature            : "; tjunc; "deg.C"
	LPRINT chr$(&H0C)
END IF
RETURN

printout_heatsink:
CLS
IF thha = 0 THEN
    COLOR 13
	PRINT
    PRINT " WARNING - No data yet! Please run with option [2] first!"
	COLOR 15
    GOSUB keywait
ELSE
	LPRINT ul$
	LPRINT " HEATSINK REQUIREMENTS SUMMARY"
	LPRINT ul$
	LPRINT " " + DATE$ + " at " + TIME$
	LPRINT
    LPRINT " Ambient temperature             : "; tamb; "deg.C"
    LPRINT
    LPRINT " Total power dissipation         : "; ptot; "W"
    LPRINT
    LPRINT " Thermal resistance junction-case: "; thjc; "deg.C/W"
    LPRINT
    LPRINT " Thermal resistance case-heatsink: "; thch; "deg.C/W"
    LPRINT
    LPRINT " Required heatsink               : "; thha; "deg.C/W"
	LPRINT CHR$(&H0C)
END IF
RETURN

warning:
PRINT ul$
PRINT " An error has occurred!"
PRINT " Please check that valid data has been entered."
PRINT " Press any key to continue..."
GOSUB keywait
RESUME main
