#define OPT_SYSTEM_INTERNAL
#define OPT_BOARD_INTERNAL
#include "vidgen_drv.h"
#include <p32xxxx.h>
#include <plib.h>
#include <WProgram.h> 
#include <inttypes.h>
#include <pins_arduino.h>



volatile unsigned int cnt = 0;			// Count the number of lines that have been displayed
volatile unsigned char frameDone = 0;	// A flag that indicates that the last screen line has been drawn


extern "C"
{
void __ISR(_TIMER_3_VECTOR, _T3_IPL_ISR) T3_IntHandler (void)
{
  
  cnt++;
  
  IFS0CLR = 0x1000; // Clear timer interrupt status flag

  if ( cnt == 1 ) {
    LATD |= 0x4;	// set the 
    
  } else if ( cnt == 5 ) {
    LATD &= ~0x4;  
    
  } else if ( cnt == 620 ) {
     // Indicate to main application that the display is free to be updated
     // As we have drawn the last 
     frameDone = 1; 
     
  }else if ( cnt == 629 ) {
    // Starting a new frame on the next line count
    cnt = 0;    
    
  } else if ( (cnt >=28 )&&(cnt <=619 ) ) {
  	// This is where we will transfer the line pixel data
  	
  }
}

} // End of extern C


void vidgen_setup( void )
{  
  // Configure Output Compare peripheral OC1 
  // Connects to pin 3 on chipKit Uno32 header J5
  OC1CON = 0x0d;  	// Setup is 16 bit, using Timer3, +ve edge
  OC1R =   0; 		// Positive edge at count 0
  OC1RS =  256; 	// Falling edge 256 counts later
  
  // Timer 3 setup, to support OC1
  PR3 = 2111;		// Timer will restart after 2111 counts
  T3CON = 0;		// Disable timer while configuring it
  TMR3 = 0;
  
  // Enable an interrupt to occur on each line. We will
  // use this later to help generate the vertical sync
  IFS0CLR = 0x1000; // Clear timer interrupt status flag
  IEC0SET = 0x1000; // Set interrupt enable on Tmr3
  
  // Specify the interrupt priority
  IPC3CLR = 0x1F;	
  IPC3SET = (_T3_IPL_IPC << 2) | _T3_SPL_IPC;
  
  // Start the timer and output compare peripheral
  T3CONSET =  0x8000;
  OC1CONSET = 0x8000;  
}


