    include <P18f27J13.INC>

	CONFIG WDTEN = OFF
	CONFIG XINST = OFF
	CONFIG IESO = OFF
	CONFIG FCMEN = OFF
	CONFIG DSWDTEN = OFF
	CONFIG OSC = INTOSCPLL
	CONFIG CFGPLLEN = ON
	CONFIG PLLDIV = 2
	CONFIG PLLSEL = PLL96
	
; RAM addresses of variables
delay_2s		EQU	0x00
wnTmp			EQU	0x01	; Temp variable used by writeNibble
LCDLine			EQU	0x02	; Input to setPos routine
LCDCol			EQU	0x03	; Input to setPos
wlTmp			EQU	0x04	; Temp variable for writeLCD
	
; Constants
TMR1_CONF 		EQU 0x8E	      ; timer is 16bit, TMR1 SOC source, prescale by 1 (None)
TOGGLE_LED_TIME	EQU .5	; time between toggling the LED - 10s

; TMR0 configuration for our usleep delay routine
TMR0_DISABLE	EQU	0x00
TMR0_ENABLE		EQU	0x83

; TMR0 load values for different delay times
USLEEP_2US		EQU	.65534
USLEEP_100US	EQU	.65461
USLEEP_200US	EQU	.65386
USLEEP_3MS		EQU .63286
USLEEP_8MS		EQU	.59536
USLEEP_80MS		EQU	.5536

; A macro to simplify calling the usleep routine
USLEEP macro delayTime
	movlw	HIGH delayTime
	movwf	TMR0H
	movlw	LOW delayTime
	movwf	TMR0L
	call	usleep
endm

; LCD pin control
LCD_RS_LAT		EQU LATA
LCD_RS_BIT		EQU 0
LCD_RW_LAT		EQU LATA
LCD_RW_BIT		EQU 1
LCD_E_LAT		EQU LATA
LCD_E_BIT		EQU 2
LCD_DATA_LAT	EQU LATB	; We use the low 4 bits.

; LCD constants
LCD_LINE1		EQU	0
LCD_LINE2		EQU 0x40
	
	;*************************************************************************
	; Set the code address to start of flash -
	; this is where the processor will start 
	; executing instructions from after a reset.
	;*************************************************************************
	org     0
	goto    main

	
	;*************************************************************************
	; Interrupt routine entry address - always 0x0008
	;*************************************************************************
	org 8
	bcf 	PIR1, TMR1IF
	
	; only toggle the LED after 5 interrupts
	decfsz	delay_2s
	goto	int_exit	
	
	btg	   	LATB, 5		; toggle the LED on PORTB5
	
	bcf		LATB, 4		; turn the LCD off.
	
	movlw	TOGGLE_LED_TIME
	movwf	delay_2s	; reset the 10s counter
	
int_exit:
	retfie  FAST

	
	;*************************************************************************
	; A delay routine providing approximate delays
	; for the LCD module. Uses timer0
	; TMR0 will have been loaded before calling.
	;*************************************************************************
usleep:
	bcf		INTCON, TMR0IF
	movlw	TMR0_ENABLE
	movwf	T0CON
usl001:
	btfss	INTCON, TMR0IF
	goto	usl001
	movlw	TMR0_DISABLE
	movwf	T0CON
	return
	
	
	;*************************************************************************
	; Writes a nibble to the LCD ( we use the LCD in 4-bit mode )
	; We make use of the fact that the LATB lower four bits are always 0 
	; on entry.
	;*************************************************************************
writeNibble:	
	movwf	wnTmp

	btfsc	wnTmp, 4	; bit 4 is the state of the RW line
	bsf		LCD_RW_LAT, LCD_RW_BIT
	btfsc	wnTmp, 5	; bit 5 is the state of the RS line
	bsf		LCD_RS_LAT, LCD_RS_BIT
	movlw	0x0F
	andwf	wnTmp, W	; remove the two control bits from the upper nibble..

	; now copy the data over to the lower four bits of PORTB, preserving the
	; upper parts of PORTB
	iorwf	LCD_DATA_LAT, F
	
	USLEEP	USLEEP_2US
	bsf		LCD_E_LAT, LCD_E_BIT 
	USLEEP	USLEEP_2US
	bcf		LCD_E_LAT, LCD_E_BIT 
	
	; drop all the LCD lines to low level
	bcf		LCD_RW_LAT, LCD_RW_BIT
	bcf		LCD_RS_LAT, LCD_RS_BIT
	movf	LCD_DATA_LAT, W
	andlw	0xF0
	movwf	LCD_DATA_LAT
	
	return 	
	
	
	;*************************************************************************
	; User Routine: set the position on the display.
	; Expects the variables LCDLine and LCDCol to have been set.
	; These take the values 0..15 and LCD_LINE1,LCD_LINE2 respectively
	;*************************************************************************
setPos:
	movf 	LCDLine, W
	addwf	LCDCol, F		; Destroys the original LCDCol, but thats ok
	swapf	LCDCol, W
	iorlw	0x08
	andlw	0x0F
	call	writeNibble
	movf	LCDCol, W
	andlw	0x0F
	call	writeNibble
	USLEEP	USLEEP_100US
	
	return	
	

	;*************************************************************************
	; Writes a character in W to the LCD at the current position
	;*************************************************************************
writeLCD:
	movwf	wlTmp
	swapf	wlTmp, W
	andlw	0x0F
	iorlw	0x20
	call	writeNibble
	movf	wlTmp, W
	andlw	0x0F
	iorlw	0x20
	call	writeNibble

	USLEEP	USLEEP_100US
		
	return	
	
	
	;*************************************************************************
	; Setup the LCD to its default state following power up
	;*************************************************************************
LCDInit:
	; allow LCD time to start up
	USLEEP	USLEEP_80MS
	
	movlw	0x03
   	call	writeNibble

	USLEEP	USLEEP_8MS
	
	movlw	0x03
   	call	writeNibble

	USLEEP	USLEEP_200US
	
	movlw	0x03
   	call	writeNibble

	USLEEP	USLEEP_200US
	
	movlw	0x02
   	call	writeNibble

	USLEEP	USLEEP_200US
	
	movlw	0x02
   	call	writeNibble
	movlw	0x0c
   	call	writeNibble

	USLEEP	USLEEP_3MS
	
	movlw	0x00
   	call	writeNibble
	movlw	0x0c
   	call	writeNibble

	USLEEP	USLEEP_3MS
	
	movlw	0x00
   	call	writeNibble
	movlw	0x01
   	call	writeNibble

	USLEEP	USLEEP_3MS
	
	movlw	0x00
   	call	writeNibble
	movlw	0x06
   	call	writeNibble

	USLEEP	USLEEP_3MS
	
	return
	
	
	;*************************************************************************
	;*************************************************************************
main:
	movlw   0x00	
	movwf   TRISB		; Set PORTB as an output
	movlw   0xF8	
	movwf   TRISA		; Set lower 3 bits of PORTA as an output
	
	; Set our LCD drive pins to digital I/O pins
  	movlw  	0x07
   	movwf  	ANCON0
   	movlw  	0x17
   	movwf  	ANCON1
   	
   	; Set all LCD signals low, and turn LED off
   	clrf	LATB
   	clrf	LATA

	movlw	TOGGLE_LED_TIME
	movwf	delay_2s
	
	bcf 	PIR1, TMR1IF
	clrf	TMR1H
	movlw	0
	clrf	TMR1L
		
	; Apply power to the LCD
	bsf		LATB, 4	
		
	; Initialise the LCD	
	call	LCDInit
	
	; Enable the 32KHz oscillator on Timer1
	movlw	TMR1_CONF
	movwf	T1CON	 	
	bsf     PIE1, TMR1IE
	bsf		INTCON, PEIE
	bsf		INTCON, GIE
	bsf		T1CON, TMR1ON
	
	; write something to the display
	clrf	LCDCol
	clrf	LCDLine
	call	setPos
	movlw	'H'
	call	writeLCD
	movlw	'e'
	call	writeLCD
	movlw	'l'
	call	writeLCD
	movlw	'l'
	call	writeLCD
	movlw	'o'
	call	writeLCD
	

loop:
	sleep
	goto    loop
	
	
	
	end
	
