	;*************************************************************************
	; file: main.asm
	;		Contains the reset, interrupt vector & main loop code
	;*************************************************************************
	

	;*************************************************************************
	; include files go here
	;*************************************************************************

    include <P18f27J13.INC>
    include <config.inc>
    include <macros.inc>


	;*************************************************************************
	; extern directives - to gain access to global functions and data from 
	;					  elsewhere
	;*************************************************************************

	extern 	HardwareInit
	extern 	LCDInit
	extern  InterruptInit
	extern  InterruptHandler
	extern  Timer0Init
	extern  Timer1Init
	extern  kitchenInit
	extern	LCDCol
	extern	LCDLine
	extern	setPos
	extern	LCDWrite
	extern  usleep
	extern  timerAsleep
	extern 	kitchenHandler


	;*************************************************************************
	; global directives - making variables and functions available elsewhere -
	;					  go here
	;*************************************************************************


	;*************************************************************************
	; Constanst - Symbolic constants and simple macros, defined with the 
	;			  EQU directive, go here.
	;*************************************************************************


	;*************************************************************************
	; Definition of RAM based variables follow the udata directive
	;*************************************************************************

	udata

	
	;*************************************************************************
	; code, such as functions and ROM based data tables, follow the code directive
	;*************************************************************************

	code
	
	;*************************************************************************
	; Set the code address to start of flash -
	; this is where the processor will start 
	; executing instructions from after a reset.
	;*************************************************************************
	org     0
	goto    main

	
	;*************************************************************************
	; Interrupt routine entry address - always 0x0008
	; interruptHandler is in interrupt.asm
	;*************************************************************************

	org 	8
	goto	InterruptHandler
	

	;*************************************************************************
	; Function: main
	;			The starting point of the code following a reset.
	;*************************************************************************
main:
	; Initialise any low level hardware features
	call 	HardwareInit

	; Initialise the Interrupt sub-system
	call	InterruptInit

	; Initialise the timer sub-system
	call	Timer0Init
	call	Timer1Init
		
	; Initialise the LCD ( optional external peripheral )
	call	LCDInit
	
	;	
	; Main, user application code starts here
	;

	; user application - start up code
	; Code here is called once following power up

	call	kitchenInit
	
mainloop:
	; The sleep instruction will cause the processor to halt, and enter
	; a low power state. Timer1 interrupts will still wake the processor.
	; Only sleep if the timer is inactive
	call	timerAsleep
	btfsc	STATUS, Z
	sleep	

	; user application - main loop
	; Code here is called either 
	; a) continuously
	; b) once per interrupt, if the sleep instruciton is present

	call	kitchenHandler

	goto    mainloop
	
	; Do not place code here - it will not be executed.
	

	end
	
