'------------------------------------------------------------------------------
'                              SPRITE DEMONSTRATION
'
'                              by Nickolas Marentes
'
'                                   June 2013
'------------------------------------------------------------------------------

Mode 3                                        ' Set video mode
LoadBMP"backdrop"                             ' Load backdrop image
Sprite Load "sprites"                         ' Load sprite definitions

Dim p(8,4)                                    ' Define array size

For n=1 To 8                                  ' Set all 8 sprites data
  p(n,1)=n*25+125                             '   X co-ordinate
  p(n,2)=216                                  '   Y co-ordinate
  p(n,3)=Fix(Rnd*4)+1                         '   Random 4 direction
  Sprite on n,n*25+125,216                    ' Turn on sprite
Next n


GAMELOOP:

  For n=1 To 8                                ' Start of main game loop

    MOVEGHOST:
    On p(n,3) GoTo LEFT,RIGHT,UP,DOWN         ' Branch to direction

      LEFT:                                   ' Move sprite left
      Sprite copy 11+b To n                   ' Copy sprite buffer graphics
      p(n,1)=p(n,1)-1                         ' Decrement X co-ordinate
      GoTo REDRAW                             ' Branch to sprite redraw

      RIGHT:                                  ' Move sprite right
      Sprite copy 9+b To n                    ' Copy sprite buffer graphics
      p(n,1)=p(n,1)+1                         ' Increment X co-ordinate
      GoTo REDRAW                             ' Branch to sprite redraw

      UP:                                     ' Move sprite up
      Sprite copy 13+b To n                   ' Copy sprite buffer graphics
      p(n,2)=p(n,2)-1                         ' Decrement Y co-ordinate
      GoTo REDRAW                             ' Branch to sprite redraw

      DOWN:                                   ' Move sprite down
      Sprite copy 15+b To n                   ' Copy sprite buffer graphics
      p(n,2)=p(n,2)+1                         ' Increment Y co-ordinate

    REDRAW:

      Sprite move n,p(n,1),p(n,2)             ' Move current sprite

    If Collision(n,edge)>0 Then GoTo BOUNCE   ' Test for edge of screen

    If Collision(n,sprite)>0 Then GoTo BOUNCE ' Test for another sprite

    If Rnd>.99 Then p(n,3)=Fix(Rnd*4)+1       ' Randomly decide to turn

    Next n                                    ' Loop back for next sprite

c=c+1                                         ' Counter for sprite animate
If c>8 Then b=b Xor 1:c=0                    ' Sets speed of animation

GoTo GAMELOOP                                 ' Do it all again


BOUNCE:                                       ' reverse sprite direction
  p(n,3)=p(n,3)+1                             ' Reverse direction
  If p(n,3)=3 Then p(n,3)=1
  If p(n,3)=5 Then p(n,3)=3
GoTo MOVEGHOST                                ' Go back to redraw sprite

