'* * * * * * * * * * * * * * * * * * * * * * * * *
'*                                               *
'*            - M A X M A N  v1.2 -              *
'*                                               *
'*        For the Maximite Computer by           *
'*                                               *
'*              Nickolas Marentes                *
'*                                               *
'* DATE:April 2012  EMAIL:nickma@optusnet.com.au *
'*                                               *
'*               <GAME CONTROLS>                 *
'*                                               *
'* START GAME  = Any key for Keyboard control    *
'*             = Joy button for Joystick control *
'* MOVE MAXMAN = Cursor Keys or Joystick         *
'* PAUSE GAME  = Spacebar                        *
'* ABORT GAME  = ESC                             *
'*                                               *
'*      Extra life awarded at 10000 points       *
'*                                               *
'* * * * * * * * * * * * * * * * * * * * * * * * *
Mode 1

Data 4,3,23,27,23,3,4,27,1
Data 23,27,23,3,4,27,4,3,1
Data 23,3,4,27,4,3,23,27,1
Data 4,27,4,3,23,27,23,3,0

'JOYSTICK SELECT

Cls:wii=2
Print@(188,60)"--  M A X M A N  --":Print@(213,80)"Version 1.1"
Line(160,110)-(325,230),1,b:Line(160,110)-(325,138),1,bf:Sound 400,50
Print@(177,120,2)"JOYSTICK CONFIGURATION"
Print@(165,150)"[1] - Atari Joystick"
Print@(165,170)"[2] - Wii Nunchuk (100khz)"
Print@(165,190)"[3] - Wii Nunchuk (400khz)"
Print@(165,210)"[4] - No Joystick"
Print@(114,300)"Some Wii Nunchuks do not operate at 400khz"
Print@(106,320)"Game runs slower when using Nunchuk at 100khz"

JOYSET:
k$=Inkey$
If k$="2" Or k$="3" Then wii=1
If k$="1" Or k$="4" Then wii=0
If wii=2 Then GoTo JOYSET
Sound 200,50

'INITIALIZATION

Cls
Font Load "MAXMAN.FNT" As #6
Open"HISCORE.DAT"For INPUT As#1:Input#1,hiscore:Close#1
For x=11 To 15:SetPin x,2:Next
If wii=0 Then GoTo STARTLEVEL

'INITIALIZE Wii NUNCHUCK (I2C on Pins 12 & 13)

Dim nun(6)

If k$="2" Then I2CEN 10,100 Else I2CEN 400,100
I2CSEND &h52,0,2,&hF0,&h55
I2CSEND &h52,0,2,&hFB,&h00


STARTLEVEL:
Line(7,9)-(160,127),0,bf:Line(175,9)-(328,127),0,bf
Line(7,275)-(327,337),0,bf:Line(7,359)-(328,421),0,bf
Line(31,335)-(304,360),0,bf:Line(67,65)-(268,277),0,bf
Line(3,191)-(332,211),0,bf:Line(400,305)-(470,413),0,bf
Font Load "SCREEN.FNT" As #5:Font #5:c=97
For y=1 To 385 Step 64:For x=0 To 240 Step 240
Print@(x,y)Chr$(c);:c=c+1:Next:Next
Font #6:Font unload #5
Dim m(27,30,3):Dim g(4,4):Dim t(4,2)

'Load Map/Dot array

For x=1 To 26:For y=1 To 29
If Pixel(x*12+4,y*14+5)=1 Then m(x,y,1)=1
If Pixel(x*12+5,y*14+5)=1 Then m(x,y,2)=1
Pixel(x*12+4,y*14+5)=0:Next y,x

'Start or Continue level

If status=1 Then GoTo START
If sc>hiscore Then hiscore=sc:Open"HISCORE.DAT"For output As#1:Print#1,hiscore:Close#1
sc=0:dotcnt=0:level=1:lives=3:q2=93:xt=10000:GoSub BOXCLS
Font#2:Print@(393,310)sc:Print@(393,337)hiscore:Print@(393,365)level:Font#6
CLRKBUFF: If Inkey$<>"" Then GoTo CLRKBUFF

PROMPT:
Font#2:Timer=0:Print@(129,183,5)"INSERT":Print@(143,205,5)"COIN"
COIN: k$=Inkey$
If k$<>"" Then v=0:GoTo GO
If wii=1 Then GoTo J1
If Pin(15)=0 Then v=1:GoTo GO
If Timer>300 Then GoTo PROMPT Else GoTo COIN
J1:
I2CSEND &h52,0,1,0
I2CRCV &h52,0,6,nun(0)
'PRINT@(0,0)nun(1)"   "
If (nun(5) And 1)=0 Then v=2:GoTo GO
If Timer>300 Then GoTo PROMPT Else GoTo COIN

GO:
GoSub BOXCLS:Sound 300,100:Pause 50:Sound 200,50
Font#2:Print@(149,182)"GET":Print@(137,204)"READY"
Pause 3000:GoSub BOXCLS:status=1

'Initialize Level Start variables

START:
Font#2:Print@(393,310)sc:Print@(393,337)hiscore:Print@(393,365)level:Font#6
px=166:py=327:pd=1:cd=1:pc=99:a=1:gscore=1:q1=1400:Line (400,395)-(460,405),0,bf
For x=1 To 4:g(x,1)=166:g(x,2)=201:g(x,3)=3:g(x,4)=x*100+50:Next
ST1: If lives>a Then Line(400+a*8,395)-(403+a*8,405),1,bf:a=a+1:GoTo ST1

'Main Game Loop

MAINLOOP:
Timer=0
pxd=Int((px-4)/12):pxx=pxd:If ((px-4)/12)-pxd<>0 Then pxd=0
pyd=Int((py-5)/14):pyy=pyd:If ((py-5)/14)-pyd<>0 Then pyd=0

If gmode=0 Then GoTo TARGET
pwrcnt=pwrcnt-1
If pwrcnt=0 Then gmode=0:gscore=1
GoTo CAUGHT

TARGET:
If Rnd*100<level*2 Then c=Fix(Rnd*(level And 3))+1:t(c,1)=pxx:t(c,2)=pyy
If tc>0 Then tc=tc-1:GoTo CAUGHT
tc=400
If tflag=0 Then Restore
For a=1 To 4:Read t(a,1),t(a,2):Next:Read tflag

CAUGHT:
If hflag=0 Or gmode=1 Then GoTo CONTROL
Locate px-8,py-9
If hflag=1 Then GoSub BOXCLS
If hflag<38 Then Print Chr$(hflag/4+79);:Sound 200-hflag*2,10
If hflag>38 Then Print Chr$(97);
If hflag=45 Then Sound 150,35:Pause 170:Sound 150,35
hflag=hflag+1
If hflag<100 Then GoTo GHOSTS
hflag=0:hit=0:lives=lives-1
For n=1 To 4:g(n,1)=166:g(n,2)=201:g(n,3)=3:g(n,4)=n*150+100:Next
If lives>0 Then GoTo START
For x=1 To 87:Line(167-x,200)-(167+x,202),1,bf:Sound x*4+50,10:Pause 5:Next
For y=1 To 32:Line(80,200-y)-(254,202+y),1,b:Sound Rnd*300+50,10:Pause 10:Next
Font#2:Print@(110,192,2)"GAME OVER":Pause 5000:status=0:Sound 100,100
Erase m,g,t:GoTo STARTLEVEL


'SCAN SELECTED CONTROLLER

CONTROL:
k=Asc(Inkey$)
If k=32 Then GoSub PAUSEGAME
If k=27 Then status=0:Erase m,g,t:GoTo STARTLEVEL
If v=0 Then GoTo KEYSCAN
If v=2 Then GoTo NUNCHUCK

ATARI:
If Pin(13)=0 Then cd=1:k=130
If Pin(14)=0 Then cd=2:k=131
If Pin(11)=0 Then cd=3:k=128
If Pin(12)=0 Then cd=4:k=129
On pd GoTo PLEFT,PRIGHT,PUP,PDOWN

NUNCHUCK:
I2CSEND &h52,0,1,0
I2CRCV &h52,0,6,nun(0)
If nun(0)<85 Then cd=1:k=130
If nun(0)>170 Then cd=2:k=131
If nun(1)>170 Then cd=3:k=128
If nun(1)<85 Then cd=4:k=129
On pd GoTo PLEFT,PRIGHT,PUP,PDOWN

KEYSCAN:
If k=130 Then cd=1
If k=131 Then cd=2
If k=128 Then cd=3
If k=129 Then cd=4
On pd GoTo PLEFT,PRIGHT,PUP,PDOWN


'PROCESS PACMAN

PLEFT:
If k=131 Then pd=2:pc=103:GoTo P001
P004: If pxd=0 Then GoTo P002
If cd=3 And m(pxd,pyd-1,1)=1 Then pd=3:pc=107:GoTo ENDPAC
If cd=4 And m(pxd,pyd+1,1)=1 Then pd=4:pc=111:GoTo ENDPAC
If pxd=1 And pyd=14 Then Print@(8,192)"a":px=316:GoTo ENDPAC
If m(pxd-1,pyd,1)=0 Then pc=99:GoTo ENDPAC
If m(pxd-1,pyd,2)=1 Then Sound 100,20:sx=pxd-1:sy=pyd:m(sx,sy,2)=0:Line(px-12,py)-(px-11,py+1),0,b:GoSub EATDOT
P002: Line (px+10,py-5)-(px+11,py+5),0,b:px=px-2
P003: pc=pc+.25:If pc>101 Then pc=98
GoTo ENDPAC

PRIGHT:
If k=130 Then pd=1:pc=99:GoTo P004
P001: If pxd=0 Then GoTo P005
If cd=3 And m(pxd,pyd-1,1)=1 Then pd=3:pc=107:GoTo ENDPAC
If cd=4 And m(pxd,pyd+1,1)=1 Then pd=4:pc=111:GoTo ENDPAC
If pxd=26 And pyd=14 Then Print@(308,192)"a":px=16:GoTo ENDPAC
If m(pxd+1,pyd,1)=0 Then pc=103:GoTo ENDPAC
If m(pxd+1,pyd,2)=1 Then Sound 100,20:sx=pxd+1:sy=pyd:m(sx,sy,2)=0:Line(px+13,py)-(px+14,py+1),0,b:GoSub EATDOT
P005: Line (px-9,py-5)-(px-7,py+5),0,bf:px=px+2
P006: pc=pc+.25:If pc>105 Then pc=102
GoTo ENDPAC

PUP:
If k=129 Then pd=4:pc=111:GoTo P007
P010: If pyd=0 Then GoTo P008
If cd=1 And m(pxd-1,pyd,1)=1 Then pd=1:pc=99:GoTo ENDPAC
If cd=2 And m(pxd+1,pyd,1)=1 Then pd=2:pc=103:GoTo ENDPAC
If m(pxd,pyd-1,1)=0 Then pc=107:GoTo ENDPAC
If m(pxd,pyd-1,2)=1 Then Sound 100,20:sx=pxd:sy=pyd-1:m(sx,sy,2)=0:Line(px+1,py-14)-(px+2,py-13),0,b:GoSub EATDOT
P008: Line (px-4,py+9)-(px+7,py+11),0,bf:py=py-2
P009: pc=pc+.25:If pc>109 Then pc=106
GoTo ENDPAC

PDOWN:
If k=128 Then pd=3:pc=107:GoTo P010
P007: If pyd=0 Then GoTo P011
If cd=1 And m(pxd-1,pyd,1)=1 Then pd=1:pc=99:GoTo ENDPAC
If cd=2 And m(pxd+1,pyd,1)=1 Then pd=2:pc=103:GoTo ENDPAC
If m(pxd,pyd+1,1)=0 Then pc=111:GoTo ENDPAC
If m(pxd,pyd+1,2)=1 Then Sound 100,20:sx=pxd:sy=pyd+1:m(sx,sy,2)=0:Line(px+1,py+14)-(px+2,py+15),0,b:GoSub EATDOT
P011: Line (px-4,py-10)-(px+7,py-8),0,bf:py=py+2
P012: pc=pc+.25:If pc>113 Then pc=110

ENDPAC: Print@(px-8,py-9)Chr$(pc);


'PROCESS GHOSTS

GHOSTS:
If gmode=1 Then GoTo GMODE1

GMODE0:
z=2
For n=1 To 4
gx=Fix((g(n,1)-4)/12):dx=gx:If ((g(n,1)-4)/12)-gx<>0 Then gx=0
gy=Fix((g(n,2)-5)/14):dy=gy:If ((g(n,2)-5)/14)-gy<>0 Then gy=0
Locate g(n,1)-8,g(n,2)-9
If hflag>0 And g(n,4)>0 Then g(n,4)=100
If g(n,4)>0 Then GoTo GREGEN
If hflag=2 Then Line(g(n,1)-9,g(n,2)-10)-(g(n,1)+12,g(n,2)+11),0,bf:GoTo GM0
If hflag<>0 Then GoTo GM0
Print Chr$(g(n,3)+113);
GM0: On g(n,3) GoTo GLEFT,GRIGHT,GUP,GDOWN

GMODE1:
z=z Xor 2
For n=1 To 4
gx=Fix((g(n,1)-4)/12):dx=gx:If ((g(n,1)-4)/12)-gx<>0 Then gx=0
gy=Fix((g(n,2)-5)/14):dy=gy:If ((g(n,2)-5)/14)-gy<>0 Then gy=0
If dx<pxx Then t(n,1)=8 Else t(n,1)=19
If dy<pyy Then t(n,2)=72 Else t(n,2)=21
Locate g(n,1)-8,g(n,2)-9
If hflag>0 And g(n,4)>0 Then g(n,4)=100
If g(n,4)>0 Then GoTo GREGEN
If hflag=2 Then Line(g(n,1)-9,g(n,2)-10)-(g(n,1)+12,g(n,2)+11),0,bf:GoTo GM1
If hflag<>0 Then GoTo GM1
If pwrcnt<85 And z=0 Then Print Chr$(119); Else Print Chr$(118);
GM1: On g(n,3) GoTo GLEFT,GRIGHT,GUP,GDOWN

GREGEN:
If gmode=1 And g(n,4)>83 Then g(n,4)=g(n,4)+1
g(n,4)=g(n,4)-1:Line(156,172)-(180,172),1
If g(n,4)=0 Or g(n,4)=43 Then g(n,3)=Int(Rnd*2)+1:GoSub BOXCLS:GoTo GM1
If g(n,4)<43 Then g(n,2)=g(n,2)-1:Print Chr$(116):GoTo LOOPEND
Print@(110+n*19,191)Chr$(116+f):GoTo LOOPEND

GUP:
If hflag=0 Then Line(g(n,1)-8,g(n,2)+10)-(g(n,1)+11,g(n,2)+11),0,b
If m(dx,dy+1,2)=1 Then x=dx*12+5:y=(dy+1)*14+5:Line (x,y)-(x+1,y+1),1,b
GU2: If gy=0 Then g(n,2)=g(n,2)-z:GoTo LOOPEND
If gmode=1 Then GoTo GU1
If gx=pxx Then t(n,1)=pxx:t(n,2)=pyy:GoTo GU1
If gx>t(n,1) And m(gx-1,gy,1)=1 Then g(n,3)=1:gx=0:GoTo GL2
If gx<t(n,1) And m(gx+1,gy,1)=1 Then g(n,3)=2:gx=0:GoTo GR2
GU1: If m(gx,gy-1,1)=1 Then g(n,2)=g(n,2)-z:GoTo LOOPEND
If m(gx-1,gy,1)=1 Then g(n,3)=1:gx=0:GoTo GL2
g(n,3)=2:gx=0:GoTo GR2

GDOWN:
If hflag=0 Then Line(g(n,1)-8,g(n,2)-10)-(g(n,1)+11,g(n,2)-9),0,b
If m(dx,dy-1,2)=1 Then x=dx*12+5:y=(dy-1)*14+5:Line (x,y)-(x+1,y+1),1,b
GD2: If gy=0 Then g(n,2)=g(n,2)+z:GoTo LOOPEND
If gmode=1 Then GoTo GD1
If gx=pxx Then t(n,1)=pxx:t(n,2)=pyy:GoTo GD1
If gx>t(n,1) And m(gx-1,gy,1)=1 Then g(n,3)=1:gx=0:GoTo GL2
If gx<t(n,1) And m(gx+1,gy,1)=1 Then g(n,3)=2:gx=0:GoTo GR2
GD1: If m(gx,gy+1,1)=1 Then g(n,2)=g(n,2)+z:GoTo LOOPEND
If m(gx-1,gy,1)=1 Then g(n,3)=1:gx=0:GoTo GL2
g(n,3)=2:gx=0:GoTo GR2

GLEFT:
If hflag=0 Then Line(g(n,1)+11,g(n,2)-9)-(g(n,1)+12,g(n,2)+10),0,b
If m(dx+1,dy,2)=1 Then x=(dx+1)*12+5:y=dy*14+5:Line (x,y)-(x+1,y+1),1,b
GL2: If gx=0 Then g(n,1)=g(n,1)-z:GoTo LOOPEND
If gx=1 And gy=14 Then Print@(8,192)"a":g(n,1)=316:GoTo LOOPEND
If gmode=1 Then GoTo GL1
If gy=pyy Then t(n,1)=pxx:t(n,2)=pyy:GoTo GL1
If gy>t(n,2) And m(gx,gy-1,1)=1 Then g(n,3)=3:gy=0:GoTo GU2
If gy<t(n,2) And m(gx,gy+1,1)=1 Then g(n,3)=4:gy=0:GoTo GD2
GL1: If m(gx-1,gy,1)=1 Then g(n,1)=g(n,1)-z:GoTo LOOPEND
If m(gx,gy-1,1)=1 Then g(n,3)=3:gy=0:GoTo GU2
g(n,3)=4:gy=0:GoTo GD2

GRIGHT:
If hflag=0 Then Line(g(n,1)-9,g(n,2)-9)-(g(n,1)-8,g(n,2)+11),0,b
If m(dx-1,dy,2)=1 Then x=(dx-1)*12+5:y=dy*14+5:Line (x,y)-(x+1,y+1),1,b
GR2: If gx=0 Then g(n,1)=g(n,1)+z:GoTo LOOPEND
If gx=26 And gy=14 Then Print@(308,192)"a":g(n,1)=16:GoTo LOOPEND
If gmode=1 Then GoTo GR1
If gy=pyy Then t(n,1)=pxx:t(n,2)=pyy:GoTo GR1
If gy>t(n,2) And m(gx,gy-1,1)=1 Then g(n,3)=3:gy=0:GoTo GU2
If gy<t(n,2) And m(gx,gy+1,1)=1 Then g(n,3)=4:gy=0:GoTo GD2
GR1: If m(gx+1,gy,1)=1 Then g(n,1)=g(n,1)+z:GoTo LOOPEND
If m(gx,gy-1,1)=1 Then g(n,3)=3:gy=0:GoTo GU2
g(n,3)=4:gy=0:GoTo GD2


LOOPEND:
If g(n,1)>px-9 And g(n,1)<px+9 And g(n,2)>py-9 And g(n,2)<py+9 Then GoSub EATME
Next n

If q1>1000 And px=162 And py=243 Then GoSub BONUSSND:s=500:GoSub SCORE:q1=1300
q1=q1+1
If q1>1000 Then Print@(157,234)Chr$(Fix(q2)):q2=q2+.25:If q2=97 Then q2=93
If q1>1300 Then q1=0:Print@(157,234)Chr$(97)

If dotcnt=244 Then Pause 2000:dotcnt=0:level=level+1:Erase m,g,t:GoTo STARTLEVEL

POWER:
i=i+1:If i=20 Then i=0:f=f Xor 1
If m(1,3,2)=1 Then Line(16,46)-(19,49),f,b
If m(26,3,2)=1 Then Line(316,46)-(319,49),f,b
If m(1,23,2)=1 Then Line(16,326)-(19,329),f,b
If m(26,23,2)=1 Then Line(316,326)-(319,329),f,b

If gmode=0 And hflag=0 And hit=1 Then Print@(px-8,py-9)Chr$(98):Pause 1000:hflag=1
WAIT: If Timer<30 Then GoTo WAIT
GoTo MAINLOOP


EATME:
If gmode=0 Then hit=1:Return
Print@(px-8,py-9)Chr$(gscore+88);
s=100:For a=1 To gscore:s=s*2:Next:gscore=gscore+1:GoSub SCORE
For a=100 To 400 Step 50:Sound a,50:Pause 50:Next
Line(g(n,1)-9,g(n,2)-10)-(g(n,1)+12,g(n,2)+11),0,bf
g(n,1)=166:g(n,2)=201:g(n,3)=3:g(n,4)=150+n*30
s=gs:gs=gs*2:GoTo SCORE

EATDOT:
s=10:dotcnt=dotcnt+1
If sx>1 And sx<26 Then GoTo EA1
If sy<>3 And sy<>23 Then GoTo EA1
s=50:gmode=1:gs=200:pwrcnt=320-((level-1) And 3)*75:GoSub BOXCLS
For a=1 To 4
If g(a,1)<pxx And g(a,3)=2 Then g(a,3)=1:GoTo EA2
If g(a,1)>pxx And g(a,3)=1 Then g(a,3)=2:GoTo EA2
If g(a,2)<pyy And g(a,3)=4 Then g(a,3)=3:GoTo EA2
If g(a,2)>pyy And g(a,3)=3 Then g(a,3)=4
EA2: Next
EA1: Sound 80,s*3

SCORE:
sc=sc+s:Font#2:Print@(392,310)sc
If sc<xt Then Font#6:Return
For a=1 To 6
Sound 500,50:Print@(400,394)"EXTRA":Pause 30
Sound 300,50:Print@(400,394)"     ":Pause 30
Next
xt=99999:lives=lives+1:a=1
ST2: If lives>a Then Line(400+a*8,395)-(403+a*8,405),1,bf:a=a+1:GoTo ST2
Font#6:Return

BOXCLS:
Line(129,176)-(206,227),0,bf
Line(156,150)-(179,175),0,bf
Line(156,172)-(180,172),1
Return

BONUSSND:
Font#2:Print@(149,234)"500"
For a=1 To 4
For b=100 To 400 Step 15:Sound b,10:Pause 10
Next:Next
Print@(149,234)"   ":Return

PAUSEGAME:
Font#2
Print@(130,235,5)"PAUSED":Pause 250
Print@(130,235,5)"PAUSED":Pause 250
If Asc(Inkey$)<>32 Then GoTo PAUSEGAME
Font#6
Return

