/* Alarm Clock */

//FOSCHS1H
//PWRT-On
//BOR-OFF
//VREGEN_OFF
//WDT_OFF
//MCLRE_ON
//LPT1OSC_OFF
//PBADEN_OFF
//CCP2MX_OFF
//STVREN_OFF
//LVP_OFF
//XINST_OFF
//DEBUG_OFF
     /*Port Assignments*/
     //Port A,0          d7 cathode
     //Port A,1          d6 cathode
     //Port A,2          d5 cathode
     //Port A,3          d4 cathode
     //Port A,4          d3 cathode
     //Port A,5          d2 cathode
     //Port B,0          LCD D4
     //Port B,1          LCD D3
     //Port B,2          LCD D2
     //Port B,3          LCD D1
     //Port B,4          LCD RS
     //Port B,5          LCD E
     //Port B,6          Alarm Cancel pushbutton
     //Port B,7
     //Port C,0          Select Pushbutton
     //Port C,1          Up Pushbutton
     //Port C,2          Down Pushbutton
     //Port C,3
     //Port C,4
     //Port C,5
     //Port C,6          Alarm Set Mode
     //Port C,7          Snooze
     //Port D,0          7 segment a
     //Port D,1          7 segment b
     //Port D,2          7 segment c
     //Port D,3          7 segment d
     //Port D,4          7 segment e
     //Port D,5          7 segment f
     //Port D,6          7 segment g
     //Port D,7          7 segment dp
     //Port E,0          d1 cathode
     //Port E,1          alarm output
     //Port E,2          alarm active indicator
unsigned char SEGMENT[] = {0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F,0xBF,0x86,0xDB,0xCF,0xE6,0xED,0xFD,0x87,0xFF,0xEF,0x40,0x00};
unsigned short digit_cathode=1;
unsigned long timebase=625;
unsigned short ep_=132;
unsigned short d1=1,d2=2,d3=3,d4=4,d5=5,d6=6,d7=7,d5c=0;
unsigned int colon=0;
unsigned int seconds_counter=60;
unsigned int minutes_counter=60;
unsigned int minute_occurred_flag=0;
unsigned int hour_occurred_flag=0;
unsigned int day_occurred_flag=0;
unsigned int year_occurred_flag=0;
unsigned long minutes_from_1stJan=1440;
unsigned long minutes_from_1stJan_adj=1440;
unsigned long snooze_alarm=700000;
unsigned long current_minutes=0;
unsigned long current_hour=0;
unsigned long current_day_number=1;
unsigned short BST_mode=0;
unsigned char d_string[12];
unsigned char td_string[12];
unsigned int portread;
unsigned int year=2009;
unsigned int found_month=1;
unsigned int found_date=1;
unsigned int found_month_1=1;
unsigned int found_date_1=1;
unsigned char temp_chr[5];
int entered_hours=0;
int entered_minutes=0;
unsigned short working_days=5; /*may be changed to 6 or 7 in set up*/
unsigned int leap_year=0;
unsigned long day_number;
unsigned int get_day_number (unsigned int month, unsigned int date);
unsigned int weekday=0;
unsigned int working_days_left=0;
unsigned long BST_start;
unsigned long BST_finish;
unsigned long BST_start_minutes=0;
unsigned long BST_finish_minutes=0;
unsigned int non_working_days[171];
unsigned int nwd_draft[171];
unsigned int easter_month=0;
unsigned int easter_date=0;
unsigned int century=0;
unsigned short countrycode=5; /* 1 =  England & UK, 2 = UK but not England, 3 = Christmas only, 4 = no Bank Holidays 5 = No Bank Holidays but with BST adj */
unsigned int counter=0;
unsigned counter1=0;
unsigned int working_day_flag=0;
unsigned int nwd_flag=0;
unsigned int day_count=0;
unsigned previous_day_number=1; /*needs to be 1, not zero, to calc wkg dates on switch on 1st Jan 00:00*/
unsigned int alarm_hours[10];
unsigned int alarm_minutes[10];
unsigned int alarm_weekdays[10];
unsigned int chirp_flag=0;

void seven_write (void);
void trim_timebase(void);
void set_time(void);
void ty_message(void);
void display_year(void);
void display_month(void);
void display_time(void);
void display_date(void);
void check_leap_year (void);
void display_day(unsigned int daydisp);
void daily_display_routine(void);
void day_to_month_and_date (unsigned int day_to_check);
void find_BST (void);
unsigned short day_of_week(unsigned int year, unsigned int month, unsigned int date);
void process_year_calcs(void);
void find_non_working_days (void);
void find_easter(void);
void display_cm(unsigned short countrycode);
unsigned long ep_read(unsigned int eadd);
void ep_write(unsigned int eadd, unsigned short bytew);
void alarm_set(void);
void normal_lcd_display(void);
void set_alarm_indicator (void);
void clear_alarm_indicator (void);
void set_alarm_output (void);
void clear_alarm_output (void);
void calculate_time_from_minutes(void);

void interrupt()
      {
      /*Clock = 20Mhz, this interrupt occurs every 1600us (time =  (4* clock period) * Prescaler * (256-TMR0L+1)*/
      INTCON=0x20;          /*set T0IE and clear T0IF*/
      TMR0L=132;            /*reload TMR0*/
      timebase--;
      if(timebase==100) TMR0L=ep_;
      seven_write();
      digit_cathode++;
      if (digit_cathode==8) digit_cathode=1;
      if (timebase==1)
         {
         timebase=625;
         if (d7==10) d7=0;
         colon=~colon;
         seconds_counter--;
         if (chirp_flag==1)
             {
             clear_alarm_output();
             clear_alarm_indicator();
             chirp_flag=0;
             }
         if (seconds_counter==0)
            {
            seconds_counter=60;
            minute_occurred_flag=1;
            minutes_from_1stJan++;
            }
         }
      }

void main()
     {
     INTCON=0b00000000;
     /*Set up ports*/
     TRISA=0b00000000;      /*all outputs*/
     TRISB=0b11000000;      /*only RB6 and RB7 is an input */
     TRISC=0b11111111;      /*all inputs*/
     TRISD=0b11111111;      /*RD0 to RD7 are inputs until modified by seven_write*/
     TRISE=0b00000000;      /*set PORT E as all outputs except E,2 which drives a display dp*/
     CMCON=0b00000111;      /* turn off comparators*/
     ADCON0=0;
     ADCON1=0b00001111;     /*make PORTA & E digital*/
     /*Configure TMR0 Interrupt*/
     T0CON=0xC3;            /*Prescaler = 16*/
     TMR0L=131;             /*load TMR0*/
     INTCON=0xa0;           /*Enable TMR0 interrupt*/
     /*Clear Ports*/
     PORTA=0;
     PORTB=0;
     PORTC=0;
     PORTD=0;
     PORTE=0;
     asm{bsf INTCON2,7};    /*disable PORTB weak pullups*/
     asm{bcf PORTE,7};      /*disable PORTD weak pullup*/
     asm{bsf PORTE,1};      /*make sure alarm sounder is off*/
     /*Configure LCD and show splash message*/
     Lcd_Config(&PORTB, 4, 5, 7, 3, 2, 1, 0);
     Lcd_Init(&PORTB);
     Lcd_Cmd(Lcd_CLEAR);
     Lcd_Cmd(LCD_CURSOR_OFF);
     Lcd_Out(1, 1, "Alarm Clock v2");
     Lcd_Out(2,2, "Dave Geary 2009");
     ep_=ep_read(1);
     if (ep_==255) ep_=132;  /*sets default value for 20Mhz clock */
     delay_ms(500);
     d1=20;
     d2=20;
     d3=20;
     d4=0;
     d5=0;
     d6=0;
     d7=0;
     /*clear any odd data in alarms*/
     for(counter=0;counter<10;counter++)
         {
         alarm_weekdays[counter]=9;
         alarm_hours[counter]=0;
         alarm_minutes[counter]=0;
         }
     /*make sure alarm active indicator is out*/
     clear_alarm_indicator();
     roloop:

     /*Read buttons*/
     portread=PORTC&0b11000111;           //read PORTC button bits only
     if (portread==1) set_time();
     if (portread==6) trim_timebase();
     if (portread==64) alarm_set();
     if (portread==128)
        {
        lcd_cmd(lcd_clear);
        lcd_out(1,1,"Snooze 10 mins");
        delay_ms(330);
        normal_lcd_display();
        clear_alarm_output();
        set_alarm_indicator();            /*necessary in case Snooze function called without an alarm going off previously*/
        snooze_alarm=minutes_from_1stJan_adj+10;
        delay_ms(1000);
        }
     LATB=0;
     PORTB=0;
     portread=0;
     portread=PORTB&0b01000000;           //read PORTB button bits only
     if (portread==64)
        {
        normal_lcd_display();
        clear_alarm_indicator();
        clear_alarm_output();
        snooze_alarm=700000;              /*a value that will never be reached (minutes_from_1stJan) so can never go off when not required*/
        }

     /*Per Minute*/
     if (minute_occurred_flag==1)
        {
        minutes_counter--;
        minute_occurred_flag=0;
        if (minutes_counter<=0)
           {
           minutes_counter=60;
           hour_occurred_flag=1;
           }
        calculate_time_from_minutes();
        /*check alarms*/
        for (counter=1;counter<10;counter++)
            {
            if( (alarm_weekdays[counter]==weekday) || ((working_day_flag==1)&&(alarm_weekdays[counter]==7)) || ((working_day_flag==0)&&(alarm_weekdays[counter]==8)) || (alarm_weekdays[counter]==10) )
                {
                if ((alarm_hours[counter]==current_hour)&&(alarm_minutes[counter]==current_minutes))
                   {
                   inttostr(counter,td_string);
                   Lcd_Cmd(Lcd_CLEAR);
                   Lcd_Out(1, 1, "Alarm!");
                   lcd_out(1,6,td_string);
                   set_alarm_indicator();
                   set_alarm_output();
                   if (alarm_weekdays[counter]==10) chirp_flag=1;
                   }
                }
            }

        if (snooze_alarm==minutes_from_1stJan_adj)
           {
           Lcd_Cmd(Lcd_CLEAR);
           Lcd_Out(1, 1, "Snooze Alarm!");
           set_alarm_output();
           }
        }

     /*Per Hour*/
     if (hour_occurred_flag==1)
        {
        hour_occurred_flag=0;
        if (current_hour==0) day_occurred_flag=1;

      /*find if BST in operation*/
      BST_mode=0;       /*BST mode is 0 for GMT, and 1 for BST*/
      if((minutes_from_1stJan>(BST_start_minutes-1))&&(minutes_from_1stJan<BST_finish_minutes)&&((countrycode<3)||(countrycode==5))) BST_mode=1;
        }
        
     /*Per Day*/
     if (day_occurred_flag==1)
        {
        daily_display_routine();
        day_occurred_flag=0;
        /*check if the end of the year has been reached*/
        if ((leap_year==0)&&(minutes_from_1stJan>525599)) year_occurred_flag=1;
        if (minutes_from_1stJan>527039) year_occurred_flag=1;
        }

     /*Per Year*/
     if (year_occurred_flag==1)
        {
        year_occurred_flag=0;
        minutes_from_1stJan=0;
        minutes_from_1stJan_adj=0;
        seconds_counter=0;
        minutes_counter=0;
        year++;
        daily_display_routine();
        }
        
     goto roloop;
     }

/*following is called during interupt to multiplex the seven segement displays*/
            
void seven_write (void)
     {
     /*the displayed digit is controlled by the global variable digit_cathode*/
     /*a tristate output is effected using TRIS*/
    d5c=d5;
    if (colon==0) d5c=d5+10;
    asm {
    clrf PORTA
    bcf PORTE,0
    }
    switch (digit_cathode)
           {
           case 1:   TRISD=~SEGMENT[d3];PORTD=SEGMENT[d3];asm{bsf PORTE,0};break;
           case 2:   TRISD=~SEGMENT[d2];PORTD=SEGMENT[d2];asm{bsf PORTA,5};break;
           case 3:   TRISD=~SEGMENT[d1];PORTD=SEGMENT[d1];asm{bsf PORTA,4};break;
           case 4:   TRISD=~SEGMENT[d7];PORTD=SEGMENT[d7];asm{bsf PORTA,3};break;
           case 5:   TRISD=~SEGMENT[d6];PORTD=SEGMENT[d6];asm{bsf PORTA,2};break;
           case 6:   TRISD=~SEGMENT[d5c];PORTD=SEGMENT[d5c];asm{bsf PORTA,1};break;
           case 7:   TRISD=~SEGMENT[d4];PORTD=SEGMENT[d4];asm{bsf PORTA,0};break;
           }
    }

/*following deal with setting the alarms*/

void alarm_set(void)
     {
     /*alarms are defined by three strings -weekday, hours, minutes. The weekday is 0 to 6 (Sunday to Saturday),
     plus 7 for working days, 8 for non-working days, and 9 for alarm off. 10 means a quick "chirp" on a working day*/
     counter=1;
     alarmselect:
     delay_ms(250);                            /*short debounce delay*/
     Lcd_Cmd(Lcd_CLEAR);
     Lcd_Out(1,1,"Alarm Set");
     while (counter<10)
        {
        inttostr(counter,td_string);
        lcd_out(2,11,td_string);
        portread=PORTC&0b10000111;           //read PORTC, bottom three bits only
        if (portread==2)
           {
           if (counter<9) counter++;
           delay_ms(50);
           }
        if (portread==4)
           {
           if (counter>1) counter--;
           delay_ms(50);
           }
        if (portread==1)
           {
           lcd_out(1,1,"Set weekday");
           counter1=alarm_weekdays[counter];
           display_day(counter1);
           delay_ms(75);
           get_alarmday:
           portread=PORTC&0b10000111;           //read PORTC, masked bits only
           if (portread==2)
              {
              if (counter1<10) counter1++;
              display_day(counter1);
              delay_ms(50);
              }
           if (portread==4)
              {
              if (counter1>0) counter1--;
              display_day(counter1);
              delay_ms(50);
              }
           if (portread==1)
              {
              alarm_weekdays[counter]=counter1;
              goto got_alarmday;
              }
           if (portread==128) goto alarmselect;          /*escape back to selecting alarm number by pressing "Snooze"*/
           goto get_alarmday;
           got_alarmday:
           ty_message();
           lcd_out(1,1,"Set hours   ");
           entered_hours=alarm_hours[counter];
           entered_minutes=alarm_minutes[counter];
           display_time();
           get_alarmhours:
           portread=PORTC&0b10000111;           //read PORTC, bottom three bits only
           if (portread==2)
              {
              entered_hours++;
              if (entered_hours>23) entered_hours=0;
              display_time();
              delay_ms(50);
              }
           if (portread==4)
              {
              entered_hours--;
              if (entered_hours<0) entered_hours=23;
              display_time();
              delay_ms(50);
              }
           if (portread==1)
              {
              alarm_hours[counter]=entered_hours;
              goto got_alarmhours;
              }
           goto get_alarmhours;
           got_alarmhours:
           ty_message();
           lcd_out(1,1,"Set minutes ");
           display_time();
           get_alarmmins:
           portread=PORTC&0b10000111;           //read PORTC, bottom three bits only
           if (portread==2)
              {
              entered_minutes++;
              if (entered_minutes>59) entered_minutes=0;
              display_time();
              delay_ms(50);
              }
           if (portread==4)
              {
              entered_minutes--;
              if (entered_minutes<0) entered_minutes=59;
              display_time();
              delay_ms(50);
              }
           if (portread==1)
              {
              alarm_minutes[counter]=entered_minutes;
              goto got_alarmmins;
              }
           goto get_alarmmins;
           got_alarmmins:
           ty_message();
           delay_ms(25);
           Lcd_Cmd(Lcd_CLEAR);
           Lcd_Out(1,1,"Alarm Set");
           }
        if (portread==128) counter=10;          /*exit this routine by pressing "Snooze"*/
        }
        portread=0;                             /*clear old data from portread*/
        lcd_out(1,1,"Exiting Alarm   ");
        delay_ms(500);                          /*avoid setting snooze accdientally*/
        normal_lcd_display();
        calculate_time_from_minutes();          /*update time display*/
     }

/*these routines set the alarm indicator LED and control the alarm output*/

void set_alarm_indicator (void)
     {
     asm{
     bcf TRISE,2;
     bsf PORTE,2}
     }
     
void clear_alarm_indicator (void)
     {
     asm{
     bsf TRISE,2;
     bcf PORTE,2}
     }

void set_alarm_output (void)
     {
     asm{
     bcf PORTE,1}
     }

void clear_alarm_output (void)
     {
     asm{
     bsf PORTE,1}
     }

/*following subroutines provide daily LCD and working days display updates*/

void daily_display_routine(void)
     {
     /*first part of this routine calculates the number of working days left*/
     nwd_flag=0;
     day_count=365;
     if (leap_year==0) day_count=366;
     working_days_left=day_count-current_day_number;
     for (counter=day_count;counter>current_day_number;counter--)
         {
         for (counter1=0;counter1<171;counter1++)
             {
             if (non_working_days[counter1]==counter) nwd_flag=1;
             if (nwd_flag==1)
                {
                nwd_flag=0;
                working_days_left--;
                break;
                }
             }
         }

     /*finally find if today is a working day so that the alarm is sounded accordingly*/

     working_day_flag=1;
     for (counter1=0;counter1<171;counter1++)
         {
         if (non_working_days[counter1]==current_day_number) working_day_flag=0;
         }
     d1=working_days_left/100;
     d2=(working_days_left-(d1*100))/10;
     d3=working_days_left%10;

     day_to_month_and_date (current_day_number);                /* Get data for LCD display*/
     weekday=day_of_week(year,found_month,found_date);
     normal_lcd_display();
     }

void normal_lcd_display(void)
     {
     /*handle LCD display*/
     switch (weekday)
            {
            case 0: lcd_out(1,1,"Sunday       "); break;
            case 1: lcd_out(1,1,"Monday       "); break;
            case 2: lcd_out(1,1,"Tuesday      "); break;
            case 3: lcd_out(1,1,"Wednesday    "); break;
            case 4: lcd_out(1,1,"Thursday     "); break;
            case 5: lcd_out(1,1,"Friday       "); break;
            case 6: lcd_out(1,1,"Saturday     "); break;
            }

     switch(BST_mode)
            {
            case 0:lcd_out(1,14,"GMT");break;
            case 1:lcd_out(1,14,"BST");break;
            }

     display_year();
     display_date();
     display_month();
     }

void display_year(void)
     {
     IntToStr(year,d_string);
     temp_chr[0]=d_string[2];
     temp_chr[1]=d_string[3];
     temp_chr[2]=d_string[4];
     temp_chr[3]=d_string[5];
     lcd_out(2,13,temp_chr);
     }

void display_month(void)
     {
     switch (found_month)
            {
            case 1: lcd_out_cp (" January  "); break;
            case 2: lcd_out_cp (" February "); break;
            case 3: lcd_out_cp (" March    "); break;
            case 4: lcd_out_cp (" April    "); break;
            case 5: lcd_out_cp (" May      "); break;
            case 6: lcd_out_cp (" June     "); break;
            case 7: lcd_out_cp (" July     "); break;
            case 8: lcd_out_cp (" August   "); break;
            case 9: lcd_out_cp (" Septembr "); break;
            case 10: lcd_out_cp(" October  "); break;
            case 11: lcd_out_cp(" November "); break;
            case 12: lcd_out_cp(" December "); break;
            }
      }

void display_time(void)
     {
     unsigned char td_string[12];
     int j=0;
     int i=0;

     ShortToStr(entered_hours,td_string);
     for(i=0;i<=11;i++)d_string[i]=0;
     for(i=0;i<=11;i++)
        {
        if(td_string[i]!=' ')
             {
             d_string[j]=td_string[i];
             j++;
             }
        }
     if (entered_hours<10)
        {
        lcd_out(2,1,"0");
        lcd_out(2,2,d_string);
        }
     if (entered_hours>9) lcd_out(2,1,d_string);

     ShortToStr(entered_minutes,td_string);
     j=0;
     for(i=0;i<=11;i++)d_string[i]=0;
     for(i=0;i<=11;i++)
        {
        if(td_string[i]!=' ')
             {
             d_string[j]=td_string[i];
             j++;
             }
        }
     if (entered_minutes<10)
        {
        lcd_out(2,4,"0");
        lcd_out(2,5,d_string);
        }
     if (entered_minutes>9) lcd_out(2,4,d_string);

     lcd_out(2,3,":");
     }

void display_date(void)
     {
     int j=0;
     int i=0;
     ShortToStr(found_date,td_string);
     for(i=0;i<=11;i++)d_string[i]=0;
     for(i=0;i<=11;i++)
        {
        if(td_string[i]!=' ')
             {
             d_string[j]=td_string[i];
             j++;
             }
        }
     if (found_date<10)
        {
        lcd_out(2,1,"0");
        lcd_out(2,2,d_string);
        }
     if (found_date>9) lcd_out(2,1,d_string);

     }

void display_day(unsigned int daydisp)
     {
     switch (daydisp)
            {
            case 0: lcd_out(2,1,"Sunday       "); break;
            case 1: lcd_out(2,1,"Monday       "); break;
            case 2: lcd_out(2,1,"Tuesday      "); break;
            case 3: lcd_out(2,1,"Wednesday    "); break;
            case 4: lcd_out(2,1,"Thursday     "); break;
            case 5: lcd_out(2,1,"Friday       "); break;
            case 6: lcd_out(2,1,"Saturday     "); break;
            case 7: lcd_out(2,1,"Working      "); break;
            case 8: lcd_out(2,1,"Non-Working  "); break;
            case 9: lcd_out(2,1,"Off          "); break;
            case 10: lcd_out(2,1,"Chirp        "); break;
            }
     }

void display_cm(unsigned short countrycode)
     {
     switch (countrycode)
            {
            case 1: lcd_out(2,1,"UK England   "); break;
            case 2: lcd_out(2,1,"UK (not Eng) "); break;
            case 3: lcd_out(2,1,"Christmas    "); break;
            case 4: lcd_out(2,1,"No Bank Hol  "); break;
            case 5: lcd_out(2,1,"No BH + BST  "); break;
            }
     }

void ty_message(void)
     {
     lcd_cmd(Lcd_CLEAR);
     Lcd_Out(1,1,"Thank you");
     delay_ms(75);
     }

/*Following subroutines allow time and date to be set*/

void set_time(void)
     {
     /*reload from current time*/
     current_day_number=(Minutes_from_1stJan_adj/1440);
     if (current_day_number>365) current_day_number=365;
     day_to_month_and_date(current_day_number);
     if (found_month>12) found_month=12;
     if (found_month<0) found_month=1;
     if (found_date>31) found_date=31;
     if (found_date<0) found_date=1;
     entered_hours=current_hour;
     entered_minutes=current_minutes;
     Lcd_Cmd(Lcd_CLEAR);
     delay_ms(75);
     Lcd_Out(1,1,"Select Year");
     get_year:
     portread=PORTC&0b00000111;           //read PORTC, bottom three bits only
     if (portread==2) year++;
     if (portread==4) year--;
     if (portread==1) goto got_year;
     display_year();
     delay_ms(75);
     goto get_year;
     got_year:
     ty_message();
     check_leap_year();
     Lcd_Cmd(Lcd_CLEAR);
     /*following abuses some global variables then calculates values, e.g. minutes_from_1stJan*/
     Lcd_Out(1,1,"Select Month");
     get_month:
     portread=PORTC&0b00000111;           //read PORTC, bottom three bits only
     if (portread==2) found_month++;
     if (portread==4) found_month--;
     if (found_month==0) found_month=1;
     if (found_month==13) found_month=12;
     if (portread==1) goto got_month;
     lcd_out(2,3,"");
     display_month();
     delay_ms(75);
     goto get_month;
     got_month:
     ty_message();

     Lcd_Cmd(Lcd_CLEAR);
     Lcd_Out(1,1,"Select Date");
     get_date:
     portread=PORTC&0b00000111;           //read PORTC, bottom three bits only
     if (portread==2) found_date++;
     if (portread==4) found_date--;
     if (found_date==0) found_date=31;
     if (found_date==32) found_date=1;
     if (portread==1) goto got_date;
     lcd_out(2,3,"");
     display_date();
     delay_ms(75);
     goto get_date;
     got_date:
     ty_message();

     Lcd_Cmd(Lcd_CLEAR);
     Lcd_Out(1,1,"Hours (24hr)");
     get_hours:
     portread=PORTC&0b00000111;           //read PORTC, bottom three bits only
     if (portread==2) entered_hours++;
     if (portread==4) entered_hours--;
     if (entered_hours==24) entered_hours=0;
     if (entered_hours==-1) entered_hours=23;
     if (portread==1) goto got_hours;
     display_time();
     delay_ms(75);
     goto get_hours;
     got_hours:
     ty_message();

     Lcd_Cmd(Lcd_CLEAR);
     Lcd_Out(1,1,"Minutes");
     get_minutes:
     portread=PORTC&0b00000111;           //read PORTC, bottom three bits only
     if (portread==2) entered_minutes++;
     if (portread==4) entered_minutes--;
     if (entered_minutes==60) entered_minutes=0;
     if (entered_minutes==-1) entered_minutes=59;
     if (portread==1) goto got_minutes;
     display_time();
     delay_ms(75);
     goto get_minutes;
     got_minutes:
     ty_message();

     Lcd_Cmd(Lcd_CLEAR);
     Lcd_Out(1,1,"Working Days/wk");
     get_wd:
     portread=PORTC&0b00000111;           //read PORTC, bottom three bits only
     if (portread==2) working_days++;
     if (portread==4) working_days--;
     if (working_days==8) working_days=7;
     if (working_days<5) working_days=5;
     if (portread==1) goto got_wd;
     ShortToStr(working_days,d_string);
     lcd_out(2,0,d_string);
     delay_ms(75);
     goto get_wd;
     got_wd:
     ty_message();

     countrycode=ep_read(0);
     if ((countrycode<1)||(countrycode>5)) countrycode=5;
     Lcd_Cmd(Lcd_CLEAR);
     Lcd_Out(1,1,"Country Mode");
     get_cm:
     portread=PORTC&0b00000111;           //read PORTC, bottom three bits only
     if (portread==2) countrycode++;
     if (portread==4) countrycode--;
     if (countrycode>5) countrycode=5;
     if (countrycode<1) countrycode=1;
     if (portread==1) goto got_cm;
     display_cm(countrycode);
     delay_ms(75);
     goto get_cm;
     got_cm:
     ep_write(0,countrycode);
     ty_message();

     /*following protects variables so they can be recovered after the next process for later use*/
     found_month_1=found_month;
     found_date_1=found_date;

     Lcd_Cmd(Lcd_CLEAR);
     Lcd_Out(1,1,"Manual NWD");
     counter=1;
     counter1=0;         /*used as temporary day counter*/
     while (counter<41)
        {
        inttostr(counter,td_string);
        lcd_out(2,11,td_string);
        portread=PORTC&0b10000111;           //read PORTC, bottom three bits only
        if ((portread==1)&&(counter1==0))       /*clears down any manually entered non working days if select is pressed before any selection is made*/
           {
           lcd_out(1,1,"Clearing Man NWD");
           lcd_out(2,1,"  Please Wait   ");
           for(counter=0;counter<41;counter++)
              {
              ep_write((counter+100),255);
              ep_write((counter+150),255);
              }
           counter=41; /*break out of this routine*/
           }
        if (portread==2)
           {
           if(counter==0) counter=1;
           if(counter1<365) counter1++;
           day_to_month_and_date(counter1);
           display_date();
           display_month();
           delay_ms(50);
           }
        if (portread==4)
           {
           if(counter==0) counter=1;
           if(counter1>1) counter1--;
           day_to_month_and_date(counter1);
           display_date();
           display_month();
           delay_ms(50);
           }
        if (portread==1)
           {
           ty_message();
           ep_write((counter+100),counter1/256);
           ep_write((counter+150),counter1%256);
           counter++;
           delay_ms(175);
           }
        if (portread==128) counter=41;          /*exit this routine by pressing "Snooze"*/
           
        }
     portread=0;                                /*clear old data from portread*/

     lcd_cmd(Lcd_CLEAR);
     Lcd_Out(1,1,"Calculating...");
     lcd_out(2,1,"  Please Wait   ");
     /*recover variables*/
     found_month=found_month_1;
     found_date=found_date_1;
     /*turn this entered information into minutes_from_1stJan*/
     current_day_number=get_day_number(found_month, found_date);
     day_number=current_day_number;

     if (leap_year==0) day_number=day_number+1;

     minutes_from_1stJan=(entered_hours*60)+entered_minutes;
     minutes_from_1stJan=minutes_from_1stJan+(day_number*1440);

     process_year_calcs();
     /*mirror this new data in some key variables*/
     calculate_time_from_minutes();
     seconds_counter=60;
     daily_display_routine();
     }

void calculate_time_from_minutes(void)
     {
     BST_mode=0;       /*BST mode is 0 for GMT, and 1 for BST*/
     if((minutes_from_1stJan>(BST_start_minutes-1))&&(minutes_from_1stJan<BST_finish_minutes)&&((countrycode<3)||(countrycode==5))) BST_mode=1;
     minutes_from_1stJan_adj=minutes_from_1stJan;
     if (BST_mode==1) minutes_from_1stJan_adj=minutes_from_1stJan_adj+60;
     minutes_from_1stJan_adj=minutes_from_1stJan;
     if (BST_mode==1) minutes_from_1stJan_adj=minutes_from_1stJan_adj+60;
     /*break down minutes_from_1stJan into current day number, then hours, then minutes*/
     current_day_number=minutes_from_1stJan_adj/1440;
     current_hour=(minutes_from_1stJan_adj-(current_day_number*1440))/60;
     current_minutes=(minutes_from_1stJan_adj-(current_day_number*1440)-(current_hour*60));
     d7=current_minutes%10;
     d6=current_minutes/10;
     d5=current_hour%10;
     d4=current_hour/10;
     minutes_counter=60-current_minutes;
     }

/*Following subroutines provide calendar calculations*/

void process_year_calcs(void)
     {
     find_non_working_days();
     find_BST();
     BST_start_minutes=((BST_Start-1)*1440)+60;
     BST_finish_minutes=((BST_Finish-1)*1440)+60;
     if (leap_year==0) BST_start_minutes=BST_start_minutes+1440;
     if (leap_year==0) BST_finish_minutes=BST_finish_minutes+1440;
     /*correct for entering time during BST*/
     if((minutes_from_1stJan>(BST_start_minutes-1))&&(minutes_from_1stJan<BST_finish_minutes)) minutes_from_1stJan=minutes_from_1stJan-60;
     }

void find_non_working_days(void)
          {
          /*requires global variables weekday, leap_year, non-working_days array*/
          unsigned int temp_day_number=0;
          unsigned int max_days=365;
          unsigned int array_counter=0;
          unsigned short daycheck=0;
          if (leap_year==0) max_days=366;

          /*set up array with non valid, non nil values*/
          for (counter=0;counter<171;counter++) non_working_days[counter]=999;
          /*add Saturdays*/
          if (working_days<6)
             {
             for (temp_day_number=0; temp_day_number<max_days; temp_day_number++)
                 {
                 day_to_month_and_date(temp_day_number);
                 day_of_week (year, found_month, found_date);
                 if (weekday==6)
                    {
                    non_working_days[array_counter]=temp_day_number;
                    array_counter++;
                    }
                 }
             }
          /*add Sundays*/
          if (working_days<7)
             {
             for (temp_day_number=0; temp_day_number<max_days; temp_day_number++)
                 {
                 day_to_month_and_date(temp_day_number);
                 day_of_week (year, found_month, found_date);
                 if (weekday==0)
                    {
                    non_working_days[array_counter]=temp_day_number;
                    array_counter++;
                    }
                 }
             }
          if (countrycode>3) goto  skip_bank_holiday_calcs;
          /*add set dates - New Years Day, Christmas Day, Boxing Day*/
          if (countrycode<3)
             {
             get_day_number(1,1);
             day_of_week(year,1,1);
             if (weekday==0) day_number=day_number+1;      /*allows for 1st January if it falls on a Sunday*/
             if (weekday==6) day_number=999;               /*if New Years Day is a Saturday, then this calc is void as the BH is taken in the previous year*/
             non_working_days[array_counter]=day_number;
             array_counter++;
             }
          get_day_number(12,25);
          day_of_week(year,12,25);
          if (weekday==0) day_number=day_number+1;      /*allows for 25th December if it falls on a weekend*/
          if (weekday==6) day_number=day_number-1;
          non_working_days[array_counter]=day_number;
          array_counter++;
          get_day_number(12,26);
          day_of_week(year,12,26);
          if (weekday==0) day_number=day_number+1;     /*allows for 26th December if it falls on a weekend*/
          if (weekday==6) day_number=day_number-1;
          non_working_days[array_counter]=day_number;
          array_counter++;
          /*add Easter Monday and Good Friday*/
          if (countrycode<3)
             {
             find_easter();
             get_day_number(easter_month, easter_date);
             non_working_days[array_counter]=day_number-2;
             array_counter++;
             non_working_days[array_counter]=day_number+5;
             array_counter++;
             /*find first Monday in May*/
             temp_day_number=get_day_number(5,1);
             for(temp_day_number=day_number; temp_day_number<day_number+7;temp_day_number++)
                {
                day_to_month_and_date(temp_day_number);
                weekday=day_of_week(year,found_month,found_date);
                if (weekday==1)
                   {
                   non_working_days[array_counter]=temp_day_number;
                   array_counter++;
                   }
                }
                /*find last Monday in May*/
              temp_day_number=get_day_number(5,31);
              for(temp_day_number=day_number; temp_day_number>day_number-7;temp_day_number--)
                {
                day_to_month_and_date(temp_day_number);
                weekday=day_of_week(year,found_month,found_date);
                if (weekday==1)
                   {
                   non_working_days[array_counter]=temp_day_number;
                   array_counter++;
                   }
                }
               }
           /*find last Monday in August*/
          if (countrycode==1)
             {
             temp_day_number=get_day_number(8,31);
             for(temp_day_number=day_number; temp_day_number>day_number-7;temp_day_number--)
                {
                day_to_month_and_date(temp_day_number);
                weekday=day_of_week(year,found_month,found_date);
                if (weekday==1)
                   {
                   non_working_days[array_counter]=temp_day_number;
                   array_counter++;
                   }
                }
              }
          skip_bank_holiday_calcs:
          /*now add Manual working days from eprom*/
          for (counter=1;counter<41;counter++)
              {
              temp_day_number=(256*ep_read(counter+100))+ep_read(counter+150);
              if (temp_day_number<365) /*this check ensures "cleared" memory locations are excluded*/
                 {
                 non_working_days[array_counter]=temp_day_number;
                 array_counter++;
                 }
              }
          lcd_out(1,1,"Checking data...");
          /*finally rationalise the non-working days array so that each day only appears once*/
          array_counter=0;
          for(counter=0;counter<367;counter++) /*runs through each day number*/
              {
              for(counter1=0;counter1<171;counter1++)  /*runs through each member of the array*/
              if (non_working_days[counter1]==counter)
                 {
                 nwd_draft[array_counter]=counter;
                 array_counter++;
                 }
              }
          lcd_out(1,1,"Copying data... ");
          for (counter1=0;counter1<171;counter1++) non_working_days[counter1]=999;                   /* clear data from non_working days array*/
          for (counter1=0;counter1<171;counter1++) non_working_days[counter1]=nwd_draft[counter1];   /* copy data from nwd_draft to non_working_days*/
          }


void find_easter(void)
          {
          unsigned int var_n=0;
          unsigned int var_i=0;
          unsigned int var_j=0;
          unsigned int var_k=0;
          unsigned int var_l=0;
          /*find date of Easter Sunday*/
          /*requires global variables century, year, easter_month, easter_date*/
          century=year/100;
          var_n=year-(19*(year/19));
          var_k=(century-17)/25;
          var_i=century-(century/4)-((century-var_k)/3)+(19*var_n)+15;
          var_i=var_i-(30*(var_i/30));
          var_i=var_i-((var_i/28)*((1-(var_i/28))*(29/(var_i+1))*((21-var_n)/11)));
          var_j=year+(year/4)+var_i+2-century+(century/4);
          var_j=var_j-(7*(var_j/7));
          var_l=var_i-var_j;
          easter_month=3+((var_l+40)/44);
          easter_date=var_l+28-(31*(easter_month/4));
          }

void find_BST (void)
          {
          /*requires global variables weekday, leap_year, BST_start, BST_finish */
          /*find last Sunday in March*/
          unsigned int temp_day_number=0;
          temp_day_number=get_day_number(3,31);
          for(temp_day_number=day_number; temp_day_number>day_number-7;temp_day_number--)
                {
                day_to_month_and_date(temp_day_number);
                weekday=day_of_week(year,found_month,found_date);
                if (weekday==0)
                   {
                   BST_start=temp_day_number;
                   break;
                   }
                }
           /*find last Sunday in October*/
          temp_day_number=get_day_number(10,31);
          for(temp_day_number=day_number; temp_day_number>day_number-7;temp_day_number--)
                {
                day_to_month_and_date(temp_day_number);
                weekday=day_of_week(year,found_month,found_date);
                if (weekday==0)
                   {
                   BST_finish=temp_day_number;
                   break;
                   }
                }
          }


unsigned short day_of_week(unsigned int year, unsigned int month, unsigned int date)
         {
         /*needs global variable weekday*/
         unsigned int temp=0;
         unsigned int greg_yr=0;
         unsigned int greg_m=0;
         unsigned int temp_1=0;
         temp=(14-month)/12;
         greg_yr=year-temp;
         greg_m=month+(12*temp)-2;
         weekday = date + greg_yr;
         weekday=weekday  + (greg_yr/4);
         weekday=weekday-(greg_yr / 100);
         weekday=weekday+ (greg_yr / 400);
         temp_1=greg_m*31;
         temp_1=temp_1/12;
         weekday=weekday + temp_1;
         weekday=weekday%7;
         return weekday;
         }

void day_to_month_and_date (unsigned int day_to_check)
          {
          /*requires global variables found_date, found_month, leap_year*/
          found_month=0;
          found_date=0;
          if (leap_year==0) day_to_check--;
          if (day_to_check>334)
             {
             found_month=12;
             day_to_check=day_to_check-334;
             goto finish
             }
          if (day_to_check>304)
             {
             found_month=11;
             day_to_check=day_to_check-304;
             goto finish
             }
          if (day_to_check>273)
             {
             found_month=10;
             day_to_check=day_to_check-273;
             goto finish
             }
          if (day_to_check>243)
             {
             found_month=9;
             day_to_check=day_to_check-243;
             goto finish
             }
          if (day_to_check>212)
             {
             found_month=8;
             day_to_check=day_to_check-212;
             goto finish
             }
          if (day_to_check>181)
             {
             found_month=7;
             day_to_check=day_to_check-181;
             goto finish
             }
          if (day_to_check>151)
             {
             found_month=6;
             day_to_check=day_to_check-151;
             goto finish
             }
          if (day_to_check>120)
             {
             found_month=5;
             day_to_check=day_to_check-120;
             goto finish
             }
          if (day_to_check>90)
             {
             found_month=4;
             day_to_check=day_to_check-90;
             goto finish
             }
          if (leap_year==0) day_to_check++;
          if (day_to_check>59)
             {
             found_month=3;
             day_to_check=day_to_check-59;
             goto finish
             }
          if (day_to_check>31)
             {
             found_month=2;
             day_to_check=day_to_check-31;
             goto finish
             }
          if (day_to_check>0)
             {
             found_month=1;
             goto finish
             }

          finish:
          found_date=day_to_check;
          }


unsigned int get_day_number (unsigned int month, unsigned int date)
         {
         /* needs global variable leap_year and day_number*/
         day_number=date;
         if (month>1) day_number=day_number+31;
         if (month>2)
            {
            day_number=day_number+28;
            if (leap_year==0) day_number++;
            }
         if (month>3) day_number=day_number+31;
         if (month>4) day_number=day_number+30;
         if (month>5) day_number=day_number+31;
         if (month>6) day_number=day_number+30;
         if (month>7) day_number=day_number+31;
         if (month>8) day_number=day_number+30;
         if (month>9) day_number=day_number+31;
         if (month>10) day_number=day_number+31;
         if (month>11) day_number=day_number+30;
         return day_number;
         }

void check_leap_year (void)
          {
          /*check if leap year, make leap_year=0 if it is*/
          /* requires global variable leap_year*/
          leap_year=year%4;
          if ((year%100)==0)
                  {
                  if ((year%400)==0) leap_year=5;
                  }
          if (leap_year>0) leap_year=1;
          }
/*Following subroutines read and write from eeprom, and allow entry of timebase trimming variable*/
    
unsigned long ep_read(unsigned int eadd)
         {
         unsigned short byter=0;
         byter = Eeprom_Read(eadd);
         delay_ms(20);
         return byter;
         }

void ep_write(unsigned int eadd, unsigned short bytew)
         {
         Eeprom_write(eadd,bytew);
         delay_ms(20);
         }

void trim_timebase(void)
         {
         unsigned short save_byte;
         signed long trim_display;
         unsigned int trim_post_dp=0;
         unsigned int trim_pre_dp=0;
         unsigned int j=0;
         unsigned int i=0;
         unsigned char ttd_string[12];
         lcd_cmd(LCD_CLEAR);
         lcd_out(1,1,"Trim (secs/day)");
         trimloop:
         if (ep_<132)
            {
            lcd_out(2,1,"+");                         /*display leading + sign*/
            trim_display=(((132-ep_)*8640000)/82500);
            }
         if (ep_==132)
            {
            lcd_out(2,1,"None      ");
            trim_display=0;
            }
         if (ep_>132)
            {
            lcd_out(2,1,"-");                         /*display leading minus sign*/
            trim_display=(((ep_-132)*8640000)/82500);
            }
         trim_post_dp=trim_display%100;
         inttostr(trim_post_dp,ttd_string);          /*calculates and converts post decimal point numbers*/
         
         for(j=0;j<=11;j++)
            {
            d_string[j]=0;                              /*clear any odd data*/
            td_string[j]=0;
            }
         j=0;                                        /*remove leading blanks from the conversion*/
         for(i=0;i<=11;i++)
            {
            if(ttd_string[i]!=' ')
                {
                d_string[j]=ttd_string[i];           /*now left with just the data required in d_string*/
                j++;
                }
            }
         
         trim_pre_dp=(trim_display-trim_post_dp)/100;
         inttostr(trim_pre_dp,ttd_string);          /*calculates and converts pre decimal point numbers*/
         
         j=0;                                        /*remove leading blanks from the conversion*/
         for(i=0;i<=11;i++)
            {
            if(ttd_string[i]!=' ')
                {
                td_string[j]=ttd_string[i];           /*now left with just the data required in d_string*/
                j++;
                }
            }
         
         strcat(ttd_string,".");
         if (trim_post_dp<10) strcat(ttd_string,"0");
         strncat(ttd_string, d_string,2);
         if (ep_!=132) lcd_out(2,2,ttd_string);

         portread=PORTC&0b00000111;           //read PORTC, bottom three bits only
         if (portread==1) goto finish_trim;
         if (portread==2) ep_--;
         if (portread==4) ep_++;
         if (ep_==0) ep_=1;
         if (ep_==255) ep_=254;
         delay_ms(25);
         goto trimloop;
         finish_trim:
         ty_message();
         save_byte=ep_;
         ep_write(1,save_byte);
         ep_=ep_read(1);
         portread=0;
         delay_ms(250);
         normal_lcd_display();
         }
