/* PIC18 XLCD peripheral routines.
 * Changes for Radiation Detector noted below
 *   Notes:
 *      - These libraries routines are written to support the
 *        Hitachi HD44780 LCD controller. */

// Interface type 4-bit with data in the upper nibble

// IF YOU CHANGE THE PROGRAMMING YOU MUST MAKE SURE THAT THE MEMORY ABOVE DATASTART IS STILL FREE OF PROGRAMMING
// OR CHANGE THE FOLLOWING LINE
#define DATASTART 0x5000  // LOCATION IN PROGRAM MEMORY WHERE DATA STARTS, ENDS AT DATASTART+ (MAXPOINTS*32)-1

// IF DATASTART IS CHANGED THEN MAXPOINTS MUST ALSO BE CHANGED
#if defined IS_18F2455
#define MAXPOINTS 125 // MAXIMUM NUMBER OF DATAPOINTS THAT WILL BE STORED IN PROGRAM MEMORY FOR 18F2455
#else
#define MAXPOINTS 375 // MAXIMUM NUMBER OF DATAPOINTS THAT WILL BE STORED IN PROGRAM MEMORY FOR 18F2550
#endif
// SYMBOLIC NAMES FOR I/O
#define RED_LED LATCbits.LATC6 
#define GREEN_LED LATCbits.LATC7
#define LCD_CONTROL LATBbits.LATB0
#define HV_MOSFET LATCbits.LATC2
 
/* DATA_PORT defines the port to which the LCD data lines are connected */
#define DATA_PORT      PORTB
#define TRIS_DATA_PORT TRISB

/* CTRL_PORT defines the port where the control lines are connected.
 * These are just samples, change to match your application.
 */
#define RS_PIN   PORTAbits.RA3   /* PORT for RS changed from default RBL*/
#define TRIS_RS  DDRAbits.RA3    /* TRIS for RS changed from default RBL */ 
#define RW_PIN   PORTAbits.RA2   /* PORT for RW changed from default RBL*/
#define TRIS_RW  DDRAbits.RA2    /* TRIS for RW changed from default RBL*/
#define E_PIN    PORTAbits.RA5   /* PORT for E  changed from default RBL*/
#define TRIS_E   DDRAbits.RA5    /* TRIS for E  changed from default RBL*/


#define PARAM_SCLASS auto
#define MEM_MODEL far  /* Change this to near for small memory model */

/* OpenXLCD
 * Configures I/O pins for external LCD
 */
void XOpenXLCD(void);

/* SetDDRamAddr
 * Sets the display data address
 */
void XSetDDRamAddr(PARAM_SCLASS unsigned char);

/* BusyXLCD
 * Returns the busy status of the LCD
 */
unsigned char XBusyXLCD(void);

/* ReadDataXLCD
 * Reads a byte of data
 */
char XReadDataXLCD(void);

/* WriteCmdXLCD
 * Writes a command to the LCD
 */
void XWriteCmdXLCD(PARAM_SCLASS unsigned char);

/* WriteDataXLCD
 * Writes a data byte to the LCD
 */
void XWriteDataXLCD(PARAM_SCLASS char);

/* putcXLCD
 * A putc is a write
 */
#define XputcXLCD WriteDataXLCD

/* putsXLCD
 * Writes a string of characters to the LCD
 */
void XputsXLCD(PARAM_SCLASS char *);

/* putrsXLCD
 * Writes a string of characters in ROM to the LCD
 */
void XputrsXLCD(PARAM_SCLASS const MEM_MODEL rom char *);

/* User defines these routines according to the oscillator frequency */
extern void DelayFor18TCY(void);
extern void DelayPORXLCD(void);
extern void DelayXLCD(void);
