; TEACHINC01.ASM 07JUN07 - TEACH IN 2008 PT3

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a list
                               ;  (LST) file

           __config  $3F30     ; internal 4MHz oscillator

           include p16f628.inc ; bring in all standard register values

DICE1      EQU h'20'     ; user register at 'h20' allocated as DICE1
DICE2      EQU h'21'     ; user register at 'h21' allocated as DICE2

           ORG 0         ; reset vector
           goto STARTIT
           ORG 4         ; Interrupt vector address
           goto STARTIT
           ORG 5         ; PIC program memory location at which to start 
           goto STARTIT

DICETABLE:
           andlw b'00000111' ; restrict val to first 3 bits (max val below 8)
           addwf PCL,F       ; add incoming val in W to program counter (PCL)
                             ; (incoming vals are below 8, so jumps beyond 7
                             ; not poss.
           retlw b'00000000' ; jump 0 (no dice LEDs to be on) 
           retlw b'00001000' ; jump 1 (dice LED to be on - bit 3)
           retlw b'00100010' ; jump 2 (dice LEDs to be on - bits 1 and 5)
           retlw b'00101010' ; jump 3 (dice LEDs to be on - bits 1, 3 and 5)
           retlw b'01100011' ; jump 4 (dice LEDs to be on - bits 0, 1, 5 and 6)
           retlw b'01101011' ; jump 5 (dice LEDs to be on - bits 0, 1, 3, 5 and 6)
           retlw b'01110111' ; jump 6 (dice LEDs to be on - bits 0, 1, 2, 4, 5, 6]
           retlw b'00000000' ; jump 7 (no dice LEDs to be on) 

STARTIT:   clrf PORTA        ; clear PORTA's output if any
           clrf PORTB        ; clear PORTB's output if any

           movlw $07         ; needed by some PICs, including PIC16F628
           movwf CMCON       ; so that PORTA is treated as digital port

           BANK1
           movlw b'00000000' ; all PORTA as output
           movwf TRISA       ; data direction register for PORTA
           movlw b'10000000' ; PORTB 0-6 as output, PORTB,7 as input
           movwf TRISB       ; data direction register for PORTB
           movlw B'00000000' ; pull-ups on (bit 7 = 0) (off if bit 7 = 1)
           movwf OPTION_REG
           BANK0

DICESTART: btfsc PORTB,7     ; is PORTB,7 low (= 0) (switch pressed) ? 
           goto DICESTART    ; no
           movlw b'00000011' ; yes, turn off DICE1 and DICE2 displays
           movwf PORTA       ; via PORTA
           clrf DICE1        ; clear DICE1 to zero
           clrf DICE2        ; clear DICE2 to zero
           clrf PORTB        ; clear PORTB to zero to turn off any LEDs

DICELOOP:  movlw 7           ; add 7 (a prime number) to DICE1
	   addwf DICE1,F
           movlw 3           ; add 3 (a prime number) to DICE2
	   addwf DICE2,F
           btfss PORTB,7     ; is PORTB,7 hi (= 1) yet (switch released)?
           goto DICELOOP     ; no, continue looping

SHOWDICE:
           movlw B'00000010' ; turn off DICE2, turn on DICE1
           movwf PORTA       ; via PORTA
           movf DICE1,W      ; get value in DICE1
           andlw b'00000111' ; restrict value to first 3 bits (max val below 8)
           call DICETABLE    ; call value conversion table
           bsf PORTA,0       ; turn off DICE1
           movwf PORTB       ; put resulting value in W out to PORTB
           movlw B'00000001' ; turn on DICE2, turn off DICE1
           movwf PORTA       ; via PORTA
           movf DICE2,W      ; get value in DICE2
           andlw b'00000111'  ; restrict value to first 3 bits (max val below 8)
           call DICETABLE    ; call value conversion table
           bsf PORTA,1       ; turn off DICE2
           movwf PORTB       ; put resulting value in W out to PORTB
           btfsc PORTB,7     ; is switch S2 pressed (PORTB bit 7 clear)?
           goto SHOWDICE     ; no, so repeat multiplexed dice show      
           goto DICESTART    ; yes, go back to DICESTART, and do another dice throw

           END                 ; end of program code












