	NOLIST 
;Macros to shift values, 16 bit. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

;ShiftLeftVK16 
;ShiftRightVK16 
;ShiftRightVK16U 

;A little care is needed to shift 16 bit numbers. 
;These simple macros help get it right. 
;It is also useful to have the number of shifts 
;as a parameter, so that this can be changed easily, 
;instead of deleting or copying lines of explicit code. 

;There is only one macro to shift left.
;Shift left can cause overflow, 
;and this must be detected explicitly 
;outside of the ShiftLeft macro.

;There are two macros to shift right.
;For unsigned numbers, 
;the bit shifted in at the left from carry 
;is always zero.
;For signed numbers, 
;the bit shifted in at the left from carry 
;is always the same as the MSB.

ShiftLeftVK16 MACRO Var1,Kount 
	variable ThisKount 
ThisKount = 0 
	WHILE ThisKount < Kount 
	addlw 0 
	rlf Var1+1,f 
	rlf Var1,f 
ThisKount += 1 
	ENDW 
	ENDM 

ShiftRightVK16 MACRO Var1,Kount 
	variable ThisKount 
ThisKount = 0 
	WHILE ThisKount < Kount 
	rlf Var1,w 
	rrf Var1,f 
	rrf Var1+1,f 
ThisKount += 1 
	ENDW 
	ENDM 

ShiftRightVK16U MACRO Var1,Kount 
	variable ThisKount 
ThisKount = 0 
	WHILE ThisKount < Kount 
	addlw 0 
	rrf Var1,f 
	rrf Var1+1,f 
ThisKount += 1 
	ENDW 
	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

	LIST 



