; Universal PIC LCD Interface Module
; 4-bit LCD test program
; By P. Pemberton, Jr.
; WWW: http://www.philpem.dsl.pipex.com/
; Email: philpem@despammed.com (replace "despammed" with "dsl.pipex" if you
; want, both addresses are valid)
; This software is distributed under the BSD License. You are free to do whatever
; you want with this code, but I would appreciate an email first. I would also
; appreciate copies of any modifications you make.
;
; Connections:
;	PIC	LCD
;	RB5	E
;	RB4	RS
;	RB3	D7
;	RB2	D6
;	RB1	D5
;	RB0	D4
;
; The contrast pin on the LCD should be connected as shown in the LCD module's
; datasheet.

;; PIC setup and toplevel includes
	LIST	P=16F874
	INCLUDE	<p16f874.inc>
	INCLUDE	"banks.inc"

; Pindefs
#DEFINE	LCD_D7	PORTB,	3
#DEFINE	LCD_D6	PORTB,	2
#DEFINE	LCD_D5	PORTB,	1
#DEFINE	LCD_D4	PORTB,	0
#DEFINE	LCD_E	PORTB,	5
#DEFINE	LCD_RS	PORTB,	4

; Variables
	CBLOCK	0x20
	ENDC

; Reset vector
	ORG	0
	GOTO	START
; Interrupt vector
	ORG	4
	GOTO	START

; Start of code
	ORG	5

START:
	CLRF	PORTB			; Clear PORTB
	PAGE1				; Bank 1
	BCF	LCD_D7			; Databits=outputs
	BCF	LCD_D6
	BCF	LCD_D5
	BCF	LCD_D4
	BCF	LCD_RS			; RS, E=outputs
	BCF	LCD_E
	PAGE0				; Bank 0

	CALL	LCD_INIT		; Init the LCD

	CLRF	FSR			; Message loop
MSGLOOP:
	MOVF	FSR,		W
	INCF	FSR,		F
	CALL	MESSAGE
	IORLW	.0
	BTFSC	STATUS,		Z
	GOTO	MSGDONE
	CALL	LCD_PUTCH
	GOTO	MSGLOOP

MSGDONE:
	MOVLW	.1			; Blinking Cursor on
	CALL	LCD_CURSBLINK
	CALL	LCD_LINE2
	MOVLW	"2"
	CALL	LCD_PUTCH
	MOVLW	"0"
	CALL	LCD_PUTCH
	MOVLW	"."
	CALL	LCD_PUTCH
	MOVLW	"0"
	CALL	LCD_PUTCH
	MOVLW	0x1A
	CALL	LCD_PUTCH
	GOTO	$

MESSAGE:
	ADDWF	PCL,		F
	DT	"Hello.",0

;; Final post-code includes
	INCLUDE	"lcd_4bit.inc"

	END
