; Universal PIC LCD Interface Module
; HD44780 serial mode transport layer/backend (LCD_SER.INC)
; By P. Pemberton, Jr.
; WWW: http://www.philpem.dsl.pipex.com/
; Email: philpem@despammed.com (replace "despammed" with "dsl.pipex" if you
; want, both addresses are valid)
; This software is distributed under the BSD License. You are free to do whatever
; you want with this code, but I would appreciate an email first. I would also
; appreciate copies of any modifications you make.
;
; Pindefs required:
;	LCD_DATA	The PIC pin connected to the A and B pins on the 
;				74LS164 (ex: PORTB,5)
;	LCD_CLOCK	The PIC pin connected to the LS164's CLOCK pin
;				(ex: PORTB,4)

        INCLUDE "banks.inc"

; File register Usage
	CBLOCK
		__LCD_DLAY		; Delay variable
		__LCD_NOTEMP		; Temporary variable for nibble output
		__LCD_TEMP		; Temporary variable
		__LCD_CNTR		; Counter
	ENDC

__LCD_INIT:
        CALL    __LCD_DLAY5             ;  Wait 20 msecs before Reset
        CALL    __LCD_DLAY5
        CALL    __LCD_DLAY5
        CALL    __LCD_DLAY5

        BCF     STATUS,         C       ; RS=0 (instruction)
        MOVLW   0x30                    ; RESET
        CALL    __LCD_NIBBLE            ; Send the nibble
        CALL    __LCD_DLAY5             ; Wait 5mS before resending

        BSF     LCD_DATA		; Send again.
        BCF     LCD_DATA
        CALL    __LCD_DLAY160           ; Wait 160uS before resending

        BSF     LCD_DATA
        BCF     LCD_DATA
        CALL    __LCD_DLAY160           ; Wait 160uS before sending

        BCF     STATUS,         C       ; RS=0 (instruction)
        MOVLW   0x20                    ; Set 4-bit (nibble) mode
        CALL    __LCD_NIBBLE            ; Send the nibble
        CALL    __LCD_DLAY160           ; Wait 160uS before sending

        MOVLW   0x28                    ; Two line mode, 4-bit
        CALL	LCD_SENDINS
        CALL	__LCD_DLAY160

        MOVLW   0x08                    ; Turn off the display
        CALL    LCD_SENDINS

        MOVLW   0x01                    ; Clear the DDRAM
        CALL    LCD_SENDINS
        CALL    __LCD_DLAY5             ; Can take up to 5uS

        MOVLW   0x06                    ; Set cursor direction
        CALL    LCD_SENDINS

        MOVLW   0x0C                    ; Display on
        CALL    LCD_SENDINS
        CALL    __LCD_DLAY160

	RETURN

LCD_PUTCH:                              ; Send a character to the LCD
        MOVWF   __LCD_DLAY              ; Temporary store.

        BSF     STATUS,         C       ; RS=1 (data)
        CALL    __LCD_NIBBLE            ; Send the high nibble

        SWAPF   __LCD_DLAY,     W       ; Low nibble -> W
        BSF     STATUS,         C       ; RS=1 (data)
        CALL    __LCD_NIBBLE            ; Send the low nibble
        RETURN

LCD_SENDINS:                            ; Send an instruction to the LCD
        MOVWF   __LCD_DLAY              ; Temporary store

        BCF     STATUS,         C       ; RS=0 (instruction)
        CALL    __LCD_NIBBLE            ; Send the high nibble

        SWAPF   __LCD_DLAY,     W       ; Low nibble -> W
        BCF     STATUS,         C       ; RS=0 (instruction)
        CALL    __LCD_NIBBLE            ; Send the low nibble
        RETURN

__LCD_NIBBLE:                           ; Sends a nibble (4 bits) to the LCD
        MOVWF   __LCD_NOTEMP            ; Temporarily store the nibble
        RRF     __LCD_NOTEMP,   F       ; Save the RS bit
        BSF     STATUS,         C       ; Carry high
        RRF     __LCD_NOTEMP,   F       ; Save the gate bit

        MOVLW   .0                      ; Clear the shift register
        CALL    __LCD_SEND

        MOVF    __LCD_NOTEMP,   W       ; Send the nibble to the LCD
        CALL    __LCD_SEND

        BSF     LCD_DATA                ; Clock in the data
        BCF     LCD_DATA
        RETURN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Send the byte in W to the 74HCT164
__LCD_SEND:
        MOVWF   __LCD_TEMP              ; Store byte
        MOVLW   .8                      ; Eight data bits
        MOVWF   __LCD_CNTR              ; Store in counter
__LCD_SENDLOOP:
        MOVLW   0
        RLF     __LCD_TEMP,	F	; Rotate left into carry
        BCF     LCD_DATA                ; Assume carry low
        BTFSC   STATUS, C               ; Carry high?
        BSF     LCD_DATA                ; Yes. Set port bit
;        GOTO    $+1                     ; Wait for the data line to settle
        BSF     LCD_CLOCK               ; Clock high
;        GOTO    $+1                     ; Make sure the HC164 sees the transition
        BCF     LCD_CLOCK		; Clock low
        DECFSZ  __LCD_CNTR,	F	; Decrement counter
        GOTO    __LCD_SENDLOOP          ; Not zero yet; keep going
        RETURN                          ; Counter=0; return.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

__LCD_DLAY160:                          ; 160uS delay
        MOVLW   .256-(160/4)            ; Loop until carry set
        ADDLW   .1
        BTFSS   STATUS,         C
        GOTO    $-2
        RETURN

__LCD_DLAY5:                            ; 5mS delay
        MOVLW   .4                      ; Set up the Delay
        MOVWF   __LCD_DLAY
        MOVLW   .256 - 0x0E8            ; Inner loop
        ADDLW   1
         BTFSC  STATUS, Z
        DECFSZ  __LCD_DLAY, F           ; Outer loop
        GOTO    $-3
        RETURN

; Include the Common LCD Functions
	INCLUDE	"lcd_cmn.inc"
