// lib to allow writing (and thus printing) to a char array
// internal pointer doesn't depend on strlen, can have nulls written to it, but saves one spot at the end for null for that it can be printed
// includes read and write functions (inherits from Stream)
// todo 'anonymous' version that uses strlen to allow dynamic usage without constructors

// includes:
// begin(array, size) -uses existing array
// write(byte)
// clear() uses internal pointer, so this needs to be set
// availableForWrite() how many bytes free (1 less than size at most)
// read()- returns -1 on nothing to return
// peek()- returns -1 on nothing to return
// available()
// padLeft(c,s) add c to left of buffer (right justify) up to length s, returns number added, safe
// padRight(c,s) add c to right of buffer (left justify) up to length s, returns number added, safe

#ifndef awriter_h
#define awriter_h

#include "Arduino.h"

class awriter: public Stream{
  public:
    awriter();
    void begin(char* a,unsigned int s);
    virtual size_t write(uint8_t d);
    void clear();
    int availableForWrite();
    int peek();
    int available();
    int read();
    int padLeft(char c, int s);
    int padRight(char c, int s);
  private:
    char* _a;
    unsigned int _s;
    unsigned int _p;
};

#endif

