'--------------------------------'

'    D O N U T  D I L E M M A

'      by Nickolas Marentes

'     For the Colour Maximite

'  Version 1.02    January 2013

'--------------------------------


'--- CHECK MMBASIC VERSION ---

If MM.Ver<4.03 Then Print"MMBASIC ver 4.3 required.":End

'--- COPY MOD FILES TO A: ___

Option error continue
Open "A:S1THROW.MOD" For input As #1
ERROR=MM.Errno:Close #1
If ERROR=0 Then GoTo LOADHISC

Copy "S1THROW.MOD"  To "A:S1THROW.MOD"
Copy "S2SPLAT.MOD"  To "A:S2SPLAT.MOD"
Copy "S3GRAB.MOD"   To "A:S3GRAB.MOD"
Copy "S4SWITCH.MOD" To "A:S4SWITCH.MOD"
Copy "S5GONG.MOD"   To "A:S5GONG.MOD"
Copy "S6WACK.MOD"   To "A:S6WACK.MOD"
Copy "S7JUMP.MOD"   To "A:S7JUMP.MOD"
Copy "S8GUN.MOD"    To "A:S8GUN.MOD"
Copy "FANFARE.MOD"  To "A:FANFARE.MOD"

LOADHISC:
Open "HISCORES" For input As #1
If MM.Errno=0 Then GoTo LH1

Open "HISCORES" For output As #1
For n=1 To 7
  Write #1,"*NNNNNNNNNN000000"
Next n
Close #1
GoTo LOADHISC

LH1:
Dim L$(8),S$(8),H(8)
For n=1 To 7
  Input #1,S$
  L$(n)=Left$(S$,1)
  S$(n)=Mid$(S$,2,10)
  H(n)=Val(Mid$(S$,12,8))
Next n
Close #1


'--- DISPLAY DISTRIBUTION NOTICE ---

START:
Mode 4
LoadBMP "TITLE0.BMP"

Do While Inkey$="":Loop
LoadBMP "TITLE1.BMP":Sprite Load "SPRITES.SPR"

Dim D(5,4), E(5,4), B(3,2), S(16)


'-- INITIALIZE CONTROLS ---

SETCONTROL:
CONTROL=Val(Inkey$)
If CONTROL=1 Then GoTo TITLES
If CONTROL=2 Then GoTo INITATARI
If CONTROL=3 Then GoTo INITNUN
GoTo SETCONTROL

INITATARI:
For x=11 To 15:SetPin x,2:Next
GoTo TITLES

INITNUN:
Dim nun(6)
I2CEN 10,100:' 400,100 for 400Khz Nunchuk operation
I2CSEND &H52,0,2,&HF0,&H55
I2CSEND &H52,0,2,&HFB,&H00


'--- DISPLAY TITLE PAGES ---

TITLES:
BD=18
If T<>600 Then T=0

TITLELOOP:
If T=000 Then LoadBMP "TITLE2.BMP"
If T=200 Then LoadBMP "TITLE3.BMP"
If T=400 Then LoadBMP "TITLE4.BMP"
If T=600 Then LoadBMP "TITLE5.BMP":GoSub DISPLAY

Sprite on BD,41,18
Pause 70

BC=BD:BD=BD+1
If BD=26 Then BD=18
Sprite off BC

Line (24,187)-(35,205),CL,b:CL=CL Xor 4
T=T+1:SKILL=0
If T=800 Then T=0

k$=UCase$(Inkey$)
Do While Inkey$<>"":Loop
If k$="S" Then SKILL=55
If Asc(k$)=156 Then SKILL=40
If SKILL=0 Then GoTo TITLELOOP


'--- INITIALIZE GAME START ---

SETSTART:

LEVEL=1:SCORE=0:LIVES=3


GAMESTART:

For x=0 To 120
  Line (x,x)-(240-x,216-x),0,b:Pause 7
Next x

Colour 3:Print@(95,100)"GET READY":Pause 2000

For x=1 To 8
  BLIT 95,100,95,101,53,8:Pause 30
Next x

Pause 500
LoadBMP "LEVEL"+Str$(LEVEL)


' Setup variables

DEATH=0:THROWS=0:DOUGH=0:SPLAT=31:BRK=0:ELV=0

Restore:L=LEVEL

Do While L>0
  Read TIME,MANS,MANX,MANY,BAGX,BAGY,ELVX
  For n=0 To 2:Read B(n,0),B(n,1):Next n
  For n=0 To 4:Read D(n,0),D(n,1),D(n,2),D(n,3):Next n
  L=L-1
Loop

If SKILL<>55 Then TIME=TIME-25:Sprite on 35,80,188:BLIT 80,188,144,188,15,15


' Setup Lives & Score display

Line (LIVES*8+3,3)-(27,10),0,bf
Color 2:Print@(14,205)SCORE


' Flash on Player sprite

For x=1 To 5
  Sprite on MANS,MANX,MANY:Pause 200
  Sprite off MANS:Pause 200
Next x

Sprite on MANS,MANX,MANY


' Turn on Donut sprites

For n=0 To 4
  If D(n,0)>0 Then Sprite on D(n,0),D(n,1),D(n,2)
Next n


'--- LEVEL SETUP ---

On LEVEL GoTo GAMELOOP,LV2,LV3,LV4,LV5,LV6,GAMELOOP,LV8,LV9,LV10

LV2:
FAT1=6:FAT2=218:Sprite on 33,FAT1,56:Sprite on 32,FAT2,56:GoTo GAMELOOP

LV3:
For n=0 To 15:S(n)=0:Next:GoTo GAMELOOP

LV4:
PX=29:FY=0:PD=1:FX=0:GoTo GAMELOOP

LV5:
PX=58:PD=1:GoTo GAMELOOP

LV6:
PC=30:PY=179:GoTo GAMELOOP

LV8:
PX=14:PD=1:Sprite on 31,PX,80:GoTo GAMELOOP

LV9:
PX=0:GoTo GAMELOOP

LV10:
Sprite on 15,28,28:Sprite on 16,17,49:Sprite on 17,39,49:PC=16:PX=40


'-----------------------
'    GAME LOOP START
'-----------------------

GAMELOOP:

MS=MANS:MX=MANX:MY=MANY:Timer=0

'--- MOVE DONUTS ---

For n=0 To 4
  E(n,0)=D(n,0):E(n,1)=D(n,1):E(n,2)=D(n,2)
  If D(n,0)=0 Then GoTo DN2
  D(n,0)=D(n,0)-1
  If D(n,0)<18 Then D(n,0)=25

  If D(n,3)=1 And Pixel(D(n,1)+10,D(n,2)+16)<>0 Then GoTo DN1
  If D(n,3)=-1 And Pixel(D(n,1)+5,D(n,2)+16)<>0 Then GoTo DN1
  If D(n,3)=1 Then D(n,3)=-1 Else D(n,3)=1

  DN1:
  If ELV=0 And DEATH=0 Then D(n,1)=D(n,1)+D(n,3)

  DN2:
Next n


'--- SCAN CONTROLS ---

KEYBOARD:
If JUMP>0 Or DEATH=1 Then GoTo ENDMAN
If ELV>0 Then GoTo EM4

k=KeyDown

If k=80 Or k=112  Then GoTo PAUSEGAME
If k=27  Then GoTo ABORTGAME

If k=128 Then GoTo MANUP
If k=129 Then GoTo MANDOWN
If LDR>1 Then GoTo JOYSTICK
If k=032 Then GoTo MANJUMP
If k=139 And SPLAT=31 Then GoTo MANTHROW
If k=130 Then GoTo MANLEFT
If k=131 Then GoTo MANRIGHT

JOYSTICK:
On CONTROL GoTo ENDMAN,ATARI,NUNCHUK

ATARI:
BT=1
If Pin(15)=1 Then BT=0:TG=0
If Pin(11)=0 Then GoTo MANUP
If Pin(12)=0 Then GoTo MANDOWN
If LDR>0 Then GoTo ENDMAN
If Pin(15)=0 Then BT=1:GoTo MANJUMP
If Pin(13)=0 Then GoTo MANLEFT
If Pin(14)=0 Then GoTo MANRIGHT
GoTo ENDKEY

NUNCHUK:
I2CSEND &H52,0,1,0
I2CRCV &H52,0,6,nun(0)

BT=1
If (nun(5) And 1)=1 Then BT=0:TG=0
If nun(1)>170 Then GoTo MANUP
If nun(1)<85  Then GoTo MANDOWN
If LDR>0 Then GoTo ENDMAN
If (nun(5) And 1)=0 Then BT=1:GoTo MANJUMP
If nun(0)<85  Then GoTo MANLEFT
If nun(0)>170 Then GoTo MANRIGHT


ENDKEY:
If MANS=9 Then GoTo ENDMAN
If MANS<5 Then MANS=1 Else MANS=5
GoTo ENDMAN


'-------------------
'    MAN ACTIONS
'-------------------

MANTHROW:
If DOUGH>0 Or THROWS=0 Then GoTo ENDMAN
If MANS<5 Then DX=MANX+1:DC=-2:MANS=1:DOUGH=1
If MANS>4 Then DX=MANX+14:DC=2:MANS=5:DOUGH=1
TG=1:DY=MANY+7:THROWS=THROWS-1
DA=Pixel(DX,DY):DB=Pixel(DX,DY+1)
Line(213+THROWS*8,3)-(235,10),0,bf
PlayMOD "A:S1THROW",200
GoTo ENDMAN

MANJUMP:
If DOUGH>0 And DOUGH<7 Then GoTo ENDMAN
If MANS<5 Then MANS=3 Else MANS=7
JUMP=1
PlayMOD "A:S7JUMP",400
GoTo ENDMAN

MANLEFT:
If MANX<9 Then MANS=1:GoTo ENDMAN
MANX=MANX-2:MANS=MANS+1:LDR=0:GoSub FOOTSTEP
If MANS>4 Then MANS=1
GoTo ENDMAN

MANRIGHT:
If MANX>215 Then MANS=5:GoTo ENDMAN
MANX=MANX+2:MANS=MANS+1:LDR=0:GoSub FOOTSTEP
If MANS<5 Or MANS>8 Then MANS=5
GoTo ENDMAN

MANUP:
If LDR>0 Then GoTo MA
If BT=1 And TG=0 Then GoTo MANTHROW
If Pixel(MANX+7,MANY-5)<>5 Then GoTo ENDKEY
Do While Pixel(MANX+7,MANY-5)=5:MANX=MANX-1:Loop
MANX=MANX+5:MANS=9:LDR=1:GoTo ENDMAN
MA:
If LDR=17 Then MANS=9:LDR=0:MANY=MANY-4:GoTo EM6
If LDR>14 Then MANS=13:GoTo MB
If LDR>12 Then MANS=12:GoTo MB
MANS=10+(LDR And 1)
MB:
MANY=MANY-2:LDR=LDR+1
U=U Xor 1
If U=1 Then Tone 420,440,8
GoTo ENDMAN

MANDOWN:
If LDR>0 Then GoTo MC
If Pixel(MANX+7,MANY+19)<>5 Then GoTo ENDMAN
Do While Pixel(MANX+7,MANY+19)=5:MANX=MANX-1:Loop
MANX=MANX+5:MANS=9:LDR=18:GoTo ENDMAN
MC:
LDR=LDR-1
If LDR=17 Then MANS=13:MANY=MANY+4:GoTo ENDMAN
If LDR=16 Then MANS=13:GoTo MD
If LDR>13 Then MANS=12:GoTo MD
If LDR=00 Then MANS=9:GoTo ENDMAN
MANS=10+(LDR And 1)
MD:
MANY=MANY+2
U=U Xor 1
If U=1 Then Tone 400,420,8

ENDMAN:
If LDR>0   Then GoTo MANHIT :' Climbing?
If DEATH=1 Then GoTo EM3    :' Man dying?
If JUMP>0  Then GoTo JUMP   :' Jumping
If DOUGH>0 Then GoTo EM5    :' Throw
GoTo EM1


'--- MAN JUMPING ---

JUMP:
If MANS=3 And MANX>9 Then MANX=MANX-2
If MANS=7 And MANX<215 Then MANX=MANX+2
If JUMP<8 Then MANY=MANY-2 Else MANY=MANY+2
JUMP=JUMP+1
If JUMP<15 Then GoTo MANHIT Else JUMP=0
If MANS=3 Then MANS=1 Else MANS=5
GoTo EM1


'--- MAN FALLING TO HIS DEATH ---

EM3:
If MANY<164 Then MANY=MANY+2:F=5000-MANY*25:Tone F,F,200:GoTo EM6
PlayMOD "A:S5GONG",400
Pause 2000
LIVES=LIVES-1
Line (LIVES*8+3,3)-(27,10),0,bf
Pause 2000
Sprite off all
If LIVES>0 Then GoTo GAMESTART

For x=0 To 120:Line (x,x)-(240-x,216-x),0,b:Pause 7:Next
Color 3:Print@(70,100)"G A M E  O V E R":Pause 3500
For x=1 To 8:BLIT 70,100,70,101,100,8:Pause 30:Next:Pause 500
If SCORE>H(7) Then GoSub ENTER:T=600
GoTo TITLES


'--- TEST FOR MAN FALL ---

EM1:
If Pixel(MANX+7,MANY+16)>0 And Pixel(MANX+8,MANY+16)>0 Then GoTo MANHIT
PlayMOD "A:S1THROW",200
DEATH=1:MANS=14

'--- TEST FOR MAN HIT BY DONUT ---

MANHIT:
If SPLAT<31 Then GoTo EM5
If Collision(MS,SPRITE)>0 Then DEATH=1:MANS=14:JUMP=0:LDR=0


'--- THROW ---

EM5:
If DOUGH=0 Then GoTo EM6
If DA=6 Or DB=6 Then DOUGH=0:n=0:PlayMOD "A:S2SPLAT",200:GoTo DHIT
Pixel(DX,DY)=DA:Pixel(DX,DY+1)=DB
DX=DX+DC:DOUGH=DOUGH+1
If DOUGH>24 Then DOUGH=0:GoTo EM6
If DOUGH>13 Then DY=DY+1 Else DY=DY-.3
DA=Pixel(DX,DY):DB=Pixel(DX,DY+1)
If DA<>6 Or DB<>6 Then Pixel(DX,DY)=7:Pixel(DX,DY+1)=7
GoTo EM6
DHIT:
If D(n,0)=0 Then GoTo DH1
If DX<D(n,1)-2 Or DX>D(n,1)+17 Then GoTo DH1
If DY<D(n,2)-2 Or DY>D(n,2)+17 Then GoTo DH1
D(n,0)=0:SX=D(n,1):SY=D(n,2)-2:ADDSCORE=200
DH1:
n=n+1
If n<5 Then GoTo DHIT
Pixel(DX,DY)=0:Pixel(DX,DY+1)=0
SPLAT=26
Sprite on SPLAT,SX,SY


'--- TEST FOR TIME=0 ---

EM6:
If Fix(TIME)=0 Then DEATH=1:MANS=14:JUMP=0:LDR=0


'--- GET BAG ---

If MANX+11<BAGX Or MANX-1>BAGX Then GoTo EM4
If MANY+10<>BAGY Then GoTo EM4
Sprite off MS
PlayMOD "A:S3GRAB.MOD",200
THROWS=3
BLIT BAGX,BAGY,229,4,7,6
BLIT BAGX,BAGY,221,4,7,6
BLIT BAGX,BAGY,213,4,7,6
Line(BAGX,BAGY)-(BAGX+6,BAGY+5),0,bf
BAGX=0:BAGY=0
Sprite on MS,MX,MY


'--- CIRCUIT BREAKERS ---

EM4:
For n=0 To 2:If B(n,0)=0 Then GoTo JP1
  If MANY<>B(n,1) Or MANX+12<B(n,0) Or MANX>B(n,0) Then GoTo JP2
  Sprite off MS
  Line(B(n,0),B(n,1)+12)-(B(n,0)+2,B(n,1)+14),0,bf
  Sprite on MS,MX,MY
  B(n,0)=0:ADDSCORE=100:BRK=BRK+1
  PlayMOD "A:S4SWITCH",150
  GoTo JP1
  JP2:
  Line(B(n,0),B(n,1)+12)-(B(n,0)+2,B(n,1)+14),Z,bf
  JP1:
Next n
z=(z+1) And 7


'--- ELEVATOR ---

If BRK=3 And LEVEL=10 Then Line(63,60)-(64,63),Z,b:GoTo JP3
If BRK=3 Then Line(ELVX,38)-(elvx+11,39),Z,b Else GoTo JP3
If ELV>0 Then GoTo JP4
If MANY<>20 Then GoTo JP3
If MANX+2<>ELVX And MANX+3<>ELVX Then GoTo JP3
Sprite off MS
MS=9:MANS=9:MANX=ELVX-2:ELV=1
Sprite on MS,MANX,19
GoTo JP3

JP4:
BLIT ELVX-1,1,ELVX-1,0,14,35
ELV=ELV+1
BLIT 187,200,ELVX,35,12,1
If ELV<>40 Then GoTo JP3

BONUS:
TIME=TIME-1:SCORE=SCORE+10
Color 2,0
Print@(198,205)Fix(TIME)" "
Print@(14,205)SCORE
Sound 200,5:Pause 50
If TIME>0 Then GoTo BONUS:Pause 500
For x=0 To 72:BLIT 0,0,0,3,240,213:Line(0,0)-(240,2),0,bf:Next

If LIVES=3 Then GoTo JP5
If LEVEL<>3 And LEVEL<>6 And LEVEL<>9 Then GoTo JP5
LIVES=LIVES+1
Color 6:Print@(65,100)"E X T R A  L I F E"
For y=1 To 3
  For x=1000 To 500 Step -10
    Tone x,x+10,20
    Pause 2
  Next x
Next y
Pause 2000

JP5:
LEVEL=LEVEL+1
Sprite off all:Cls
If LIVES>3 Then LIVES=3
GoTo GAMESTART
JP3:


'--- TIMER AND SCORE READOUTS ---

If TIME>00 Then TIME=TIME-.05
Color 2
If TIME<11 And (TIME And 1)=1 And DEATH=0 Then Color 4:Tone 1000,1000,30
Print@(198,205)Fix(TIME)" ":Color 2
If ADDSCORE>0 Then SCORE=SCORE+ADDSCORE:ADDSCORE=0:Print@(14,205)SCORE


'--- LEVEL CODE ---

On LEVEL GoTo ENDLOOP,LEV2,LEV3,LEV4,LEV5,LEV6,ENDLOOP,LEV8,LEV9,LEV10

LEV2:
If FAT1>214 And DEATH=0 Then FAT1=6:FAT2=218
FAT1=FAT1+4:FAT2=FAT2-4
If ELV=0 Then Sprite off MS
Sprite move 33,FAT1,55
Sprite move 32,FAT2,127
If ELV=0 Then Sprite on MS,MX,MY
If FAT1<12 Then Sound 100-FAT1,30
If Collision(MS,sprite)=0 Then GoTo ENDLOOP

MANHIT2:
If MANS=14 Then GoTo ENDLOOP
Sprite off MS
MS=14:MANS=14
Sprite on MS,MX,MY
PlayMOD "A:S6WACK",400:Pause 400
DEATH=1:JUMP=0:LDR=0
GoTo ENDLOOP

LEV3:
For n=0 To 15
  If S(n)>0 Then GoTo L3A
  If Rnd>.95 Then S(n)=1 Else GoTo L3B
  L3A:
  If S(n)>3 And Pixel(59+n*8,86+S(n))<>7 Then GoTo L3C
  Pixel(59+n*8,86+S(n))=0
  S(n)=S(n)+2
  If Pixel(59+n*8,86+S(n))>0 Then DEATH=1:S(n)=0:GoTo L3B
  If S(n)>56 Then S(n)=0:Line(59+n*8,120)-(59+n*8,143),0:GoTo L3B
  Pixel(59+n*8,86+S(n))=7
  L3B:
Next
If DEATH=1 Then GoTo MANHIT2 Else GoTo ENDLOOP
L3C:
DEATH=1:S(n)=0
Sprite off MS:Pixel(59+n*8,86+S(n))=0:Sprite on MS,MX,MY,Black:GoTo L3B

LEV4:
If PD=1 Then BLIT PX-2,13,PX,13,10,10:PX=PX+2
If PD=0 Then BLIT PX,13,PX-2,13,10,10:PX=PX-2
If PX<23 Or PX>168 Then PD=PD Xor 1
If Rnd>.05 Then GoTo L4A
If PX<MANX And PX<166 Then PD=1
If PX>MANX And PX>25  Then PD=0
L4A:
If FY=0 Then FX=PX-4:FY=14:Sprite on 34,FX,FY
If FY>=13 And FY<17 And DEATH=0 Then Sound 400,5:Sound 150-FY*5,30
FY=FY+5
If ELV=0 Then Sprite off MS
Sprite off 34
If FY>164 Then FY=0 Else Sprite on 34,FX,FY
If ELV=0 Then Sprite on MS,MX,MY
GoTo ENDLOOP

LEV5:
If DEATH=1 Then GoTo ENDLOOP
If PD=1 Then GoTo L5A
BLIT PX,36,PX-1,36,28,3:BLIT PX,108,PX-1,108,28,3
BLIT 212-PX,72,213-PX,72,28,3:BLIT 212-px,144,213-PX,144,28,3
PX=PX-1:If PX=55 Then PD=1
GoTo L5B
L5A:
BLIT PX-1,36,PX,36,28,3:BLIT px-1,108,px,108,28,3
BLIT 213-PX,72,212-px,72,28,3:BLIT 213-PX,144,212-PX,144,28,3
PX=PX+1:If PX=158 Then PD=-1
L5B:
If MANX<55 Or MANX>179 Then GoTo ENDLOOP
If MANY=20 Or MANY=92 Then MANX=MANX+PD
If MANY=56 Or MANY=128 Then MANX=MANX-PD
GoTo ENDLOOP

LEV6:
If PC<35 Then GoTo L6C
If PC<50 Then GoTo L6B
If PC=100 Then PlayMOD "A:S1THROW",100
If PY>168 Then PY=PY-4
For n=0 To 7
  If Pixel(60+n*17,PY-1)>0 Then DEATH=1
  Line(60+n*17,PY)-(60+n*17,179),7
Next:GoTo L6C
L6B:
If PY=180 Then GoTo L6C
For n=0 To 7
  If Pixel(60+n*17,PY)<>7 Then DEATH=1
  Pixel(60+n*17,PY)=0
Next:PY=PY+1
L6C:
PC=PC-1:If PC=0 Then PC=100
If DEATH=1 Then GoTo MANHIT2 Else GoTo ENDLOOP

LEV8:
If Rnd<.95 Then GoTo L8A
Sound 200,20:Sound 150,20
If MANY<80 Or MANY>96 Then PD=PD Xor 1:GoTo L8A
If PX>MANX Then PD=0
If PX<MANX Then PD=1

L8A:
If PX<9  Then PD=1:Sound 200,20:Sound 150,20
If PX>173 Then PD=0:Sound 200,20:Sound 150,20
If PD=1 Then GoTo L8B

X=Pixel(185,75):Y=Pixel(186,75):BLIT 11,75,13,75,174,1
Pixel(11,75)=X:Pixel(12,75)=Y
X=Pixel(11,79):Y=Pixel(12,79):BLIT 13,79,11,79,174,1
Pixel(185,79)=X:Pixel(186,79)=Y
PX=PX-2:GoTo L8C

L8B:
X=Pixel(11,75):Y=Pixel(12,75):BLIT 13,75,11,75,174,1
Pixel(185,75)=X:Pixel(186,75)=Y
X=Pixel(185,79):Y=Pixel(186,79):BLIT 11,79,13,79,174,1
Pixel(11,79)=X:Pixel(12,79)=Y
PX=PX+2

L8C:
Sprite move 31,PX,80
If Pixel(PX+3,96)<>0 Or Pixel(PX+12,96)<>0 Then DEATH=1:GoTo MANHIT2
GoTo ENDLOOP

LEV9:
x=Fix((MANX-1)/14)*14+8
If PX>0 Then GoTo L9A
If MANY>130 Or ELV>0 Then GoTo ENDLOOP
If Pixel(x,MANY+19)=2 And Pixel(x+1,MANY+19)=0 Then PX=x:PY=MANY+16:PC=60
GoTo ENDLOOP
L9A:
PC=PC-1
If PC>31 Then c=4 Else c=7
If x<>PX Or LDR>0 Or PC=0 Then Line(PX,PY)-(PX+13,PY+5),0,bf:PX=0:GoTo ENDLOOP
If Pixel(PX+1,PY+2)=0 Then Line(PX+1,PY+1)-(PX+12,PY+4),c,bf:GoTo ENDLOOP
If Pixel(PX+1,PY+2)=c Then Line(PX+1,PY+1)-(PX+12,PY+4),0,bf:GoTo ENDLOOP
GoTo ENDLOOP

LEV10:
Sprite move PC,28,28:PC=PC+1:If PC>17 Then PC=15
Sprite move PC,17,49:PC=PC+1:If PC>17 Then PC=15
Sprite move PC,39,49:PC=PC+2:If PC>17 Then PC=PC-3
If MANX<63 And MANY<57 And BRK=3 Then GoTo HOORAH
PX=PX-1
If PX=8 Or PX=6 Or PX=4 Then Tone 400,600,50
If PX>0 Then GoTo ENDLOOP Else PX=40
BLIT 106,108,78,108,42,8:BLIT 78,108,134,108,42,8:BLIT 106,108,135,36,42,8
GoTo ENDLOOP

HOORAH:
Pause 2000:Cls:Sprite move MS,MANX,MANY:Pause 2000
Cls:Pause 500:Sprite off all
Line(60,81)-(178,133),7,b:PlayMOD "A:FANFARE":Timer=0
Color 6,0:Print@(74,92)"CONGRATULATIONS"
Color 2,0:Print@(63,115)"10 LEVELS COMPLETED"
HOA:
x=Fix(Rnd*8):y=Fix(Rnd*8):c=Fix(Rnd*8)
If x<2 Or  x>5 Then GoTo HOB
If Y>2 And y<5 Then GoTo HOA
HOB:
Line(x*30,y*27)-(X*30+28,y*27+25),c,bf
If Timer<25180 Then GoTo HOA
PlayMOD stop:LEVEL=1:SKILL=40
GoTo GAMESTART


'--------------------
'    GAMELOOP END
'--------------------

ENDLOOP:

'--- UPDATE SPRITES ---

If SPLAT<31 Then Sprite off SPLAT:SPLAT=SPLAT+1
If DOUGH>0 Then Pixel(DX,DY)=DA:Pixel(DX,DY+1)=DB

For n=0 To 4
  If E(n,0)>0 Then Sprite off E(n,0)
Next n

If ELV=0 Then Sprite off MS:Sprite on MANS,MANX,MANY

For n=0 To 4
  If D(n,0)>0 Then Sprite on D(n,0),D(n,1),D(n,2)
Next n

If DOUGH>0 Then Pixel(DX,DY)=7:Pixel(DX,DY+1)=7
If SPLAT<31 Then Sprite on SPLAT,SX,SY


'--- GAMELOOP SPEED CONTROL ---

Do While Timer<SKILL:Loop
GoTo GAMELOOP


'-------------------
'    SUBROUTINES
'-------------------

' PAUSE GAME

PAUSEGAME:
If Inkey$<>"" Then GoTo PAUSEGAME
Do While Inkey$="":Loop
Pause 200
GoTo JOYSTICK


' ABORT GAME

ABORTGAME:
Color 7:Print@(68,90)" ABORT GAME (Y/N) "
Sound 300,50:Pause 30:Sound 100,50
AG:
k$=UCase$(Inkey$)
If k$="N" Then Line(68,90)-(170,100),0,bf:Pause 200:GoTo JOYSTICK
If k$="Y" Then Sprite off all:GoTo TITLES
GoTo AG


' FOOTSTEP SOUND

FOOTSTEP:
If FSTEP=0 Then FSTEP=4 Else FSTEP=FSTEP-1
If FSTEP=4 Then Tone 300,320,10
If FSTEP=2 Then Tone 350,330,10
Return


' DISPLAY HIGH SCORES

DISPLAY:
Y=103
For n=1 To 7
  Color n,0
  If L$(n)="*" Then GoTo DPA
  Print@(97,Y)S$(n)
  Print@(164,Y)H(n)
  C=Asc(L$(n))
  If C<75 Then Print@(202,Y)C-64:GoTo DPA
  Print@(202,Y)C-74
  Sprite on 35,0,0:BLIT 0,0,225,Y-1,15,15:Sprite off 35
  DPA:
  Y=Y+15
Next n
Return


' ENTER HIGH SCORE

ENTER:
Cls:Color 6,0:Print@(66,30)"H I G H  S C O R E":Color 7
Line(86,103)-(144,103),3
Locate 86,90
Do While Inkey$<>"":Loop
Line Input S$
S$=UCase$(S$)
If S$="" Or Len(S$)>10 Then PlayMOD "A:S5GONG":GoTo ENTER
If Len(S$)<10 Then S$=S$+String$(10-Len(s$),32)
n=7

ENT1:
  If SCORE<H(n) Then GoTo ENT2
  L$(n+1)=L$(n):S$(n+1)=S$(n):H(n+1)=H(n)
  S$(n)=S$:H(n)=SCORE
  If SKILL<55 Then L$(n)=Chr$(LEVEL+74) Else L$(n)=Chr$(LEVEL+64)
  If n>1 Then n=n-1:GoTo ENT1

ENT2:
Open "HISCORES" For output As #1
For n=1 To 7
  Write #1,L$(n)+S$(n)+Str$(H(n))
Next n
Close #1
Return


'------------------
'    LEVEL DATA
'------------------

'TIME,MANS,MANX,MANY,BAGX,BAGY,ELVX,CIRCUITBREAKERS X AND Y x 3
'Donut Data (Sprite#,X,Y,Direction) x 5

Data 101,1,115,164,221,138,135,21,164,145,56,215,20
Data 18,70,20,1, 19,70,92,1, 20,50,128,-1, 21,80,128,1, 0,0,0,0

Data 101,9,133,164,19,174,191,17,20,39,92,217,92
Data 18,110,20,1, 19,206,20,-1, 20,180,164,-1, 0,0,0,0, 0,0,0,0

Data 101,9,197,164,187,174,37,15,56,15,128,223,20
Data 18,30,20,1, 19,200,20,1, 20,154,56,-1, 21,40,164,1, 22,143,20,1

Data 101,9,37,164,221,138,191,15,56,223,92,223,164
Data 18,209,56,1, 19,184,92,1, 0,0,0,0, 0,0,0,0, 0,0,0,0

Data 101,9,191,164,31,174,37,27,56,27,128,209,20
Data 18,162,56,1, 19,64,92,1, 20,162,128,-1, 0,0,0,0, 0,0,0,0

Data 101,9,37,164,215,174,191,15,128,207,128,159,56
Data 18,54,20,1, 19,126,20,-1, 20,198,20,1, 21,118,92,-1, 0,0,0,0

Data 101,9,189,164,151,30,107,15,128,125,56,223,92
Data 18,192,20,1, 19,78,56,-1, 20,58,92,1, 21,80,128,1, 22,68,164,1

Data 101,9,103,164,221,30,107,29,92,223,164,223,128
Data 18,80,20,1, 19,42,56,1, 20,139,164,-1, 21,151,20,-1, 22,52,128,1

Data 101,9,107,164,221,138,107,181,20,25,20,15,92
Data 18,162,56,1, 19,161,92,1, 20,78,92,1, 21,169,164,-1, 0,0,0,0

Data 101,9,107,164,217,174,65,223,128,15,92,195,56
Data 18,96,20,1, 19,36,128,-1, 20,169,164,-1, 0,0,0,0, 0,0,0,0
