'******************************************************************************
' FILE MANAGER v2.0                                                  JUNE 2013
'
' by Nickolas Marentes                                  nickma@optusnet.com.au
'
' This software is provided as is without warranty of any kind. In no event
' shall the author be liable for any claim, damages or other liability arising
' from the use of this software."
'******************************************************************************


'--- Keyboard Controls Documentation ------------------------------------------

' UP/DOWN arrow keys move cursor through files and directories.
' LEFT/RIGHT arrow keys switch between left and right display panes.
' ENTER navigates in and out of directories and executes BASIC programs.
' SPACE will tag the current files and directories.
' ALT activates the central command strip. LEFT or RIGHT arrow to exit.
' ESC untags all files and directories in both panes.
' F12 exits File Manager and returns to MMBASIC.


'--- Launch Bar Setup ---------------------------------------------------------

' To define the buttons for the Launch Bar, edit the lines below to include
' the filename and file path. The filename cannot be longer than 8 characters.

' The path should begin at the SD card root folder leading up to the executable
' BAS file's folder. F$(n,0) contains the filename. F$(n,1) contains the path.

' For example, to run the file MAXMAN.BAS in the B:\MAXMAN folder...

' F$(1,0)="MAXMAN":F$(1,1)="\MAXMAN"


Dim F$(5,1)

F$(1,0)="":F$(1,1)=""

F$(2,0)="":F$(2,1)=""

F$(3,0)="":F$(3,1)=""

F$(4,0)="":F$(4,1)=""

F$(5,0)="":F$(5,1)=""


'--- Main Program Start -------------------------------------------------------

Mode 3:Color 0

' Initialise variables
Ldrv$="B:":Rdrv$="B:":Lpath$="\":Rpath$="\"
cl=1:cr=1:cc=1:cy=45
Dim Ldir$(2,45) length 20
Dim Rdir$(2,45) length 20
Option error continue
If MM.Device$ = "Colour Maximite" Then V=1 Else V=2


'--- Setup Screen -------------------------------------------------------------

Cls:Line(0,0)-(479,20),2,bf:Line(10,3)-(84,17),0,bf:Line(395,3)-(469,17),0,bf
Print@(155,6,V)"F I L E  M A N A G E R  v2.0"
Line(0,42)-(200,377),6,b:Line(279,42)-(479,377),6,b
Line(0,404)-(479,423),3,bf:Line(0,382)-(479,400),2,bf

For x=1 To 5:Print@(x*96-85,387,V)"F";Chr$(x+48);": ";
If F$(x,0)="" Then t$="________" Else t$=F$(x,0)
Print@(x*96-60,387,V)t$;
Next
For x=94 To 450 Step 96:Line(x,380)-(x+2,400),0,bf:Next

y=44:Color 7:For a=1 To 5:Read t$
Line(204,y)-(275,y+20),1,bf:Print@(235-Len(t$)*5/2,y+6,V)t$
y=y+30:Next:Color 0

Data "MAKE DIR","REMOVE DIR","COPY FILE","DELETE FILE","RENAME"

GoSub COMCLR:GoSub LUPDATE:GoSub RUPDATE:GoTo LCURSOR


'--- Update Left Pane ---------------------------------------------------------

LUPDATE:
Drive Ldrv$:Chdir Lpath$
Line(0,26)-(200,42),6,bf
Color 0:Print@(8,30,V)Ldrv$;Lpath$
Line(1,43)-(199,375),0,bf:Line(100,42)-(100,376),6

a=1
Ldir$(2,a)=Dir$("*.*",dir):Ldir$(1,a)=" D"
If Ldir$(2,a)="" Then GoTo LFILES
If Ldir$(2,a)="." Then a=a-1
Do
a=a+1:Ldir$(2,a)=Dir$():Ldir$(1,a)=" D"
Loop Until Ldir$(2,a)=""

LFILES:
Ldir$(2,a)=Dir$("*.*",file):Ldir$(1,a)=" F"
If Ldir$(2,a)="" Then GoTo LSHOW
Do
a=a+1:Ldir$(2,a)=Dir$():Ldir$(1,a)=" F"
If a=45 Then Ldir$(2,a)=""
Loop Until Ldir$(2,a)=""

LSHOW:
a=0
LSA:
a=a+1
If a>22 Then b=109 Else b=9
If a>22 Then c=a-22 Else c=a
If Ldir$(2,a)="" Then Return
If Ldir$(1,a)=" D" Then Color 3:Print@(b,c*15+35)"(DIR) "Ldir$(2,a):GoTo LSA
If Right$(Ldir$(2,a),3)="BAS" Then Color 7 Else Color 6
Print@(b,c*15+35)Ldir$(2,a)
GoTo LSA

'--- Left Panel Cursor Routine ------------------------------------------------

LCURSOR:
Drive Ldrv$:Chdir Lpath$
vp=1:Color 7:Print@(29,6)"SOURCE":Line(395,3)-(469,17),0,bf:Color 0
If cl>22 Then c=(cl-22)*15+34 Else c=cl*15+34
If cl>22 Then b=101 Else b=1
Line(b+8,c)-(b+91,c+10),-1,bf
WAIT1:
Line(353,411)-(399,418),3,bf:Print@(353,410,V)Time$;"  ";Date$:Pause 100
k$=UCase$(Inkey$):If k$="" Then GoTo WAIT1 Else k=Asc(k$)
If k$="5" Then SaveBMP "colour"
Line(b+8,c)-(b+91,c+10),-1,bf

If k=27 Then GoSub RUPDATE:GoSub LUPDATE:GoTo LCURSOR
If k=128 And cl>1 Then cl=cl-1
If k=129 And Ldir$(2,cl+1)<>"" Then cl=cl+1
If k=131 Then GoTo RCURSOR
If k=139 Then GoTo COMMAND
If k=13 Then GoTo ENTER
If K=156 Then GoTo QUIT
If k>144 And k<150 Then k=k-144:GoTo LAUNCH
If k<>32 Then GoTo LCURSOR

a=Asc(Left$(Ldir$(1,cl),1)) Xor 10
Ldir$(1,cl)=Chr$(a)+Right$(Ldir$(1,cl),1)
Line(b+2,c+3)-(b+5,c+7),-1,bf
If Ldir$(2,cl+1)<>"" Then cl=cl+1
GoTo LCURSOR


'--- Update Right Pane --------------------------------------------------------

RUPDATE:
Drive Rdrv$:Chdir Rpath$
Line(279,26)-(479,42),6,bf
Color 0:Print@(289,30,V)Rdrv$;Rpath$
Line(280,43)-(478,375),0,bf:Line(379,42)-(379,376),6

a=1
Rdir$(2,a)=Dir$("*.*",dir):Rdir$(1,a)=" D"
If Rdir$(2,a)="" Then GoTo RFILES
If Rdir$(2,a)="." Then a=a-1
Do
a=a+1:Rdir$(2,a)=Dir$():Rdir$(1,a)=" D"
Loop Until Rdir$(2,a)=""

RFILES:
Rdir$(2,a)=Dir$("*.*",file):Rdir$(1,a)=" F"
If Rdir$(2,a)="" Then GoTo RSHOW
Do
a=a+1:Rdir$(2,a)=Dir$():Rdir$(1,a)=" F"
If a=45 Then Rdir$(2,a)=""
Loop Until Rdir$(2,a)=""

RSHOW:
a=0
RSA:
a=a+1
If a>22 Then b=390 Else b=288
If a>22 Then c=a-22 Else c=a
If Rdir$(2,a)="" Then Return
If Rdir$(1,a)=" D" Then Color 3:Print@(b,c*15+35)"(DIR) "Rdir$(2,a):GoTo RSA
If Right$(Rdir$(2,a),3)="BAS" Then Color 7 Else Color 6
Print@(b,c*15+35)Rdir$(2,a)
GoTo RSA


'--- Right Pane Cursor Routine ------------------------------------------------

RCURSOR:
Drive Rdrv$:Chdir Rpath$
vp=2:Color 7:Print@(416,6)"SOURCE":Line(10,3)-(84,17),0,bf:Color 0
If cr>22 Then c=(cr-22)*15+34 Else c=cr*15+34
If cr>22 Then b=380 Else b=280
Line(b+8,c)-(b+91,c+10),-1,bf
WAIT2:
Line(353,411)-(399,418),3,bf:Print@(353,410,V)Time$;"  ";Date$:Pause 100
k$=UCase$(Inkey$):If k$="" Then GoTo WAIT2 Else k=Asc(k$)
Line(b+8,c)-(b+91,c+10),-1,bf

If k=27 Then GoSub LUPDATE:GoSub RUPDATE:GoTo RCURSOR
If k=128 And cr>1 Then cr=cr-1
If k=129 And Rdir$(2,cr+1)<>"" Then cr=cr+1
If k=130 Then GoTo LCURSOR
If k=13 Then GoTo ENTER
If k=139 Then GoTo COMMAND
If k=156 Then GoTo QUIT
If k>144 And k<150 Then k=k-144:GoTo LAUNCH
If k<>32 Then GoTo RCURSOR

a=Asc(Left$(Rdir$(1,cr),1)) Xor 10
Rdir$(1,cr)=Chr$(a)+Right$(Rdir$(1,cr),1)
Line(b+2,c+3)-(b+5,c+7),-1,bf
If Rdir$(2,cr+1)<>"" Then cr=cr+1
GoTo RCURSOR


'--- Command Strip ------------------------------------------------------------

COMWIN:
Line(1,405)-(330,422),0,bf:Color 6:Print@(11,409)t$;:Return

COMERR:
If error=1 Then t$="SELECT A DIRECTORY!"
If error=2 Then t$="DIRECTORY IS NOT EMPTY!"
If error=3 Then t$="DIRECTORIES ARE THE SAME!"
If error=4 Then t$="INVALID NAME!"
Line(1,405)-(330,422),4,bf
Print@(11,409,V)t$:Tone 1000,1200,100:Pause 2500

COMCLR:
Line(1,405)-(330,422),3,bf:Color 0
Print@(11,409,V)"F12: QUIT TO MMBASIC":Return


'--- Command Select -----------------------------------------------------------

COMMAND:
Line(353,411)-(399,418),3,bf:Print@(353,410,V)Time$;"  ";Date$
Line(205,cy)-(274,cy+18),-1,bf:Pause 150
k$=UCase$(Inkey$):If k$="" Then GoTo COMMAND Else k=Asc(k$)
If Pixel(205,cy)=0 Or Pixel(205,cy)=6 Then Line(205,cy)-(274,cy+18),-1,bf

If k=128 And cc>1 Then cc=cc-1:cy=cy-30:o=-10
If k=129 And cc<5 Then cc=cc+1:cy=cy+30:o=10
If k=130 Then t$="":GoTo LCURSOR
If k=131 Then t$="":GoTo RCURSOR
If k<>13 Then GoTo COMMAND

tag=1
On cc GoTo MAKDIR,REMDIR,COPFILE,DELFILE,RENAME


'--- Change Directory ---------------------------------------------------------

CHGDIR:
If vp=2 Then GoTo CHA

If Ldir$(2,tag)="" Then error=1:GoSub COMERR:GoTo LCURSOR
If Ldir$(1,tag)<>"*D" Then tag=tag+1:GoTo CHGDIR
If Ldir$(2,tag)=".." Then GoSub CHC Else Lpath$=Lpath$+Ldir$(2,tag)+"\"
Chdir Lpath$:GoSub LUPDATE:cl=1:GoTo LCURSOR

CHC:
Lpath$=Left$(Lpath$,Len(Lpath$)-1)
If Right$(Lpath$,1)<>"\" Then GoTo CHC
Return

CHA:
If Rdir$(2,tag)="" Then error=1:GoSub COMERR:GoTo RCURSOR
If Rdir$(1,tag)<>"*D" Then tag=tag+1:GoTo CHGDIR
If Rdir$(2,tag)=".." Then GoSub CHD Else Rpath$=Rpath$+Rdir$(2,tag)+"\"
Chdir Rpath$:GoSub RUPDATE:cr=1:GoTo RCURSOR

CHD:
Rpath$=Left$(Rpath$,Len(Rpath$)-1)
If Right$(Rpath$,1)<>"\" Then GoTo CHD
Return


'--- Make Directory -----------------------------------------------------------

MAKDIR:
t$="Enter new directory name":GoSub COMWIN:Input F$:GoSub COMCLR
If f$="" Then GoTo NULL
If Len(f$)>8 Then GoTo MAKDIR

If vp=1 Then Mkdir Lpath$+f$:GoSub LUPDATE:GoSub RUPDATE:GoTo LCURSOR
Mkdir Rpath$+f$:GoSub LUPDATE:GoSub RUPDATE:GoTo RCURSOR

NULL:
GoSub LUPDATE:GoSub RUPDATE:GoSub COMCLR
If vp=1 Then GoTo LCURSOR Else GoTo RCURSOR

'--- Remove Directory ---------------------------------------------------------

REMDIR:
If vp=2 Then GoTo RMB

RMA:
If Ldir$(2,tag)="" Then cl=1:GoTo NULL
If Ldir$(1,tag)<>"*D" Or Ldir$(2,tag)=".." Then tag=tag+1:GoTo RMA
t$="Delete directory "+Ldir$(2,tag)+"?  (Y/N)":GoSub COMWIN:GoSub RMC
If k$="Y" Then Chdir Lpath$:Rmdir Ldir$(2,tag)
If Right$(Rpath$,Len(Ldir$(2,tag))+1)=Ldir$(2,tag)+"\" Then Rpath$="\"
If MM.Errno=14 Then error=2:GoSub COMERR:GoTo LCURSOR
tag=tag+1:GoTo RMA

RMB:
If Rdir$(2,tag)="" Then cr=1:GoTo NULL
If Rdir$(1,tag)<>"*D" Or Rdir$(2,tag)=".." Then tag=tag+1:GoTo RMB
t$="Delete directory "+Rdir$(2,tag)+"?  (Y/N)":GoSub COMWIN:GoSub RMC
If k$="Y" Then Chdir Rpath$:Rmdir Rdir$(2,tag)
If Right$(Lpath$,Len(Rdir$(2,tag))+1)=Rdir$(2,tag)+"\" Then Lpath$="\"
If MM.Errno=14 Then error=2:GoSub COMERR:GoTo RCURSOR
tag=tag+1:GoTo RMB

RMC:
k$=UCase$(Inkey$):If k$="" Then GoTo RMC
GoTo COMCLR


'--- Copy File ----------------------------------------------------------------

COPFILE:
'If Lpath$=Rpath$ Then error=3:GoSub COMERR:GoTo COMMAND
If vp=2 Then GoTo CPA

If Ldir$(2,tag)="" Then GoTo NULL
If Ldir$(1,tag)<>"*F" Then tag=tag+1:GoTo COPFILE
t$="Copying files: "+Ldir$(2,tag)+"     ":GoSub COMWIN
Copy Ldrv$+Lpath$+Ldir$(2,tag) To Rdrv$+Rpath$+Ldir$(2,tag)
tag=tag+1:GoTo COPFILE

CPA:
If Rdir$(2,tag)="" Then GoTo NULL
If Rdir$(1,tag)<>"*F" Then tag=tag+1:GoTo COPFILE
t$="Copying files: "+Rdir$(2,tag)+"     ":GoSub COMWIN
Copy Rdrv$+Rpath$+Rdir$(2,tag) To Ldrv$+Lpath$+Rdir$(2,tag)
tag=tag+1:GoTo COPFILE


'--- Delete File --------------------------------------------------------------

DELFILE:
t$="Are you sure you wish to DELETE these files? (Y/N)":GoSub COMWIN:GoSub RMC
If k$<>"Y" Then Ldir$(2,tag)="":Rdir$(2,tag)=""
If vp=2 Then GoTo DEB

DEA:
If Ldir$(2,tag)="" Then cl=1:GoTo NULL
If Ldir$(1,tag)<>"*F" Then tag=tag+1:GoTo DEA
t$="DELETEing files: "+Ldir$(2,tag)+"     ":GoSub COMWIN
Kill Ldrv$+Lpath$+Ldir$(2,tag)
tag=tag+1:GoTo DEA

DEB:
If Rdir$(2,tag)="" Then cr=1:GoTo NULL
If Rdir$(1,tag)<>"*F" Then tag=tag+1:GoTo DEB
t$="DELETEing files: "+Ldir$(2,tag)+"     ":GoSub COMWIN
Kill Rdrv$+Rpath$+Rdir$(2,tag)
tag=tag+1:GoTo DEB


'--- Rename File/Directory ----------------------------------------------------

RENAME:
If vp=2 Then GoTo REB

REA:
If Ldir$(2,tag)="" Then GoTo NULL
If Left$(Ldir$(1,tag),1)<>"*" Then tag=tag+1:GoTo REA
If Ldir$(2,tag)=".." Then tag=tag+1:GoTo REA
t$="RENAME "+Ldir$(2,tag)+" TO ":GoSub COMWIN
Input t$:If t$<>"" Then Name Ldir$(2,tag) As t$
If MM.Errno>0 Then error=4:GoSub COMERR:GoTo REA
GoSub COMCLR:tag=tag+1:GoTo REA

REB:
If Rdir$(2,tag)="" Then GoTo NULL
If Left$(Rdir$(1,tag),1)<>"*" Then tag=tag+1:GoTo REB
t$="RENAME "+Rdir$(2,tag)+" TO ":GoSub COMWIN
Input t$:If t$<>"" Then Name Rdir$(2,tag) As t$
If MM.Errno>0 Then error=4:GoSub COMERR:GoTo REB
GoSub COMCLR:tag=tag+1:GoTo REB


'--- Launch Shortcut ----------------------------------------------------------

LAUNCH:

If F$(k,0)="________" Then GoTo NULL
Chdir F$(k,1):Mode 3:Color 7,0:Cls:Run F$(k,0)+".BAS"
STOP


'--- Quite File Manager -------------------------------------------------------

QUIT:
Color 7,0:Cls:Print "Maximite BASIC Version "MM.Ver:Print
New


'--- ENTER Key Control --------------------------------------------------------

ENTER:
If vp=1 And Right$(ldir$(1,cl),1)="D" Then ldir$(1,cl)="*D":tag=cl:GoTo CHGDIR
If vp=2 And Right$(rdir$(1,cr),1)="D" Then rdir$(1,cr)="*D":tag=cr:GoTo CHGDIR

If vp=1 Then t$=ldir$(2,cl) Else t$=rdir$(2,cr)

If Right$(t$,4)<>".BAS" Then GoTo NORUN
If vp=1 Then Chdir Lpath$ Else Chdir Rpath$
Erase Ldir$,Rdir$:Mode 3:Color 7,0:Cls:Run t$

NORUN:
On vp GoTo LCURSOR,RCURSOR



