/*
 * File:   main.c
 * Author: mike
 *
 * Created on 31 March 2019, 19:27
 */


#include <xc.h>
#include "i2c.h"

#pragma config MCLRE = OFF
#pragma config WDTE = OFF

#define LCD_ADDRESS     0x7c
#define RGB_ADDRESS     0xc4

// color define 
#define WHITE           0
#define RED             1
#define GREEN           2
#define BLUE            3

#define REG_RED         0x04        // pwm2
#define REG_GREEN       0x03        // pwm1
#define REG_BLUE        0x02        // pwm0

#define REG_MODE1       0x00
#define REG_MODE2       0x01
#define REG_OUTPUT      0x08

// commands
#define LCD_CLEARDISPLAY 0x01
#define LCD_RETURNHOME 0x02
#define LCD_ENTRYMODESET 0x04
#define LCD_DISPLAYCONTROL 0x08
#define LCD_CURSORSHIFT 0x10
#define LCD_FUNCTIONSET 0x20
#define LCD_SETCGRAMADDR 0x40
#define LCD_SETDDRAMADDR 0x80

// flags for display entry mode
#define LCD_ENTRYRIGHT 0x00
#define LCD_ENTRYLEFT 0x02
#define LCD_ENTRYSHIFTINCREMENT 0x01
#define LCD_ENTRYSHIFTDECREMENT 0x00

// flags for display on/off control
#define LCD_DISPLAYON 0x04
#define LCD_DISPLAYOFF 0x00
#define LCD_CURSORON 0x02
#define LCD_CURSOROFF 0x00
#define LCD_BLINKON 0x01
#define LCD_BLINKOFF 0x00

// flags for display/cursor shift
#define LCD_DISPLAYMOVE 0x08
#define LCD_CURSORMOVE 0x00
#define LCD_MOVERIGHT 0x04
#define LCD_MOVELEFT 0x00

// flags for function set
#define LCD_8BITMODE 0x10
#define LCD_4BITMODE 0x00
#define LCD_2LINE 0x08
#define LCD_1LINE 0x00
#define LCD_5x10DOTS 0x04
#define LCD_5x8DOTS 0x00


void delay_50ms( unsigned int num)
{
    // nop takes 1us. the loop adds a few more
    while (num--) {
        unsigned int lp = 3000;

        while (lp--) {
            __nop(); 
        }
    }
}


void LCD_init(void)
{
    delay_50ms(5);
    
    // Send first command
    i2c_start();             
    i2c_tx(LCD_ADDRESS);  
    i2c_tx(0x80);
    i2c_tx(LCD_FUNCTIONSET | LCD_2LINE);
    i2c_stop();
    
    delay_50ms(1);

    // resend first command in case of 
	// a startup failure
    i2c_start();             
    i2c_tx(LCD_ADDRESS);  
    i2c_tx(0x80);
    i2c_tx(LCD_FUNCTIONSET | LCD_2LINE);
    i2c_stop();
    
    delay_50ms(1);
            
    // resend first command in case of 
	// a startup failure
    i2c_start();             
    i2c_tx(LCD_ADDRESS);  
    i2c_tx(0x80);
    i2c_tx(LCD_FUNCTIONSET | LCD_2LINE);
    i2c_stop();
    
    // Set display mode
    i2c_start();             
    i2c_tx(LCD_ADDRESS);  
    i2c_tx(0x80);
    i2c_tx(LCD_DISPLAYCONTROL | LCD_DISPLAYON 
            | LCD_CURSOROFF | LCD_BLINKOFF);
    i2c_stop();

    // Clear display, set cursor to top left position
    i2c_start();             
    i2c_tx(LCD_ADDRESS);  
    i2c_tx(0x80);
    i2c_tx(LCD_CLEARDISPLAY);
    i2c_stop();
    
    delay_50ms(1);
}


void LCD_show_banner(void) 
{
    // Send message to display
    i2c_start();             
    i2c_tx(LCD_ADDRESS);  
    i2c_tx(0x40);
    i2c_tx('H');
    i2c_tx('e');
    i2c_tx('l');
    i2c_tx('l');
    i2c_tx('o');
    i2c_tx(' ');
    i2c_tx('f');
    i2c_tx('r');
    i2c_tx('o');
    i2c_tx('m');
    i2c_tx(' ');
    i2c_tx('P');
    i2c_tx('E');        
    i2c_stop();
    
     // Set position to next line
    i2c_start();             
    i2c_tx(LCD_ADDRESS);  
    i2c_tx(0x80);
    i2c_tx(0xc0);
    i2c_stop();
   
    // Send message to display
    i2c_start();             
    i2c_tx(LCD_ADDRESS);  
    i2c_tx(0x40);
    i2c_tx('T');
    i2c_tx('e');
    i2c_tx('m');
    i2c_tx('p');
    i2c_tx(':');
    i2c_tx(' ');
    i2c_tx('2');
    i2c_tx('1');
    i2c_tx('.');
    i2c_tx('6');
    i2c_tx(0xDF);
    i2c_tx('C');
    i2c_stop();    
}


void backlight_init(void)
{
    i2c_start();             
    i2c_tx(RGB_ADDRESS);  
    i2c_tx(REG_MODE1);  
    i2c_tx(0);  
    i2c_stop();    

    i2c_start();             
    i2c_tx(RGB_ADDRESS);  
    i2c_tx(REG_OUTPUT);  
    i2c_tx(0xFF);  
    i2c_stop();    

    i2c_start();             
    i2c_tx(RGB_ADDRESS);  
    i2c_tx(REG_MODE2);  
    i2c_tx(0x20);  
    i2c_stop();    
    
    i2c_start();             
    i2c_tx(RGB_ADDRESS);  
    i2c_tx(REG_RED);  
    i2c_tx(0x00);  
    i2c_stop();    

    i2c_start();             
    i2c_tx(RGB_ADDRESS);  
    i2c_tx(REG_GREEN);  
    i2c_tx(0x00);  
    i2c_stop();    

    i2c_start();             
    i2c_tx(RGB_ADDRESS);  
    i2c_tx(REG_BLUE);  
    i2c_tx(0x80);  
    i2c_stop();    
}


void main(void) 
{    
    OPTION = 0x9F;  // Enable GPIO function on GP2, no wakeup on GP1
    
    i2c_init();
    
    GPIO = 0;
   
    LCD_init();
    
    LCD_show_banner(); 

    backlight_init();
    
    do {} while(1);
}
