/*
 * File:   main.c
 * Author: mike
 *
 * Created on 31 March 2019, 19:27
 */


#include <xc.h>

#pragma config MCLRE = OFF
#pragma config WDTE = OFF

#define DELAY_30M           30*60*20UL
#define TIMEON              DELAY_30M

#define TIME_PRESS_3S       3*20UL
#define TIME_PRESS          TIME_PRESS_3S

#define LEDTIME_500MS       10UL
#define LEDTIME             LEDTIME_500MS

#if TIMEON > 65535 
#error The time delay specified for TIMEON will exceed variable size
#endif

unsigned char pinStatus;
unsigned short onCounter;

unsigned char LEDTimer;
unsigned char timer3s;

void delay_50ms( unsigned int num)
{
    // nop takes 1us. the loop adds a few more
    while (num--) {
        unsigned int lp = 3000;

        while (lp--) {
            __nop(); 
        }
    }
}

void main(void) 
{    
    OPTION = 0x1F;  // Enable GPIO function on GP2, wakeup on GP1
    TRISGPIO = 0x02; // GP0, GP2 and GP3 are outputs
    
    if (STATUSbits.GPWUF) {
        // Button press wake-up
        // ====================
        STATUS = 0;
        
        // Read GPIO
        pinStatus = GPIO;
        
        // IS the button low?
        if (pinStatus & 0x02) {
            // It is not low - so sleep
            asm("SLEEP");
        } else {
            // Pin is low
            
            // Delay 50ms
            delay_50ms(1);
            
            // Read GPIO 
            pinStatus = GPIO;
            
            // Is the push button low?
            if (pinStatus & 0x02) {
                // Not low - so sleep
                asm("SLEEP");
            } else {
                // POWER ON
                
                // LED to ON, Power to ON
                GPIO = 0x01;
 
                // Delay for a few seconds to avoid key de-bounce
                delay_50ms(40);
                 
                onCounter = 40;
                
                do { 
                    // Have we been on long enough?
                    if (onCounter >= TIMEON) {                    
                        // LED to OFF, Power to OFF
                        GPIO = 0x04;

                        // Sleep
                        asm("SLEEP");
                    } else {
                        delay_50ms(1);
                        onCounter++;

                        // Read GPIO 
                        pinStatus = GPIO;

                        // Is the push button low?
                        if ((pinStatus & 0x02) == 0) {

                            // Delay for 3s, flashing LED
                            // ==========================
                            
                            LEDTimer = 0;
                            timer3s = 0;
                                    
                            do {
                                delay_50ms(1);
                                onCounter++;
                                LEDTimer++;
                                timer3s++;
                                
                                if ( LEDTimer == LEDTIME) {
                                    // TOGGLE LED TBD
                                    GPIObits.GP2 = !GPIObits.GP2;
                                    LEDTimer = 0;
                                }
                                
                                // Read GPIO 
                                pinStatus = GPIO;
                                
                                // Button released?
                                if (pinStatus & 0x02) {
                                    GPIObits.GP2 = 0;
                                    break;
                                }                                                               
                            } while (timer3s < TIME_PRESS);

                            if (timer3s == TIME_PRESS)
                                onCounter = TIMEON;
                        } 
                    }
                } while (1);                
            }
        }        
    } else {
        // A normal power-up condition
        // ===========================
        
        // LED to OFF, Power to OFF
        GPIO = 0x04;
        
        // Set Push button to Wake interrupt
        // Already set in option register
        
        // Read GPIO register
        pinStatus = GPIO;
        
        // Sleep
        asm("SLEEP");
    }
}
