/*
 * File:   hardware.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 31 March 2014, 20:53
 *
 * Low level hardware initialisation.
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18f27j13.h>
#include "hardware.h"
#include "LCD-Graphic-ILI9341.h"
#include "timers.h"

/**************************************************************************
* Function: HardwareInit
*           Low level hardware initialisation.
**************************************************************************
*/
void HardwareInit( void )
{
    // Initially, set all I/O to digital rather than analogue

    ANCON0 = 0xFE;
    ANCON1 = 0x7F;

    // And set the LED pin as an output, LED Off, as it draws 11mA current
    LATBbits.LATB5 = 0;
    TRISBbits.TRISB5 = 0;
    
    //Buttons Setup
    TRISBbits.TRISB0 = 1;
    TRISBbits.TRISB1 = 1;
    TRISCbits.TRISC6 = 1;
    TRISCbits.TRISC7 = 1;
}

void CheckforButtonPress(void) {
    if (PORTCbits.RC6) {
        //LATBbits.LATB5 ^= 1;  
        if (HOLD_SAMPLING) {
            LCD_Clear(BLACK);
            POINT_COLOR = GRAY;
            LCD_DrawRectangle(10,10,239,319);   // Replaces 4 lines below
            LCD_DrawScreenWords(BUTTON_SELECT);
            HOLD_SAMPLING = 0;
        } else {
            HOLD_SAMPLING = 1;
        }
        delayms(500);
    }
  
    // Select Screen words code
    if (PORTCbits.RC7) {
        // Checks Button Select
        if (BUTTON_SELECT == 3) {
            BUTTON_SELECT = 0;
        } else {
            BUTTON_SELECT++;
        }
        LCD_DrawScreenWords(BUTTON_SELECT);  
        delayms(500);
    }
        
    // Up Button
    if (PORTBbits.RB0) {
        if (BUTTON_SELECT == 0) {
            AUTO_SAMPLE ^= 1;
        } else if (BUTTON_SELECT == 1) {
            EDGE_SAMPLE ^= 1;
        } else if (BUTTON_SELECT == 2) {
            TRIGGER_LINE++;
        } else if (BUTTON_SELECT == 3) {
            MEASURE_LINE++;
        }
        LCD_DrawScreenWords(BUTTON_SELECT); 
        delayms(100);
    }
    
    // Down Button
    if (PORTBbits.RB1) {
        if (BUTTON_SELECT == 0) {
            AUTO_SAMPLE ^= 1;
        } else if (BUTTON_SELECT == 1) {
            EDGE_SAMPLE ^= 1;
        } else if (BUTTON_SELECT == 2) {
            TRIGGER_LINE--;
        } else if (BUTTON_SELECT == 3) {
            MEASURE_LINE--;
        }  
        LCD_DrawScreenWords(BUTTON_SELECT); 
        delayms(100);
    }
    
}

