; NiCd/NiMH Burp Charger  


	list P=16F88
	#include p16f88.inc
	ERRORLEVEL -302
	ERRORLEVEL -306

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Bank 0 RAM

; A/D values
TRICKLE			equ	H'20'	; trickle value
TRICKLE_LS		equ	H'21'	; trickle ls 10 bits
DELTA_TEMP		equ	H'22'	; change in temperature
THERMISTOR		equ	H'23'	; battery thermistor value
STO_NTC			equ	H'24'	; thermistor stored value
CHARGE_I		equ	H'25'	; charge current
HEATSINK_T		equ	H'26'	; heatsink thermistor temperature

; Timers
TIMEOUT			equ	H'28'	; timeout value	
ADCOUNT			equ	H'29'	; A/D address counter
TIMERH			equ	H'2A'	; ms byte of timer
TIMERL			equ	H'2B'	; ls byte of timer
FLASHER			equ	H'2C'	; LED flasher timer 
LOOP_COUNT		equ	H'2D'	; update A/D counter
TIMES_5			equ	H'2E'	; times 5 timer
DELTA_TIMER		equ	H'2F'	; delta Temp timer	
NTC_COUNT		equ	H'30'	; time between NTC storage
THERM_COUNT		equ	H'31'	; thermistor count
FIRST_MINUTE	equ	H'32'	; wait for first minute for NTC

; General
CHARGE_STATE	equ	H'33'	; charge status
CHARGE_I_TEMP	equ	H'34'	; temporary
DEL_COUNT		equ	H'35'	; delay counter
HEAT_COUNT		equ	H'36'	; heatsink thermistor read count
BURP_CYCLE		equ	H'37'	; burp cycle
PWM_STORE		equ	H'38'	; PWM storage

; Math
AARGB0			equ	H'60'	; ms multiplier
AARGB1			equ	H'61'	; ls multiplier
BARGB0			equ	H'62'	; ms multiplier
LOOPCOUNT		equ	H'63'	; counter
AARGB3			equ	H'64'	; div routine
REMB0			equ	H'65'	; remainder
TEMP1			equ	H'66'	; temporary register
			 
; All Banks RAM
; Interrupt store registers 
W_TMP			equ	H'72'	; storage of w before interrupt
STATUS_TMP		equ	H'73'	; status storage before interrupt


; start at memory 0
	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT

; **********************************************************************************************

SETUP
; initial port states
	clrf	PORTB		; port B outputs low
	movlw	B'11000000'
	movwf	PORTA		; port A outputs 

	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11111000'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00111111'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled, TMR0/256,negative edge interrupt)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'01011111'	; AN0 to AN4 and AN6 are analog inputs
	movwf	ANSEL
	movlw	B'01000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	clrf	PORTB		; port B outputs low
	movlw	B'11000000'
	movwf	PORTA		; port A outputs high
	movlw	B'01000000'	; Fosc, channel etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01101000'	; 4MHz
	movwf	OSCCON		; 
	bcf		STATUS,RP0	; select memory bank 0

; preset timer 1 for 0.479s
	movlw	H'0D'
	movwf	TMR1H		; timer high byte
	movlw	H'46'		; 
	movwf	TMR1L	
	movlw	B'00110001'	; timer 1 fosc/4 1:8 prescaler
	movwf	T1CON
	clrf	BURP_CYCLE	; start cycle at 0

; PWM
	bsf		STATUS,RP0	; select memory bank 1		
	movlw	H'FE'
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	
; pwm set
	clrf	CCPR1L		; duty 0% Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	; clear 10-bits
	bsf		T2CON,2		; enable timer 2

	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation 490Hz
	
; initial conditions
INITIAL
	movlw	D'05'		; x 5
	movwf	TIMES_5
 	clrf	ADCOUNT		; A/D address count
	clrf	HEAT_COUNT
	clrf	FIRST_MINUTE; counter to wait 1 minute for NTC
	clrf	BURP_CYCLE	; burp cycle. starts at 0

; A/D conversion start and get A/D values before interrupt
AD
	movlw	D'10'
	movwf	LOOP_COUNT	; counter	
REDO_AD					; redo A/D conversion
	call	ANALOG_AD
	decfsz	LOOP_COUNT,f
	goto	REDO_AD
	movlw	D'2'		; counts to initiate stored thermistor value
	movwf	THERM_COUNT	; thermistor count

	movf	THERMISTOR,w; transfer values	
	movwf	STO_NTC

; start timer
	clrf	CHARGE_STATE	; charge status clear is off
	bsf		CHARGE_STATE,0	; fast charge rate
	bsf		PORTB,2			; charger LED

; load timer
; calculate timeout (TIMEOUT x 142)
	movf	TIMEOUT,w
	movwf	AARGB0

; check if burp charging
	movlw	D'142'			; timing for timeout period standard
	btfss	PORTB,3			; if low then burp
	movlw	D'160'			; 13% extra period compensating for burp discharge and rest period
;	movlw	D'01'			; test for timer /142
	movwf	BARGB0
	call	EIGHTEIGHT		; 
	movf	AARGB0,w		; ms
	movwf	TIMERH			; 
	movf	AARGB1,w
	movwf	TIMERL			; timer loaded

	bcf		PIR1,TMR1IF		; clear timer 1 flag
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count

; check if burp charging
	movlw	D'121'			; timing for delta T of 60 seconds
	btfss	PORTB,3			; if low then burp
	movlw	D'133'			; 10% extra period compensating for burp discharge and rest period
;	movlw	D'12'			; test for over 6-seconds
	movwf	NTC_COUNT		; 0.495833 x 121 = 60 seconds or x 110% for burp 

; allow interrupts
	bsf		STATUS,RP0		; select memory bank 1
	bsf		PIE1,TMR1IE		; timer 1 overflow interrupt
	bcf		STATUS,RP0		; select memory bank 0
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag
	bsf		INTCON,PEIE		; enable periperal interrupts 	 
	bsf		INTCON,GIE

; start Timer1
	movlw	B'00110001'		; timer 1 fosc/4
	movwf	T1CON
	bcf		PORTA,6			; allow charging

CYCLE						; code cycle
; update A/D values
; A/D conversion
; set analog input address
	
	movlw	B'11000111'		; mask bits 5:3
	andwf	ADCON0,f		; set bits 5:3 to zero
	btfsc	ADCOUNT,0		; if bit 0 set then set bit 3 in ADCON0
	bsf		ADCON0,3
	btfsc	ADCOUNT,1		; if bit 1 set then set bit 4 in ADCON0
	bsf		ADCON0,4
	btfsc	ADCOUNT,2		; if bit 2 set,set bit 5
	bsf		ADCON0,5

	call	DELAY			; allow inputs to settle

	movf	ADCOUNT,w		; find address
	btfsc	STATUS,Z		; if zero
	goto	CH_0AD
	movf	ADCOUNT,w
	xorlw	D'01'			; 1
	btfsc	STATUS,Z
	goto	CH_1AD
	movf	ADCOUNT,w
	xorlw	D'02'			; 2
	btfsc	STATUS,Z
	goto	CH_2AD
	movf	ADCOUNT,w
	xorlw	D'03'			; 3
	btfsc	STATUS,Z
	goto	CH_3AD
	movf	ADCOUNT,w
	xorlw	D'04'			; 4
	btfsc	STATUS,Z
	goto	CH_4AD
	movf	ADCOUNT,w
	xorlw	D'05'			; 5
	btfsc	STATUS,Z
	goto	CH_5AD
	movf	ADCOUNT,w
	xorlw	D'06'			; 6
	btfsc	STATUS,Z
	goto	CH_6AD

; Channel 0 A/D value
CH_0AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV0
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV0
	movf	ADRESH,w
	movwf	TIMEOUT			; timeout value
	goto	NEW_ADDRESS		; end

; Channel 1 A/D value
CH_1AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	movf	ADRESH,w
	movwf	TRICKLE			; trickle
	bsf		STATUS,RP0		; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0		; select memory bank 0
	movwf	TRICKLE_LS
	goto	NEW_ADDRESS		; end

; Channel 2 A/D value
CH_2AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV2
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV2
	movf	ADRESH,w
	movwf	CHARGE_I_TEMP	; charging current

	sublw	D'127'			; if > 2.5V set at 2.5V
	movf	CHARGE_I_TEMP,w		; reload
	btfss	STATUS,C
	movlw	D'127'			; if larger set at 127
	movwf	CHARGE_I_TEMP
	bcf		STATUS,C
	rlf		CHARGE_I_TEMP,w; multiply by 2 (2.5V = 5V) 
	movwf	CHARGE_I
	goto	NEW_ADDRESS	; end

; Channel 3 A/D value
CH_3AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV3
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV3
	movf	ADRESH,w
	movwf	DELTA_TEMP		; change in temperature
	goto	NEW_ADDRESS		; end

; Channel 4 A/D value
CH_4AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV4
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV4
	movf	ADRESH,w
	movwf	THERMISTOR		; Thermistor value
	goto	NEW_ADDRESS		; end

; Channel 5 A/D value
CH_5AD						; not used
	goto	NEW_ADDRESS		; end

; Channel 6 A/D value
CH_6AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV6
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV6
	movf	ADRESH,w
	movwf	HEATSINK_T		; heatsink temperature
	goto	NEW_ADDRESS		; end

; set new address
NEW_ADDRESS
	incf	ADCOUNT,f		; counter
	movf	ADCOUNT,w
	sublw	B'00000110'		; compare with 6,if positive or zero leave as is
	btfss	STATUS,C
	goto	ALL_AD
	goto	CYCLE
ALL_AD						; all A/D done
	bsf 	INTCON,GIE		; set global interrupt enable
	clrf	ADCOUNT			; back to zero
	goto	CYCLE

 ; ******************************************************************************************************
; INTERRUPT

; start interrupt by saving w and status registers 
	
INTERRUPT
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP		; status in status_tmp 
	bcf		STATUS,RP0		; bank select
	bcf 	STATUS,RP1		; select memory bank 0 

	btfss	PIR1,TMR1IF		; timer 1 interrupt flag
	goto	CHECK_END		; no timer interrupt so exit
	bcf		PIR1,TMR1IF		; clear flag


; check RB3 setting
	btfsc	PORTB,3			; if low then burp charge enabled
	goto	UPDATE1

	btfsc	CHARGE_STATE,0	; fast (main) charge rate. When set then burp charge
	goto	BURP1

	btfss	CHARGE_STATE,1	; Topup (main) charge rate. When set then burp charge
	goto	UPDATE1
BURP1
; Burp charge updates
; BURP_CYCLE describes current charge cycle
; 0 is initial .497s charging
; 1 is off for 1ms
; 2 is discharge for 30ms
; 3 is off for 29ms
; 4 is charge for 437ms
; 1-4 totals to 497ms

; next cycle
	incf	BURP_CYCLE,f
	movlw	D'5'
	subwf	BURP_CYCLE,w
	btfsc	STATUS,C		; when minus return  BURP_CYCLE to 0
	goto	UPDATE2

; check cycle
	movlw	D'1'
	xorwf	BURP_CYCLE,w
	btfss	STATUS,Z		; = 1?
	goto	CK_CYC2
; 1. charge and discharge off
	movf	CCPR1L,w
	movwf	PWM_STORE
	clrf	CCPR1L			; PWM off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	B'11000000'
	movwf	PORTA			; charge off (RA6 high) discharge off RA7 high 
; set timer for 1ms
; 8us per count so 1ms is 125 counts (take from full 16-bit counter @ 65536). =D65411
	bcf		T1CON,TMR1ON	; stop timer
	movlw	H'FF'
	movwf	TMR1H			; timer high byte
	movlw	H'83'			; 
	movwf	TMR1L			; timer low byte
	bsf		T1CON,TMR1ON	; restart timer	
	goto	CHECK_END		; bypass other interrupt code till 
CK_CYC2
	movlw	D'2'
	xorwf	BURP_CYCLE,w
	btfss	STATUS,Z		; = 2?
	goto	CK_CYC3
; 2. charge off, discharge on
	movf	PWM_STORE,w
	movwf	CCPR1L			; PWM on

	movlw	B'01000000'
	movwf	PORTA			; charge off (RA6 high) discharge on RA7 low 
; set timer for 30ms
; 8us per count so 30ms is 3750 counts (take from full 16-bit counter @ 65536). = D61786, H
	bcf		T1CON,TMR1ON	; stop timer
	movlw	H'F1'
	movwf	TMR1H			; timer high byte
	movlw	H'5A'			; 
	movwf	TMR1L			; timer low byte
	bsf		T1CON,TMR1ON	; restart timer	
	goto	CHECK_END		; bypass other interrupt code till 
CK_CYC3
	movlw	D'3'
	xorwf	BURP_CYCLE,w
	btfss	STATUS,Z		; = 3?
	goto	CK_CYC4
; 3. charge and discharge off
	movf	CCPR1L,w
	movwf	PWM_STORE
	clrf	CCPR1L			; PWM off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	B'11000000'
	movwf	PORTA			; charge off (RA6 high) discharge off RA7 high 
; set timer for 29ms
; 8us per count so 29ms is 3625 counts (take from full 16-bit counter @ 65536). = D61911
	bcf		T1CON,TMR1ON	; stop timer
	movlw	H'F1'
	movwf	TMR1H			; timer high byte
	movlw	H'D7'			; 
	movwf	TMR1L			; timer low byte
	bsf		T1CON,TMR1ON	; restart timer	
	goto	CHECK_END		; bypass other interrupt code till 
CK_CYC4
	movlw	D'4'
	xorwf	BURP_CYCLE,w
	btfss	STATUS,Z		; = 4?
	goto	UPDATE2			; => 5
; 4. charge on and discharge off
	movf	PWM_STORE,w
	movwf	CCPR1L			; PWM on

	movlw	B'10000000'
	movwf	PORTA			; charge on (RA6 low) discharge off RA7 high 
; set timer for 437.1ms
; 8us per count so 437ms is 54637 counts (take from full 16-bit counter @ 65536). = D10898, H
	bcf		T1CON,TMR1ON	; stop timer
	movlw	H'2A'
	movwf	TMR1H			; timer high byte
	movlw	H'92'			; 
	movwf	TMR1L			; timer low byte
	bsf		T1CON,TMR1ON	; restart timer	
	goto	NTC_COUNTING

UPDATE2
	clrf	BURP_CYCLE		; full 0.4971ms period of charging
	movlw	B'10000000'
	movwf	PORTA			; charge on (RA6 low) discharge off RA7 high 
UPDATE1 ; 0.4971s update
; on overflow set timer to 62137 so 4x 1/500kHz = 8us. 8us x 62137 = update every .4971s 
; a/d value (0-5V) x 142 x .4971 = timeout
; 5V or 255 x 142 x .4971 = 18000 (18000/60/60 = 5hours)
; ie load timer with 65536 - 62137 = 3399 or D46 as a Hex value
 
	bcf		T1CON,TMR1ON	; stop timer
	movlw	H'0D'
	movwf	TMR1H			; timer high byte
	movlw	H'46'			; 
	movwf	TMR1L			; timer low byte
	bsf		T1CON,TMR1ON	; restart timer	

NTC_COUNTING
	movf	NTC_COUNT,w
	btfss	STATUS,Z		; when zero do not decrement
	decf	NTC_COUNT,f		; time between checking NTC thermistor
	incf	FLASHER,f		; flasher timer

; first check heatsink temperature
; check if heatsink over 40 degrees

	movf	HEAT_COUNT,w	; wait till therm count decreased
	btfsc	STATUS,Z
	goto	CK_HT
	decf	HEAT_COUNT,f
	goto	FLSH_HT_LED		; flash heatsink LED
CK_HT
	movf	HEATSINK_T,w	; heatsink NTC thermistor value
	sublw	D'51'			; if <51 then >40 degrees
	btfss	STATUS,C		; if minus low temp
	goto	OVR_50			; check battery thermistor for >50 deg C
; over 40 degrees
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	D'242'			; 0.495833 x 242 = 120 seconds
	movwf	HEAT_COUNT		; heatsink thermistor count check again in 2 minutes
FLSH_HT_LED
	btfss	FLASHER,2		; flash LED very slowly
	goto	NTC_LED_OFF1
	bsf		PORTB,1			; NTC LED on
	goto	SKIP_LED
NTC_LED_OFF1
	bcf		PORTB,1			; NTC LED off
SKIP_LED
	bcf		PORTB,2			; charge LED off
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	goto	CHECK_END

; check if battery over 50 degrees
OVR_50
	movf	THERMISTOR,w	; NTC thermistor value
	sublw	D'40'			; if <40 then 50 degrees
	btfsc	STATUS,C
	goto	STOP_CHRG

; update thermistor value
; measure change in temperature over time based on VR2
; STORE_NTC
	btfss	CHARGE_STATE,0	; check change in temperature when charging only
	goto	CK_NTC_OUT

; only decrease THERM_COUNT if THERMISTOR is >25 C
	movf	THERMISTOR,w	; NTC thermistor value
	sublw	D'127'			; if <127 then >25 degrees
	btfsc	STATUS,C
	goto	CN_NTC

	movf	THERM_COUNT,w	
	btfsc	STATUS,Z	
	goto	CN_NTC
	decfsz	THERM_COUNT,f	; read NTC when counter is zero
	goto	CN_NTC
	movlw	D'2'
	movwf	THERM_COUNT
	movf	THERMISTOR,w	; get NTC value to storage for comparison
	movwf	STO_NTC
	goto	CK_NTC_OUT
CN_NTC
	movf	NTC_COUNT,w		; 
	btfss	STATUS,Z
	goto	CK_NTC_OUT
; check if burp charging
	movlw	D'121'			; timing for delta T of 60 seconds
	btfss	PORTB,3			; if low then burp
	movlw	D'137'			; 13% extra period compensating for burp discharge and rest period
;	movlw	D'12'			; test 6-seconds
	movwf	NTC_COUNT		; 0.495833 x 121 = 60 seconds or x 113% for burp

; calculate delta T/time. Off when valid (goto CHARGE_END as per timer finished)
; base delta T depending on VR2 (DELTA_TEMP). If current value < previous by the factor then switch off.
; calculate temperature change based on DELTA_TEMP 5 degrees = a change of about 10 for Thermistor

	movf	DELTA_TEMP,w
	sublw	D'25'			; if less than x set at 1
	btfsc	STATUS,C
	goto	SET_VAL1
	movf	DELTA_TEMP,w		
	movwf	AARGB1			; numerator
	clrf	AARGB0
	movlw	D'25'			; 
	movwf	BARGB0
	call	DIV16_8
	goto	CK_DELTT
SET_VAL1
	movlw	D'1'
	movwf	AARGB1
CK_DELTT
	movlw	D'1'			; make sure AARGB1 is 1
	subwf	AARGB1,w
	btfss	STATUS,C
	goto 	SET_VAL1		; minimum of 1

; check delta T/t (dT/dt)
; only check after first minute of charge
	btfss	FIRST_MINUTE,0
	goto	STO_THERM

 	movf	THERMISTOR,w
	subwf	STO_NTC,w	; subtract current from previous
	btfsc	STATUS,Z	; if zero ok
	goto	STO_THERM
	btfss	STATUS,C	; if negative ok
	goto	STO_THERM
	subwf	AARGB1,w
	btfss	STATUS,C	; if negative switch off
	goto	CHARGE_END	; full charge ended check for topup
STO_THERM
; store thermistor values between two time periods
	movf	THERMISTOR,w
	movwf	STO_NTC

	bsf		FIRST_MINUTE,0	; first minute set bit 0

CK_NTC_OUT
; if NTC out hold timers, Mosfet off and NTC LED on
; out of circuit
	movf	THERMISTOR,w	; NTC thermistor value
	sublw	D'240'			; if >240 then NTC is out of circuit
	btfsc	STATUS,C		; if minus NTC out
	goto	CK_NTC_LO
	bsf		PORTB,1			; NTC LED on
	bcf		PORTB,2			; charge LED off
	clrf	CCPR1L			; mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count
	goto	CHECK_END		; stop charging
CK_NTC_LO
	movf	THERMISTOR,w	; NTC thermistor value
	sublw	D'197'			; if >197 then 0 degrees
	btfsc	STATUS,C		; if minus low temp
	goto	CK_OVR_50
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count
	btfss	FLASHER,1		; flash LED slowly
	goto	NTC_LED_OFF
	bsf		PORTB,1			; NTC LED on
	goto	CHECK_END
NTC_LED_OFF
	bcf		PORTB,1			; NTC LED off
	bcf		PORTB,2			; charge LED off
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count
	goto	CHECK_END

; compare temperature for over 50 deg C
CK_OVR_50
	movf	THERMISTOR,w	; NTC thermistor value
	sublw	D'40'			; if <40 then 50 degrees
	btfss	STATUS,C
	goto	CHRG_STATE_MOSFET
	bcf		PORTB,2			; charge LED off
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count
	btfss	FLASHER,0		; flash LED 
	goto	NTC_LED_OFF
	bsf		PORTB,1			; NTC LED on
	goto	CHECK_END

CHRG_STATE_MOSFET
	bcf		PORTB,1			; NTC LED off
; check charge state and drive Mosfet accordingly
; CHARGE_STATE (bit 0 set = charge, bit 1 set = topup, bit 2 set = trickle)
; topup and trickle based on VR3 and if LK2/LK3 in circuit
	btfsc	CHARGE_STATE,0
	goto	DRV_LEDS		; charge so bypass and drive led and mosfet
	btfss	CHARGE_STATE,1	; topup
	goto	MOSFET_TRICKLE

; TOPUP current
; topup drive mosfet at 4x the trickle setting
; calculate duty by dividing VR3 Trickle value (10-bits) by 5 and x4 (=shift left twice) 
	movf	TRICKLE,w		; 0-255 = 0-500mA
	movwf	AARGB1
	clrf	AARGB0
; set as 10-bits
	bcf		STATUS,C		; carry cleared
	rlf		AARGB1,f		; left
	rlf		AARGB0,f		; shift into AARGB0 x2
	bcf		STATUS,C		; carry cleared
	rlf		AARGB1,f		; left
	rlf		AARGB0,f		; shift into AARGB0 x4
	btfsc	TRICKLE_LS,6	; bit 10
	bsf		AARGB1,0		; set bit 0 when bit 10 set
	btfsc	TRICKLE_LS,7	; bit 9
	bsf		AARGB1,1		; set bit 1 when bit 9 set
	movlw	D'5'
	movwf	BARGB0			; divide by 5 to convert 0-5V to 0-500mA
	call	DIV16_8
	movf	AARGB1,w		; /5
	movwf	CCPR1L
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear ms bits
	goto	DRV_LEDS
	
MOSFET_TRICKLE	
 	btfss	CHARGE_STATE,2	; trickle
	goto	DRV_LEDS
; trickle drive mosfet at the trickle setting
; calculate duty by dividing VR3 Trickle value (10-bits) by 5 
	movf	TRICKLE,w		; 0-255 = 0-500mA
	movwf	AARGB1
	clrf	AARGB0
; set as 10-bits (x4)
	bcf		STATUS,C		; carry cleared
	rlf		AARGB1,f		; left
	rlf		AARGB0,f		; shift into AARGB0 x2
	bcf		STATUS,C		; carry cleared
	rlf		AARGB1,f		; left
	rlf		AARGB0,f		; shift into AARGB0 x4
	btfsc	TRICKLE_LS,6	; bit 10
	bsf		AARGB1,0		; set bit 0 when bit 10 set
	btfsc	TRICKLE_LS,7	; bit 9
	bsf		AARGB1,1		; set bit 1 when bit 9 set
	movlw	D'5'
	movwf	BARGB0			; divide by 5 to convert 0-5V from 0-5A to 0-500mA
	call	DIV16_8
; divide by 4 to compensate for the x4 above
	bcf		STATUS,C
	rrf		AARGB1,f		; /2
	btfsc	STATUS,C		; if carry set set the ls 10 bit
	goto	SET_5
	bcf		CCP1CON,5		; clear bit 10
	goto	SET_CLEAR_4
SET_5
	bsf		CCP1CON,5		; set bit 10
SET_CLEAR_4
	bcf		STATUS,C
	rrf		AARGB1,f		; /4
	btfsc	STATUS,C		; if carry set set bit 9
	goto	SET_4
	bcf		CCP1CON,4		; clear bit 9
	goto	END_SET_CLEAR
SET_4
	bsf		CCP1CON,4		; set bit 9
END_SET_CLEAR
	movf	AARGB1,w		; Trickle/5
	movwf	CCPR1L
	
DRV_LEDS
; drive charge LED based on CHARGE_STATE (charge LED off when CHARGE_STATE is 0)
	movf	CHARGE_STATE,w
	btfss	STATUS,Z		; if zero LED off
	goto	OTHER_CHRG_FULL
	bcf		PORTB,2			; charge LED off
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	goto	CHECK_END
OTHER_CHRG_FULL
	btfss	CHARGE_STATE,0	; if set full Charge rate
	goto	OTHER_CHRG_TOPUP
	bsf		PORTB,2			; Charge LED on
	movf	CHARGE_I,w		; charge value
	movwf	CCPR1L			; Mosfet on
	movwf	PWM_STORE
	bsf		CCP1CON,4
	bsf		CCP1CON,5		; set 10-bits
	goto	DEC_TIME
OTHER_CHRG_TOPUP
	btfss	CHARGE_STATE,1	; if set topup
	goto	OTHER_CHRG_TRICKLE
	btfss	FLASHER,0		; flash LED
	goto	TOP_FLSH 
	bsf		PORTB,2			; Charge LED on
	goto	DEC_TIME
TOP_FLSH
	bcf		PORTB,2			; Charge LED on
	goto	DEC_TIME
OTHER_CHRG_TRICKLE
	btfss	CHARGE_STATE,2	; if set trickle
	goto	DEC_TIME
	btfss	FLASHER,1		; flash LED
	goto	TRICKLE_FLSH 
	bsf		PORTB,2			; Charge LED on
	goto	DEC_TIME
TRICKLE_FLSH
	bcf		PORTB,2			; Charge LED on
	goto	DEC_TIME

DEC_TIME
; decrease timers
; check if x 5, check if topup
	btfsc	CHARGE_STATE,1	; bypass x 5 on topup
	goto	BY_X5
	btfsc	PORTB,6			; if x 5 link then decrease x 5 timer
	goto	BY_X5
	decfsz	TIMES_5,f
	goto	CHECK_END
	movlw	D'5'			; x 5
	movwf	TIMES_5 
BY_X5	
	movf	TIMERH,w		; ms timer
	btfss	STATUS,Z		; if zero 
	goto	DEC_LOW
	movf	TIMERL,w		; ls byte of timer
	btfss	STATUS,Z
	goto	DEC_LOW			; do not decrease past 0
	movf	CHARGE_STATE,w	; if charger off bypass
	btfsc	STATUS,Z
	goto	CHARGER_OFF
	goto	CK_TOP_TRICK	; check topup or trickle	
DEC_LOW
DEC_TMRHL		
	decfsz	TIMERL,f		; if low byte zero decrease high byte
	goto	CHECK_END
	movf	TIMERH,w
	btfsc	STATUS,Z		; if zero charge ended
	goto	CHARGE_END
	decfsz	TIMERH,f
	goto	CHECK_END
CHARGE_END
	movlw	D'00'
	movwf	TIMERH			; set to 0
	movwf	TIMERL

; check if topup and trickle required
CK_TOP_TRICK
	btfsc	PORTB,5			; if low topup
	goto	CK_TOPUP		; see if trickle
	btfss	CHARGE_STATE,0	; if set then clear and set bit 1
	goto	CK_TOPUP
	clrf	CHARGE_STATE
	bsf		CHARGE_STATE,1	; topup

; set timer	to 60 minutes
	movlw	H'1C'			; ! correct timer period
;	movlw	D'01'			; test timer period
	movwf	TIMERH
	movlw	H'4A'
	movwf	TIMERL			; timer loaded

	goto	CHECK_END
CK_TOPUP
	btfsc	PORTB,4			; if low trickle enable
	goto	STOP_CHRG		; not low so charging stops
SET_TRICL
	clrf	CHARGE_STATE
	bsf		CHARGE_STATE,2	; trickle
	goto	CHECK_END

STOP_CHRG
; stop charger
	clrf	CHARGE_STATE	; charge status

; set timers to 0
	movlw	D'00'
	movwf	TIMERH			; set to 0
	movwf	TIMERL

CHARGER_OFF
	bcf		PORTB,2			; charger LED
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits

CHECK_END
; end of interrupt reclaim w and status 

	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

; **************************************************************
; Subroutines

; A/D conversion
; set analog input address
ANALOG_AD
	movlw	B'11000111'		; mask bits 5:3
	andwf	ADCON0,f		; set bits 5:3 to zero
	btfsc	ADCOUNT,0		; if bit 0 set then set bit 3 in ADCON0
	bsf		ADCON0,3
	btfsc	ADCOUNT,1		; if bit 1 set then set bit 4 in ADCON0
	bsf		ADCON0,4
	btfsc	ADCOUNT,2		; if bit 2 set,set bit 5
	bsf		ADCON0,5

	movf	ADCOUNT,w		; find address
	btfsc	STATUS,Z		; if zero
	goto	CH_0
	movf	ADCOUNT,w
	xorlw	D'01'			; 1
	btfsc	STATUS,Z
	goto	CH_1
	movf	ADCOUNT,w
	xorlw	D'02'			; 2
	btfsc	STATUS,Z
	goto	CH_2
	movf	ADCOUNT,w
	xorlw	D'03'			; 3
	btfsc	STATUS,Z
	goto	CH_3
	movf	ADCOUNT,w
	xorlw	D'04'			; 4
	btfsc	STATUS,Z
	goto	CH_4
	movf	ADCOUNT,w
	xorlw	D'05'			; 5
	btfsc	STATUS,Z
	goto	CH_5
	movf	ADCOUNT,w
	xorlw	D'06'			; 6
	btfsc	STATUS,Z
	goto	CH_6

; Channel 0 A/D value
CH_0
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	TIMEOUT			; timeout value
	goto	INPUTS_READ		; end

; Channel 1 A/D value
CH_1
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	TRICKLE			; trickle
	bsf		STATUS,RP0		; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0		; select memory bank 0
	movwf	TRICKLE_LS
	goto	INPUTS_READ		; end

; Channel 2 A/D value
CH_2
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	CHARGE_I		; charging current
	sublw	D'127'			; if > 2.5V set at 2.5V
	movf	CHARGE_I,w		; reload
	btfss	STATUS,C
	movlw	D'127'			; if larger set at 127
	movwf	CHARGE_I
	bcf		STATUS,C
	rlf		CHARGE_I,f		; x 2
	goto	INPUTS_READ		; end

; Channel 3 A/D value
CH_3
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	DELTA_TEMP		; change in temperature
	goto	INPUTS_READ

; Channel 4 A/D value
CH_4
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	THERMISTOR		; Thermistor value
	goto	INPUTS_READ		; end

; Channel 5 A/D value
CH_5						; not used
	goto	INPUTS_READ		; end

; Channel 6 A/D value
CH_6
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	HEATSINK_T		; heatsink temperature
	goto	INPUTS_READ		; end

; subroutine to wait for conversion
ACQUIRE_AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

INPUTS_READ					; inputs are read
; set new address
	incf	ADCOUNT,f		; counter
	movf	ADCOUNT,w
	sublw	B'00000110'		; compare with 6,if positive or zero leave as is
	btfss	STATUS,C
	clrf	ADCOUNT			; back to zero
	return

DELAY
	movlw	D'08'
	movwf	DEL_COUNT
DEL1
	decfsz	DEL_COUNT,f
	goto	DEL1
	return
	
; 8 x 8 multiply

EIGHTEIGHT      CLRF    AARGB1          ; clear partial product
UMUL0808L        
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
                MOVF    AARGB0,W

LOOPUM0808A
                RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    LUM0808NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808A

                CLRF    AARGB0
                RETLW   H'00'

LUM0808NAP
                BCF     STATUS,C
                GOTO    LUM0808NA

LOOPUM0808
                RRF     BARGB0, F
                BTFSC   STATUS,C
                ADDWF   AARGB0, F
LUM0808NA       RRF    	AARGB0, F
                RRF    	AARGB1, F
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808

                return  

;**********************************************************************************************
        
;       16/8 Bit Unsigned Fixed Point Divide 16/8 -> 16.08

;       Input:  16 bit unsigned fixed point dividend in AARGB0, AARGB1
;               8 bit unsigned fixed point divisor in BARGB0

;      ;       Output: 16 bit unsigned fixed point quotient in AARGB0, AARGB1
;               8 bit unsigned fixed point remainder in REMB0

;       Result: AARG, REM  <--  AARG / BARG

DIV16_8      	CLRF            REMB0
                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608A      RLF             AARGB0,W
                RLF             REMB0, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F

                BTFSC           STATUS,C
                GOTO            UOK68A          
                ADDWF           REMB0, F
                BCF             STATUS,C
UOK68A          RLF             AARGB0, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608A

                CLRF            TEMP1

                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608B      RLF             AARGB1,W
                RLF             REMB0, F
                RLF             TEMP1, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F
                CLRF            AARGB3
                CLRW
                BTFSS           STATUS,C
                INCFSZ          AARGB3,W
                SUBWF           TEMP1, F

                BTFSC           STATUS,C
                GOTO            UOK68B          
                MOVF            BARGB0,W
                ADDWF           REMB0, F
                CLRF            AARGB3
                CLRW
                BTFSC           STATUS,C
                INCFSZ          AARGB3,W
                ADDWF           TEMP1, F

                BCF             STATUS,C
UOK68B          RLF             AARGB1, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608B
                return
           

 end
