/* 
 * File:   main.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 25 February 2014, 13:47
 */

/*
 NOTE:  This application uses LPLC board pins PORTB4, PORTC6 and PORTC7
 *      This is because the pins shown on the Feb 2015 article are also used
 *      by the programmer interface, which means the circuit wont work until
 *      you disconnect the programmer.
 */


#include <stdio.h>
#include <stdlib.h>
#include <pic18.h>
#include "config.h"
#include "lplc-adc.h"
#include "timers.h"
#include "LCD-Graphic-ST7735S.h"
#include "interrupts.h"
#include "hardware.h"
#include "lcd.h"
#include "pwm.h"

/*
 * 
 */
int main(int argc, char** argv)
{
    int adcVal;
    int r=40,g=70,b=0;
    int rs=1,bs=1,gs=1;
    int duty;

    // Initialise any low level hardware features
    HardwareInit();

    // Initialise the Interrupt sub-system
    InterruptInit();

    // Initialise the Interrupt sub-system
    timer0Init();
    timer1Init();

    // Power up delay
    delayms(50);

    adc_init(ADC_FOSC_RC & ADC_RIGHT_JUST & ADC_12_TAD, ADC_CH0 & ADC_INT_OFF & ADC_REF_VDD_VSS,
             0, ADC_0ANA);

    // user application - main loop
    // Code here is called either
    //    a) continuously
    //    b) once per interrupt, if the sleep instruction is present

    /*
     Use PWM to control the three LEDs connected to pins RB5, RB6 and RB7 (RGB)
     Set the period to 25KHz (an arbitrary value when considering LEDs)
    */

    PWMPeriod(24000);
    PWMDuty(PWMPIN1, 50); // RED
    PWMInit(PWMPIN1);
    PWMDuty(PWMPIN5, 50); // GREEN
    PWMInit(PWMPIN5);
    PWMDuty(PWMPIN6, 50); // BLUE
    PWMInit(PWMPIN6);

    while (1) {
        // The sleep instruction will cause the processor to halt, and enter
        // a low power state. Timer1 interrupts will still wake the processor.
        // SLEEP();

        // Read the setting on the trimmer resistor;
        // We will use that as an overall brightness control
        convert_adc();
        while (busy_adc())
            ;
        adcVal = getval_adc();

        // This block is just a bit of fun - cycle round giving each LED
        // a different intensity, creating a fun "mood lamp"
        duty = adcVal / 10;

        PWMDuty(PWMPIN1, (r * duty)/100); // RED
        PWMDuty(PWMPIN5, (g * duty)/200); // GREEN
        PWMDuty(PWMPIN6, (b * duty)/100); // BLUE

        delayms(500);
        r = r + rs * 1; if ((r > 100) || (r < 0)) rs *= -1;
        g = g + gs * 3; if ((g > 100) || (g < 0)) gs *= -1;
        b = b + bs * 5; if ((b > 100) || (b < 0)) bs *= -1;
    }

    // Should never reach this point
    return (EXIT_SUCCESS);
}

