/* 
 * File:   main.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 25 February 2014, 13:47
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18.h>
#include "config.h"
#include "lplc-adc.h"
#include "timers.h"
// Choose the appropriate header file
//#include "LCD-Graphic-ST7735S.h"
#include "LCD-Graphic-ILI9341.h"
#include "interrupts.h"
#include "hardware.h"
#include "lcd.h"
#include "pwm.h"

static const unsigned char oscSig[160] = {
// first 5 are not drawn.
// Following values must be in range 11..254
    0,0,0,0,0,30,32,31,30,60,
    198,198,196,194,196,198,198,192,192,194,
    198,198,198,198,198,30,30,32,30,30,
    30,30,32,30,30,30,28,32,30,30,
    30,30,32,30,30,30,30,30,30,30,
    30,30,32,30,30,30,28,32,30,30,
    198,198,196,194,196,198,198,192,192,194,
    198,198,198,198,198,30,30,32,30,30,
    30,30,32,30,30,30,28,32,30,30,
    30,30,32,30,30,30,30,30,30,30,
    30,30,32,30,30,30,28,32,30,30,
    198,198,196,194,196,198,198,192,192,194,
    198,198,198,198,198,30,30,32,30,30,
    30,30,32,30,30,30,28,32,30,30,
    30,30,32,30,30,30,30,30,30,30,
    30,30,32,30,30,30,28,32,30,30,
};


/*
 * 
 */
int main(int argc, char** argv)
{
    unsigned short lpx, lpy;
    int adcVal;
    int r=40,g=70,b=0;
    int rs=1,bs=1,gs=1;
    int duty;

    // Initialise any low level hardware features
    HardwareInit();

    // Initialise the Interrupt sub-system
    InterruptInit();

    // Initialise the Interrupt sub-system
    timer0Init();
    timer1Init();

    // Power up delay
    delayms(50);

    // Choose the appropriate graphics display init
    //LCDST7735sInit();
    LCDILI9341Init();
    
    LCD_Clear(BLACK);

    // Draw the oscilloscope 'screen'
    POINT_COLOR = GRAY;
    LCD_DrawLine(10,10,10,319);
    LCD_DrawLine(239,10,239,319);
    LCD_DrawLine(10,10,239,10);
    LCD_DrawLine(10,319,239,319);

    // And the graticule
    LINE_MASK = 0xCC;

    for (lpy = 10 + 40; lpy < 320; lpy += 40) {
        LCD_DrawLine(11,lpy,238,lpy);
    }
    for (lpx = 10 + 40; lpx < 240; lpx += 40) {
        LCD_DrawLine(lpx,11,lpx,318);
    }

    LCD_ShowString(0,120," 10ms/div ");
    LCD_ShowString(47,0,"1");
    LCD_ShowString(87,0,"2");
    LCD_ShowString(127,0,"3");
    LCD_ShowString(167,0,"4");
    LCD_ShowString(207,0,"5");

    POINT_COLOR = GREEN;
    LINE_MASK = 0xFF;

    // Show the fake waveform
    for (lpy = 6; lpy < 159; lpy++) {
        LCD_DrawLine(oscSig[lpy-1], (lpy*2)-2, oscSig[lpy], (lpy*2) );
    }


    adc_init(ADC_FOSC_RC & ADC_RIGHT_JUST & ADC_12_TAD, ADC_CH0 & ADC_INT_OFF & ADC_REF_VDD_VSS,
             0, ADC_0ANA);

    // user application - main loop
    // Code here is called either
    //    a) continuously
    //    b) once per interrupt, if the sleep instruction is present

    /*
     Use PWM to control the three LEDs connected to pins RB5, RB6 and RB7 (RGB)
     Set the period to 25KHz (an arbitrary value when considering LEDs)
    */

    PWMPeriod(24000);
    PWMDuty(PWMPIN1, 50); // RED
    PWMInit(PWMPIN1);
    PWMDuty(PWMPIN5, 50); // GREEN
    PWMInit(PWMPIN5);
    PWMDuty(PWMPIN6, 50); // BLUE
    PWMInit(PWMPIN6);

    while (1) {
        // The sleep instruction will cause the processor to halt, and enter
        // a low power state. Timer1 interrupts will still wake the processor.
        // SLEEP();

        // Read the setting on the trimmer resistor;
        // We will use that as an overall brightness control
        convert_adc();
        while (busy_adc())
            ;
        adcVal = getval_adc();

        // This block is just a bit of fun - cycle round giving each LED
        // a different intensity, creating a fun "mood lamp"
        duty = adcVal / 10;

        PWMDuty(PWMPIN1, (r * duty)/100); // RED
        PWMDuty(PWMPIN5, (g * duty)/200); // GREEN
        PWMDuty(PWMPIN6, (b * duty)/100); // BLUE

        delayms(500);
        r = r + rs * 1; if ((r > 100) || (r < 0)) rs *= -1;
        g = g + gs * 3; if ((g > 100) || (g < 0)) gs *= -1;
        b = b + bs * 5; if ((b > 100) || (b < 0)) bs *= -1;
    }

    // Should never reach this point
    return (EXIT_SUCCESS);
}

