/* 
 * File:   main.c
 * Author: mike hibbett
 *
 * Created on 12 February 2014, 21:49
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18f27j13.h>
#include "config.h"

#include "timers.h"
#include "LCD-Graphic-ST7735S.h"

static const unsigned char oscSig[160] = {
// first 10 are not drawn.
// Following values must be in range 11..126
    0,0,0,0,0,0,0,0,0,0,
    99,99,98,97,98,99,99,96,96,97,
    99,99,99,99,99,15,15,16,15,15,
    15,15,16,15,15,15,14,16,15,15,
    15,15,16,15,15,15,15,15,15,15,
    15,15,16,15,15,15,14,16,15,15,
    99,99,98,97,98,99,99,96,96,97,
    99,99,99,99,99,15,15,16,15,15,
    15,15,16,15,15,15,14,16,15,15,
    15,15,16,15,15,15,15,15,15,15,
    15,15,16,15,15,15,14,16,15,15,
    99,99,98,97,98,99,99,96,96,97,
    99,99,99,99,99,15,15,16,15,15,
    15,15,16,15,15,15,14,16,15,15,
    15,15,16,15,15,15,15,15,15,15,
    15,15,16,15,15,15,14,16,15,15,
};

/*
 * 
 */
int main(int argc, char** argv)
{
    unsigned short lpx, lpy;

    timer0Init();

    // Power up delay
    delayms(50);

    LCDST7735sInit();

    LCD_Clear(BLACK);

    // Draw the oscilloscope 'screen'
    POINT_COLOR = GRAY;
    LCD_DrawLine(10,10,10,159);
    LCD_DrawLine(127,10,127,159);
    LCD_DrawLine(10,10,127,10);
    LCD_DrawLine(10,159,127,159);

    // And the graticule
    LINE_MASK = 0xCC;

    for (lpy = 10 + 20; lpy < 160; lpy += 20) {
        LCD_DrawLine(11,lpy,126,lpy);
    }
    for (lpx = 10 + 20; lpx < 128; lpx += 20) {
        LCD_DrawLine(lpx,11,lpx,158);
    }

    LCD_ShowString(0,50," 10ms/div ");
    LCD_ShowString(27,0,"1");
    LCD_ShowString(47,0,"2");
    LCD_ShowString(67,0,"3");
    LCD_ShowString(87,0,"4");
    LCD_ShowString(107,0,"5");

    POINT_COLOR = BLUE;
    LINE_MASK = 0xFF;
    
    // Show the fake waveform
    for (lpy = 12; lpy < 159; lpy++) {
        LCD_DrawLine(oscSig[lpy-1], lpy-1, oscSig[lpy], lpy );
    }

    while (1);

    // Should never reach this point

    return (EXIT_SUCCESS);
}

