/*
 * File:   interrupts.c
 * Author: Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 31 March 2014, 20:53
 *
 * Interrupt routines.
 */

#include <pic18.h>
#include "interrupts.h"
#include "kitchen.h"

#define TOGGLE_LED_TIME 1   // time between toggling the LED - 2s

extern unsigned char timerState;

unsigned char delay_2s;
volatile unsigned char IntOccurred;


/*************************************************************************
 * Function: InterruptInit
 * Initialises the interrupt sub-system.
 *************************************************************************
 */
void InterruptInit( void )
{
    delay_2s = TOGGLE_LED_TIME;
    IntOccurred = 0;
}


/*************************************************************************
 * Function: InterruptHandler
 * Provides a basic interrupt handler function.
 *************************************************************************
 */
void interrupt InterruptHandler( void )
{
    // Clear the interrupt flag. Only one interrupt is enabled,
    // so this must be it
    PIR1bits.TMR1IF = 0;

    delay_2s--;

    if ( !delay_2s ) {

        delay_2s = TOGGLE_LED_TIME;

        // is the timer running?
        if (timerState == 2) {
            // Only toggle the LED if the timer is actually running
            LATBbits.LATB5 = ~LATBbits.LATB5;

            // Signal to the foreground that an interrupt occurred
            // so it can update the display. Also, decrement the
            // timer.
            // A value of 2 indicates that the timer has expired

            IntOccurred = 1;

            // Decrement the timer by two seconds
            if (!decTimer()) {
                IntOccurred = 2;
            } else {
                if (!decTimer()) {
                    IntOccurred = 2;
                }
            }
        }
    }
}