    include <P18f27J13.INC>

	CONFIG WDTEN = OFF
	CONFIG XINST = OFF
	CONFIG IESO = OFF
	CONFIG FCMEN = OFF
	CONFIG DSWDTEN = OFF
	CONFIG OSC = INTOSCPLL
	CONFIG CFGPLLEN = ON
	CONFIG PLLDIV = 2
	CONFIG PLLSEL = PLL96
	
; RAM addresses of variables
delay_2s	EQU	0x00
	
; Constants
TMR1_CONF 	EQU 0x8E	      ; timer is 16bit, TMR1 SOC source, prescale by 1 (None)
TOGGLE_LED_TIME	EQU .5	; time between toggling the LED - 10s
	
	
	; Set the code address to start of flash -
	; this is where the processor will start 
	; executing instructions from after a reset.
	org      0
	goto     main
	
	; Interrupt routine entry address - always 0x0008
	org 8
	bcf 	   PIR1, TMR1IF
	
	; only toggle the LED after 5 interrupts
	decfsz	delay_2s
	goto	   int_exit	
	
	comf	   LATB		; toggle all bits in PORTB
	
	movlw	   TOGGLE_LED_TIME
	movwf	   delay_2s	; reset the 10s counter
	
int_exit:
	retfie   FAST
	
main:
	movlw    0x00	
	movwf    TRISB		; Set PORTB as an output
		
	movlw	   TOGGLE_LED_TIME
	movwf	   delay_2s
	
	bcf 	   PIR1, TMR1IF
	movlw	   HIGH TMR1_COUNT_1S
	movwf	   TMR1H
	movlw	   LOW TMR1_COUNT_1S
	movwf	   TMR1L
	
	; Enable the 32KHz oscillator on Timer1
	movlw	   TMR1_CONF
	movwf	   T1CON	 	
	bsf      PIE1, TMR1IE
	bsf		INTCON, PEIE
	bsf		INTCON, GIE
	bsf		T1CON, TMR1ON

loop:
	sleep
	goto     loop
	
	
	
	end
	
