/*
    Module: main.c

    Author: Mike Hibbett

    Date: 21/11/09

    Function: Main project source code, targetting a PIC18F45K20
              
*/

#include <p18cxxx.h>
#include <usart.h>
#include <stdio.h>
#include "mainconfig.h"
#include "serialDebug\serialDebug.h"

#define versionNumber "Project v0.1"

#define BAUD_RATE_GEN 416   // Fosc = 16MHz, Baud Rate = 9600 bps. SYNC=0, BRGH=BRG16=1


void low_isr( void );
void high_isr( void );

#pragma code low_vector=0x18
void low_interrupt(void)
{
	_asm GOTO low_isr _endasm
}

#pragma interruptlow low_isr
void low_isr (void)
{
    
    if ( PIR1bits.RCIF ) {
        /* Serial port handler for debugging interface */
	    sdRxChar(RCREG);
	}
}

#pragma code high_vector=0x08
void high_interrupt(void)
{
	_asm GOTO high_isr _endasm
}

#pragma code

#pragma interrupt high_isr
void high_isr (void)
{
    static unsigned char lastKeyState = 0xD4;
    static unsigned char keyDebounce = 0;
    unsigned char key;
    
    if (PIR1bits.TMR2IF) {
	    
	    /* Example interrupt handling. Interrupt handling code goes here */
	    
    	PIR1bits.TMR2IF = 0;   	
	}
}



void hwInit(void)
{
    // Setup port pins. Unused ones are set to output low
    PORTA = 0;
    TRISA = 0;
    PORTC = 0;
    TRISC = 0x80; /* Ensure rs232 interface is an input */
    PORTD = 0;
    TRISD = 0;
    PORTE = 0;
    TRISE = 0;
    PORTB = 0;
    TRISB = 0;

    /* Select 16MHz internal clock. Or whatever clock source you wish. */
    /* Internal oscillator is easier, as there are fewer components to go wrong */
	OSCCON = 0xF2;

    // Setup the uart interface	  
    TXSTA = 0x24;
    BAUDCON = 0x08;
    SPBRGH = BAUD_RATE_GEN / 256;
    SPBRG = BAUD_RATE_GEN & 0xFF;
    RCSTA = 0x90;
    
    /* set interrupt to the low priority one */
    IPR1 = 0xDF;
    
    /* Clear RCIF flag */
    PIR1 = 0;
    
    /* Set RCIE flag */
    PIE1 = 0x20;
    
    /* Enable Priority Interrupts */
    RCON = 0x80;
    
    /* Set PEIE and GIE flags */
    INTCON = 0xC0;
}




void main(void) 
{
    hwInit();    

	/* Display startup banner over the debug interface */
    putrsUSART((const far rom char *)versionNumber);
    
    while (1) {
        
        /* The process is set to idle with just peripheral clock on, CPU off */
        /* Wake-up caused by any interrupt, including debug serial data */
        Sleep();
        Nop();
        Nop();
        
        /* Your own 'main loop' code goes here */
        
        /* This only does real work when a LF character is detected on the serial line */
		serialDebug();
				
    }   
}
	