/****************************************************************************
*
*   Module:     pic24ps2key.h
*   Author:     Mike Hibbett
*   Date:       19/4/09
*   Purpose:    Header file for the PIC24 PS2 Keyboard library.
*                
****************************************************************************/

/* Codes for special keys */    
enum specialKeys { F1=0xC0, F2, F3, F4, F5, F6, F7, F8, F9, F10, F11, F12, 
                   LEFTALT, LEFTCTRL, NUMLOCK, SCRLK, ALTPRTSC }; 



/****************************************************************************
*
*   Function:   PIC24ps2keyInit
*   inputs:     none
*   returns:    none
*   Purpose:    Setup the I/O used by the keyboard system.
*
****************************************************************************/
void PIC24ps2keyInit(void);


/****************************************************************************
*
*   Function:   PIC24ps2keyGetByte
*   inputs:     none
*   returns:    a byte from the keyboard buffer
*   Purpose:    Low level interface to the keyboard driver.
*               This routine will block until data bytes come in.
*
****************************************************************************/
unsigned char PIC24ps2keyGetByte( void );


/****************************************************************************
*
*   Function:   PIC24ps2keyGetKey
*   inputs:     none
*   returns:    A character from the keyboard.
*   Purpose:    When called, will parse characters in the 
*               Your application reads this to get 2 byte pairs for a key press.
*               This function will block until a key is pressed.
*
****************************************************************************/

unsigned int PIC24ps2keyGetKey( void );
