 ;MIDI Activity Detector
 ;~~~~~~~~~~~~~~~~~~~~~~
 ;Everyday Practical Electronics
 ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;by
 ;David Clark
 ;
 ;PIC - 16F627
 ;~~~~~~~~~~~~
 ;
 ;Function
 ;~~~~~~~~
 ;Read MIDI messages and
 ;light LEDs according to
 ;activity - system messages
 ;and channel messages
 ;Includes switched clock filter
 ;
 ;Needs 4MHz xtal for correct operation
 ;
 ;Standard MIDI in
 ;
 ;System Messeage LED on Port B RB3 
 ;Channel Messeage LED on Port B RB4
 ;Clock Filter Switch on Port A RB0
 ;
 ;Timer modules used as pulse extenders
 ;for lighting leds for a sufficiently 
 ;long period to be visible
 ;
 ;START OF ASSEMBLY INSTRUCTIONS
 ;+*SAI*************************
 ;
 ;***************************************
 ;
 ;BRUNSOFT ONLY DIRECTIVES
 ;+*BOD*******************
 ;
 ;pic16f627;Device
 ;~~~~~~
 ;identity 'MADEPE 1';Identity code
 ;~~~~~~~~~~~~~
 ;config %11111101100001;Configuration
 ;~~~~~~~~~~~~~
 ;Program code protection off <13:10>
 ;<9> unimplemented (1)
 ;Data memory code protection off <8>
 ;Low voltage programming disabled <7>
 ;Brown-out detect enabled <6>
 ;<5> ra5/mclre- is mclre-
 ;XT xtal oscillator on ra6,ra7 <4,1:0>
 ;Power-up timer enabled <3>
 ;Watchdog timer disabled <2>
 ;<1:0> see <4,1:0>
 ;
 ;Missing intrinsic directives
 ;+*MID~~~~~~~~~~~~~~~~~~~~~~~
 ;equ ;
 ;
 ;END OF BRUNSOFT ONLY DIRECTIVES
 ;+*EOBOD********************************
 ;
 ;***************************************
 ;
 ;ASM ONLY DIRECTIVES
 ;+*AOD**************
 ;
 ;LIST R=DEC ;Default radix decimal
 ;LIST P=PIC16f627 ;Device
 ;
 ;__CONFIG %11111101100001;Configuration
 ;
 ;Program code protection off
 ;Data code protection off
 ;Low voltage programming disabled
 ;Brown-out detect enabled
 ;MCLR- selected
 ;Power-up timer enabled
 ;Watchdog timer disabled
 ;XT xtal selected
 ;
 ;WORKING REGISTERS
 ;+----------------
 ;
W equ 0 ;working register flag
F equ 1 ;file register flag
 ;
 ;END OF WORKING REGISTERS
 ;------------------------
 ;
 ;SPECIAL FUNCTION REGISTERS
 ;+-------------------------
 ;
 ;**Check these for Bank
 ;
 ;TXREG equ $19;
 ;
 ;BANK 0
 ;+-----
 ;
 ;PCL equ $02 ;
STATUS equ $03 ;
RP0 equ 5 ;
RP1 equ 6;
 ;C equ 0 ;
Z equ 2 ;
 ;
PORTA equ $05 ;
RA0 equ 0;
 ;RA3 equ 3 ;
 ;RA4 equ 4 ;
 ;
PORTB equ $06 ;
RB4 equ 4;
RB3 equ 3;
RB2 equ 2;
RB1 equ 1;
RB0 equ 0;
 ;RS equ 4;LCD rs control line on port b
 ;E equ 5;LCD e control line on port b
 ;
INTCON equ $0B ;
GIE equ 7;
PEIE equ 6;
T0IE equ 5;
INTE equ 4;
RBIE equ 3;
T0IF equ 2;
INTF equ 1;
RBIF equ 0;
 ;
PIR1 equ $0C ;
EEIF equ 7;
CMIF equ 6;
RCIF equ 5;
TXIF equ 4;
CCP1IF equ 2;
TMR2IF equ 1;
TMR1IF equ 0;
 ;
TMR1L equ $0E ;
 ;
TMR1H equ $0F ;
 ;
T1CON equ $10 ;
T1CKPS1 equ 5;
T1CKPS0 equ 4;
T1OSCEN equ 3;
T1SYNC equ 2;
TMR1CS equ 1;
TMR1ON equ 0 ;
 ;
RCSTA equ $18 ;
CREN equ 4 ;
SPEN equ 7 ;
 ;
RCREG equ $1A ;
 ;
CMCON equ $1F ;
 ;C1OUT equ 6 ;
 ;
 ;BANK 1
 ;+-----
 ;
OPTION equ $81;
 ;OPT_REG equ $81 ;
 ;
TRISA equ $85 ;
 ;TRISA4 equ 4;
 ;TRISA0 equ 0;
 ;
TRISB equ $86 ;
 ;TRISB2 equ 2;
 ;TRISB1 equ 1;
 ;
SPBRG equ $99 ;
 ;
PIE1 equ $8C ;
 ;RCIE equ 5 ;
 ;CMIF equ 6 ;
 ;VRCON equ $1F ;
 ;
 ;END OF SPECIAL FUNCTION REGISTERS
 ;---------------------------------
 ;
 ;END OF ASM ONLY DIRECTIVES
 ;+*EOAOD********************************
 ;
 ;
 ;GENERAL PURPOSE REGISTERS
 ;+*GPR********************
 ;
MIDI_BYTE equ $20;
T0_DLY equ $21 ;
 ;END OF GENERAL PURPOSE REGISTERS
 ;+*EOGPR********************************
 ;
 ;END OF SET UP ASSEMBLERS
 ;+*EOSUA*****************
 ;
 ;***************************************
 ;
 ;PROGRAMME CODE
 ;
 ;+*PC******************
 ;
 ;device code origin
 ;+*ORGDC***********
 org $0000 ;
 goto PRG_STRT;
 ;
 ;interrupt vector origin
 ;+*ORGIV****************
 org $0004;
 ;Interrupt vector
 ;nb first jump address must lie within
 ;first 2k (setting pclath not available
 ;for interrupt vector address)
 ;
 ;goto INT_VCTR;
 ;
 ;programme code origin
 ;+*ORGPC**************
 org $0005;
PRG_STRT: ;
 ;Configure PIC modules
 call CON_COMP;
 call CON_IO;
 call CON_USART;
 call CON_TMR0;
 call CON_TMR1;
 ;Clear USART receiver registers
 movf RCREG,W;
 movf RCREG,W;
 movf RCREG,W;
 ;Enable reception
 bsf RCSTA,CREN;
 ;=======================================
 ;
 ;BEGINNING OF MAIN PROGRAMME LOOP
 ;
 ;+*MPL**************************
MAIN_LP: ;
 ;Wait until MIDI byte received
 ;Continue to check led timers
 ;while doing so
RX_LP_1: ;
 btfsc PIR1,RCIF;
 goto MIDI_RCVD;
 ;Check timers and switch off leds as 
 ;appropriate
 ;
 ;Timer0
 btfss INTCON,T0IF;
 goto LED_ON_0;
 ;
 ;switch off led 0
 bcf PORTB,RB3;
 ;reset timer0 flag
 bcf INTCON,T0IF;
LED_ON_0: ;
 ;
 ;Timer1
 btfss PIR1,TMR1IF;
 goto LED_ON_1;
 ;
 ;switch off led 1
 bcf PORTB,RB4;
 ;reset timer1 flag
 bcf PIR1,TMR1IF;
LED_ON_1: ;
 ;
 ;
 goto RX_LP_1;
 ;end of wait for midi byte loop
MIDI_RCVD: ;
 ;Transfer MIDI byte to general purpose 
 ;register
 movf RCREG,W;
 movwf MIDI_BYTE;
 ;Establish whether system, data or
 ;channel message
 ;
 ;Ignore message data bytes
 btfss MIDI_BYTE,7;
 goto CHK_TMRS;
 ;
 ;If reached here, must be system or
 ;channel message
 ;
 ;Determine which
 ;If most significant nibble is %1111,
 ;then it is a system message
 movlw %11110000;
 andwf MIDI_BYTE,W;
 sublw %11110000;
 btfss STATUS,Z;
 goto NOT_SYS;
 ;If reached here, must be system
 ;message
 ;
 ;
 ;Is it a clock message?
 movf MIDI_BYTE,W;
 sublw %11111000;
 btfss STATUS,Z;
 goto NOT_CLK;
 ;If reached here, must be a clock
 ;message
 ;
 ;Check if 'ignore clock' switch
 ;is on ('0' = on ie ignore message)
 ;If so, exit loop via timers check
 btfss PORTA,RA0;
 goto CHK_TMRS;
 ;If it is a clock message and
 ;'ignore clock' switch is not on,
 ;or it is another system message,
NOT_CLK: ;
 ; - light appropriate led
 ; - start/reset appropriate timer
 clrf T0_DLY;
 bsf PORTB,RB3;
 ;bsf PORTA,RA0;
 ;
 goto CHK_TMRS;
 ;
NOT_SYS: ;
 ;If reached here, must be channel
 ;message, so
 ;
 ; - light appropriate led
 ; - start/reset appropriate timer
 ;
 ;Stop tmr1
 bcf T1CON,TMR1ON;
 ;Reset timer
 clrf TMR1H;
 clrf TMR1L;
 ;Light channel message led
 bsf PORTB,RB4;
 ;Start tmr1
 bsf T1CON,TMR1ON;
 ;
 goto CHK_TMRS;
CHK_TMRS: ;
 ;Check timers and switch off leds as 
 ;appropriate
 ;
 ;Check timer0
CHK_TMR0: ;
 btfss INTCON,T0IF;
 goto CHK_TMR1;
 ;
 ;switch off system led
 bcf PORTB,RB3;
 ;reset timer0 flag
 bcf INTCON,T0IF;
 goto ENDOFLOOP;
 ;
 ;Check timer1
CHK_TMR1: ;
 btfss PIR1,TMR1IF;
 goto ENDOFLOOP;
 ;
 ;switch off channel led
 bcf PORTB,RB4;
 ;reset timer1 flag
 bcf PIR1,TMR1IF;
 goto ENDOFLOOP;
 ;
ENDOFLOOP: ;
 ;Loop back and wait for next MIDI byte
 goto MAIN_LP;
 ;END OF MAIN PROGRAMME LOOP
 ;+*EOMPL********************************
 ;
 ;SUB-ROUTINES
 ;+*SR*********************
 ;
 ;CONFIGURATION SUB-ROUTINES
 ;+*CONSR****************************
 ;
 ;
 ;CONFIGURE I/O SUB-ROUTINES
 ;+*CONIO===================
CON_IO: ;
 ;TRISA and TRISB are set to all inputs
 ;after a reset ie at power up
 ;
 ;CONFIGURE PORT A
 ;+*CONPORTA======
 ;
 ;Set RA0 as i/p
 ;Set <RA1:RA3> as o/p
 ;
 ;Bank 1
 bsf STATUS,RP0;
 ;
 movlw %11110001;
 movwf TRISA;
 ;+END OF PORT A CONFIGURATION
 ;----------------------------
 ;
 ;CONFIGURE PORT B
 ;+*CONPORTB======
 ;
 ;RB1 and RB2 must be set as i/p to
 ;use the USART
 ;RB1 is RX
 ;RB2 is TX
 ;
 ;(Default setting on power up)
 ;
 ;Set RB0,RB3:RB7 as o/p
 ;
 ;
 ;Bank 1
 movlw %00000110;
 movwf TRISB;
 ;+END OF PORT B CONFIGURATION
 ;----------------------------
 ;
 ;
 ;reset to bank 0
 bcf STATUS,RP0;
 ;
 return;
 ;END OF CONFIGURE I/O SUB-ROUTINES
 ;=================================
 ;
 ;
 ;CONFIGURE USART SUB-ROUTINE
 ;+*CONUSART=================
CON_USART: ;
 ;The USART is used to input MIDI bytes
 ;
 ;RB1 and RB2 must be set as i/p to
 ;use the USART - see i/o configuration
 ;RB1 is RX
 ;RB2 is TX
 ;
 ;Set baud rate to 31250
 ;
 ;4MHz xtal
 ;
 ;Bank 1
 bsf STATUS,RP0 ;
 ;Required TXSTA,BRGH = 0 is default
 ;at power up
 ;
 ;Set SPBRG (X) to 1
 movlw 1;
 movwf SPBRG ;
 ;Required asynchronous mode is default
 ;at power up
 ;
 ;Enable serial port
 ;
 ;Bank 0
 bcf STATUS,RP0 ;
 bsf RCSTA,SPEN;
 ;Required 8-bit data is power up default
 ;
 ;Interrupts not required
 return ;
 ;END OF CONFIGURE USART SUB-ROUTINE
 ;==================================
 ;
 ;CONFIGURE COMPARATORS S-R
 ;+------------------------
CON_COMP: ;
 ;Comparator module set to all analogue
 ;inputs on power-up
 clrf PORTA;
 ;Set up comparator module as all
 ;comparators off ie PORTA <RA0:RA3>
 ;are all digital i/o
 ;
 ;Already bank 0
 ;
 movlw %00000111;
 movwf CMCON;
 ;
 return;
 ;END OF CONFIG COMPARATORS S-R
 ;==============================
 ;
 ;==================================
 ;
 ;CONFIGURE TIMER0 SUB-ROUTINE
 ;+*CONTIMER0=================
CON_TMR0: ;
 ;general purpose timer
 ;
 ;Set Timer 0 counter source to internal,
 ;= fosc/4 ie 1us at 4MHz
 ;
 ;Prescalar assigned to Timer 0
 ;
 ;default prescalar is 1:256 (max) -
 ;use this, hence each count is 256us
 ;256 counts before overflow,
 ;hence time-out at 65.5ms
 ;
 ;
 ;ensure no spurious reset issues
 CLRWDT;
 ;Bank 1
 bsf STATUS,RP0;
 ;set up timer0
 movlw %00000111;
 movwf OPTION;
 ;
 ;Bank 0
 bcf STATUS,RP0;
 ;
 return;
 ;END OF CONFIG TIMER0 SUB-ROUTINE
 ;================================
 ;
 ;================================
 ;
 ;CONFIGURE TIMER1 SUB-ROUTINE
 ;+---------------------------
CON_TMR1: ;
 ;
 bcf STATUS,RP0;Bank 0
 ;
 ;Tmr prescalar 1:1 - each increment of
 ;tmr1h = 256us
 bcf T1CON,T1CKPS1;
 bcf T1CON,T1CKPS0;
 ;256 tmr1h counts before overflow,
 ;hence time-out at 65.5ms
 ;
 ;Switch off external clock inverter
 bcf T1CON,T1OSCEN;
 ;Use internal clock
 bcf T1CON,TMR1CS;
 ;Stop clock
 bcf T1CON,TMR1ON;
 ;Reset timer
 clrf TMR1H;
 clrf TMR1L;
 ;PIR1,TMR1IF flag is set on overflow
 ;Clear TMR1 overflow flag
 bcf PIR1,TMR1IF;
 ;
 return;
 ;END OF CONFIG TIMER1 SUB-ROUTINE
 ;================================
 ;
 ;END OF CONFIGURATION SUB-ROUTINES
 ;+*EOCONSR******************************
 ;
 ;=======================================
 ;
 ;====================
 ;ASM ONLY DIRECTIVE
 ;
 ;+*****************
 ;end
 ;
 ;END OF ASM ONLY DIRECTIVE
 ;*************************
 ;
 ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;
