; txTVstandby320.ASM 06MAY07

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

    include p16f627.inc
    __CONFIG   h'3F30' ; int osc (4MHz)
    List P = PIC16F627, r=dec

        CBLOCK
CLKCNT
SWITCH
ONFLAG
MAINIDCODE
       ENDC

PROMVAL EQU h'70'    ; in both pages
SPBRG   EQU h'99'    ; not in INC file for some odd reason.  Bank 1

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto STARTIT

;****************

STARTIT: clrf PORTA
        clrf PORTB
        movlw 7
        movwf CMCON

        BANK1
        movlw b'11111011'     ; PORTB as input, except RB2 as output
        movwf TRISB
        movlw b'00011111'     ; RA0-2 S1-S3, RA3-RA4 for S4 bank
        movwf TRISA
        movlw b'00000111'     ; timer 1:128, pull-ups on (bit 7 = 0)
        movwf OPTION_REG
        BANK0

        call PAUSIT

        btfss PORTA,0
        goto ST2
        clrf SWITCH
        call SWITCHID         ; get main ID
        movf SWITCH,W
        movwf PROMVAL
        movlw 0
        call SETPRM

waithere: nop
        goto waithere       ; wait till power off


ST2:    call JOESETBAUD     ; initialise serial BAUD rate etc
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT

        movlw 0
        call PRMGET
        iorlw 64
        movwf MAINIDCODE

MAIN:   btfsc PORTA,0    ; is single send needed?
        goto SENDSINGLE  ; yes
        btfsc PORTA,1    ; no, is turn off all needed?
        goto TURNOFFALL  ; yes
        goto MAIN        ; no

TURNOFFALL:
        movf MAINIDCODE,W
        call TXBYTE      ; send main ID
        call PAUSIT2
        bsf PORTA,6      ; turn on TX LED

        movlw %11000000  ; send clear all code
        call TXBYTE
        call PAUSIT      ; allow for switch bounce
        bcf PORTA,6      ; turn off TX LED

TO2:    btfsc PORTA,1    ; is PORTA,1 still pressed?
        goto TO2         ; yes
        goto MAIN        ; go back to MAIN

SENDSINGLE:
        clrf ONFLAG
        btfsc PORTA,2    ; is ON mode needed?
        bsf ONFLAG,7     ; yes
        movf ONFLAG,W
        movwf SWITCH
        call SWITCHID

        bsf PORTA,6      ; turn on LED on RA6

        movf SWITCH,W
        movwf PROMVAL
        movlw 3
        call SETPRM

SS2:    movf MAINIDCODE,W ; send main ID code
        call TXBYTE
        call PAUSIT2

        movf SWITCH,W    ; send receiver ID code
        call TXBYTE
        call PAUSIT2

        call PAUSIT
        bcf PORTA,6
SS0:    btfsc PORTA,0    ; is single send still pressed?
        goto SS0         ; yes
        call PAUSIT      ; no, allow for switch bounce
        goto MAIN

;*****************************************************************************

PAUSIT: movlw 5         ; 1/5th sec wait
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:  btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

PAUSIT2: movlw 1
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE2: btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE2     ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE2     ; no
        return          ; yes


; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ;according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
	
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL, which is located in both pages at or above h'70'
SETPRM: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value from PROMVAL and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw h'55'       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw h'AA'       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        BANK0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR1 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR1
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x    retlwvices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read flag
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        BANK0
        return

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03

JOESETBAUD: BANK1               ; Configure the baud rate generator
;        movlw 207                ; BRG for 1200baud from 4MHz, brgh=1
        movlw 103                ; BRG for 2400baud from 4MHz, brgh=1
;        movlw 51                ; BRG for 4800baud from 4MHz, brgh=1
                                ; Internal osc is 4MHz

        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2=1) & ASYNC transmission (bit 5=0)
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0

        movlw   b'10010000'     ; ASYNC reception ; no reception for this PIC
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Send byte in W to the USART

TxByte: nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer:
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
        movf    RCREG,W
        return

SWITCHID: btfsc PORTA,3  ; is RA3 high
        bsf SWITCH,0     ; yes, set SWITCH bit 0
        btfsc PORTA,4    ; is RA4 high
        bsf SWITCH,1     ; yes, set SWITCH bit 1

        btfsc PORTB,0    ; is RB0 high?
        bsf SWITCH,2     ; yes, set SWITCH bit 2
        btfsc PORTB,3    ; is RB3 high?
        bsf SWITCH,3     ; yes, set SWITCH bit 3
        btfsc PORTB,4    ; is RB4 high?
        bsf SWITCH,4     ; yes, set SWITCH bit 4
        btfsc PORTB,5    ; is RB5 high?
        bsf SWITCH,5     ; yes, set SWITCH bit 5
        return

;*************

        org H'2100'      ; data eeprom address
        DE 63
        DE 0
        DE 0
        DE 0

        END
