; TEACHINE05.ASM 11JUN07 - TEACH IN 2008 PT5
; BCD counting in seconds

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a
                               ; list (LST) file

           include p16f628.inc ; bring in all standard register values

           CBLOCK h'20'
RSLINE
STORE
LOOP
LOOPA
CLKCNT
CLKSEC
TEMP
          ENDC

           __config  h'3F21'     ; external xtal oscillator (3.2768MHz)

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

           include LCDheader.inc

STARTIT    clrf PORTA          ; clear PORTA's output if any
           clrf PORTB          ; clear PORTB's output if any
           movlw 7             ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1
           movlw b'00000000'   ; PORTA as output
           movwf TRISA         ; data direction register for PORTA
           movlw b'00000000'   ; PORTB as output
           movwf TRISB         ; data direction register for PORTB
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0

           call PAUSIT

           call LCDSET
	   call PAUSIT

                movlw 25                ; set CLKCNT to 25
                movwf CLKCNT
                clrf CLKSEC             ; clear seconds
                bcf INTCON,2            ; clear time-out flag
                 
MAIN            btfss INTCON,2          ; has a timer time-out been detected?
                goto MAIN               ; no
                bcf INTCON,2            ; yes, clear flag
                decfsz CLKCNT,F         ; dec CLKCNT (1/25 divider), is it zero?
                goto MAIN               ; no
                movlw 25                ; yes, reset it to 25
                movwf CLKCNT
                incf CLKSEC,F           ; inc secs
                movf CLKSEC,W           ; check for secs val greater than 9
                addlw 6
                btfss STATUS,DC         ; is there a digit carry (>15)?
                goto OUTPUT             ; no, bypass next part
                movwf CLKSEC            ; yes, move new val to secs
                movlw B'01100000'       ; load W with BCD 60
                xorwf CLKSEC,W          ; alternative way of checking instead of adding
                btfsc STATUS,Z          ; is CLKSEC = 60 (has XOR found equality, Z=1)?
                clrf CLKSEC             ; yes, clear secs

OUTPUT   	call LCD1
		bsf RSLINE,4
                swapf CLKSEC,W           ; get secs tens val
		andlw b'00001111'        ; knock out MSN
		iorlw 48                 ; convert to ASCII
		call LCDOUT              ; show it
                movf CLKSEC,W            ; get secs units val
		andlw b'00001111'	 ; knock out LSN
		iorlw 48                 ; convert to ASCII
		call LCDOUT              ; show it
                movlw ' '
                call LCDOUT
                movlw 'S'
                call LCDOUT
                movlw 'E'
                call LCDOUT
                movlw 'C'
                call LCDOUT
                movlw 'S'
                call LCDOUT

                call LCD21
		bsf RSLINE,4
		movf CLKSEC,W
		movwf TEMP
		call SHOWBINARY

                goto MAIN                ; go back to reading time-out bit


SHOWBINARY: movlw 8
	   movwf LOOP

SB2	   bcf STATUS,C
	   rlf TEMP,F
	   movf STATUS,W
	   andlw 1
	   xorlw 48             ; convert to ASCII value
	   call LCDOUT
           decfsz LOOP,F
	   goto SB2
	   return


PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

           include LCDroutines.inc

           END
