; TEACHINE02.ASM 09JUN07 - TEACH IN 2008 PT2

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

           include p16f628.inc

           __config  $3F30    ;  internal 4MHz oscillator

	   CBLOCK h'20'
CLKCNT
COUNT
RATE
	   ENDC

           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 

STARTIT    clrf PORTB              ; clear Port B data register
           BANK1                   ; BANK 1
           clrf TRISB              ; Port B direction register for output
           movlw b'10000000'       ; timer 1:2, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0                   ; BANK 0
           clrf RATE               ; start with a rate of 0
           movlw 32                ; startinjg value for COUNT
           movwf COUNT
                 
           bsf STATUS,C            ; set the Carry bit in STATUS

           call DELAY              ; brief pause
                 
LOOP       rlf PORTB,F             ; rotate left PORTB
	   call DELAY
           decfsz COUNT,F
           goto LOOP               ; repeat
           movf RATE,W             ; timer rate
           BANK1                   ; BANK 1
           iorlw b'10000000'
           movwf OPTION_REG
           BANK0                   ; BANK 0
           incf RATE,F             ; inc rate value
           bcf RATE,3              ; restrict rate val to 7 max
           movlw 32                ; reset COUNT val
           movwf COUNT
           goto LOOP               ; repeat

DELAY      movlw 50                ; set delay counter to 50
           movwf CLKCNT            ;
           clrf INTCON             ; clear interupt flag

DELAY2     btfss INTCON,2          ; has a timer time-out been detected?
           goto DELAY2             ; no
           bcf INTCON,2            ; yes
           decfsz CLKCNT,F         ; dec counter, is it zero?
           goto DELAY2             ; no
           return                  ; yes

           END
