; ORGCTL820.ASM 29NOV06  ; COPYRIGHT JOHN BECKER - ORGAN CONTROLLER
; PIC POLYPHONIUM MASTER

; 1st byte    2nd byte           3rd byte (note length)
; MSB  LSB    MSB  LSB  1st note MSB  LSB 2nd note
; Oct Note    Oct Note

PIC16F877, WDT OFF, POR ON, 10MHz

#DEFINE BANK0 BCF $03,5
#DEFINE BANK1 BSF $03,5
#DEFINE SERIALDELAY call CYCLES17  ;25
; CYCLES25 for 20MHz, CYCLES5 for 4MHz or below

        List P = PIC16F877, R=DEC; 
        __CONFIG h'3F33' ; ext osc - source TOG PIC xtal
        include P16F877.inc

        CBLOCK
CLKCNT
LOOP
LOOPMSB

NOTESTOREA
NOTESTOREAs
NOTESTOREB
NOTESTOREC
NOTESTORECs
NOTESTORED
NOTESTOREDs
NOTESTOREE
NOTESTOREF
NOTESTOREFs
NOTESTOREG
NOTESTOREGs

STORE1
NOTEBYTE2
NOTELENBYTE
CONTINUOUS
TEMPTIMER
FILELENMSB
FILELENLSB
SWITCH
SWITCHMEM
PREVSWITCH

; ******* serial eeprom equates

MEMHI     
MEMLO     
WADDRL    
WADDRH    
WADDRLSTORE
WADDRHSTORE
RADDRH
RADDRL    
POLLCNT     ; serial eeprom use
SLAVE       ; serial eeprom use
TXBUF       ; serial eeprom use
BCOUNT  
COUNT   
DATAI   
DATAO   
EEPROM  
ECHAN
MEMCNT
ECHANTEMP
MEMFUL
STORE
COUNTERMSB
COUNTERLSB
	ENDC

PROMVAL .EQU $70    ; in both banks
SPBRG   .EQU $99    ; not in INC file for some odd reason.  Bank 1

             ;********** BIT DEFINITIONS **************************************************

DI:         EQU 7        ; eeprom input bit
DO:         EQU 6        ; eeprom output bit
SDATA:      EQU 4        ; serial EE data & RTC data line (PORTC) 
SCLK:       EQU 3        ; serial EE clock 
TCLK:       EQU 3        ; RTC clk line (PORTA)


; **********************

        ORG 0
        goto GIEOFF
        nop
        nop
        nop
        ORG 4                 ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE        ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

SETSWITCHMEM:           ; address at which EPROM data stored
        movf SWITCH,W
        andlw 7
        addwf PCL,F
        retlw 0     ; 0
        retlw 2     ; 1
        retlw 4     ; 2
        retlw 6     ; 3
        retlw 8     ; 4
        retlw 10    ; 5
        retlw 12    ; 6
        retlw 14    ; 7

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03

; TRISC must have bit 7 set for this to work, eg :
;        movlw B'10000000'     ; RC7 as input (RS232 receive)
;        movwf TRISC

JOESETBAUD:
        bcf STATUS,RP1
        bsf STATUS,RP0
        movlw 64                ; BRG for 9600baud from 10MHz, brgh=1
        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Send byte in W to the USART

TxByte
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

; **************

START:  bcf STATUS,RP0
        bcf STATUS,RP1

        clrf ECHAN
        clrf PORTA            ; initialise all port outputs to zero
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE

        BANK1
        movlw %10001110       ; set RHS justify, RA0 as analog input
        movwf ADCON1          ; with RA, RE digital, ref to +VE and 0V
        movlw %00000001       ; RA0 as input, rest as output
        movwf TRISA

        clrf TRISB            ; PORTB as output
        movlw B'10000000'     ; RC7 as input (RS232 receive)
        movwf TRISC
        clrf TRISD            ; PORTD as output
        movlw B'00000111'
        movwf TRISE           ; PORTE as input

        movlw B'10001110'     ; set for RA0 analog, rest of RA & RE as digital
        movwf ADCON1          ; right justified (8 bit only) (bit 7=1)

        movlw B'00000100'     ; timer 1:32, pull-ups on
        movwf OPTION_REG
        BANK0

        movlw %10000001 ; set AD on, Fosc/32,       sample RA0
        movwf ADCON0    ; bit 0    , bits 7/6 = 10, bits 5-7 = 0

        call JOESETBAUD

J4:     clrf NOTESTOREA
        clrf NOTESTOREAs
        clrf NOTESTOREB
        clrf NOTESTOREC
        clrf NOTESTORECs
        clrf NOTESTORED
        clrf NOTESTOREDs
        clrf NOTESTOREE
        clrf NOTESTOREF
        clrf NOTESTOREFs
        clrf NOTESTOREG
        clrf NOTESTOREGs
        clrf STORE
        clrf CONTINUOUS
        comf PORTE,W
        andlw %00000111
        movwf ECHAN
        movwf SWITCH
        movwf PREVSWITCH
        call SETSWITCHMEM
        movwf SWITCHMEM

; *************** START OF MAIN PROG ***********

MAIN:   clrf RADDRH
        clrf RADDRL
        clrf COUNTERMSB
        clrf COUNTERLSB

        movf SWITCHMEM,W
        call PRMGET
        movwf FILELENMSB

;        movwf PROMVAL  ; 29nov06
;        movlw 100      ; 29nov06
;        call SETPRM    ; 29nov06

        incf SWITCHMEM,W
        call PRMGET
        movwf FILELENLSB

;        movwf PROMVAL  ; 29nov06
;        movlw 101      ; 29nov06
;        call SETPRM    ; 29nov06

        movf FILELENMSB,W
        btfss STATUS,Z
        goto MAIN2
        movf FILELENLSB,W
        xorlw 3
        btfss STATUS,Z
        goto MAIN2
        bsf CONTINUOUS,0


MAIN2:  btfss PIR1,RCIF     ; Check for any RX'd data
        goto M2A            ; Nothing RX'd
        movf RCREG,W        ; Store the RX'd data in 'W'
        movwf STORE
        xorlw 'S'
        btfss STATUS,Z
        goto M3A
        goto RECEIVEDATA

M3A:    movf STORE,W
        xorlw 'R'
        btfss STATUS,Z
        goto M2A
        goto READBACKDATA

M2A:    call READ           ; first note byte ; 1
        movf MEMHI,W
        movwf NOTESTOREA    ; 1st note byte
        call INCREADADDRESS
        call INCCOUNTER

        call READ                           ; 2
        movf MEMHI,W
        movwf NOTEBYTE2
        call INCREADADDRESS
        call INCCOUNTER

        call READ           ; get 3rd byte, note length for first in msb
        movf MEMHI,W
        movwf NOTELENBYTE   ; note length byte
        call INCREADADDRESS
        call INCCOUNTER

        movf NOTESTOREA,W   ; get 1st note byte
        andlw %01111111     ; knock out chord flag marker
        xorlw 15            ; is note = 15 (rest symbol)?
        btfsc STATUS,Z
        goto REST1          ; 05 nov06

        movf NOTESTOREA,W   ; get 1st note byte
        andlw %01111111     ; knock out chord flag marker
        movwf PORTB         ; output 1st note to PORTB unswapped
        call SWAPIT         ; swap pin order to suit PCB
        movwf PORTD         ; send to output

REST1:
        call PAUSIT2
        call PAUSIT2
        call PAUSIT2
        call PAUSIT2

        btfss CONTINUOUS,0
        goto M2X
        movlw 15
        goto M2Y

        movf NOTESTOREA,W   ; get 1st note byte
        andlw %01111111     ; knock out chord flag marker
        xorlw 15            ; is note = 15 (rest symbol)?
        btfsc STATUS,Z
        goto REST2A

M2X:    swapf NOTELENBYTE,W ; get 1st note len from msb
        andlw 15
M2Y:    iorlw 128           ; set marker flag to advise 2nd PIC that this is a len byte
        movwf PORTB         ; output 1st len byte to PORTB unswapped
        call SWAPIT         ; swap pin order to suit PCB
        movwf PORTD         ; send to output

        call PAUSIT2
        btfsc NOTESTOREA,7  ; is 1st note marked as concurrent with next?
        goto M4A            ; yes, so no pause

REST2A:
        call PAUSIT3        ; give a pause

M4A:
        movf NOTESTOREA,W   ; get 1st note byte
        andlw %01111111     ; knock out chord flag marker
        xorlw 15            ; is note = 15 (rest symbol)?
        btfsc STATUS,Z
        goto REST4

        movf NOTEBYTE2,W    ; get 2nd note byte
        andlw %01111111     ; knock out chord flag marker
        movwf PORTB         ; output 2nd note to PORTB unswapped
        call SWAPIT         ; swap pin order to suit PCB
        movwf PORTD         ; send to output

;REST3:
        call PAUSIT2
        call PAUSIT2
        call PAUSIT2
        call PAUSIT2

        btfss CONTINUOUS,0
        goto M2X2
        movlw 15
        goto M2Y2

M2X2:
        movf NOTESTOREA,W   ; get 1st note byte
        andlw %01111111     ; knock out chord flag marker
        xorlw 15            ; is note = 15 (rest symbol)?
        btfsc STATUS,Z
        goto REST4

        movf NOTELENBYTE,W  ; get 2nd note len from lsb
        andlw 15
M2Y2:   iorlw 128           ; set marker flag to advise 2nd PIC that this is a len byte
        movwf PORTB         ; output 2nd note len byte to PORTB unswapped
        call SWAPIT         ; swap pin order to suit PCB
        movwf PORTD         ; send to output
        call PAUSIT2

        btfsc NOTEBYTE2,7   ; is 2nd note marked as concurrent with next?
        goto M5A            ; yes, so no pause

REST4:  call PAUSIT3        ; give a pause

M5A:    comf PORTE,W        ; get ECHAN from switches
        andlw %00000111     ; (eeprom channel)
        movwf ECHAN
        movwf SWITCH
        xorwf PREVSWITCH,W
        btfsc STATUS,Z      ; is current switch same as prev switch?
        goto M6A            ; yes
        goto 0              ; no

M6A:    movf COUNTERMSB,W   ; are both msbs the same?
        xorwf FILELENMSB,W
        btfss STATUS,Z
        goto MAIN2          ; no

;        movf COUNTERLSB,W   ; 29nov06
;        movwf PROMVAL  ; 29nov06
;        movlw 102      ; 29nov06
;        call SETPRM    ; 29nov06
;        movf FILELENLSB,W
;        movwf PROMVAL  ; 29nov06
;        movlw 111      ; 29nov06
;        call SETPRM    ; 29nov06
;        movf COUNTERMSB,W   ; 29nov06
;        movwf PROMVAL  ; 29nov06
;        movlw 103      ; 29nov06
;        call SETPRM    ; 29nov06
;        movf FILELENMSB,W
;        movwf PROMVAL  ; 29nov06
;        movlw 112      ; 29nov06
;        call SETPRM    ; 29nov06

        movf COUNTERLSB,W   ; are both lsbs the same?
        xorwf FILELENLSB,W
        btfss STATUS,Z
        goto MAIN2          ; no

;        movf COUNTERLSB,W   ; 29nov06
;        movwf PROMVAL  ; 29nov06
;        movlw 102      ; 29nov06
;        call SETPRM    ; 29nov06
;        movf FILELENLSB,W
;        movwf PROMVAL  ; 29nov06
;        movlw 111      ; 29nov06
;        call SETPRM    ; 29nov06
;        movf COUNTERMSB,W   ; 29nov06
;        movwf PROMVAL  ; 29nov06
;        movlw 103      ; 29nov06
;        call SETPRM    ; 29nov06
;        movf FILELENMSB,W
;        movwf PROMVAL  ; 29nov06
;        movlw 112      ; 29nov06
;        call SETPRM    ; 29nov06

;        movlw 'J'
;        movwf PROMVAL  ; 29nov06
;        movlw 113      ; 29nov06
;        call SETPRM    ; 29nov06
;        movlw 'B'
;        movwf PROMVAL  ; 29nov06
;        movlw 114      ; 29nov06
;        call SETPRM    ; 29nov06


        goto MAIN           ; yes, restart loop


;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                          ;This routine is entered with W holding
                          ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1    ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR       ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0    ;set for Page 3
        bcf EECON1,EEPGD  ;point to data memory
        bsf EECON1,RD     ;enable read flag
        bcf STATUS,RP0    ;set for Page 2 
        movf EEDATA,W     ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1    ;set for Page 0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                         ;This routine is entered with W holding
                         ;the eeprom byte address at which data
                         ;is to be stored. The data to be stored
                         ;is held in PROMVAL
SETPRM: bsf STATUS,RP1   ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR      ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1   ;set for Page 0
        MOVF PROMVAL,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1   ;set for Page 2
        movwf EEDATA     ;copy W into eeprom data byte register
        bsf STATUS,RP0   ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN  ;enable write flag

MANUAL: movlw H'55'      ;these lines cause the action required by
        movwf EECON2     ;by the eeprom to store the data in EEDATA
        movlw H'AA'      ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR    ;set the ``perform write'' flag
        bcf STATUS,RP1   ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF  ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF    ;clear bit 4 of PIR2
        return

SWAPIT: ; from PORTD 7 6 5 4 3 2 1 0 bits ; rearrange bits to suit PCB
        ; to   PORTC 3 2 1 0 4 5 6 7

        movwf STORE1  ;7 6 5 4 3 2 1 0 bits

        clrf STORE
        btfsc STORE1,0
        bsf STORE,7   
        btfsc STORE1,1
        bsf STORE,6   
        btfsc STORE1,2
        bsf STORE,5
        btfsc STORE1,3        
        bsf STORE,4
        btfsc STORE1,4
        bsf STORE,0   
        btfsc STORE1,5
        bsf STORE,1   
        btfsc STORE1,6
        bsf STORE,2
        btfsc STORE1,7        
        bsf STORE,3
        movf STORE,W
        return

PAUSIT2:  clrf TEMPTIMER
PAUSIT2A: decfsz TEMPTIMER,F
        goto PAUSIT2A
        return

PAUSIT3: bsf ADCON0,GO       ;start data conversion
        call GETADC     ; get adc val from external pot
        movwf CLKCNT

        clrf INTCON     ;clear interupt flag
PAUSE3: btfss INTCON,2  ;has a timer time-out been detected?
        goto PAUSE3     ;no
        BCF INTCON,2    ;yes
        decfsz CLKCNT,F ;dec loop, is it zero?
        goto PAUSE3     ;no
        return          ;yes

;********** GET ADC VALUE

GETADC: btfsc ADCON0,GO
        goto GETADC

ADC2:   BANK1
        movf ADRESL,W     ;get ADC LSB val
        BANK0
        return

;*********

;SERIALMEM01 30MAR02 from LOG430.ASM 29OCT99 - JOHN BECKER - EPE DATA LOGGER MODIFIED EXTRACT

SAVESAMPLE:  movf MEMHI,W  ; store MSB
        call WRBYTE
        incf WADDRL,F      ; inc address
        movf MEMLO,W       ; store LSB
        call WRBYTE
        decf WADDRL,F      ; dec address back to prev count
        call INCADDRESS
        return

;*********** cycles pause called by Serial EEPROM write routines ****

; the CALL takes 2 clock cycles
; the RETURN takes 2 clock cycles
; a pause of 4 clock cycles is created by just CALLing CYCLES4 and returning
; each NOP adds a further 1 cycle pause

CYCLES25:  NOP
CYCLES24:  NOP
CYCLES23:  NOP
CYCLES22:  NOP
CYCLES21:  NOP
CYCLES20:  NOP
CYCLES19:  NOP
CYCLES18:  NOP
CYCLES17:  NOP
CYCLES16:  NOP
CYCLES15:  NOP
CYCLES14:  NOP
CYCLES13:  NOP
CYCLES12:  NOP
CYCLES11:  NOP
CYCLES10:  NOP
CYCLES9:   NOP
CYCLES8:   NOP
CYCLES7:   NOP
CYCLES6:   NOP
CYCLES5:   NOP
CYCLES4:   return

;*************

;CONVERTED MPASM FILE C:\ASMCNV\2WDPOLL.ASM
;       TO TASM  FILE C:\PIC\2WDPOLL.ASM 03-12-1999 19:28:42
; see Microchip CD-ROM disk 2, download\appnote\category\eeproms\00567.ZIP
; the original used timings based on a 4MHz clock
; this routine has been modified to enable different xtal rates
; Defining SERIALDELAY as "call CYCLE5" is for 4MHz or less xtal
; Defining SERIALDELAY as "call CYCLE25" is for 20MHz xtal

          ;***************************************************************
          ;       Byte Write Routine with data polling
          ;***************************************************************

WRBYTE:   movwf DATAO         ;entry with val to send in W, stored to DATAO
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode
          MOVWF SLAVE

BYTE:     CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; move slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRL,W       ; send address low byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          MOVF DATAO,W        ; move data byte
          MOVWF TXBUF         ; to tranmit buffer
          CALL TX             ; and transmit it
          CALL BSTOP          ; generate stop bit

          MOVLW 40            ; now start polling for a low ack bit
          MOVWF POLLCNT       ; set max number of times to poll
POLL:     CALL BSTART         ; generate start bit

          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it
          BTFSS EEPROM,DI     ; was the ack bit low?
          GOTO EXITPOLL       ; yes, do another byte
          DECFSZ POLLCNT,F    ; is poll counter down to zero?
          GOTO POLL           ; no, poll again.
EXITPOLL: return

          ;**************************************************************
          ;       Start Bit Subroutine - generates a start bit
          ;       (Low going data line while clock is high)
          ;**************************************************************

BSTART:   BSF PORTC,SDATA    ; make sure data is high
          BANK1
          movlw %10100111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC        ; set data and clock lines for output
          BANK0
          BCF PORTC,SCLK     ; make sure clock is low
          NOP                 
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SDATA    ; data line goes low during
                             ; high clock for start bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; start clock train
          NOP                 
          NOP                 
          RETLW 0             

          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP:    BANK1
          movlw %10100111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC        ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA    ; make sure data line is low
          SERIALDELAY        ; timing adjustment        
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BSF PORTC,SDATA    ; data goes high while clock high for stop bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; set clock low again
          SERIALDELAY        ; timing adjustment
          RETLW 0

            ;*************************************************************
            ;       BITOUT routine takes one bit of data in 'do' and
            ;       transmits it to the serial EE device
            ;*************************************************************

BITOUT:   BANK1
          movlw %10100111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC
          BANK0
          BTFSS EEPROM,DO    ; check for state of data bit to xmit
          GOTO BITLOW        ;
          BSF PORTC,SDATA    ; set data line high
          GOTO CLKOUT        ; go toggle the clock

BITLOW:   BCF PORTC,SDATA    ; output a low bit
CLKOUT:   BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; return clock line low
          RETLW 0             

          ;**************************************************************
          ;       BITIN routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN:    BSF EEPROM,DI      ; assume input bit is high
          BANK1
          movlw %10110111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC
          BANK0
          BSF PORTC,SDATA    ; set sdata line for input
          BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI      ; input bit was low
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX:       MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP:     BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; otherwise data bit =1
          CALL BITOUT         ; serial data out
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP           ; no - go again
          CALL BITIN          ; read ack bit
          RETLW 0             
                              
;CONVERTED MPASM FILE C:\ASMCNV\2WSEQR.ASM
;       TO TASM  FILE C:\PIC\2WSEQR.ASM 03-12-1999 19:29:04

          ;************************************************************
          ;       2-Wire Sequential Read Program
          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP2:   BANK1
          movlw %10100111     ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC         ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA     ; make sure data line is low
          SERIALDELAY
          BSF PORTC,SCLK      ; set clock high
          SERIALDELAY
          BSF PORTC,SDATA     ; data goes high while clock high for stop bit
          SERIALDELAY
          BCF PORTC,SCLK      ; set clock low again
          SERIALDELAY
          RETLW 0

          ;**************************************************************
          ;       BITIN2 routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN2:   BSF EEPROM,DI       ; assume input bit is high
          BANK1
          movlw %10110111     ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC
          BANK0
          BSF PORTC,SCLK      ; set clock line high
          SERIALDELAY
          BTFSS PORTC,SDATA   ; read the data bit
          BCF EEPROM,DI       ; input bit was low, set 'di' accordingly
          BCF PORTC,SCLK      ; set clock line low
          RETLW 0             

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX2:      MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP2:    BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; no, set it high
          CALL BITOUT         ; send the bit to serial EE
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP2          ; no - go again
          CALL BITIN2         ; read ack bit
          BTFSC EEPROM,DI     ; check ack bit
          NOP
          RETLW 0             

          ;****************************************************************
          ;       Receive data Routine
          ;****************************************************************

RX:       MOVLW 8             ; set # bits to 8
          MOVWF COUNT         
          CLRF DATAI          ; clear input register
          BCF STATUS,0        ; make sure carry bit is low
RXLP:     RLF DATAI,F         ; rotate DATAI 1 bit left
          CALL BITIN2         ; read a bit
          BTFSC EEPROM,DI     
          BSF DATAI,0         ; set bit 0 if necessary
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO RXLP           ; no, do another
          RETLW 0             

          ;**************************************************************
          ;       READ (sequential read routine)
          ;**************************************************************

READ:     MOVLW 2             
          MOVWF BCOUNT        ; set number of bytes to read
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode
          MOVWF SLAVE         

          CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; get slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          movf RADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          MOVF RADDRL,W       ; get word address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          CALL BSTART         ; generate start bit
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100001     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and transmit it
                              ;
RBYTE:    CALL RX             ; read 1 byte from device
          DECFSZ BCOUNT,F     ; are both bytes read?
          GOTO LOWACK         ; no, send low ack and do another
          BSF EEPROM,DO       ; yes, send high ack bit
          CALL BITOUT         ; to stop transmission
          CALL BSTOP2         ; and send a stop bit
          movf DATAI,W
          movwf MEMLO         ; data low byte
          return

LOWACK:   movf DATAI,W
          movwf MEMHI         ; data high byte
          BCF EEPROM,DO       ; send low ack bit
          CALL BITOUT         ; to continue transmission
          GOTO RBYTE          ; and read another byte

; *****************

INCADDRESS: clrf MEMFUL    ; inc write address
         movlw 2
         addwf WADDRL,F    ;inc write address by 2
         btfss STATUS,C
         return
         incf WADDRH,F
         return            ; no

INCREADADDRESS:
         movlw 1
         addwf RADDRL,F    ;inc read address by 1
         btfss STATUS,C
         return 
         incf RADDRH,F
         return 

INCCOUNTER:
         movlw 1
         addwf COUNTERLSB,F    ;inc read address by 1
         btfss STATUS,C
         return 
         incf COUNTERMSB,F
         return

; *****************

CLEARADR: clrf MEMHI
        clrf MEMLO
        clrf RADDRH      ; set read address MSB
        clrf RADDRL      ; set read address LSB
        clrf ECHAN
        clrf MEMFUL
        return

RECEIVEDATA:
        movlw 'S'
        call TXBYTE
        clrf WADDRH
        clrf WADDRL
        clrf RADDRH
        clrf RADDRL
        clrf LOOP
        clrf LOOPMSB

        movf SWITCH,W
        call SETSWITCHMEM
        movwf SWITCHMEM
        movwf LOOP

RD1:    btfss PIR1,RCIF     ; Check for any RX'd data
        goto RD1            ; Nothing RX'd
        movf RCREG,W        ; Store the RX'd data in 'W'
        movwf PROMVAL       ; MSB of file length
        movwf FILELENMSB

        call TXBYTE
        movf LOOP,W
        call SETPRM         ; store file len data in PIC eeprom at 0
        incf LOOP,F

RD1A:   btfss PIR1,RCIF     ; Check for any RX'd data
        goto RD1A           ; Nothing RX'd
        movf RCREG,W        ; Store the RX'd data in 'W'
        movwf STORE
        call TXBYTE
        movf STORE,W
        movwf PROMVAL       ; LSB of file length
        andlw 254
        movwf FILELENLSB

        movf LOOP,W
        call SETPRM         ; store file len data in PIC eeprom at 0

RD2:    btfss PIR1,RCIF     ; Check for any RX'd data
        goto RD2            ; Nothing RX'd
        movf RCREG,W        ; Store the RX'd data in 'W'
        movwf MEMHI
        call TXBYTE         ; ack back to PC

RD3:    btfss PIR1,RCIF     ; Check for any RX'd data
        goto RD3            ; Nothing RX'd
        movf RCREG,W        ; Store the RX'd data in 'W'
        movwf MEMLO
        call TXBYTE         ; ack back to PC

        call SAVESAMPLE     ; save both bytes to serial eeprom
        movf WADDRH,W
        movwf PORTC

        movf WADDRH,W       ; is write address MSB same as FILELENMSB ?
        xorwf FILELENMSB,W
        btfss STATUS,Z
        goto RD2            ; no

        movf WADDRL,W       ; is write address LSB same as FILELENLSB ?
        xorwf FILELENLSB,W
        btfss STATUS,Z
        goto RD2            ; no

        call TXBYTE         ; yes, send extra bytes in case PC prog waiting
        call TXBYTE         ; for triplet completion
;        goto MAIN
        goto 0

READBACKDATA: ; author's use only
        clrf RADDRH      ; set read address MSB
        clrf RADDRL      ; set read address LSB
        clrf ECHAN

        comf PORTE,W
        andlw %00000111
        movwf ECHAN

        movlw 0
        call PRMGET
        movwf FILELENMSB
        movlw 1
        call PRMGET
        movwf FILELENLSB

        movlw 'R'
        call TXBYTE

; wait for 'G'

RBD5:   btfss PIR1,RCIF     ; Check for any RX'd data
        goto RBD5            ; Nothing RX'd
        movf FILELENMSB,W
        call TXBYTE      ; send file length MSB
        movf FILELENLSB,W
        call TXBYTE      ; send file length LSB

; wait for 'G' again

RBD6:   btfss PIR1,RCIF     ; Check for any RX'd data
        goto RBD6            ; Nothing RX'd

RBD1:   call READ           ; first note byte ; 1                
        movf MEMHI,W
        call TXBYTE
        incf RADDRL,F
        decfsz LOOP,F
        goto RBD1

        incf RADDRH,F
        decfsz FILELENMSB,F
        goto RBD6

RDB7:   btfss PIR1,RCIF     ; Check for any RX'd data
        goto RDB7            ; Nothing RX'd

        movf FILELENLSB,W
        movwf LOOP
RBD2:   call READ           ; first note byte ; 1                
        movf MEMHI,W
        call TXBYTE
        incf RADDRL,F
        decfsz LOOP,F
        goto RBD2

hereL:  nop
        goto hereL        

        END


