/*****************************************************************************
*   Filename:   SPEECH.C                                                     *
******************************************************************************
*   Author:     Rodger Richey                                                *
*   Title:      Senior Applications Manager                                  *
*   Company:    Microchip Technology Incorporated                            *
*   Revision:   1                                                            *
*   Date:       12-1-04                                                      *
******************************************************************************
* Software License Agreement												 *
*																			 *
* This software is owned by Microchip Technology Inc. ("Microchip") 		 *
* and is supplied to you for use exclusively as described in the 			 *
* associated software agreement.  This software is protected by 			 *
* software and other intellectual property laws.  Any use in 				 *
* violation of the software license may subject the user to criminal 		 *
* sanctions as well as civil liability.  Copyright 2006 Microchip			 *
* Technology Inc.  All rights reserved.										 *
*																			 *
* This software is provided "AS IS."  MICROCHIP DISCLAIMS ALL 				 *
* WARRANTIES, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, NOT LIMITED 		 *
* TO MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND 				 *
* INFRINGEMENT.  Microchip shall in no event be liable for special, 		 *
* incidental, or consequential damages.										 *
*																			 *
******************************************************************************
*   Include files:                                                           *
*      stdio.h - Standard input/output header file                           *
*      string.h - Standard string header file                                *
*      adpcm.h - ADPCM related information header file                       *
******************************************************************************
*   This file contains the code to:                                          *
*      - Open the input and output files                                     *
*      - Read data from the input file                                       *
*      - Call the appropriate encode/decode routines                         *
*      - Write data to the output file                                       *
******************************************************************************
*   Revision 0  1/11/96                                                      *
*      Original release supporting only ADPCM using signed raw data          *
*      Compiled with Borland C++ Version 3.1                                 *
*   Revision 1  11/10/04                                                     *
*      Add CVSD, change ADPCM to support unsigned raw data                   *
*      Compiled using Borland C++ 6.0                                        *
*****************************************************************************/
#include <p24fj128ga010.h>

//#include "adpcm.h"
//#include "mpfs.h"
//#include "stacktsk.h"
#include "config.h"
#include <string.h>


/*****************************************************************************
*   Protypes and Declarations for main		                                 *
*****************************************************************************/

int main (void);
//void PlayClip(MPFS hfile);						// Play specified audio clip
//void Transistion(void);							// Transition between clips

//struct  ADPCMstate   state;         			// ADPCM state variable





/*****************************************************************************
*   main - controls file I/O and ADPCM calls                                 *
*****************************************************************************/
int main(void)
{
	//char filename[13];							// filename to play
	//MPFS hFile;									// file pointer
	//char string[13];
	//unsigned char Temperature;
	//long time;
	int SampleIn, SampleOut;					//Input

	CORCONbits.PSV = 1;							// enable PSV usage

	// Setup ports
	PORTA = 0;
	TRISA = 0x0080;
	PORTB = 0;
	TRISB = 0x0030;
	PORTC = 0;
	TRISC = 0xc000;
	PORTD = 0x1080;
	TRISD = 0x2040;
	PORTE = 0;
	TRISE = 0;
	PORTF = 0;
	TRISF = 0x1010;
	PORTG = 0;
	TRISG = 0x0080;

	//Setup ADC for Sample at 8kHz,10bit on AN0

	AD1CON1 = 0x80E4;				//Turn on, auto sample start, auto-convert
	AD1CON2 = 0;					//AVdd, AVss, int every conversion, MUXA only
	
	//Try each of these AD1CON3 Settings and note the difference between sampling
	//at 8kHz and 16kHz
    AD1CON3 = 0x807C;				//16Tad (0b1000 0x80) 124*Tcy (0b1111100 0x7C) 16kHz //0x1FFF
	//AD1CON3 = 0x1FFF;				//31Tad 131Tcy 8kHz
	
	AD1CHS = 0;						//MIC Input on RB0/AN0 CH0
	AD1PCFGbits.PCFG5 = 0;			//Disable digital input on AN5
	AD1PCFGbits.PCFG4 = 0;          //Disable digital input on AN4
	AD1CSSL = 0;					//No scanned inputs

	// Setup PWM for 16KHz at 'n'MHz * 4 (using PLL)
	// Explorer16 uses 8MHz Xtal
	OC1CON          = 0x0000; 		// Turn off Output Compare 1 Module
	OC1RS           = 0; 	  		// Initialize Secondary Compare Register1 
							  		// with first PWM value
	OC1CON          = 0x0006; 		// Load PWM mode to OC1CON

	T2CONbits.TON   = 0;      		// Turn off timer 3
	T2CONbits.TCS   = 0;      		// Select the timer clock source. Fosc/4 in this case
	T2CONbits.T32   = 0;      		// Configure timer 2 for 16 bit mode
	T2CONbits.TCKPS = 0;      		// Select the prescaler ratio using TCKPS1:TCKPS0 bits
	T2CONbits.TGATE = 0;      		// Gated time accumulation mode disabled
	PR2				= 999;	  		// 16kHz at 8MHz Xtal x4 PLL	
//	PR2             = 768;    		// 16kHz at 6.144MHz Xtal x4 PLL	Initialize PR2 with the calculated decimal value
	TMR2            = 0;      		// Clear timer 2 or preload with required value if needed
	IFS0bits.T2IF   = 0;      		// Clear Output Compare 1 interrupt flag
	T2CONbits.TON   = 1;      		// Start Timer2 with assumed settings
	


   while(1)
   {
	   PORTAbits.RA3 = 1;					// Put audio driver in low power mode
		OC1RS = 512;							// Reset PWM duty cycle to 1/2 supply

		while(PORTDbits.RD13);				// Wait for pushbutton to be pressed

		while(!PORTDbits.RD13);				// Wait for pushbutton to be released

		PORTAbits.RA3 = 0;					// Enable audio amplifier

		if(PORTDbits.RD13)					// If pushbutton has been released
		{
			
			while(PORTDbits.RD13)			//Perform Conversions until button pressed
			{

				//When Pushbutton Released Start Sampling ADC until next button pressed
				
				//Sample ADC at 8kHz or 16kHz (see above), 10bits
				while(!AD1CON1bits.DONE);		// Perform A/D conversion on AN0
					SampleIn = ADC1BUF0;
					SampleOut = SampleIn;		

				//This is a simple Sample and Pass Through example.
				//For a more complete, robust system then consider using input and
				//output buffers, or using the ADC in 8byte sample mode and ping-pong between
				//high and low buffer to ensure accurate sampling. This should be done in
				//conjunction with interrupts.
				//The performance of this basic example is however pretty good.
				//This can be modified to perform a compression and decompression 
				//using the ADCPM code in AN643. Intially a compress/decompress can
				//performed which could then be backed up with a store to DataEE.
				//Care should be taken to allow for buffering and write timing to the 
				//DataEE. Examples for reading and writing to DataEE can be found in
				//standard Explorer-16 Development Board Source Code - available in the
				//Proteus sample designs folder and on the Microchip Website.
				

				//Playback sample
				//Effective Output Rate is 8kHz
				//However single sample can be output twice to give
				//an effective 16kHz output rate
				OC1RS = SampleOut;
				while(!IFS0bits.T2IF);			// Wait for Timer2 interrupt flag
				IFS0bits.T2IF = 0;				// do this twice, 2 interrupts = 8KHz
				//Try commenting out this while to try difference between 8kHz and 16kHz output		
				//while(!IFS0bits.T2IF);
				


			} //end while conversion loop
	
		} //end if pushbutton released - start conversion
	} // end infinite loop
} //end main

//----------------------------------------------------------------------------

