	NOLIST 
;Macros to increment and decrement modulo a constant, 8 bit. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

;****** ******* ******* ******* ******* ******* ******* *** * 
;The IncMod... and DecMod... Macros follow. 
;------ ------- ------- ------- ------- ------- ------- --- - 

;These macros are used for numbers like times 
;that are cyclic. 
;That is, the time after 23:59 is 00:00. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;IncModK8 
;------ ------- ------- ------- ------- ------- ------- --- - 

;Increment whole byte modulo constant maximum. 
;See below for explanation of how and why it works. 

IncModK8 MACRO Var1,ItsMax
;v = v +1
;if v > x
;then v = 0 
	incf Var1,f  
	movf Var1,w  
	sublw ItsMax 
	btfss STATUS,C 
	clrf Var1  
	ENDM 

;Explanation of above. 
;Increment whole byte modulo constant maximum. 

;For modulo, the ItsMax=0xFF case is not a problem. 
;IncModK8 MACRO Var1,ItsMax 
;v = v +1
;if v > x
;then v = 0 
;	incf Var1,f  
;	movf Var1,w  
;	sublw ItsMax 
;Does Max-Variable v<x v=x v>x 
;Carry =            1   1   0 
;	btfss STATUS,C 
;	clrf Var1  
;	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;DecModK8 
;------ ------- ------- ------- ------- ------- ------- --- - 

;Decrement whole byte modulo constant maximum. 
;See below for explanation of how and why it works. 

DecModK8 MACRO Var1,ItsMax 
;if v = 0
;then v = ItsMax
;else v = v -1
	movlw ItsMax+1 
	movf Var1,f  
	btfsc STATUS,Z 
	movwf Var1  
	decf Var1,f  
	ENDM 

;Explanation of above. 
;Decrement whole byte modulo constant maximum. 

;For modulo, the ItsMax=0xFF case is not a problem. 
;DecModK8 MACRO Var1,ItsMax 
;if v = 0
;then v = ItsMax
;else v = v -1
;	movlw ItsMax+1 ;I dec it later 
;	movf Var1,f ;if v = 0 
;	btfsc STATUS,Z 
;	movwf Var1 ;then v = ItsMax+1 
;	decf Var1,f ;v = v -1 
;	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

	LIST 



