;*****************************************************************************        
;
;   Module:     blconst.inc
;               
;   Author:     Mike Hibbett, mikehibbett@oceanfree.net 
;                                                                  
;   Version:    1.0 11/10/05                                              
;
;               equate statements for variable locations
;               equate statements for constants
;               NOTE: CPU constants are extracted from gputils header file,
;               p18f2420.inc, found in the gputils header subdirectory
;
;*****************************************************************************        


; Change the p= parameter to match the PIC in your design

    list p=18F2620, st=OFF, x=OFF, n=0

    
    errorlevel -302
    errorlevel -306


; Change this to suit the processor you will use.
; Look in C:\GPUTILS\HEADER for list of supported PIC's

    #include <p18f2620.inc>


; PC RS232 Interface bits
; Change these six lines to match the I/O pins you will
; use for the bootloader RS232 interface
; Here, we are using PORTC7 for Received Data, PORTC6 for transmit

TRIS_TX_PIN     EQU     TRISC   ; The register that defines the pin as an input or output
TX_PIN_BIT      EQU     6       ; The bit, 0..7, that indicated which bit is used in the register
PORT_TX_PIN     EQU     LATC    ; The register that is written to for transmit data
TRIS_RX_PIN     EQU     TRISC   ; The register that defines the pin as an input or output
RX_PIN_BIT      EQU     7       ; The bit, 0..7, that indicated which bit is used in the register
PORT_RX_PIN     EQU     PORTC   ; The register that is read from for received data
PORT_RX_MASK    EQU     0x80    ; The Mask to AND with the read-register to get the received data


; Change this value to suit for your clock speed. Clock, not crystal, since you may be using a PLL
OSC_FREQ_HZ     EQU     D'40000000'   ; The speed at which the internal clock is running, in Hz


; NO FURTHER USER CHANGABLE VALUES APPEAR BELOW HERE


; If you are using a clock speed below 10MHz, the bootloader will run at 38400 baud
; and you will need to invoke bload with the s option  eg bload 1 s c:\myfile\main.hex
; These lines take care of the code changes for you - not changes required by you here.
IF ( OSC_FREQ_HZ < D'10000000' ) 
FREQ_HZ         EQU (OSC_FREQ_HZ * 3)
ELSE
FREQ_HZ         EQU OSC_FREQ_HZ
ENDIF

; This determines how many retries are permitted when syncing up to a PC.
; You probably do not need to change it.
; If you do, your application will take longer to start.
RX_RETRIES              EQU     0x05    ; Try 5 times before jumping to the application code

RX_BYTE_TIMEOUT_10MS    EQU     (( D'10' * (OSC_FREQ_HZ/D'1000') ) / ( 4 * 9))

RX_BYTE_TIMEOUT_20MS    EQU     (( D'20' * (OSC_FREQ_HZ/D'1000') ) / ( 4 * 9))

RX_BYTE_TIMEOUT_58MS    EQU     (( D'58' * (OSC_FREQ_HZ/D'1000') ) / ( 4 * 9))

RX_BYTE_TIMEOUT         EQU     RX_BYTE_TIMEOUT_58MS    


; The rather complicated set of equates below enabled us to implement subroutines
; with very precise delay times, no matter what clock speed is entered above
; You do not need to change any of this!
DELAY_50US_LOOP_VAL     EQU     ((((OSC_FREQ_HZ/D'80000') - 7 ) / 3) + 1 )

BIT_CLOCKS_REQUIRED     EQU     (((D'868' * (FREQ_HZ/D'100'))/D'4000000') - 8 )
BIT_LOOP_VAL            EQU     (((BIT_CLOCKS_REQUIRED - 9) / 3 ) + 1 )
BIT_EXTRA_CLOCKS        EQU     (BIT_CLOCKS_REQUIRED - 9 - ( 3 * ( BIT_LOOP_VAL - 1 ) ) )

BITHALF_CLOCKS_REQUIRED EQU     ((D'13' * FREQ_HZ)/D'4000000')
BITHALF_LOOP_VAL        EQU     (((BITHALF_CLOCKS_REQUIRED - 9) / 3 ) + 1 )
BITHALF_EXTRA_CLOCKS    EQU     (BITHALF_CLOCKS_REQUIRED - 9 - ( 3 * ( BITHALF_LOOP_VAL - 1 ) ) )

; Variables held in Bank 0 ( low address ) GPRS
; THESE VARIABLE ARE ONLY USED DURING BOOTLOADER OPERATION
; YOU MAY REUSE THEM IN THE APPLICATION CODE AS YOU SEE FIT

delay1                  EQU 0x02
delay2                  EQU 0x03
delay3                  EQU 0x04
bitDelay                EQU 0x06
bitCount                EQU 0x07
hostByte                EQU 0x08
progAddHigh             EQU 0x09        ; NOTE: bootloader also uses 0x40 - 0x7F
progAddLow              EQU 0x0A        ;       as a buffer for write data
progRxResult            EQU 0x0B        ;
progRxCheck             EQU 0x0C        ; a simple sum of AAD..D ( 66 bytes )
progCounter             EQU 0x0D
rxTimeoutH              EQU 0x0E        ; Counter for timing the non-blocking receive call
rxTimeoutL              EQU 0x0F
rxRetries               EQU 0x10        ; Number of times the unit attempts to sync with PC