;*****************************************************************************        
;
;   Module:     equates.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    1.0 22/02/06
;
;               equate statements for variables and constants
;
;*****************************************************************************        


XTAL_FREQ           EQU D'3579545'  ; The frequency of our crystal

BAUD_19200          EQU (XTAL_FREQ/(D'16' * D'19200')) + 1
BAUD_CONSTANT       EQU BAUD_19200  ; The speed we will actually run at

TIMER1_1MS_VAL      EQU 0xFFFF - (XTAL_FREQ/(8 * 4 * D'1000'))

MASTER_ADDRESS      EQU 0x01        ; RS485 address (when slave addresses master)
SLAVE_1_ADDRESS     EQU 0x02        ; RS485 address
SLAVE_2_ADDRESS     EQU 0x03        ; RS485 address
SLAVE_1_LED_BIT     EQU 0           ; PORTB.0 is LED for SLAVE_1
SLAVE_2_LED_BIT     EQU 1           ; PORTB.1 is LED for SLAVE_1

TX_ENABLE_BIT       EQU 5           ; PORTC.5 is tx enable control

; The following are a list of 'commands' supported by the link
; As this is a demonstration of how to use the system, we only implement
; a single command, READ_DATA_COMMAND, to read a slaves port
READ_DATA_COMMAND   EQU 0x01

SLAVE_READ_TIMEOUT  EQU D'100'      ; Allow up to 100ms for a response

; Bank 0 RAM

sPORTB              EQU 0x20        ; Shadow of PORTB output register
sPORTC              EQU 0x21        ; Shadow of PORTC output register
deviceReadOK        EQU 0x22        ; return status from getSlaveData
deviceData          EQU 0x23        ; return value from getSlaveData

timer1msCount       EQU 0x24        ; The applications 1ms resolution timer
delay1              EQU 0x25        ; delay routine use only.
PCLATH_TEMP         EQU 0x7d        ; Exists in all banks
STATUS_TEMP         EQU 0x7e        ; Exists in all banks
W_TEMP              EQU 0x7f        ; Exists in all banks
