; PnMSep05a.ASM 01AUG05 - COPYRIGHT JOHN BECKER
; Digital pot demo

; this listing differs slightly to that published in EPE Sept 05

;PIC16F628, 4MHz, WDT OFF, POR ON, XTAL HS

;PROGRAM WRITTEN IN TASM - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

        List P = PIC16F628, R=DEC;
        __CONFIG   h'3F22'

        include P16F628.inc

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

        CBLOCK

STORE
LOOP
POTVAL0
POTVAL1
POTVAL2
POTVAL3

	ENDC

; *********** BITS *******

POTDATA equ 0         ; PORTB,0  dig pot data bit
POTCLK  equ 1         ; PORTB,1  dig pot clock active high
POTRST  equ 2         ; PORTB,2  dig pot set active high

; **********************

          ORG 0
          goto START 
          ORG 4
          retfie
          ORG 5

START:    clrf PORTB
          clrf POTVAL0
          clrf POTVAL1
          clrf POTVAL2
          clrf POTVAL3

          BANK1
          clrf TRISB             ; PORTB as output
          BANK0

MAIN:     bsf PORTB,POTRST    ; set dig pot to receive data
          bcf PORTB,POTDATA   ; clear stack bit
          call CLKPOT         ; send stack bit

          movf POTVAL1,W      ; copy pot 1 val to W
          call SETPOTS        ; send it
          movf POTVAL0,W      ; copy pot 0 val to W
          call SETPOTS        ; send it
          incf POTVAL0,F      ; inc pot 0 val
          decf POTVAL1,F      ; dec pot 1 val

          goto ENDPOTS        ; bypass data for chip 2

          bcf PORTB,POTDATA   ; clear stack bit
          call CLKPOT         ; send stack bit

          movf POTVAL3,W      ; copy pot 3 val to W
          call SETPOTS        ; send it
          movf POTVAL2,W      ; copy pot 2 val to W
          call SETPOTS        ; send it
          movlw 2
          addwf POTVAL2,F     ; inc pot 2 val
          movlw 5
          addwf POTVAL3,F     ; inc pot 3 val

ENDPOTS:  bcf PORTB,POTRST    ; disable dig pot from receiving data
          goto MAIN

SETPOTS:  movwf STORE         ; store W
          movlw 8             ; set loop for 8 actions
          movwf LOOP
DIGLOOP0: bcf PORTB,POTDATA   ; clear data bit
          rlf STORE,F         ; rotate store left (MSB out first)
          btfsc STATUS,C      ; is CARRY set?
          bsf PORTB,POTDATA   ; yes, set data bit
          call CLKPOT         ; send data bit
          decfsz LOOP,F       ; dec loop, is it 0?
          goto DIGLOOP0       ; no, repeat for next bit
          return

CLKPOT:   bsf PORTB,POTCLK    ; take dig pot clk high
          bcf PORTB,POTCLK    ; take dig pot clk low
          return

          END

