;*****************************************************************************        
;
;   Module:     cw2.asm
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 06/06/05                                                  
;
;               Main source file for EPE CameraWatch2 project.
;               This file contains only framework code that enables a bootloader
;               to be implemented. All application code starts from 0x200, and
;               gets called once the bootloader has completed.
;
;               Unless you intend to change the bootloader or memory layout
;               this file should not need editing.
;
;*****************************************************************************        

    list p=18F2420, st=OFF, x=OFF, n=0

    
    errorlevel -302
    errorlevel -306

    #include <p18f2420.inc>

    #include "constants.inc"    
    
    ; The settings for config bits are so compilcated now
    ; they deserve their own file...
    
    #include "config.inc"

    

;*****************************************************************************        
;
;   Function :  Reset vector
;               Hardware entry point to the code
;               This vector is also used for soft resets in the event of 
;               abnormal events
;
;   Input:      None.
;
;   Output:     N/A
;
;*****************************************************************************        
    
    ORG    0

    call    Bootloader
    goto    Startup



;*****************************************************************************        
;
;   Function :  Interrupt vectors
;               Hardware entry point for interrupts
;               This vectors handles all external and internal interrupts;
;               As we have a bootloader, these transfer control into
;
;   Input:      None.
;
;   Output:     N/A
;
;*****************************************************************************        
    
    ORG    0x08
 
    bra  IntVecHigh

    ORG    0x18
 
    bra  IntVecLow
    
    
    ; Ensure that the bootloader code is at the start of memory,
    ; just after the PIC vectors.
    
    #include "bootload.inc"


    ; User code starts at 0x600 - This is the first flash address that the boot
    ; loader will write to.
    
    ORG     0x600

    ; This symbols UserStartup,IntVecLow and IntVecHigh must always be at 
    ; the same location, since the location jumped to by the reset or interrupts
    ; must always be the same - the application code, starting at 0400, may be
    ; different to the bootloader.
    
Startup
    ; Goto the main application. 
    goto    Main
    
    ORG     0x604

IntVecLow
    goto    UserIntVecLow 
    
    
    
;*****************************************************************************        
;
;   Function :  IntVecHigh
;               The re-mapped fast interrupt vector goes at 0x608, and
;               the re-mapped low level interrupt handler follows it.
;               The actual code is in interrupts.inc, to allow this file 
;               to remain simple
;
;   Input:      None.
;
;   Output:     Using the FAST directive to update registers automatically
;
;*****************************************************************************        

    ORG     0x608

    #include "interrupts.inc"       ; Must always follow ORG statement

    #include "math.inc"
    
    #include "cw2app.inc"
    
    #include "rxstate.inc" 
    
    #include "spieeprom.inc"
    
    #include "displays.inc"
    
    #include "melody.inc"
    
    
    END                ; End of program
    