;*****************************************************************************        
;
;   Module:     rxstate.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.2 10/2/05                                                  
;
;               GPS data state machines
;               called by the interrupt routine to
;               process incoming data from the GPS module
;
;   Revision    0.2 Changed Valid flag test; Rather than test for 1, I test for
;                   'Not 0'
;*****************************************************************************        


;*****************************************************************************        
;
;   Function :  rxStateMachine
;               Interrupt routine that handles the incoming nmea data, looking
;               for lat/long data and the valid flag.
;               This function is called once per incoming character
;
;   Input:      character received in W. state in rxState
;
;   Output:     Once the Valid flag has been recieved, it sets or clears the
;               INLOCKFLAG2 bit
;           
;               If the above flag is set, then NEWDATAFLAG2 bit is set,
;               indicating that the application should look at the
;               iLatxxxx and iLongxxxx variables
;
;*****************************************************************************        
rxStateMachine
    movwf   inChar
    movlw   high rxStateMachine
    movwf   PCLATH
    movfw   rxState
    andlw   0x0f        ; there are only 16 states
    addwf   PCL ,F
    goto    rxs00       ; awaiting $
    goto    rxs01       ; awaiting G
    goto    rxs02       ; awaiting P
    goto    rxs03       ; awaiting G
    goto    rxs04       ; awaiting G
    goto    rxs05       ; awaiting A
    goto    rxs06       ; awaiting ,time : xxxxxx.xxx,
    goto    rxs07       ; awaiting latitude : ddmm.mmmm
    goto    rxs08       ; awaiting ,
    goto    rxs09       ; awaiting N/S character
    goto    rxs10       ; awaiting ,
    goto    rxs11       ; awaiting longitude : dddmm.mmmm
    goto    rxs12       ; awaiting ,
    goto    rxs13       ; awaiting E/W character
    goto    rxs14       ; awaiting ,
rxStateMachine_end
    goto    rxs15       ; awaiting valid flag
    
    IF ( (rxStateMachine & 0x0FF) >= (rxStateMachine_end & 0x0FF) )
        MESSG   "Table rxStateMachine overflow"
    ENDIF

rxs00
    movfw   inChar
    sublw   '$'
    btfss   STATUS,Z
    return
    incf    rxState,F
    return   
    
rxs01
    clrf    rxState
    movfw   inChar
    sublw   'G'
    btfss   STATUS,Z
    return
    movlw   0x02
    movwf   rxState
    return   

rxs02
    clrf    rxState
    movfw   inChar
    sublw   'P'
    btfss   STATUS,Z
    return
    movlw   0x03
    movwf   rxState
    return   
    
rxs03
	; test code
	; Dump pic bank 0 ram if $GP? entered
    movfw   inChar
    sublw   '?'
    btfss   STATUS,Z

    goto    rxs03_test2
    ; ok, dump 0x20 to 0x7f
    
    movlw   0x0A
    call    SerialTransmit
    movlw   0x0D
    call    SerialTransmit
    movlw   0x0A
    call    SerialTransmit
    movlw   0x0D
    call    SerialTransmit
    movlw   0x20
    movwf   FSR
dspMem
    movfw   FSR
    andlw   0x0F
    btfss   STATUS, Z
    goto    dspMem1
    movlw   0x0A
    call    SerialTransmit
    movlw   0x0D
    call    SerialTransmit
dspMem1
    movfw   INDF
    call    SerialHexTransmit
    incf    FSR, F
    btfss   FSR, 7                  ; Have we reached 0x80?
    goto    dspMem                  ; - No, so continue
    goto	rxs03_proper
    
rxs03_test2
	; Dump eeprom contents if $GP! entered
    movfw   inChar
    sublw   '!'
    btfss   STATUS,Z

    goto    rxs03_test3
    
    ; Let the foreground task do the dump
	bsf		flags2, DUMPEEPROMFLAG2   
    goto    rxs03_proper


rxs03_test3
	; fill eeprom if $GP* entered
    movfw   inChar
    sublw   '*'
    btfsc   STATUS,Z
    ; Let the foreground task do the fill
	bsf		flags2, FILLEEPROMFLAG2   

    
rxs03_proper
    clrf    rxState
    movfw   inChar
    sublw   'G'
    btfss   STATUS,Z
    return
    movlw   0x04
    movwf   rxState
    return   

rxs04
    clrf    rxState
    movfw   inChar
    sublw   'G'
    btfss   STATUS,Z
    return
    movlw   0x05
    movwf   rxState
    return   

rxs05
    clrf    rxState
    movfw   inChar
    sublw   'A'
    btfss   STATUS,Z
    return
    btfsc   flags2,NEWDATAFLAG2
    return
    movlw   0x06
    movwf   rxState
    movlw   0x0C        ; number of characters to discard in next state
    movwf   rxSubState
    return   

rxs06                   ;time field
    decfsz  rxSubState, F
    return
    incf    rxState, F
    movlw   0x09        ; number of characters to parse in next state
    movwf   rxSubState
    return 
      
rxs07                   ; latitude. ddmm.mmmm
    movlw   0x09
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs07001
    
    movlw   0x30
    subwf   inChar, W
    movwf   iLatDeg
    goto    rxs07exit
    
rxs07001    
    movlw   0x08
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs07002
    
    bcf     STATUS, C
    rlf     iLatDeg, F
    rlf     iLatDeg, W
    movwf   iTmp
    rlf     iTmp, W
    addwf   iLatDeg, F
    movlw   0x30
    subwf   inChar, W
    addwf   iLatDeg, F
    goto    rxs07exit               ; We now have degrees in iLatDeg
    
rxs07002
    movlw   0x07
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs07003
    
    ; store first minute digit 
    movlw   0x30
    subwf   inChar, W
    movwf   tmpL
    clrf    tmpM
    clrf    tmpH

    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; So thats x2
    movfw   tmpL
    movwf   tmp1L
    movfw   tmpM
    movwf   tmp1M
    movfw   tmpH
    movwf   tmp1H
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movfw   tmp1L
    addwf   tmpL, F
    movfw   tmp1M
    btfsc   STATUS, C
    incfsz  tmp1M, W
    addwf   tmpM, F
    movfw   tmp1H
    btfsc   STATUS, C
    incfsz  tmp1H, W
    addwf   tmpH, F
    
    goto    rxs07exit
    
rxs07003
    movlw   0x06
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs07004
    
    ; store second minute digit 
    ; add ascii digit and * 10
    ; add in m2
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpM,F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpH,F

    ; Multiply iLatDeg by 60. iLatDeg unchanged, result in tmpL/M/H
    movfw   iLatDeg
    movwf   tmp1M                ; ie, tmp = iLatDeg * 256
    clrf    tmp1L
    
    swapf   iLatDeg, W          ; subtract 16 * degrees..          
    andlw   0x0F
    movwf   tmp1H
    swapf   iLatDeg, W          
    andlw   0xF0        
    subwf   tmp1L, F
    movfw   tmp1H
    btfss   STATUS, C
    incfsz  tmp1H, W
    subwf   tmp1M, F
    clrf    tmp1H

    bcf     STATUS, C           ; and divide by 4
    rrf     tmp1H, F
    rrf     tmp1M, F
    rrf     tmp1L, F
    rrf     tmp1H, F
    rrf     tmp1M, F
    rrf     tmp1L, F
 
    ; Now add this into tmpL/M/H
    movfw   tmp1L
    addwf   tmpL, F
    movfw   tmp1M
    btfsc   STATUS, C
    incfsz  tmp1M, W
    addwf   tmpM, F
    movfw   tmp1H
    btfsc   STATUS, C
    incfsz  tmp1H, W
    addwf   tmpH, F
     
    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; So thats x2
    movfw   tmpL
    movwf   tmp1L
    movfw   tmpM
    movwf   tmp1M
    movfw   tmpH
    movwf   tmp1H
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movfw   tmp1L
    addwf   tmpL, F
    movfw   tmp1M
    btfsc   STATUS, C
    incfsz  tmp1M, W
    addwf   tmpM, F
    movfw   tmp1H
    btfsc   STATUS, C
    incfsz  tmp1H, W
    addwf   tmpH, F
    goto    rxs07exit
    
rxs07004
    movlw   0x05
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs07004a

    ; skip the . character
    goto    rxs07exit
    
rxs07004a
    movlw   0x04
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs07005

; add ascii digit and * 10
    
    ; add in m3
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpM,F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpH,F
    
    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; So thats x2
    movfw   tmpL
    movwf   tmp1L
    movfw   tmpM
    movwf   tmp1M
    movfw   tmpH
    movwf   tmp1H
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movfw   tmp1L
    addwf   tmpL, F
    movfw   tmp1M
    btfsc   STATUS, C
    incfsz  tmp1M, W
    addwf   tmpM, F
    movfw   tmp1H
    btfsc   STATUS, C
    incfsz  tmp1H, W
    addwf   tmpH, F
    goto    rxs07exit
    
rxs07005
    movlw   0x03
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs07exit
    
    ; add in m4
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpM,F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpH,F
    
rxs07exit
    decfsz  rxSubState, F
    return
    incf    rxState, F
    return  
     
rxs08
    incf    rxState, F  ; skip the , character
    return  
     
rxs09
    movlw   'S'
    subwf   inChar, W
    btfss   STATUS, Z
    goto    rxs09exit
    
    ; negate the binary value.
    ; ie, invert the bits and add 1
    comf    tmpL, F
    comf    tmpM, F
    comf    tmpH, F
    movlw   1    
    addwf   tmpL, F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpM,F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpH,F

rxs09exit
    ; Now store tmp into iLatmmhh
    movfw   tmpH
    movwf   iLatmmhh
    movfw   tmpM
    movwf   iLatmmhh + 1
    movfw   tmpL
    movwf   iLatmmhh + 2

    incf    rxState, F 
    return   
    
rxs10
    incf    rxState, F  ; skip the , character
    movlw   0x0A        ; number of characters to parse in next state
    movwf   rxSubState
    return   
    
rxs11
    ; read  the longitude values
    movlw   0x0A
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs11001
    
    movlw   0x30
    subwf   inChar, W
    movwf   iLongDeg
    goto    rxs11exit    

rxs11001
    movlw   0x09
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs11002
    
    bcf     STATUS, C
    rlf     iLongDeg, F
    rlf     iLongDeg, W
    movwf   iTmp
    rlf     iTmp, W
    addwf   iLongDeg, F
    movlw   0x30
    subwf   inChar, W
    addwf   iLongDeg, F
    goto    rxs11exit              

rxs11002
    movlw   0x08
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs11003
    
    bcf     STATUS, C
    rlf     iLongDeg, F
    rlf     iLongDeg, W
    movwf   iTmp
    rlf     iTmp, W
    addwf   iLongDeg, F
    movlw   0x30
    subwf   inChar, W
    addwf   iLongDeg, F
    goto    rxs11exit               ; We now have degrees in iLongDeg

rxs11003
    movlw   0x07
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs11004
    
   ; store first minute digit 
    movlw   0x30
    subwf   inChar, W
    movwf   tmpL
    clrf    tmpM
    clrf    tmpH

    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; So thats x2
    movfw   tmpL
    movwf   tmp1L
    movfw   tmpM
    movwf   tmp1M
    movfw   tmpH
    movwf   tmp1H
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movfw   tmp1L
    addwf   tmpL, F
    movfw   tmp1M
    btfsc   STATUS, C
    incfsz  tmp1M, W
    addwf   tmpM, F
    movfw   tmp1H
    btfsc   STATUS, C
    incfsz  tmp1H, W
    addwf   tmpH, F
 
    goto    rxs11exit    
    
rxs11004
    movlw   0x06
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs11005
    
    ; store second minute digit 
    ; add ascii digit and * 10
    ; add in m2
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpM,F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpH,F

    ; Multiply iLongDeg by 60. iLatDeg unchanged, result in tmpL/M/H
    movfw   iLongDeg
    movwf   tmp1M                ; ie, tmp = iLatDeg * 256
    clrf    tmp1L
    
    swapf   iLongDeg, W          ; subtract 16 * degrees..          
    andlw   0x0F
    movwf   tmp1H
    swapf   iLongDeg, W          
    andlw   0xF0        
    subwf   tmp1L, F
    movfw   tmp1H
    btfss   STATUS, C
    incfsz  tmp1H, W
    subwf   tmp1M, F
    clrf    tmp1H

    bcf     STATUS, C           ; and divide by 4
    rrf     tmp1H, F
    rrf     tmp1M, F
    rrf     tmp1L, F
    rrf     tmp1H, F
    rrf     tmp1M, F
    rrf     tmp1L, F
 
    ; Now add this into tmpL/M/H
    movfw   tmp1L
    addwf   tmpL, F
    movfw   tmp1M
    btfsc   STATUS, C
    incfsz  tmp1M, W
    addwf   tmpM, F
    movfw   tmp1H
    btfsc   STATUS, C
    incfsz  tmp1H, W
    addwf   tmpH, F
     
    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; So thats x2
    movfw   tmpL
    movwf   tmp1L
    movfw   tmpM
    movwf   tmp1M
    movfw   tmpH
    movwf   tmp1H
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movfw   tmp1L
    addwf   tmpL, F
    movfw   tmp1M
    btfsc   STATUS, C
    incfsz  tmp1M, W
    addwf   tmpM, F
    movfw   tmp1H
    btfsc   STATUS, C
    incfsz  tmp1H, W
    addwf   tmpH, F
    
    goto    rxs11exit
    
rxs11005
    movlw   0x05                ; the . character
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs11005a
    goto    rxs11exit
    
    
rxs11005a
    movlw   0x04                
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs11006
    
; add ascii digit and * 10
    
    ; add in m3
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpM,F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpH,F
    
    ; times the lot by 10 - ie, x8 + x2

    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; So thats x2
    movfw   tmpL
    movwf   tmp1L
    movfw   tmpM
    movwf   tmp1M
    movfw   tmpH
    movwf   tmp1H
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x4
    bcf     STATUS, C
    rlf     tmpL,F
    rlf     tmpM,F
    rlf     tmpH,F          ; and thats x 8
    
    ; Finally add in the x2 part
    movfw   tmp1L
    addwf   tmpL, F
    movfw   tmp1M
    btfsc   STATUS, C
    incfsz  tmp1M, W
    addwf   tmpM, F
    movfw   tmp1H
    btfsc   STATUS, C
    incfsz  tmp1H, W
    addwf   tmpH, F
    goto    rxs11exit
    
rxs11006
    movlw   0x03
    subwf   rxSubState,W
    btfss   STATUS, Z
    goto    rxs11exit 
 
    ; add in m4
    movlw   0x30
    subwf   inChar, W
    addwf   tmpL, F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpM,F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpH,F
 
rxs11exit
    decfsz  rxSubState, F
    return
    incf    rxState, F
    return   
    
rxs12
    incf    rxState, F  ; skip the , character
    return   
    
rxs13
    movlw   'W'
    subwf   inChar, W
    btfss   STATUS, Z
    goto    rxs13exit

    ; negate the binary value.
    ; ie, invert the bits and add 1
    comf    tmpL, F
    comf    tmpM, F
    comf    tmpH, F
    movlw   1    
    addwf   tmpL, F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpM,F
    movlw   0
    btfsc   STATUS, C
    movlw   1
    addwf   tmpH,F
    
rxs13exit
    ; Now store tmp into iLongmmhh
    movfw   tmpH
    movwf   iLongmmhh
    movfw   tmpM
    movwf   iLongmmhh + 1
    movfw   tmpL
    movwf   iLongmmhh + 2
    incf    rxState, F 
    return   

rxs14
    incf    rxState, F  ; skip the , character
    return   

rxs15
    ; If valid flag is set, set INLOCKFLAG flag
    clrf    rxState
    bcf    flags2, INLOCKFLAG2
    movfw   inChar
    sublw   '0'
    btfss   STATUS,Z
    bsf     flags2, INLOCKFLAG2
    btfss   STATUS,Z
    bsf     flags2, NEWDATAFLAG2        ; Signal to forground that we have data
    return   
