;*****************************************************************************        
;
;   Module:     an617.inc
;               
;   Author:     Microchip Inc.
;               This file comes from the microchip web site application note 
;               an617.inc. There was no licence or copyright statement in the
;               original files, so none is included here.
;               
;                                                                  
;   Version:                                           
;
;               Fix point math routines
;
;*****************************************************************************        

;	For example, to multiply the 24 bit unsigned integer AARG = 0xED85E1 by the 16 bit
;	unsigned integer BARG = 0x2292, simply load AARG and BARG with the appropriate
;	values and call FXM2416U. The 40 bit unsigned result, 0x20133E3C52, is left justified
;	in AARG, occupying AARGB0,AARGB1,AARGB2,AARGB3 and AARGB4.


        
;        movlw   0x5B  ; 82 decimal
;        sublw   0x5A
;        btfss   STATUS, C
;        goto    l1
        
;        ; deg <= 90dec
;        movlw   0x01
;l2  
;        goto    l2
        
;l1
;        movlw   0x02
;l3
;        goto    l3        

        ; 0x000451
;		MOVLW	0x00
;		MOVWF	AARGB0
;		MOVLW	0x04
;		MOVWF	AARGB1
;		MOVLW	0x51
;		MOVWF	AARGB2

        ; 0x315a
;		MOVLW	0x31
;		MOVWF	BARGB0
;		MOVLW	0x5A
;		MOVWF	BARGB1
;       call    FXM2416U
    

;		MOVLW	0x00
;		MOVWF	AARGB0
;		MOVLW	0x04
;		MOVWF	AARGB1
;		MOVLW	0x51
;		MOVWF	AARGB2

        ; 0x315a
;		MOVLW	0x31
;		MOVWF	BARGB0
;		MOVLW	0x5A
;		MOVWF	BARGB1
;    call    FXM2424U


;endit
;    goto    endit


		#define	_C		STATUS,0
		#define	_Z		STATUS,2




UMUL2416L        macro

;       Max Timing:     2+14+6*20+19+2+7*21+20 = 324 clks

;       Min Timing:     2+7*6+5+1+7*6+5+5 = 102 clks

;       PM: 18+20+2+21 = 61            DM: 12


                MOVLW   0x08
                MOVWF   LOOPCOUNT

LOOPUM2416A
                RRF     BARGB1, F
                BTFSC   _C
                GOTO    ALUM2416NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM2416A

                MOVWF   LOOPCOUNT

LOOPUM2416B
                RRF     BARGB0, F
                BTFSC   _C
                GOTO    BLUM2416NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM2416B

                CLRF    AARGB0
                CLRF    AARGB1
                CLRF    AARGB2
                RETURN

BLUM2416NAP
                BCF     _C
                GOTO    BLUM2416NA

ALUM2416NAP
                BCF     _C
                GOTO    ALUM2416NA

ALOOPUM2416
                RRF     BARGB1, F
                BTFSS   _C
                GOTO    ALUM2416NA
                MOVF   TEMPB2,W
                ADDWF   AARGB2, F
                MOVF            TEMPB1,W
                BTFSC           _C
                INCFSZ          TEMPB1,W
                ADDWF           AARGB1, F
                MOVF            TEMPB0,W
                BTFSC           _C
                INCFSZ          TEMPB0,W
                ADDWF           AARGB0, F

ALUM2416NA
                RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF     AARGB3, F
                DECFSZ  LOOPCOUNT, F
                GOTO    ALOOPUM2416

                MOVLW   0x08
                MOVWF   LOOPCOUNT

BLOOPUM2416
                RRF     BARGB0, F
                BTFSS   _C
                GOTO    BLUM2416NA
                MOVF    TEMPB2,W
                ADDWF   AARGB2, F
                MOVF            TEMPB1,W
                BTFSC           _C
                INCFSZ          TEMPB1,W
                ADDWF           AARGB1, F
                MOVF            TEMPB0,W
                BTFSC           _C
                INCFSZ          TEMPB0,W
                ADDWF           AARGB0, F

BLUM2416NA
                RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF             AARGB3, F
                RRF             AARGB4, F
                DECFSZ  LOOPCOUNT, F
                GOTO    BLOOPUM2416

                endm



UMUL2424L        macro

;       Max Timing:     2+14+6*20+19+2+7*21+20+2+7*22+21 = 501 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+5 = 150 clks

;       PM: 23+20+2+21+2+22 = 88            DM: 13


                MOVLW   0x08
                MOVWF   LOOPCOUNT

LOOPUM2424A
                RRF     BARGB2, F
                BTFSC   _C
                GOTO    ALUM2424NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM2424A

                MOVWF   LOOPCOUNT

LOOPUM2424B
                RRF     BARGB1, F
                BTFSC   _C
                GOTO    BLUM2424NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM2424B

                MOVWF   LOOPCOUNT

LOOPUM2424C
                RRF     BARGB0, F
                BTFSC   _C
                GOTO    CLUM2424NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM2424C

                CLRF    AARGB0
                CLRF    AARGB1
                CLRF    AARGB2
                RETURN

CLUM2424NAP
                BCF     _C
                GOTO    CLUM2424NA

BLUM2424NAP
                BCF     _C
                GOTO    BLUM2424NA

ALUM2424NAP
                BCF     _C
                GOTO    ALUM2424NA

ALOOPUM2424
                RRF     BARGB2, F
                BTFSS   _C
                GOTO    ALUM2424NA
                MOVF   TEMPB2,W
                ADDWF   AARGB2, F
                MOVF            TEMPB1,W
                BTFSC           _C
                INCFSZ          TEMPB1,W
                ADDWF           AARGB1, F
                MOVF            TEMPB0,W
                BTFSC           _C
                INCFSZ          TEMPB0,W
                ADDWF           AARGB0, F

ALUM2424NA
                RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF     AARGB3, F
                DECFSZ  LOOPCOUNT, F
                GOTO    ALOOPUM2424

                MOVLW   0x08
                MOVWF   LOOPCOUNT

BLOOPUM2424
                RRF     BARGB1, F
                BTFSS   _C
                GOTO    BLUM2424NA
                MOVF    TEMPB2,W
                ADDWF   AARGB2, F
                MOVF            TEMPB1,W
                BTFSC           _C
                INCFSZ          TEMPB1,W
                ADDWF           AARGB1, F
                MOVF            TEMPB0,W
                BTFSC           _C
                INCFSZ          TEMPB0,W
                ADDWF           AARGB0, F

BLUM2424NA
                RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF             AARGB3, F
                RRF             AARGB4, F
                DECFSZ  LOOPCOUNT, F
                GOTO    BLOOPUM2424

                MOVLW   0x08
                MOVWF   LOOPCOUNT

CLOOPUM2424
                RRF     BARGB0, F
                BTFSS   _C
                GOTO    CLUM2424NA
                MOVF   TEMPB2,W
                ADDWF   AARGB2, F
                MOVF            TEMPB1,W
                BTFSC           _C
                INCFSZ          TEMPB1,W
                ADDWF           AARGB1, F
                MOVF            TEMPB0,W
                BTFSC           _C
                INCFSZ          TEMPB0,W
                ADDWF           AARGB0, F

CLUM2424NA
                RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF             AARGB3, F
                RRF             AARGB4, F
                RRF             AARGB5, F
                DECFSZ  LOOPCOUNT, F
                GOTO    CLOOPUM2424

                endm





;**********************************************************************************************
;**********************************************************************************************
        
;       24x16 Bit Unsigned Fixed Point Multiply 24x16 -> 40

;       Input:  24 bit unsigned fixed point multiplicand in AARGB0
;               16 bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM2416U

;       Output: 40 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     8+324+2 = 334 clks

;       Min Timing:     8+102 = 110 clks

;       PM: 8+61+1 = 70              DM: 12

FXM2416U
                CLRF    AARGB3          ; clear partial product
                CLRF    AARGB4
                MOVF   AARGB0,W
                MOVWF   TEMPB0
                MOVF   AARGB1,W
                MOVWF   TEMPB1
                MOVF   AARGB2,W
                MOVWF   TEMPB2

                UMUL2416L

                RETURN


;**********************************************************************************************
;**********************************************************************************************
        
;       24x24 Bit Unsigned Fixed Point Multiply 24x24 -> 48

;       Input:  24 bit unsigned fixed point multiplicand in AARGB0
;                       24 bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM2424U

;       Output: 48 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     9+501+2 = 512 clks

;       Min Timing:     9+150 = 159 clks

;       PM: 9+88+1 = 98              DM: 13

FXM2424U
        CLRF    AARGB3          ; clear partial product
                CLRF    AARGB4
                CLRF    AARGB5
                MOVF   AARGB0,W
                MOVWF   TEMPB0
                MOVF   AARGB1,W
                MOVWF   TEMPB1
                MOVF   AARGB2,W
                MOVWF   TEMPB2

                UMUL2424L

                RETURN
 